/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.persist.jdbc;

import com.sibvisions.rad.persist.jdbc.CheckConstraintSupport;
import com.sibvisions.rad.persist.jdbc.DBAccess;
import com.sibvisions.rad.persist.jdbc.Name;
import com.sibvisions.rad.persist.jdbc.ServerMetaData;
import com.sibvisions.rad.persist.jdbc.TableInfo;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.type.CommonUtil;
import com.sibvisions.util.type.StringUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.rad.persist.DataSourceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MSSQLDBAccess
extends DBAccess {
    private static String sCheckSelect = "SELECT cu.TABLE_NAME, cu.COLUMN_NAME, c.CHECK_CLAUSE FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS t, INFORMATION_SCHEMA.CHECK_CONSTRAINTS c, INFORMATION_SCHEMA.CONSTRAINT_COLUMN_USAGE cu WHERE t.CONSTRAINT_TYPE = 'CHECK' AND t.CONSTRAINT_SCHEMA = c.CONSTRAINT_SCHEMA AND t.CONSTRAINT_CATALOG = c.CONSTRAINT_CATALOG AND t.CONSTRAINT_NAME = c.CONSTRAINT_NAME AND t.TABLE_NAME = ? AND t.TABLE_NAME = cu.TABLE_NAME AND t.TABLE_CATALOG = cu.TABLE_CATALOG AND t.TABLE_SCHEMA = cu.TABLE_SCHEMA AND t.CONSTRAINT_SCHEMA = cu.CONSTRAINT_SCHEMA AND t.CONSTRAINT_CATALOG = cu.CONSTRAINT_CATALOG AND t.CONSTRAINT_NAME = cu.CONSTRAINT_NAME";
    private static String sSynonymSelect = "SELECT name, base_object_name FROM sys.synonyms t WHERE t.name = ?";

    public MSSQLDBAccess() {
        this.setDriver("net.sourceforge.jtds.jdbc.Driver");
        this.setQuoteCharacters("[", "]");
    }

    private String addMSSQLSpecificAutoIncSupport(String string, String string2, ServerMetaData serverMetaData, Object[] objectArray, Object[] objectArray2) {
        int[] nArray = serverMetaData.getAutoIncrementColumnIndices();
        for (int i = 0; nArray != null && i < nArray.length; ++i) {
            if ((objectArray != null || objectArray2[nArray[i]] == null) && (objectArray == null || objectArray2[nArray[i]] == null || objectArray2[nArray[i]].equals(objectArray[nArray[i]]))) continue;
            return "SET IDENTITY_INSERT " + this.translateQuotes(string) + " ON " + string2 + " SET IDENTITY_INSERT " + this.translateQuotes(string) + " OFF";
        }
        return string2;
    }

    @Override
    public Object[] insertDatabaseSpecific(String string, String string2, ServerMetaData serverMetaData, Object[] objectArray, String string3) throws DataSourceException {
        string2 = this.addMSSQLSpecificAutoIncSupport(string, string2, serverMetaData, null, objectArray);
        return this.insertAnsiSQL(string, string2, serverMetaData, objectArray, string3);
    }

    @Override
    protected Object translateDefaultValue(String string, int n, String string2) throws Exception {
        String string3 = StringUtil.removeQuotes(string2, "('", "')");
        string3 = StringUtil.removeQuotes(string3, "((", "))");
        string3 = StringUtil.removeQuotes(string3, "(", ")");
        return super.translateDefaultValue(string, n, string3);
    }

    @Override
    protected Map<String, Object[]> getAllowedValuesIntern(String string, String string2, String string3) throws DataSourceException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Hashtable<String, Object[]> hashtable = new Hashtable();
        Hashtable<String, List<String>> hashtable2 = null;
        try {
            try {
                preparedStatement = this.getPreparedStatement(sCheckSelect, false);
                preparedStatement.setString(1, string3);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    hashtable2 = CheckConstraintSupport.parseCondition(resultSet.getString(3), hashtable2, false);
                }
                hashtable = CheckConstraintSupport.translateValues(this, string, string2, string3, hashtable2);
            }
            catch (SQLException sQLException) {
                throw new DataSourceException("Can't access check constraints for: '" + string3 + "'", this.formatSQLException(sQLException));
            }
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            CommonUtil.close(resultSet, preparedStatement);
            throw throwable;
        }
        CommonUtil.close(resultSet, preparedStatement);
        return hashtable;
    }

    @Override
    public boolean isAutoQuote(String string) {
        return false;
    }

    @Override
    public void setUsername(String string) {
        super.setUsername(DBAccess.removeQuotes(string));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected TableInfo getTableInfoIntern(String string) throws DataSourceException {
        Object object;
        long l;
        Object object2;
        Object object3;
        block13: {
            TableInfo tableInfo;
            block12: {
                TableInfo tableInfo2;
                block11: {
                    TableInfo tableInfo3;
                    block10: {
                        String[] stringArray;
                        List<Object[]> list;
                        TableInfo tableInfo4 = super.getTableInfoIntern(string);
                        String string2 = DBAccess.removeQuotes(tableInfo4.getTable());
                        if (tableInfo4.getSchema() != null && (list = this.checkTablesAndViews((String)(object3 = ((String)(object2 = DBAccess.removeQuotes((String)(object3 = tableInfo4.getSchema())))).equals(object3) ? ((String)object3).toLowerCase() : object2), string2 = (stringArray = this.splitSchemaTable(string2))[1])).size() == 1) {
                            return new TableInfo(tableInfo4.getCatalog(), ((Name)list.get(0)[0]).getRealName(), tableInfo4.getTable());
                        }
                        object3 = null;
                        object2 = null;
                        l = System.currentTimeMillis();
                        try {
                            try {
                                if (this.getConnection().getMetaData().getDatabaseMajorVersion() > 8) {
                                    List<Object[]> list2;
                                    object3 = this.getPreparedStatement("SELECT default_schema_name FROM sys.database_principals WHERE type = 'S' AND name = ?", false);
                                    object3.setString(1, this.getUsername());
                                    object2 = object3.executeQuery();
                                    if (object2.next() && (object = object2.getString(1)) != null && (list2 = this.checkTablesAndViews((String)object, string2)).size() == 1) {
                                        tableInfo3 = new TableInfo(tableInfo4.getCatalog(), ((Name)list2.get(0)[0]).getRealName(), tableInfo4.getTable());
                                        Object var12_16 = null;
                                        break block10;
                                    }
                                } else {
                                    String string3 = this.getDefaultSchema();
                                    if (string3 != null) {
                                        tableInfo2 = new TableInfo(tableInfo4.getCatalog(), string3, tableInfo4.getTable());
                                        break block11;
                                    }
                                    tableInfo = new TableInfo(tableInfo4.getCatalog(), "dbo", tableInfo4.getTable());
                                    break block12;
                                }
                                object = tableInfo4;
                                break block13;
                            }
                            catch (SQLException sQLException) {
                                throw new DataSourceException("Jdbc statement close failed", this.formatSQLException(sQLException));
                            }
                        }
                        catch (Throwable throwable) {
                            Object var12_20 = null;
                            CommonUtil.close(object2, object3);
                            if (!MSSQLDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) throw throwable;
                            MSSQLDBAccess.debug("getColumnMetaData() - getDefaultSchema in time=", System.currentTimeMillis() - l);
                            throw throwable;
                        }
                    }
                    CommonUtil.close(object2, object3);
                    if (!MSSQLDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) return tableInfo3;
                    MSSQLDBAccess.debug("getColumnMetaData() - getDefaultSchema in time=", System.currentTimeMillis() - l);
                    return tableInfo3;
                }
                Object var12_17 = null;
                CommonUtil.close(object2, object3);
                if (!MSSQLDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) return tableInfo2;
                MSSQLDBAccess.debug("getColumnMetaData() - getDefaultSchema in time=", System.currentTimeMillis() - l);
                return tableInfo2;
            }
            Object var12_18 = null;
            CommonUtil.close(object2, object3);
            if (!MSSQLDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) return tableInfo;
            MSSQLDBAccess.debug("getColumnMetaData() - getDefaultSchema in time=", System.currentTimeMillis() - l);
            return tableInfo;
        }
        Object var12_19 = null;
        CommonUtil.close(object2, object3);
        if (!MSSQLDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) return object;
        MSSQLDBAccess.debug("getColumnMetaData() - getDefaultSchema in time=", System.currentTimeMillis() - l);
        return object;
    }

    @Override
    protected String getTableForSynonymIntern(String string) throws DataSourceException {
        String string2;
        long l;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block6: {
            preparedStatement = null;
            resultSet = null;
            l = System.currentTimeMillis();
            preparedStatement = this.getPreparedStatement(sSynonymSelect, false);
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) break block6;
            CommonUtil.close(resultSet, preparedStatement);
            String string3 = string;
            Object var9_8 = null;
            CommonUtil.close(resultSet, preparedStatement);
            return string3;
        }
        try {
            String string4 = resultSet.getString("BASE_OBJECT_NAME");
            if (MSSQLDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                MSSQLDBAccess.debug("getTableForSynonym(", string, ") in ", System.currentTimeMillis() - l, "ms");
            }
            string2 = string4;
            Object var9_9 = null;
        }
        catch (SQLException sQLException) {
            try {
                throw new DataSourceException("Synonyms couldn't determined from database! - " + string, this.formatSQLException(sQLException));
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                CommonUtil.close(resultSet, preparedStatement);
                throw throwable;
            }
        }
        CommonUtil.close(resultSet, preparedStatement);
        return string2;
    }

    private List<Object[]> checkTablesAndViews(String string, String string2) throws DataSourceException {
        Object object;
        long l = System.currentTimeMillis();
        ResultSet resultSet = null;
        try {
            resultSet = this.getConnection().getMetaData().getTables(this.getConnection().getCatalog(), string, string2, new String[]{"TABLE", "VIEW"});
            ArrayUtil<Object[]> arrayUtil = new ArrayUtil<Object[]>();
            while (resultSet.next()) {
                object = resultSet.getString("TABLE_SCHEM");
                if (((String)object).equals("sys") || ((String)object).equals("INFORMATION_SCHEMA")) continue;
                arrayUtil.add(new Object[]{new Name(resultSet.getString("TABLE_SCHEM"), this.quote(resultSet.getString("TABLE_SCHEM"))), new Name(resultSet.getString("TABLE_NAME"), this.quote(resultSet.getString("TABLE_NAME")))});
            }
            object = arrayUtil;
            Object var9_8 = null;
        }
        catch (SQLException sQLException) {
            try {
                throw new DataSourceException("Jdbc statement close failed", this.formatSQLException(sQLException));
            }
            catch (Throwable throwable) {
                block6: {
                    Object var9_9 = null;
                    CommonUtil.close(resultSet);
                    if (!MSSQLDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) break block6;
                    MSSQLDBAccess.debug("getTables() time=", System.currentTimeMillis() - l);
                }
                throw throwable;
            }
        }
        CommonUtil.close(resultSet);
        if (MSSQLDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
            MSSQLDBAccess.debug("getTables() time=", System.currentTimeMillis() - l);
        }
        return object;
    }
}

