/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.persist.jdbc;

import com.sibvisions.rad.model.Filter;
import com.sibvisions.rad.persist.AbstractCachedStorage;
import com.sibvisions.rad.persist.jdbc.DB2DBAccess;
import com.sibvisions.rad.persist.jdbc.DBCredentials;
import com.sibvisions.rad.persist.jdbc.DBStorage;
import com.sibvisions.rad.persist.jdbc.DerbyDBAccess;
import com.sibvisions.rad.persist.jdbc.ForeignKey;
import com.sibvisions.rad.persist.jdbc.HSQLDBAccess;
import com.sibvisions.rad.persist.jdbc.HanaDBAccess;
import com.sibvisions.rad.persist.jdbc.IDBAccess;
import com.sibvisions.rad.persist.jdbc.Key;
import com.sibvisions.rad.persist.jdbc.MSSQLDBAccess;
import com.sibvisions.rad.persist.jdbc.MySQLDBAccess;
import com.sibvisions.rad.persist.jdbc.Name;
import com.sibvisions.rad.persist.jdbc.OracleDBAccess;
import com.sibvisions.rad.persist.jdbc.PostgreSQLDBAccess;
import com.sibvisions.rad.persist.jdbc.ServerColumnMetaData;
import com.sibvisions.rad.persist.jdbc.ServerMetaData;
import com.sibvisions.rad.persist.jdbc.TableInfo;
import com.sibvisions.rad.persist.jdbc.param.AbstractParam;
import com.sibvisions.rad.server.protocol.ProtocolFactory;
import com.sibvisions.rad.server.protocol.Record;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.GroupHashtable;
import com.sibvisions.util.ICloseable;
import com.sibvisions.util.IValidatable;
import com.sibvisions.util.KeyValueList;
import com.sibvisions.util.ObjectCache;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.LoggerFactory;
import com.sibvisions.util.type.CommonUtil;
import com.sibvisions.util.type.DateUtil;
import com.sibvisions.util.type.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.rad.io.IFileHandle;
import javax.rad.io.RemoteFileHandle;
import javax.rad.model.MetaDataCacheOption;
import javax.rad.model.ModelException;
import javax.rad.model.SortDefinition;
import javax.rad.model.condition.And;
import javax.rad.model.condition.CompareCondition;
import javax.rad.model.condition.Equals;
import javax.rad.model.condition.Greater;
import javax.rad.model.condition.GreaterEquals;
import javax.rad.model.condition.ICondition;
import javax.rad.model.condition.Less;
import javax.rad.model.condition.LessEquals;
import javax.rad.model.condition.Like;
import javax.rad.model.condition.LikeIgnoreCase;
import javax.rad.model.condition.LikeReverse;
import javax.rad.model.condition.LikeReverseIgnoreCase;
import javax.rad.model.condition.Not;
import javax.rad.model.condition.OperatorCondition;
import javax.rad.model.condition.Or;
import javax.rad.model.datatype.BigDecimalDataType;
import javax.rad.model.datatype.BooleanDataType;
import javax.rad.model.datatype.IDataType;
import javax.rad.model.datatype.StringDataType;
import javax.rad.model.datatype.TimestampDataType;
import javax.rad.persist.DataSourceException;
import javax.rad.server.ISession;
import javax.rad.server.SessionContext;
import javax.rad.util.TranslationMap;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBAccess
implements IDBAccess,
ICloseable {
    public static final int NCHAR = -15;
    public static final int NVARCHAR = -9;
    public static final int LONGNVARCHAR = -16;
    public static final int SQLXML = 2009;
    public static final int NCLOB = 2011;
    public static final String QUOTE = "`";
    private static TranslationMap tmpAutoLinkColumnNames = new TranslationMap();
    private static Hashtable<String, Class<? extends DBAccess>> dbAccessClasses = new Hashtable();
    private static KeyValueList<String, String> kvlApplicationGroups = new KeyValueList();
    private static long lDefaultLargeObjectLimit = 8192L;
    private static GroupHashtable<String, String, List<ForeignKey>> ghtFKsCache = new GroupHashtable();
    private static GroupHashtable<String, String, Key> ghtPKCache = new GroupHashtable();
    private static GroupHashtable<String, String, List<Key>> ghtUKsCache = new GroupHashtable();
    private static GroupHashtable<String, String, Map<String, Object[]>> ghtAllowedValuesCache = new GroupHashtable();
    private static GroupHashtable<String, String, Map<String, Object>> ghtDefaultValuesCache = new GroupHashtable();
    private static GroupHashtable<String, String, ServerColumnMetaData[]> ghtColumnMetaDataCache = new GroupHashtable();
    private static GroupHashtable<String, String, TableInfo> ghtTableInfoCache = new GroupHashtable();
    private static GroupHashtable<String, String, String> ghtTableNameCache = new GroupHashtable();
    private static final List<ForeignKey> FKS_NULL = new ArrayUtil<ForeignKey>();
    private static final Key PKS_NULL = new Key(null, null);
    private static final List<Key> UKS_NULL = new ArrayUtil<Key>();
    private static final Map<String, Object[]> ALLOWED_VALUES_NULL = new Hashtable<String, Object[]>();
    private static final Map<String, Object> DEFAULT_VALUES_NULL = new Hashtable<String, Object>();
    private static final ServerColumnMetaData[] COLUMNMETADATA_NULL = new ServerColumnMetaData[0];
    private static final TableInfo TABLEINFO_NULL = new TableInfo(null, null, null);
    private static final String TABLENAME_NULL = new String("TABLENAME_NULL");
    private MetaDataCacheOption mdcCacheOption = MetaDataCacheOption.Default;
    private static ILogger logger = null;
    private static boolean lastGlobalMetaDataCache = false;
    private boolean bModified;
    private int iMaxTime = 100;
    private Connection cConnection;
    private String sUrl;
    private String sDriver;
    private String sUsername;
    private String sPassword;
    private String sOpenQuote;
    private String sCloseQuote;
    private String sDefaultSchema;
    private String sApplicationName = "";
    private Properties properties = new Properties();
    private int iQueryTimeOut = 0;
    private Hashtable<Select, ResultSet> htFetchResultSetCache = new Hashtable();
    private DateUtil dateUtil = new DateUtil(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
    private boolean bExternalConnection = false;
    private int iMaxColumnLength;
    private String sIdentifier = null;
    private long lLargeObjectLimit = lDefaultLargeObjectLimit;

    public DBAccess() {
        this.setQuoteCharacters("\"", "\"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DBAccess getDBAccess(String string) throws DataSourceException {
        Object object;
        Object object2;
        if (string == null) {
            return null;
        }
        if (!DBAccess.isJdbc(string)) {
            try {
                object2 = new InitialContext();
                try {
                    object = ((InitialContext)object2).lookup(string);
                    if (object instanceof DBAccess) {
                        DBAccess dBAccess = (DBAccess)object;
                        Object var5_8 = null;
                        ((InitialContext)object2).close();
                        return dBAccess;
                    }
                    if (object instanceof Connection) {
                        DBAccess dBAccess = DBAccess.getDBAccess((Connection)object, true);
                        Object var5_9 = null;
                        ((InitialContext)object2).close();
                        return dBAccess;
                    }
                    if (object instanceof DataSource) {
                        DBAccess dBAccess = DBAccess.getDBAccess(((DataSource)object).getConnection(), true);
                        Object var5_10 = null;
                        ((InitialContext)object2).close();
                        return dBAccess;
                    }
                    Object var5_11 = null;
                    ((InitialContext)object2).close();
                }
                catch (Throwable throwable) {
                    Object var5_12 = null;
                    ((InitialContext)object2).close();
                    throw throwable;
                }
            }
            catch (Exception exception) {
                throw new DataSourceException("JNDI URL used, but resource was not found!", exception);
            }
        }
        object2 = DBAccess.getDBAccessClass(string);
        try {
            object = (DBAccess)((Class)object2).newInstance();
            ((DBAccess)object).setUrl(string);
            return object;
        }
        catch (Exception exception) {
            throw new DataSourceException("Instantion of '" + object2 + "' failed!", exception);
        }
    }

    public static DBAccess getDBAccess(DBCredentials dBCredentials) throws DataSourceException {
        if (dBCredentials == null) {
            return null;
        }
        Class<? extends DBAccess> clazz = DBAccess.getDBAccessClass(dBCredentials.getUrl());
        try {
            DBAccess dBAccess = clazz.newInstance();
            String string = dBCredentials.getDriver();
            if (!StringUtil.isEmpty(string)) {
                dBAccess.setDriver(string);
            }
            dBAccess.setUrl(dBCredentials.getUrl());
            dBAccess.setUsername(dBCredentials.getUserName());
            dBAccess.setPassword(dBCredentials.getPassword());
            return dBAccess;
        }
        catch (Exception exception) {
            throw new DataSourceException("Instantion of '" + clazz + "' failed!", exception);
        }
    }

    public static long getDefaultLargeObjectLimit() {
        return lDefaultLargeObjectLimit;
    }

    public static DBAccess getDBAccess(Connection connection) throws DataSourceException {
        return DBAccess.getDBAccess(connection, false);
    }

    private static DBAccess getDBAccess(Connection connection, boolean bl) throws DataSourceException {
        if (connection == null) {
            throw new DataSourceException("Connection is null");
        }
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String string = databaseMetaData.getURL();
            Class<? extends DBAccess> clazz = DBAccess.getDBAccessClass(string);
            DBAccess dBAccess = clazz.newInstance();
            dBAccess.setUrl(string);
            dBAccess.setUsername(databaseMetaData.getUserName());
            dBAccess.setConnection(connection);
            dBAccess.bExternalConnection = bl;
            return dBAccess;
        }
        catch (Exception exception) {
            throw new DataSourceException("Database detection for '" + connection.getClass().getName() + "' failed!", exception);
        }
    }

    private static Class<? extends DBAccess> getDBAccessClass(String string) {
        for (String string2 : dbAccessClasses.keySet()) {
            if (!string.startsWith(string2)) continue;
            return dbAccessClasses.get(string2);
        }
        return DBAccess.class;
    }

    public static void registerDBAccessClass(String string, Class<? extends DBAccess> clazz) {
        dbAccessClasses.put(string, clazz);
    }

    public static void setAutomaticLinkColumnNameTranslation(TranslationMap translationMap) {
        tmpAutoLinkColumnNames = translationMap;
    }

    public static TranslationMap getAutomaticLinkColumnNameTranslation() {
        return tmpAutoLinkColumnNames;
    }

    public static void setDefaultLargeObjectLimit(long l) {
        lDefaultLargeObjectLimit = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Key> getUniqueKeysIntern(String string, String string2, String string3) throws DataSourceException {
        Object object;
        long l;
        ArrayUtil<Key> arrayUtil;
        ArrayUtil<Key> arrayUtil2;
        ResultSet resultSet;
        block11: {
            resultSet = null;
            arrayUtil2 = new ArrayUtil<Key>();
            arrayUtil = new ArrayUtil<Key>();
            l = System.currentTimeMillis();
            DatabaseMetaData databaseMetaData = this.cConnection.getMetaData();
            resultSet = databaseMetaData.getIndexInfo(DBAccess.removeQuotes(string), DBAccess.removeQuotes(string2), DBAccess.removeQuotes(string3), true, false);
            if (resultSet.next()) break block11;
            CommonUtil.close(resultSet);
            ArrayUtil<Key> arrayUtil3 = arrayUtil2;
            Object var15_12 = null;
            CommonUtil.close(resultSet);
            return arrayUtil3;
        }
        try {
            String string4 = null;
            do {
                if (resultSet.getString("COLUMN_NAME") == null) continue;
                if (string4 != null && !resultSet.getString("INDEX_NAME").equals(string4)) {
                    object = new Key(string4, arrayUtil.toArray(new Name[arrayUtil.size()]));
                    arrayUtil2.add((Key)object);
                    arrayUtil.clear();
                }
                string4 = resultSet.getString("INDEX_NAME");
                object = this.removeDBSpecificQuotes(resultSet.getString("COLUMN_NAME"));
                arrayUtil.add((Key)((Object)new Name((String)object, this.quote((String)object))));
            } while (resultSet.next());
            if (arrayUtil.size() > 0) {
                object = new Key(string4, arrayUtil.toArray(new Name[arrayUtil.size()]));
                arrayUtil2.add((Key)object);
            }
            if (arrayUtil2.size() > 0 && (object = this.getPrimaryKey(string, string2, string3)) != null) {
                for (int i = arrayUtil2.size() - 1; i >= 0; --i) {
                    Name[] nameArray = arrayUtil2.get(i).getColumns();
                    if (!ArrayUtil.containsAll(nameArray, ((Key)object).getColumns()) || nameArray.length != ((Key)object).getColumns().length) continue;
                    arrayUtil2.remove(i);
                }
            }
            if (DBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                DBAccess.debug("getUKs(", string3, ") in ", System.currentTimeMillis() - l, "ms");
            }
            object = arrayUtil2;
            Object var15_13 = null;
        }
        catch (SQLException sQLException) {
            try {
                DBAccess.error("Unique Keys couldn't determined from database! - ", string3, sQLException);
                arrayUtil = null;
                Object var15_14 = null;
            }
            catch (Throwable throwable) {
                Object var15_15 = null;
                CommonUtil.close(resultSet);
                throw throwable;
            }
            CommonUtil.close(resultSet);
            return arrayUtil;
        }
        CommonUtil.close(resultSet);
        return object;
    }

    public long getLargeObjectLimit() {
        return this.lLargeObjectLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Key getPrimaryKeyIntern(String string, String string2, String string3) throws DataSourceException {
        Key key;
        String string4;
        ArrayUtil<Name> arrayUtil;
        long l;
        ResultSet resultSet;
        block8: {
            resultSet = null;
            l = System.currentTimeMillis();
            arrayUtil = new ArrayUtil<Name>();
            string4 = null;
            DatabaseMetaData databaseMetaData = this.cConnection.getMetaData();
            resultSet = databaseMetaData.getPrimaryKeys(DBAccess.removeQuotes(string), DBAccess.removeQuotes(string2), DBAccess.removeQuotes(string3));
            if (resultSet.next()) break block8;
            Key key2 = null;
            Object var13_12 = null;
            CommonUtil.close(resultSet);
            return key2;
        }
        try {
            Key key3;
            do {
                if (string4 == null) {
                    string4 = resultSet.getString("PK_NAME");
                }
                arrayUtil.add(new Name(resultSet.getString("COLUMN_NAME"), this.quote(resultSet.getString("COLUMN_NAME"))));
            } while (resultSet.next());
            if (DBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                DBAccess.debug("getPK(", string3, ") in ", System.currentTimeMillis() - l, "ms");
            }
            key = key3 = new Key(string4, arrayUtil.toArray(new Name[arrayUtil.size()]));
            Object var13_13 = null;
        }
        catch (SQLException sQLException) {
            Key key4;
            try {
                DBAccess.error("PrimaryKey couldn't determined from database! - ", string3, sQLException);
                key4 = null;
                Object var13_14 = null;
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                CommonUtil.close(resultSet);
                throw throwable;
            }
            CommonUtil.close(resultSet);
            return key4;
        }
        CommonUtil.close(resultSet);
        return key;
    }

    protected List<ForeignKey> getForeignKeysIntern(String string, String string2, String string3) throws DataSourceException {
        ArrayUtil<ForeignKey> arrayUtil;
        long l;
        ArrayUtil<ForeignKey> arrayUtil2;
        ResultSet resultSet;
        block9: {
            resultSet = null;
            arrayUtil2 = new ArrayUtil<ForeignKey>();
            l = System.currentTimeMillis();
            DatabaseMetaData databaseMetaData = this.cConnection.getMetaData();
            resultSet = databaseMetaData.getImportedKeys(DBAccess.removeQuotes(string), DBAccess.removeQuotes(string2), DBAccess.removeQuotes(string3));
            if (resultSet.next()) break block9;
            ArrayUtil<ForeignKey> arrayUtil3 = arrayUtil2;
            Object var16_11 = null;
            CommonUtil.close(resultSet);
            return arrayUtil3;
        }
        try {
            String string4 = null;
            String string5 = null;
            ArrayUtil<Name> arrayUtil4 = new ArrayUtil<Name>();
            ArrayUtil<Name> arrayUtil5 = new ArrayUtil<Name>();
            ForeignKey foreignKey = new ForeignKey(new Name(resultSet.getString("PKTABLE_NAME"), this.quote(resultSet.getString("PKTABLE_NAME"))), new Name(resultSet.getString("PKTABLE_CAT"), this.quote(resultSet.getString("PKTABLE_CAT"))), new Name(resultSet.getString("PKTABLE_SCHEM"), this.quote(resultSet.getString("PKTABLE_SCHEM"))));
            do {
                if (!((string4 = resultSet.getString("FK_NAME")) != null && string4.length() != 0 || (string4 = resultSet.getString("PK_NAME")) != null && string4.length() != 0)) {
                    throw new DataSourceException("Database/jdbc driver didn't support FK, PK names!");
                }
                if (string5 != null && !string5.equals(string4)) {
                    foreignKey.setFKColumns(arrayUtil5.toArray(new Name[arrayUtil5.size()]));
                    foreignKey.setPKColumns(arrayUtil4.toArray(new Name[arrayUtil4.size()]));
                    arrayUtil2.add(foreignKey);
                    arrayUtil4.clear();
                    arrayUtil5.clear();
                    foreignKey = new ForeignKey(new Name(resultSet.getString("PKTABLE_NAME"), this.quote(resultSet.getString("PKTABLE_NAME"))), new Name(resultSet.getString("PKTABLE_CAT"), this.quote(resultSet.getString("PKTABLE_CAT"))), new Name(resultSet.getString("PKTABLE_SCHEM"), this.quote(resultSet.getString("PKTABLE_SCHEM"))));
                }
                string5 = string4;
                arrayUtil4.add(new Name(resultSet.getString("PKCOLUMN_NAME"), this.quote(resultSet.getString("PKCOLUMN_NAME"))));
                arrayUtil5.add(new Name(resultSet.getString("FKCOLUMN_NAME"), this.quote(resultSet.getString("FKCOLUMN_NAME"))));
                foreignKey.setFKName(resultSet.getString("FK_NAME"));
            } while (resultSet.next());
            foreignKey.setFKColumns(arrayUtil5.toArray(new Name[arrayUtil5.size()]));
            foreignKey.setPKColumns(arrayUtil4.toArray(new Name[arrayUtil4.size()]));
            arrayUtil2.add(foreignKey);
            if (DBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                DBAccess.debug("getFKs(", string3, ") in ", System.currentTimeMillis() - l, "ms");
            }
            arrayUtil = arrayUtil2;
            Object var16_12 = null;
        }
        catch (SQLException sQLException) {
            try {
                throw new DataSourceException("Foreign Keys couldn't determined from database! - " + string3, this.formatSQLException(sQLException));
            }
            catch (Throwable throwable) {
                Object var16_13 = null;
                CommonUtil.close(resultSet);
                throw throwable;
            }
        }
        CommonUtil.close(resultSet);
        return arrayUtil;
    }

    public final List<Key> getUniqueKeys(String string, String string2, String string3) throws DataSourceException {
        if (this.isMetaDataCacheEnabled()) {
            String string4 = this.getIdentifier();
            String string5 = DBAccess.createIdentifier(string, string2, string3);
            List<Key> list = ghtUKsCache.get(string4, string5);
            if (list == null) {
                list = this.getUniqueKeysIntern(string, string2, string3);
                if (list == null) {
                    list = UKS_NULL;
                }
                ghtUKsCache.put(string4, string5, list);
            }
            if (list == UKS_NULL) {
                return null;
            }
            return list;
        }
        return this.getUniqueKeysIntern(string, string2, string3);
    }

    public final Key getPrimaryKey(String string, String string2, String string3) throws DataSourceException {
        if (this.isMetaDataCacheEnabled()) {
            String string4 = this.getIdentifier();
            String string5 = DBAccess.createIdentifier(string, string2, string3);
            Key key = ghtPKCache.get(string4, string5);
            if (key == null) {
                key = this.getPrimaryKeyIntern(string, string2, string3);
                if (key == null) {
                    key = PKS_NULL;
                }
                ghtPKCache.put(string4, string5, key);
            }
            if (key == PKS_NULL) {
                return null;
            }
            return key;
        }
        return this.getPrimaryKeyIntern(string, string2, string3);
    }

    public final List<ForeignKey> getForeignKeys(String string, String string2, String string3) throws DataSourceException {
        if (this.isMetaDataCacheEnabled()) {
            String string4 = this.getIdentifier();
            String string5 = DBAccess.createIdentifier(string, string2, string3);
            List<ForeignKey> list = ghtFKsCache.get(string4, string5);
            if (list == null) {
                list = this.getForeignKeysIntern(string, string2, string3);
                if (list == null) {
                    list = FKS_NULL;
                }
                ghtFKsCache.put(string4, string5, list);
            }
            if (list == FKS_NULL) {
                return null;
            }
            return list;
        }
        return this.getForeignKeysIntern(string, string2, string3);
    }

    public final String getTableForSynonym(String string) throws DataSourceException {
        if (this.isMetaDataCacheEnabled()) {
            String string2 = this.getIdentifier();
            String string3 = DBAccess.createIdentifier(string);
            String string4 = ghtTableNameCache.get(string2, string3);
            if (string4 == null) {
                string4 = this.getTableForSynonymIntern(string);
                if (string4 == null) {
                    string4 = TABLENAME_NULL;
                }
                ghtTableNameCache.put(string2, string3, string4);
            }
            if (string4 == TABLENAME_NULL) {
                return null;
            }
            return string4;
        }
        return this.getTableForSynonymIntern(string);
    }

    protected String getTableForSynonymIntern(String string) throws DataSourceException {
        return string;
    }

    @Override
    public List<Object[]> fetch(ServerMetaData serverMetaData, String string, String[] stringArray, String string2, ICondition iCondition, String string3, String string4, SortDefinition sortDefinition, int n, int n2, boolean bl) throws DataSourceException {
        return this.fetch(serverMetaData, string, stringArray, string2, iCondition, string3, string4, sortDefinition, null, n, n2, bl);
    }

    public List<Object[]> fetch(ServerMetaData serverMetaData, String string, String[] stringArray, String string2, ICondition iCondition, String string3, String string4, SortDefinition sortDefinition, int n, int n2) throws DataSourceException {
        return this.fetch(serverMetaData, string, stringArray, string2, iCondition, string3, string4, sortDefinition, null, n, n2, false);
    }

    public List<Object[]> fetch(ServerMetaData serverMetaData, String string, String[] stringArray, String string2, ICondition iCondition, String string3, String string4, SortDefinition sortDefinition, String string5, int n, int n2) throws DataSourceException {
        return this.fetch(serverMetaData, string, stringArray, string2, iCondition, string3, string4, sortDefinition, string5, n, n2, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Object[]> fetch(ServerMetaData serverMetaData, String string, String[] stringArray, String string2, ICondition iCondition, String string3, String string4, SortDefinition sortDefinition, String string5, int n, int n2, boolean bl) throws DataSourceException {
        Record record = ProtocolFactory.openRecord("FETCH", new Object[0]);
        try {
            if (!this.isOpen()) {
                throw new DataSourceException("DBAccess is not open!");
            }
            long l = System.currentTimeMillis();
            String string6 = this.getSelectStatement(serverMetaData, string, stringArray, string2, iCondition, string3, string4, sortDefinition, string5);
            Object[] objectArray = this.getParameter(iCondition);
            if (record != null) {
                if (objectArray != null && objectArray.length > 0) {
                    record.setParameter(string6, objectArray);
                } else {
                    record.setParameter(string6);
                }
            }
            ServerColumnMetaData[] serverColumnMetaDataArray = serverMetaData.getServerColumnMetaData();
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                Select select = new Select(string6, objectArray, n);
                resultSet = this.htFetchResultSetCache.remove(select);
                ArrayUtil<Object[]> arrayUtil = new ArrayUtil<Object[]>();
                if (resultSet != null) {
                    preparedStatement = (PreparedStatement)resultSet.getStatement();
                } else {
                    preparedStatement = this.getPreparedStatement(string6, false);
                    if (this.iQueryTimeOut > 0) {
                        preparedStatement.setQueryTimeout(this.iQueryTimeOut);
                    }
                    if (iCondition != null) {
                        this.setFilterParameter(1, preparedStatement, objectArray);
                    }
                    resultSet = preparedStatement.executeQuery();
                    for (int i = 0; i < n; ++i) {
                        if (resultSet.next()) continue;
                        arrayUtil.add(null);
                        CommonUtil.close(resultSet, preparedStatement);
                        if (record != null) {
                            record.setCount(arrayUtil.size());
                        }
                        ArrayUtil<Object[]> arrayUtil2 = arrayUtil;
                        Object var41_27 = null;
                        CommonUtil.close(record);
                        return arrayUtil2;
                    }
                    if (DBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                        DBAccess.debug("select(", string6, ", ", this.getParameter(iCondition), ", from Row ", n, ", MinimumCount ", n2, ") in ", System.currentTimeMillis() - l, "ms");
                    }
                }
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                l = System.currentTimeMillis();
                int n3 = this.iMaxTime;
                int n4 = serverMetaData.getMetaData().getColumnMetaDataCount();
                int n5 = resultSetMetaData.getColumnCount();
                int[] nArray = null;
                boolean[] blArray = null;
                String string7 = null;
                int n6 = 0;
                while (true) {
                    int n7;
                    Object object;
                    Object object2;
                    block40: {
                        block41: {
                            block38: {
                                block39: {
                                    if (n2 >= 0 && n6 >= n2 && n3 < 0) break block38;
                                    object2 = null;
                                    if (!resultSet.next()) break block39;
                                    object2 = new Object[n4];
                                    if (nArray != null) break block40;
                                    nArray = new int[n5];
                                    blArray = new boolean[n5];
                                    break block41;
                                }
                                arrayUtil.add(null);
                                CommonUtil.close(resultSet, preparedStatement);
                                if (record != null) {
                                    record.setCount(arrayUtil.size());
                                }
                                object = arrayUtil;
                                Object var41_28 = null;
                                CommonUtil.close(record);
                                return object;
                            }
                            if (arrayUtil.size() == 0) {
                                arrayUtil.add(null);
                                CommonUtil.close(resultSet, preparedStatement);
                            } else {
                                this.htFetchResultSetCache.put(new Select(string6, objectArray, n + n6), resultSet);
                            }
                            if (record != null) {
                                record.setCount(arrayUtil.size());
                            }
                            object2 = arrayUtil;
                            Object var41_29 = null;
                            CommonUtil.close(record);
                            return object2;
                        }
                        for (int i = 0; i < n5; ++i) {
                            n7 = serverMetaData.getServerColumnMetaDataIndex(this.getColumnName(resultSetMetaData, i + 1).toUpperCase());
                            if (n7 >= 0) {
                                nArray[i] = n7;
                                blArray[i] = serverMetaData.getServerColumnMetaData(n7).getColumnMetaData().isFetchLargObjectsLazy();
                                continue;
                            }
                            nArray[i] = i;
                        }
                    }
                    object = null;
                    for (n7 = 0; n7 < n5; ++n7) {
                        Object object3;
                        Object object4 = resultSet.getObject(n7 + 1);
                        int n8 = nArray[n7];
                        if (object4 instanceof Number && !(object4 instanceof BigDecimal)) {
                            object4 = resultSet.getBigDecimal(n7 + 1);
                        } else if (object4 instanceof Date && !(object4 instanceof Timestamp)) {
                            object4 = resultSet.getTimestamp(n7 + 1);
                        } else if (object4 instanceof Clob) {
                            object3 = (Clob)object4;
                            object4 = object3.getSubString(1L, (int)object3.length());
                        } else if (object4 instanceof Blob) {
                            object3 = (Blob)object4;
                            if (bl && blArray[n8] && object3 != null && object3.length() >= this.lLargeObjectLimit) {
                                Object object5;
                                Object object6;
                                if (string7 == null) {
                                    string7 = DBAccess.createIdentifier(this.getConnection(), string2);
                                }
                                if (object == null) {
                                    object6 = serverMetaData.getPrimaryKeyColumnIndices();
                                    object5 = new ArrayList();
                                    for (int i = 0; i < nArray.length; ++i) {
                                        if (!ArrayUtil.contains(object6, nArray[i])) continue;
                                        object5.add(resultSet.getObject(i + 1));
                                    }
                                    object = string7 + DBAccess.createIdentifier(object5.toArray(new Object[object5.size()]));
                                }
                                object6 = serverColumnMetaDataArray[n8].getName();
                                object5 = object + "/" + (String)object6;
                                BlobFileHandle blobFileHandle = new BlobFileHandle((String)object6, (Blob)object3);
                                ObjectCache.put(object5, blobFileHandle);
                                object4 = new RemoteFileHandle((String)object6, object5);
                            } else {
                                object4 = object3.getBytes(1L, (int)object3.length());
                            }
                        }
                        object2[n8] = this.convertDatabaseSpecificObjectToValue(serverColumnMetaDataArray[n8], object4);
                    }
                    arrayUtil.add((Object[])object2);
                    n3 = this.iMaxTime - (int)(System.currentTimeMillis() - l);
                    ++n6;
                }
            }
            catch (Exception exception) {
                Exception exception2;
                CommonUtil.close(resultSet, preparedStatement);
                String string8 = "fetch statement failed! - " + string6;
                if (exception instanceof SQLException) {
                    exception2 = this.formatSQLException((SQLException)exception);
                    throw new DataSourceException(string8, exception2);
                }
                exception2 = exception;
                throw new DataSourceException(string8, exception2);
            }
        }
        catch (Throwable throwable) {
            Object var41_30 = null;
            CommonUtil.close(record);
            throw throwable;
        }
    }

    @Override
    public void lockRow(String string, ServerMetaData serverMetaData, ICondition iCondition) throws DataSourceException {
        if (!this.isOpen()) {
            throw new DataSourceException("DBAccess is not open!");
        }
        if (string == null) {
            throw new DataSourceException("Missing WriteBackTable!");
        }
        try {
            if (!this.cConnection.getAutoCommit() && this.cConnection.getMetaData().supportsSelectForUpdate()) {
                this.lockRowInternal(string, serverMetaData, iCondition);
            }
        }
        catch (SQLException sQLException) {
            throw new DataSourceException("Execute locking failed!", this.formatSQLException(sQLException));
        }
    }

    protected int lockRowInternal(String string, ServerMetaData serverMetaData, ICondition iCondition) throws DataSourceException {
        return this.getRowCount(this.getDatabaseSpecificLockStatement(string, serverMetaData, iCondition), iCondition, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] insert(String string, ServerMetaData serverMetaData, Object[] objectArray) throws DataSourceException {
        Object[] objectArray2;
        Record record = ProtocolFactory.openRecord("INSERT", string);
        try {
            int n;
            if (!this.isOpen()) {
                throw new DataSourceException("DBAccess is not open!");
            }
            if (string == null) {
                throw new DataSourceException("Missing WriteBackTable!");
            }
            StringBuilder stringBuilder = new StringBuilder("INSERT INTO ");
            stringBuilder.append(string);
            stringBuilder.append(" (");
            int n2 = 0;
            String string2 = null;
            ServerColumnMetaData[] serverColumnMetaDataArray = serverMetaData.getServerColumnMetaData();
            int[] nArray = serverMetaData.getWritableColumnIndices();
            for (n = 0; n < nArray.length; ++n) {
                if (objectArray[nArray[n]] == null) continue;
                if (n2 > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(serverColumnMetaDataArray[nArray[n]].getColumnName().getQuotedName());
                ++n2;
            }
            if (n2 == 0) {
                for (n = 0; n2 == 0 && n < nArray.length; ++n) {
                    if (serverColumnMetaDataArray[nArray[n]].isAutoIncrement()) continue;
                    string2 = serverColumnMetaDataArray[nArray[n]].getColumnName().getQuotedName();
                    stringBuilder.append(string2);
                    ++n2;
                }
            }
            stringBuilder.append(") VALUES (");
            if (n2 > 0) {
                stringBuilder.append("?");
                for (n = 1; n < n2; ++n) {
                    stringBuilder.append(",?");
                }
            }
            stringBuilder.append(")");
            this.setModified(true);
            objectArray = this.insertDatabaseSpecific(string, stringBuilder.toString(), serverMetaData, objectArray, string2);
            if (DBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                DBAccess.debug(stringBuilder.toString(), "[", objectArray, "]");
            }
            if (serverMetaData.getPrimaryKeyType() != ServerMetaData.PrimaryKeyType.AllColumns) {
                n = 1;
                int[] nArray2 = serverMetaData.getPrimaryKeyColumnIndices();
                if (nArray2 != null) {
                    for (int i = 0; i < nArray2.length && n != 0; ++i) {
                        if (objectArray[nArray2[i]] == null) continue;
                        n = 0;
                    }
                }
                if (n != 0) {
                    throw new DataSourceException("Primary key column empty after insert!" + string);
                }
            }
            objectArray2 = objectArray;
            Object var14_14 = null;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            CommonUtil.close(record);
            throw throwable;
        }
        CommonUtil.close(record);
        return objectArray2;
    }

    public void setLargeObjectLimit(long l) {
        this.lLargeObjectLimit = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] update(String string, ServerMetaData serverMetaData, Object[] objectArray, Object[] objectArray2) throws DataSourceException {
        Object[] objectArray3;
        Record record;
        block18: {
            int n;
            int n2;
            StringBuilder stringBuilder;
            block17: {
                record = ProtocolFactory.openRecord("UPDATE", string);
                try {
                    if (!this.isOpen()) {
                        throw new DataSourceException("DBAccess is not open!");
                    }
                    if (string == null) {
                        throw new DataSourceException("Missing WriteBackTable!");
                    }
                    if (serverMetaData.getPrimaryKeyColumnNames() == null || serverMetaData.getPrimaryKeyColumnNames().length == 0) {
                        throw new DataSourceException("PK Columns empty! - update not possible!");
                    }
                    stringBuilder = new StringBuilder("UPDATE ");
                    stringBuilder.append(string);
                    stringBuilder.append(" SET ");
                    n2 = 0;
                    ServerColumnMetaData[] serverColumnMetaDataArray = serverMetaData.getServerColumnMetaData();
                    int[] nArray = serverMetaData.getWritableColumnIndices();
                    for (int i = 0; i < nArray.length; ++i) {
                        IDataType iDataType = serverColumnMetaDataArray[nArray[i]].getDataType();
                        if (iDataType.compareTo(objectArray2[nArray[i]], objectArray[nArray[i]]) == 0) continue;
                        if (n2 > 0) {
                            stringBuilder.append(", ");
                        }
                        stringBuilder.append(serverColumnMetaDataArray[nArray[i]].getColumnName().getQuotedName());
                        stringBuilder.append(" = ? ");
                        ++n2;
                    }
                    ICondition iCondition = Filter.createEqualsFilter(serverMetaData.getPrimaryKeyColumnNames(), objectArray, serverMetaData.getMetaData().getColumnMetaData());
                    n = 0;
                    if (n2 == 0) {
                        try {
                            if (!this.cConnection.getAutoCommit() && this.cConnection.getMetaData().supportsSelectForUpdate()) {
                                n = this.lockRowInternal(string, serverMetaData, iCondition);
                            }
                            objectArray3 = new StringBuilder("SELECT * FROM ");
                            objectArray3.append(string);
                            objectArray3.append(this.getWhereClause(serverMetaData, iCondition, null, false));
                            n = this.getRowCount(objectArray3.toString(), iCondition, 1);
                        }
                        catch (SQLException sQLException) {
                            throw new DataSourceException("Connection access failed!", this.formatSQLException(sQLException));
                        }
                    } else {
                        stringBuilder.append(this.getWhereClause(serverMetaData, iCondition, null, false));
                        this.setModified(true);
                        n = this.updateDatabaseSpecific(string, stringBuilder.toString(), serverMetaData, objectArray, objectArray2, iCondition);
                        if (DBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                            DBAccess.debug(stringBuilder.toString(), "[", objectArray2, "]");
                        }
                    }
                    if (record != null) {
                        record.setCount(n);
                    }
                    if (n != 0) break block17;
                    objectArray3 = this.insert(string, serverMetaData, objectArray2);
                    Object var14_16 = null;
                }
                catch (Throwable throwable) {
                    Object var14_19 = null;
                    CommonUtil.close(record);
                    throw throwable;
                }
                CommonUtil.close(record);
                return objectArray3;
            }
            if (n != 1) {
                throw new DataSourceException("Update failed ! - Result row count != 1 ! - " + stringBuilder.toString());
            }
            if (n2 != 0) break block18;
            objectArray3 = objectArray;
            Object var14_17 = null;
            CommonUtil.close(record);
            return objectArray3;
        }
        objectArray3 = objectArray2;
        Object var14_18 = null;
        CommonUtil.close(record);
        return objectArray3;
    }

    public int updateDatabaseSpecific(String string, String string2, ServerMetaData serverMetaData, Object[] objectArray, Object[] objectArray2, ICondition iCondition) throws DataSourceException {
        return this.updateAnsiSQL(string, string2, serverMetaData, objectArray, objectArray2, iCondition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateAnsiSQL(String string, String string2, ServerMetaData serverMetaData, Object[] objectArray, Object[] objectArray2, ICondition iCondition) throws DataSourceException {
        int n;
        ServerColumnMetaData[] serverColumnMetaDataArray = serverMetaData.getServerColumnMetaData();
        int[] nArray = serverMetaData.getWritableColumnIndices();
        PreparedStatement preparedStatement = this.getPreparedStatement(string2, false);
        try {
            int n2 = this.setColumnsToStore(preparedStatement, serverColumnMetaDataArray, nArray, objectArray2, objectArray) + 1;
            this.setFilterParameter(n2, preparedStatement, this.getParameter(iCondition));
            n = this.executeUpdate(preparedStatement);
            Object var13_12 = null;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            CommonUtil.close(preparedStatement);
            throw throwable;
        }
        CommonUtil.close(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String string, ServerMetaData serverMetaData, Object[] objectArray) throws DataSourceException {
        Record record = ProtocolFactory.openRecord("DELETE", string);
        try {
            if (!this.isOpen()) {
                throw new DataSourceException("DBAccess is not open!");
            }
            if (string == null) {
                throw new DataSourceException("Missing WriteBackTable!");
            }
            if (serverMetaData.getPrimaryKeyColumnNames() == null || serverMetaData.getPrimaryKeyColumnNames().length == 0) {
                throw new DataSourceException("PK Columns empty! - delete not possible!");
            }
            ICondition iCondition = null;
            ServerColumnMetaData[] serverColumnMetaDataArray = serverMetaData.getServerColumnMetaData();
            String[] stringArray = serverMetaData.getPrimaryKeyColumnNames();
            if (serverColumnMetaDataArray != null) {
                iCondition = Filter.createEqualsFilter(stringArray, objectArray, serverMetaData.getMetaData().getColumnMetaData());
            } else {
                iCondition = new Equals(stringArray[0], objectArray[0]);
                for (int i = 1; i < stringArray.length; ++i) {
                    iCondition = iCondition.and(new Equals(stringArray[i], objectArray[i]));
                }
            }
            StringBuilder stringBuilder = new StringBuilder("DELETE FROM ");
            stringBuilder.append(string);
            String string2 = this.getWhereClause(serverMetaData, iCondition, null, false);
            stringBuilder.append(string2);
            DBAccess.debug("delete(", stringBuilder, ")", stringArray, objectArray);
            PreparedStatement preparedStatement = this.getPreparedStatement(stringBuilder.toString(), false);
            try {
                this.setFilterParameter(1, preparedStatement, this.getParameter(iCondition));
                this.setModified(true);
                int n = this.executeUpdate(preparedStatement);
                if (n > 1) {
                    throw new DataSourceException("Delete failed ! - Result row count > 1 ! - " + n + "," + stringBuilder.toString());
                }
                Object var13_13 = null;
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                CommonUtil.close(preparedStatement);
                throw throwable;
            }
            CommonUtil.close(preparedStatement);
            Object var15_16 = null;
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            CommonUtil.close(record);
            throw throwable;
        }
        CommonUtil.close(record);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.sPassword != null ? ",Password set" : ",Password not set";
        boolean bl = false;
        try {
            bl = this.isOpen();
        }
        catch (DataSourceException dataSourceException) {
            return stringBuilder.toString() + " :: " + dataSourceException.getMessage();
        }
        Properties properties = new Properties(this.properties);
        properties.remove("user");
        properties.remove("password");
        stringBuilder.append("DBAccess :: Connected=");
        stringBuilder.append(bl);
        stringBuilder.append(", ConnectionString=");
        stringBuilder.append(this.sUrl);
        stringBuilder.append(", DriverName=");
        stringBuilder.append(this.sDriver);
        stringBuilder.append(", UserName=");
        stringBuilder.append(this.sUsername);
        stringBuilder.append(string);
        stringBuilder.append(",Properties=");
        stringBuilder.append(properties);
        stringBuilder.append("\n");
        stringBuilder.append("ResultSet Cache:\n");
        for (Map.Entry<Select, ResultSet> entry : this.htFetchResultSetCache.entrySet()) {
            stringBuilder.append(entry.getKey());
            stringBuilder.append("\n");
        }
        stringBuilder.append(super.toString());
        return stringBuilder.toString();
    }

    public String getOpenQuoteCharacter() {
        return this.sOpenQuote;
    }

    public String getCloseQuoteCharacter() {
        return this.sCloseQuote;
    }

    protected void setQuoteCharacters(String string, String string2) {
        this.sOpenQuote = string;
        this.sCloseQuote = string2;
    }

    public boolean isAutoQuote(String string) {
        StringUtil.CaseSensitiveType caseSensitiveType = StringUtil.getCaseSensitiveType(string);
        return caseSensitiveType != StringUtil.CaseSensitiveType.UpperCase;
    }

    public String quote(String string) {
        if (string == null) {
            return null;
        }
        if (this.isAutoQuote(string)) {
            return this.quoteAllways(string);
        }
        return string;
    }

    public String quoteAllways(String string) {
        StringBuilder stringBuilder = new StringBuilder(QUOTE);
        stringBuilder.append(StringUtil.replace(string, QUOTE, "\\`"));
        stringBuilder.append(QUOTE);
        return stringBuilder.toString();
    }

    public static String removeQuotes(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        char c = QUOTE.charAt(0);
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c == c2) {
                if (i == 0 || string.charAt(i - 1) != '\\') continue;
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                stringBuilder.append(c2);
                continue;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public String removeDBSpecificQuotes(String string) {
        return StringUtil.removeQuotes(string, this.sOpenQuote, this.sCloseQuote);
    }

    public String translateQuotes(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        char c = QUOTE.charAt(0);
        boolean bl = true;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c == c2) {
                if (i != 0 && string.charAt(i - 1) == '\\') {
                    stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                    stringBuilder.append(c2);
                    continue;
                }
                if (bl) {
                    stringBuilder.append(this.sOpenQuote);
                    bl = false;
                    continue;
                }
                stringBuilder.append(this.sCloseQuote);
                bl = true;
                continue;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws DataSourceException {
        if (!this.isOpen()) {
            ISession iSession = SessionContext.getCurrentSession();
            if (iSession != null) {
                this.sApplicationName = iSession.getApplicationName();
            }
            if (this.sApplicationName == null) {
                this.sApplicationName = "";
            }
            long l = System.currentTimeMillis();
            if (!this.bExternalConnection) {
                if (this.sUrl == null) {
                    throw new DataSourceException("Connection String is null!");
                }
                try {
                    Connection connection;
                    block28: {
                        String string = this.translateQuotes(this.sUsername);
                        connection = null;
                        if (!DBAccess.isJdbc(this.sUrl)) {
                            try {
                                InitialContext initialContext = new InitialContext();
                                try {
                                    Object object = initialContext.lookup(this.sUrl);
                                    if (object instanceof Connection) {
                                        connection = (Connection)object;
                                    } else if (object instanceof DataSource) {
                                        connection = !StringUtil.isEmpty(string) && !StringUtil.isEmpty(this.sPassword) ? ((DataSource)object).getConnection(string, this.sPassword) : ((DataSource)object).getConnection();
                                    } else {
                                        throw new DataSourceException("Configured JNDI resource '" + (connection != null ? connection.getClass().getName() : "null") + " has to be a Connection!");
                                    }
                                    Object var9_13 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var9_14 = null;
                                    initialContext.close();
                                    throw throwable;
                                }
                                initialContext.close();
                                {
                                    break block28;
                                }
                            }
                            catch (Exception exception) {
                                if (exception instanceof DataSourceException) {
                                    throw (DataSourceException)exception;
                                }
                                throw new DataSourceException("JNDI URL used, but resource was not found!", exception);
                            }
                        }
                        if (this.sDriver == null) {
                            throw new DataSourceException("Jdbc Driver is null!");
                        }
                        try {
                            Class.forName(this.sDriver);
                        }
                        catch (Exception exception) {
                            throw new DataSourceException("Jdbc driver not found!", exception);
                        }
                        Properties properties = new Properties(this.properties);
                        if (this.sUsername != null) {
                            properties.setProperty("user", this.sUsername);
                        }
                        if (this.sPassword != null) {
                            properties.setProperty("password", this.sPassword);
                        }
                        connection = DriverManager.getConnection(this.sUrl, properties);
                    }
                    if (connection.getTransactionIsolation() != 2) {
                        connection.setTransactionIsolation(2);
                    }
                    connection.setAutoCommit(true);
                    this.setConnection(connection);
                }
                catch (SQLException sQLException) {
                    String string = this.sPassword != null ? "Password set" : "Password not set";
                    throw new DataSourceException("Connection failed! - " + this.sUrl + "; Username=" + this.sUsername + "; " + string, this.formatSQLException(sQLException));
                }
            }
            try {
                this.iMaxColumnLength = this.cConnection.getMetaData().getMaxColumnNameLength();
                if (this.iMaxColumnLength == 0) {
                    this.iMaxColumnLength = Integer.MAX_VALUE;
                }
            }
            catch (SQLException sQLException) {
                this.iMaxColumnLength = 30;
                DBAccess.debug(sQLException);
            }
            this.bModified = false;
            if (DBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                DBAccess.debug("open(", this.sUrl, ",", this.translateQuotes(this.sUsername), ") in ", System.currentTimeMillis() - l, "ms");
            }
        } else {
            DBAccess.debug("connection is already open!");
        }
    }

    public boolean isOpen() throws DataSourceException {
        try {
            return this.cConnection != null && !this.cConnection.isClosed();
        }
        catch (SQLException sQLException) {
            throw new DataSourceException("Open failed!", this.formatSQLException(sQLException));
        }
    }

    @Override
    public void close() throws DataSourceException {
        if (this.isOpen()) {
            try {
                if (this.cConnection.getAutoCommit()) {
                    this.cConnection.commit();
                } else {
                    this.cConnection.rollback();
                }
            }
            catch (SQLException sQLException) {
                DBAccess.debug(sQLException);
            }
            if (!this.bExternalConnection) {
                CommonUtil.close(this.cConnection);
                this.setConnection(null);
            }
        }
    }

    public void setAutoCommit(boolean bl) throws DataSourceException {
        if (!this.isOpen()) {
            throw new DataSourceException("DBAccess is not open!");
        }
        try {
            this.cConnection.setAutoCommit(bl);
        }
        catch (SQLException sQLException) {
            throw new DataSourceException("Setting autocommit state failed!", this.formatSQLException(sQLException));
        }
    }

    public boolean isAutoCommit() throws DataSourceException {
        if (!this.isOpen()) {
            throw new DataSourceException("DBAccess is not open!");
        }
        try {
            return this.cConnection.getAutoCommit();
        }
        catch (SQLException sQLException) {
            throw new DataSourceException("Can't check autocommit state!", this.formatSQLException(sQLException));
        }
    }

    public void rollback() throws DataSourceException {
        if (!this.isOpen()) {
            throw new DataSourceException("DBAccess is not open!");
        }
        try {
            this.cConnection.rollback();
            this.setModified(false);
        }
        catch (SQLException sQLException) {
            throw new DataSourceException("Rollback failed!", this.formatSQLException(sQLException));
        }
    }

    public void commit() throws DataSourceException {
        if (!this.isOpen()) {
            throw new DataSourceException("DBAccess is not open!");
        }
        try {
            this.cConnection.commit();
            this.setModified(false);
        }
        catch (SQLException sQLException) {
            throw new DataSourceException("Commit failed!", this.formatSQLException(sQLException));
        }
    }

    public int getQueryTimeOut() {
        return this.iQueryTimeOut;
    }

    public void setQueryTimeOut(int n) {
        this.iQueryTimeOut = n;
    }

    public Connection getConnection() {
        return this.cConnection;
    }

    protected void setConnection(Connection connection) {
        this.cConnection = connection;
    }

    public String getDriver() {
        return this.sDriver;
    }

    public void setDriver(String string) {
        this.sDriver = string;
    }

    public String getUrl() {
        return this.sUrl;
    }

    public void setUrl(String string) {
        this.sUrl = string;
    }

    public String getUsername() {
        return this.sUsername;
    }

    public void setUsername(String string) {
        this.sUsername = string;
    }

    public String getPassword() {
        return this.sPassword;
    }

    public void setPassword(String string) {
        this.sPassword = string;
    }

    public void setDBProperty(String string, String string2) {
        if (string2 == null) {
            this.properties.remove(string);
        } else {
            this.properties.setProperty(string, string2);
        }
    }

    public String getDBProperty(String string) {
        return this.properties.getProperty(string);
    }

    public void setDBProperties(Properties properties) {
        this.properties = properties;
    }

    public Properties getDBProperties() {
        return this.properties;
    }

    public int getMaxTime() {
        return this.iMaxTime;
    }

    public void setMaxTime(int n) {
        this.iMaxTime = n;
    }

    public int getMaxColumnLength() {
        return this.iMaxColumnLength;
    }

    public void executeProcedure(String string, Object ... objectArray) throws DataSourceException {
        if (!this.isOpen()) {
            throw new DataSourceException("DBAccess is not open!");
        }
        StringBuilder stringBuilder = new StringBuilder("{ call ");
        stringBuilder.append(string);
        if (objectArray != null && objectArray.length > 0) {
            stringBuilder.append("(");
            for (int i = 0; i < objectArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append("?");
            }
            stringBuilder.append(")");
        }
        stringBuilder.append(" }");
        CallableStatement callableStatement = null;
        try {
            try {
                AbstractParam.ParameterType parameterType;
                AbstractParam abstractParam;
                int n;
                DBAccess.debug("executeProcedure -> ", stringBuilder);
                callableStatement = this.cConnection.prepareCall(this.translateQuotes(stringBuilder.toString()));
                for (n = 0; objectArray != null && n < objectArray.length; ++n) {
                    if (objectArray[n] == null) {
                        callableStatement.setNull(n + 1, 12);
                        continue;
                    }
                    if (objectArray[n] instanceof AbstractParam) {
                        abstractParam = (AbstractParam)objectArray[n];
                        parameterType = abstractParam.getType();
                        if (parameterType == AbstractParam.ParameterType.Out || parameterType == AbstractParam.ParameterType.InOut) {
                            callableStatement.registerOutParameter(n + 1, abstractParam.getSqlType());
                        }
                        if (abstractParam.getValue() == null) {
                            callableStatement.setNull(n + 1, abstractParam.getSqlType());
                            continue;
                        }
                        callableStatement.setObject(n + 1, this.convertValueToDatabaseSpecificObject(abstractParam.getValue()), abstractParam.getSqlType());
                        continue;
                    }
                    callableStatement.setObject(n + 1, this.convertValueToDatabaseSpecificObject(objectArray[n]));
                }
                callableStatement.execute();
                for (n = 0; objectArray != null && n < objectArray.length; ++n) {
                    if (!(objectArray[n] instanceof AbstractParam) || (parameterType = (abstractParam = (AbstractParam)objectArray[n]).getType()) != AbstractParam.ParameterType.Out && parameterType != AbstractParam.ParameterType.InOut) continue;
                    abstractParam.setValue(callableStatement.getObject(n + 1));
                }
                Object var9_10 = null;
            }
            catch (SQLException sQLException) {
                throw new DataSourceException("executeProcedure failed! - " + stringBuilder, this.formatSQLException(sQLException));
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            CommonUtil.close(callableStatement);
            throw throwable;
        }
        CommonUtil.close(callableStatement);
    }

    public Object executeFunction(String string, int n, Object ... objectArray) throws DataSourceException {
        Object object;
        if (!this.isOpen()) {
            throw new DataSourceException("DBAccess is not open!");
        }
        StringBuilder stringBuilder = new StringBuilder("{ ? = call ");
        stringBuilder.append(string);
        if (objectArray != null && objectArray.length > 0) {
            stringBuilder.append("(");
            for (int i = 0; i < objectArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append("?");
            }
            stringBuilder.append(")");
        }
        stringBuilder.append(" }");
        CallableStatement callableStatement = null;
        try {
            AbstractParam.ParameterType parameterType;
            AbstractParam abstractParam;
            DBAccess.debug("executeFunction -> ", stringBuilder);
            callableStatement = this.cConnection.prepareCall(this.translateQuotes(stringBuilder.toString()));
            callableStatement.registerOutParameter(1, n);
            for (int i = 0; objectArray != null && i < objectArray.length; ++i) {
                if (objectArray[i] == null) {
                    callableStatement.setNull(i + 2, 12);
                    continue;
                }
                if (objectArray[i] instanceof AbstractParam) {
                    abstractParam = (AbstractParam)objectArray[i];
                    parameterType = abstractParam.getType();
                    if (parameterType == AbstractParam.ParameterType.Out || parameterType == AbstractParam.ParameterType.InOut) {
                        callableStatement.registerOutParameter(i + 2, abstractParam.getSqlType());
                    }
                    if (abstractParam.getValue() == null) {
                        callableStatement.setNull(i + 2, abstractParam.getSqlType());
                        continue;
                    }
                    callableStatement.setObject(i + 2, this.convertValueToDatabaseSpecificObject(abstractParam.getValue()), abstractParam.getSqlType());
                    continue;
                }
                callableStatement.setObject(i + 2, this.convertValueToDatabaseSpecificObject(objectArray[i]));
            }
            if (callableStatement.execute()) {
                CommonUtil.close(callableStatement.getResultSet());
            }
            Object object2 = callableStatement.getObject(1);
            for (int i = 0; objectArray != null && i < objectArray.length; ++i) {
                if (!(objectArray[i] instanceof AbstractParam) || (parameterType = (abstractParam = (AbstractParam)objectArray[i]).getType()) != AbstractParam.ParameterType.Out && parameterType != AbstractParam.ParameterType.InOut) continue;
                abstractParam.setValue(callableStatement.getObject(i + 2));
            }
            object = object2;
            Object var11_14 = null;
        }
        catch (SQLException sQLException) {
            try {
                throw new DataSourceException("executeFunction failed! - " + stringBuilder, this.formatSQLException(sQLException));
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                CommonUtil.close(callableStatement);
                throw throwable;
            }
        }
        CommonUtil.close(callableStatement);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeStatement(String string) throws SQLException {
        Statement statement = null;
        try {
            statement = this.getConnection().createStatement();
            String string2 = this.translateQuotes(string);
            DBAccess.debug("executeStatement -> ", string2);
            if (statement.execute(string2)) {
                CommonUtil.close(statement.getResultSet());
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            CommonUtil.close(statement);
            throw throwable;
        }
        CommonUtil.close(statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Object> executeSql(String string, Object ... objectArray) throws SQLException {
        List<Object> list;
        PreparedStatement preparedStatement = null;
        try {
            String string2 = this.translateQuotes(string);
            preparedStatement = this.getConnection().prepareStatement(string2);
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] == null) {
                        preparedStatement.setNull(i + 1, 12);
                        continue;
                    }
                    preparedStatement.setObject(i + 1, this.convertValueToDatabaseSpecificObject(objectArray[i]));
                }
            }
            DBAccess.debug("executeSql -> ", string);
            if (preparedStatement.execute()) {
                ResultSet resultSet;
                block10: {
                    ArrayUtil<Object> arrayUtil;
                    resultSet = preparedStatement.getResultSet();
                    try {
                        if (!resultSet.next()) break block10;
                        ArrayUtil<Object> arrayUtil2 = new ArrayUtil<Object>();
                        do {
                            arrayUtil2.add(resultSet.getObject(1));
                        } while (resultSet.next());
                        arrayUtil = arrayUtil2;
                        Object var9_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_12 = null;
                        CommonUtil.close(resultSet);
                        throw throwable;
                    }
                    CommonUtil.close(resultSet);
                    Object var11_13 = null;
                    CommonUtil.close(preparedStatement);
                    return arrayUtil;
                }
                Object var9_11 = null;
                CommonUtil.close(resultSet);
            }
            list = null;
            Object var11_14 = null;
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            CommonUtil.close(preparedStatement);
            throw throwable;
        }
        CommonUtil.close(preparedStatement);
        return list;
    }

    public PreparedStatement getPreparedStatement(String string, boolean bl) throws DataSourceException {
        PreparedStatement preparedStatement;
        if (!this.isOpen()) {
            throw new DataSourceException("DBAccess is not open!");
        }
        string = this.translateQuotes(string.toString());
        try {
            if (bl) {
                try {
                    preparedStatement = this.cConnection.prepareStatement(string, 1);
                }
                catch (SQLException sQLException) {
                    preparedStatement = this.cConnection.prepareStatement(string);
                }
            } else {
                preparedStatement = this.cConnection.prepareStatement(string);
            }
        }
        catch (SQLException sQLException) {
            throw new DataSourceException("PrepareStatement failed! - " + string, this.formatSQLException(sQLException));
        }
        return preparedStatement;
    }

    public int executeUpdate(PreparedStatement preparedStatement) throws DataSourceException {
        if (!this.isOpen()) {
            throw new DataSourceException("DBAccess is not open!");
        }
        try {
            return preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new DataSourceException("Execute update failed!", this.formatSQLException(sQLException));
        }
    }

    protected SQLException formatSQLException(SQLException sQLException) {
        return this.formatSQLException(sQLException, sQLException.getMessage(), "" + sQLException.getErrorCode());
    }

    protected SQLException formatSQLException(SQLException sQLException, String string, String string2) {
        if (string.indexOf(string2) < 0) {
            String string3 = this.getClass().getSimpleName();
            int n = string3.indexOf("DBAccess");
            if (n >= 0) {
                string3 = string3.substring(0, n);
            }
            SQLException sQLException2 = new SQLException(string3 + "-" + string2 + ": " + string);
            sQLException2.setStackTrace(sQLException.getStackTrace());
            sQLException2.initCause(sQLException.getCause());
            return sQLException2;
        }
        return sQLException;
    }

    public String getSelectStatement(ServerMetaData serverMetaData, String string, String[] stringArray, String string2, ICondition iCondition, String string3, String string4, SortDefinition sortDefinition, String string5) throws DataSourceException {
        if (string2 == null) {
            throw new DataSourceException("Missing FROM clause!");
        }
        StringBuilder stringBuilder = new StringBuilder("SELECT ");
        if (string != null) {
            stringBuilder.append(string);
            stringBuilder.append(" ");
        }
        if (stringArray != null && stringArray.length > 0 && stringArray[0].length() > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(stringArray[i]);
            }
        } else {
            stringBuilder.append("*");
        }
        stringBuilder.append(" FROM ");
        stringBuilder.append(string2);
        stringBuilder.append(this.getWhereClause(serverMetaData, iCondition, string3, true));
        if (string4 != null) {
            stringBuilder.append(" ");
            stringBuilder.append(string4);
            stringBuilder.append(" ");
        }
        if (sortDefinition != null) {
            stringBuilder.append(" ORDER BY ");
            String[] stringArray2 = sortDefinition.getColumns();
            boolean[] blArray = sortDefinition.isAscending();
            for (int i = 0; i < stringArray2.length; ++i) {
                int n = serverMetaData.getServerColumnMetaDataIndex(stringArray2[i]);
                if (n < 0) {
                    stringBuilder.append(stringArray2[i]);
                } else {
                    stringBuilder.append(serverMetaData.getServerColumnMetaData(n).getColumnName().getQuotedName());
                }
                if (blArray[i]) {
                    stringBuilder.append(" ASC");
                } else {
                    stringBuilder.append(" DESC");
                }
                if (i + 1 >= stringArray2.length) continue;
                stringBuilder.append(", ");
            }
        } else if (!StringUtil.isEmpty(string5)) {
            stringBuilder.append(" ORDER BY ");
            stringBuilder.append(string5);
        }
        return stringBuilder.toString();
    }

    protected String getWhereClause(ServerMetaData serverMetaData, ICondition iCondition, String string, boolean bl) throws DataSourceException {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = this.getSQL(serverMetaData, iCondition, bl);
        if (string2 != null && string2.length() > 0) {
            stringBuilder.append(" WHERE ");
            stringBuilder.append(string2);
        }
        if (string != null && string.length() > 0) {
            if (string2 == null || string2.length() == 0) {
                stringBuilder.append(" WHERE ");
            } else {
                stringBuilder.append(" AND ");
            }
            stringBuilder.append(" ");
            stringBuilder.append(string);
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    protected String getDatabaseSpecificLockStatement(String string, ServerMetaData serverMetaData, ICondition iCondition) throws DataSourceException {
        if (string == null) {
            throw new DataSourceException("Missing WriteBackTable!");
        }
        StringBuilder stringBuilder = new StringBuilder("SELECT * FROM ");
        stringBuilder.append(string);
        stringBuilder.append(this.getWhereClause(serverMetaData, iCondition, null, false));
        stringBuilder.append(" FOR UPDATE");
        return stringBuilder.toString();
    }

    protected Object[] insertDatabaseSpecific(String string, String string2, ServerMetaData serverMetaData, Object[] objectArray, String string3) throws DataSourceException {
        return this.insertAnsiSQL(string, string2, serverMetaData, objectArray, string3);
    }

    public boolean supportsGetGeneratedKeys() {
        try {
            return this.cConnection.getMetaData().supportsGetGeneratedKeys();
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    protected Object[] insertAnsiSQL(String string, String string2, ServerMetaData serverMetaData, Object[] objectArray, String string3) throws DataSourceException {
        block14: {
            Object[] objectArray2;
            boolean bl = this.supportsGetGeneratedKeys();
            PreparedStatement preparedStatement = this.getPreparedStatement(string2, bl);
            ResultSet resultSet = null;
            try {
                ServerColumnMetaData[] serverColumnMetaDataArray = serverMetaData.getServerColumnMetaData();
                int[] nArray = serverMetaData.getWritableColumnIndices();
                if (string3 == null) {
                    this.setColumnsToStore(preparedStatement, serverColumnMetaDataArray, nArray, objectArray, null);
                } else {
                    try {
                        for (int i = 0; i < serverColumnMetaDataArray.length; ++i) {
                            if (!serverColumnMetaDataArray[i].getColumnName().getQuotedName().equals(string3)) continue;
                            preparedStatement.setObject(1, null, serverColumnMetaDataArray[i].getSQLType());
                            break;
                        }
                    }
                    catch (SQLException sQLException) {
                        throw new DataSourceException("Insert failed! - " + string2, this.formatSQLException(sQLException));
                    }
                }
                if (this.executeUpdate(preparedStatement) != 1) break block14;
                if (bl) {
                    try {
                        resultSet = preparedStatement.getGeneratedKeys();
                        if (resultSet.next()) {
                            String[] stringArray = serverMetaData.getPrimaryKeyColumnNames();
                            int n = resultSet.getMetaData().getColumnCount();
                            for (int i = 0; i < n && stringArray != null && i < stringArray.length; ++i) {
                                Object object;
                                int n2 = ServerMetaData.getServerColumnMetaDataIndex(serverColumnMetaDataArray, stringArray[i]);
                                if (n2 < 0 || (object = resultSet.getObject(i + 1)) == null) continue;
                                objectArray[n2] = object;
                            }
                        }
                    }
                    catch (SQLException sQLException) {
                        throw new DataSourceException("The generated keys couldn't read! - " + string2, this.formatSQLException(sQLException));
                    }
                }
                objectArray2 = objectArray;
                Object var17_20 = null;
            }
            catch (Throwable throwable) {
                Object var17_21 = null;
                CommonUtil.close(resultSet, preparedStatement);
                throw throwable;
            }
            CommonUtil.close(resultSet, preparedStatement);
            return objectArray2;
        }
        throw new DataSourceException("Insert failed! - Result row count != 1" + string2);
    }

    protected ServerColumnMetaData[] getColumnMetaDataIntern(String string, String[] stringArray, String string2, String string3, String string4) throws DataSourceException {
        ServerColumnMetaData[] serverColumnMetaDataArray;
        long l = System.currentTimeMillis();
        string3 = string3 == null ? "1=2" : string3 + " AND 1=2";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string5 = this.getSelectStatement(null, string2, stringArray, string, null, string3, string4, null, null);
        try {
            preparedStatement = this.getPreparedStatement(string5, false);
            resultSet = preparedStatement.executeQuery();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            ArrayUtil<ServerColumnMetaData> arrayUtil = new ArrayUtil<ServerColumnMetaData>();
            ArrayUtil<String> arrayUtil2 = new ArrayUtil<String>();
            for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                String string6 = this.getColumnName(resultSetMetaData, i);
                Name name = new Name(string6, this.quote(string6));
                if (arrayUtil2.indexOf(name.getName()) >= 0) {
                    throw new DataSourceException("Duplicate definition of '" + name.getName() + "' in DBStorage " + string5 + "!");
                }
                ServerColumnMetaData serverColumnMetaData = new ServerColumnMetaData(name);
                if (stringArray != null) {
                    String string7 = stringArray[i - 1].toLowerCase();
                    String string8 = serverColumnMetaData.getName().toLowerCase();
                    int n = string7.length() - string8.length() - 1;
                    if (string7.endsWith(string8) && n > 0 && Character.isWhitespace(string7.charAt(n))) {
                        string7 = stringArray[i - 1].substring(0, n).trim();
                        n = string7.length() - 3;
                        if (string7.endsWith("as") && n > 0 && Character.isWhitespace(string7.charAt(n))) {
                            string7 = stringArray[i - 1].substring(0, n).trim();
                        }
                    } else {
                        string7 = stringArray[i - 1];
                    }
                    serverColumnMetaData.setRealQueryColumnName(string7);
                    DBAccess.debug("Name=", serverColumnMetaData.getName(), "==", string7);
                } else {
                    serverColumnMetaData.setRealQueryColumnName(serverColumnMetaData.getColumnName().getRealName());
                }
                if (resultSetMetaData.isNullable(i) == 0) {
                    serverColumnMetaData.setNullable(false);
                } else {
                    serverColumnMetaData.setNullable(true);
                }
                serverColumnMetaData.setAutoIncrement(resultSetMetaData.isAutoIncrement(i));
                int n = resultSetMetaData.getColumnType(i);
                serverColumnMetaData.setSQLType(n);
                serverColumnMetaData.setSQLTypeName(resultSetMetaData.getColumnTypeName(i));
                if (!this.setDatabaseSpecificType(resultSetMetaData, i, serverColumnMetaData)) {
                    switch (n) {
                        case -16: 
                        case -15: 
                        case -9: 
                        case -1: 
                        case 1: 
                        case 12: 
                        case 2005: {
                            serverColumnMetaData.setDataType(12);
                            if (resultSetMetaData.getPrecision(i) > 0) {
                                serverColumnMetaData.setPrecision(resultSetMetaData.getPrecision(i));
                                break;
                            }
                            serverColumnMetaData.setPrecision(Integer.MAX_VALUE);
                            break;
                        }
                        case -7: 
                        case 16: {
                            serverColumnMetaData.setDataType(16);
                            break;
                        }
                        case 6: 
                        case 7: 
                        case 8: {
                            serverColumnMetaData.setDataType(3);
                            serverColumnMetaData.setPrecision(0);
                            serverColumnMetaData.setScale(-1);
                            serverColumnMetaData.setSigned(resultSetMetaData.isSigned(i));
                            break;
                        }
                        case -6: 
                        case -5: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            serverColumnMetaData.setDataType(3);
                            if (resultSetMetaData.getPrecision(i) <= 0 || resultSetMetaData.getPrecision(i) > 30) {
                                serverColumnMetaData.setPrecision(0);
                                serverColumnMetaData.setScale(-1);
                            } else {
                                serverColumnMetaData.setPrecision(resultSetMetaData.getPrecision(i));
                                serverColumnMetaData.setScale(resultSetMetaData.getScale(i));
                            }
                            serverColumnMetaData.setSigned(resultSetMetaData.isSigned(i));
                            break;
                        }
                        case 91: 
                        case 92: 
                        case 93: {
                            serverColumnMetaData.setDataType(93);
                            break;
                        }
                        case -4: 
                        case -3: 
                        case -2: 
                        case 2004: {
                            serverColumnMetaData.setDataType(-2);
                            if (resultSetMetaData.getPrecision(i) > 0) {
                                serverColumnMetaData.setPrecision(resultSetMetaData.getPrecision(i));
                                break;
                            }
                            serverColumnMetaData.setPrecision(Integer.MAX_VALUE);
                            break;
                        }
                        default: {
                            throw new DataSourceException(serverColumnMetaData.getName() + " :: SQL Type '" + n + "' is not support!");
                        }
                    }
                }
                arrayUtil.add(serverColumnMetaData);
                arrayUtil2.add(serverColumnMetaData.getName());
            }
            if (DBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                DBAccess.debug("getMetaData(", string5, ") in ", System.currentTimeMillis() - l, "ms");
            }
            serverColumnMetaDataArray = arrayUtil.toArray(new ServerColumnMetaData[arrayUtil.size()]);
            Object var22_23 = null;
        }
        catch (SQLException sQLException) {
            try {
                throw new DataSourceException("Meta data couldn't load from database! - " + string5, this.formatSQLException(sQLException));
            }
            catch (Throwable throwable) {
                Object var22_24 = null;
                CommonUtil.close(resultSet, preparedStatement);
                throw throwable;
            }
        }
        CommonUtil.close(resultSet, preparedStatement);
        return serverColumnMetaDataArray;
    }

    public final ServerColumnMetaData[] getColumnMetaData(String string, String[] stringArray, String string2, String string3, String string4) throws DataSourceException {
        if (this.isMetaDataCacheEnabled()) {
            String string5 = this.getIdentifier();
            String string6 = DBAccess.createIdentifier(string, stringArray, string2);
            ServerColumnMetaData[] serverColumnMetaDataArray = ghtColumnMetaDataCache.get(string5, string6);
            if (serverColumnMetaDataArray == null) {
                serverColumnMetaDataArray = this.getColumnMetaDataIntern(string, stringArray, string2, string3, string4);
                if (serverColumnMetaDataArray == null) {
                    serverColumnMetaDataArray = COLUMNMETADATA_NULL;
                }
                ghtColumnMetaDataCache.put(string5, string6, serverColumnMetaDataArray);
            }
            if (serverColumnMetaDataArray == COLUMNMETADATA_NULL) {
                return null;
            }
            ServerColumnMetaData[] serverColumnMetaDataArray2 = new ServerColumnMetaData[serverColumnMetaDataArray.length];
            for (int i = 0; i < serverColumnMetaDataArray.length; ++i) {
                serverColumnMetaDataArray2[i] = serverColumnMetaDataArray[i].clone();
            }
            return serverColumnMetaDataArray2;
        }
        return this.getColumnMetaDataIntern(string, stringArray, string2, string3, string4);
    }

    protected TableInfo getTableInfoIntern(String string) throws DataSourceException {
        TableInfo tableInfo;
        long l = System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string2 = this.getSelectStatement(null, null, null, string, null, "1=2", null, null, null);
        try {
            String string3;
            preparedStatement = this.getPreparedStatement(string2, false);
            resultSet = preparedStatement.executeQuery();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            String string4 = resultSetMetaData.getCatalogName(1);
            String string5 = resultSetMetaData.getSchemaName(1);
            if (string4 != null && string4.trim().length() == 0 && (string4 = string4.trim()).length() == 0) {
                string4 = null;
            }
            if (string5 != null && (string5 = string5.trim()).length() == 0) {
                string5 = null;
            }
            String[] stringArray = this.splitSchemaTable(string);
            if (string5 == null) {
                string5 = stringArray[0];
            }
            if ((string3 = stringArray[1]) != null) {
                if (string3.endsWith(" m ")) {
                    string3 = string3.substring(0, string3.length() - 3);
                }
                string3 = string3.trim();
            }
            if (DBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                DBAccess.debug("getTableInfo(", string2, ") in ", System.currentTimeMillis() - l, "ms");
            }
            tableInfo = new TableInfo(string4, string5, string3);
            Object var14_13 = null;
        }
        catch (SQLException sQLException) {
            try {
                throw new DataSourceException("Meta data couldn't load from database! - " + string2, this.formatSQLException(sQLException));
            }
            catch (Throwable throwable) {
                Object var14_14 = null;
                CommonUtil.close(resultSet, preparedStatement);
                throw throwable;
            }
        }
        CommonUtil.close(resultSet, preparedStatement);
        return tableInfo;
    }

    public final TableInfo getTableInfo(String string) throws DataSourceException {
        if (this.isMetaDataCacheEnabled()) {
            String string2 = this.getIdentifier();
            String string3 = DBAccess.createIdentifier(string);
            TableInfo tableInfo = ghtTableInfoCache.get(string2, string3);
            if (tableInfo == null) {
                tableInfo = this.getTableInfoIntern(string);
                if (tableInfo == null) {
                    tableInfo = TABLEINFO_NULL;
                }
                ghtTableInfoCache.put(string2, string3, tableInfo);
            }
            if (tableInfo == TABLEINFO_NULL) {
                return null;
            }
            return tableInfo;
        }
        return this.getTableInfoIntern(string);
    }

    private void setFilterParameter(int n, PreparedStatement preparedStatement, Object[] objectArray) throws DataSourceException {
        int n2 = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            try {
                if (objectArray[i] == null) continue;
                preparedStatement.setObject(n + n2, this.convertValueToDatabaseSpecificObject(objectArray[i]));
                ++n2;
                continue;
            }
            catch (SQLException sQLException) {
                throw new DataSourceException("Set value into PreparedStatement failed!", this.formatSQLException(sQLException));
            }
        }
    }

    protected int setColumnsToStore(PreparedStatement preparedStatement, ServerColumnMetaData[] serverColumnMetaDataArray, int[] nArray, Object[] objectArray, Object[] objectArray2) throws DataSourceException {
        int n = 1;
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            if ((objectArray2 != null || objectArray[n2] == null) && (objectArray2 == null || serverColumnMetaDataArray[n2].getDataType().compareTo(objectArray[n2], objectArray2[n2]) == 0)) continue;
            try {
                if (objectArray[n2] == null) {
                    preparedStatement.setNull(n, serverColumnMetaDataArray[n2].getSQLType());
                } else {
                    Object object = this.convertValueToDatabaseSpecificObject(objectArray[n2]);
                    if (object instanceof IFileHandle) {
                        IFileHandle iFileHandle = (IFileHandle)object;
                        preparedStatement.setBinaryStream(n, iFileHandle.getInputStream(), (int)iFileHandle.getLength());
                    } else {
                        preparedStatement.setObject(n, this.convertValueToDatabaseSpecificObject(objectArray[n2]));
                    }
                }
                ++n;
                continue;
            }
            catch (Exception exception) {
                SQLException sQLException;
                if (exception instanceof SQLException) {
                    sQLException = this.formatSQLException((SQLException)exception);
                }
                throw new DataSourceException("Set value into PreparedStatement failed!", sQLException);
            }
        }
        return --n;
    }

    public final Map<String, Object> getDefaultValues(String string, String string2, String string3) throws DataSourceException {
        if (this.isMetaDataCacheEnabled()) {
            String string4 = this.getIdentifier();
            String string5 = DBAccess.createIdentifier(string, string2, string3);
            Map<String, Object> map = ghtDefaultValuesCache.get(string4, string5);
            if (map == null) {
                map = this.getDefaultValuesIntern(string, string2, string3);
                if (map == null) {
                    map = DEFAULT_VALUES_NULL;
                }
                ghtDefaultValuesCache.put(string4, string5, map);
            }
            if (map == DEFAULT_VALUES_NULL) {
                return null;
            }
            return map;
        }
        return this.getDefaultValuesIntern(string, string2, string3);
    }

    protected Map<String, Object> getDefaultValuesIntern(String string, String string2, String string3) throws DataSourceException {
        Hashtable<String, Object> hashtable;
        Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
        ResultSet resultSet = null;
        try {
            resultSet = this.cConnection.getMetaData().getColumns(string, string2, string3, null);
            while (resultSet.next()) {
                String string4 = resultSet.getString("COLUMN_DEF");
                if (string4 == null) continue;
                String string5 = resultSet.getString("COLUMN_NAME");
                try {
                    Object object = this.translateDefaultValue(string5, resultSet.getInt("DATA_TYPE"), string4.trim());
                    if (object == null) continue;
                    hashtable2.put(string5, object);
                }
                catch (Exception exception) {
                    DBAccess.debug(string4, exception);
                }
            }
            hashtable = hashtable2;
            Object var11_12 = null;
        }
        catch (SQLException sQLException) {
            try {
                throw new DataSourceException("Get default values failed!", this.formatSQLException(sQLException));
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                CommonUtil.close(resultSet);
                throw throwable;
            }
        }
        CommonUtil.close(resultSet);
        return hashtable;
    }

    protected Object translateDefaultValue(String string, int n, String string2) throws Exception {
        return this.translateValue(n, string2);
    }

    protected Object translateValue(int n, String string) throws Exception {
        if (string == null || string.equalsIgnoreCase("null")) {
            return null;
        }
        switch (n) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return string;
            }
            case -7: 
            case 16: {
                return Boolean.valueOf(string);
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return new BigDecimal(string);
            }
            case 91: 
            case 92: 
            case 93: {
                if (string.startsWith("0000-00-00")) {
                    return null;
                }
                return new Timestamp(this.dateUtil.parse(string).getTime());
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return null;
            }
        }
        throw new DataSourceException("SQL Type '" + n + "' is not support!");
    }

    protected Map<String, Object[]> getAllowedValuesIntern(String string, String string2, String string3) throws DataSourceException {
        return null;
    }

    public final Map<String, Object[]> getAllowedValues(String string, String string2, String string3) throws DataSourceException {
        if (this.isMetaDataCacheEnabled()) {
            String string4 = this.getIdentifier();
            String string5 = DBAccess.createIdentifier(string, string2, string3);
            Map<String, Object[]> map = ghtAllowedValuesCache.get(string4, string5);
            if (map == null) {
                map = this.getAllowedValuesIntern(string, string2, string3);
                if (map == null) {
                    map = ALLOWED_VALUES_NULL;
                }
                ghtAllowedValuesCache.put(string4, string5, map);
            }
            if (map == ALLOWED_VALUES_NULL) {
                return null;
            }
            return map;
        }
        return this.getAllowedValuesIntern(string, string2, string3);
    }

    public Object[] getDefaultAllowedValues(String string, String string2, String string3, ServerColumnMetaData serverColumnMetaData) {
        if (serverColumnMetaData.getDataType().getTypeIdentifier() == 16) {
            return new Boolean[]{Boolean.TRUE, Boolean.FALSE};
        }
        return null;
    }

    private int getRowCount(String string, ICondition iCondition, int n) throws DataSourceException {
        int n2;
        long l = System.currentTimeMillis();
        PreparedStatement preparedStatement = this.getPreparedStatement(string.toString(), false);
        ResultSet resultSet = null;
        try {
            this.setFilterParameter(1, preparedStatement, this.getParameter(iCondition));
            resultSet = preparedStatement.executeQuery();
            if (DBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                DBAccess.debug("select (", string, ",...) in ", System.currentTimeMillis() - l, "ms");
            }
            int n3 = 0;
            while (resultSet.next()) {
                if (n < 0 || ++n3 <= n) continue;
                throw new DataSourceException("Too many rows found! " + string);
            }
            n2 = n3;
            Object var11_10 = null;
        }
        catch (SQLException sQLException) {
            try {
                throw new DataSourceException("Execute statement failed! " + string, this.formatSQLException(sQLException));
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                CommonUtil.close(resultSet, preparedStatement);
                throw throwable;
            }
        }
        CommonUtil.close(resultSet, preparedStatement);
        return n2;
    }

    protected String getSQL(ServerMetaData serverMetaData, ICondition iCondition, boolean bl) throws DataSourceException {
        StringBuilder stringBuilder = new StringBuilder();
        if (iCondition instanceof CompareCondition) {
            CompareCondition compareCondition = (CompareCondition)iCondition;
            Object object = compareCondition.getValue();
            if (!compareCondition.isIgnoreNull() || object != null) {
                String string = null;
                if (serverMetaData != null) {
                    try {
                        string = bl ? serverMetaData.getServerColumnMetaData(compareCondition.getColumnName()).getRealQueryColumnName() : serverMetaData.getServerColumnMetaData(compareCondition.getColumnName()).getColumnName().getQuotedName();
                    }
                    catch (ModelException modelException) {
                        // empty catch block
                    }
                }
                if (string == null) {
                    string = compareCondition.getColumnName();
                }
                if ((compareCondition instanceof LikeReverse || compareCondition instanceof LikeReverseIgnoreCase) && compareCondition.getValue() != null) {
                    if (compareCondition instanceof LikeReverse) {
                        stringBuilder.append(this.createWhereParam(serverMetaData, compareCondition));
                    } else if (compareCondition instanceof LikeReverseIgnoreCase) {
                        stringBuilder.append("UPPER(");
                        stringBuilder.append(this.createWhereParam(serverMetaData, compareCondition));
                        stringBuilder.append(")");
                    }
                } else if (compareCondition instanceof LikeIgnoreCase) {
                    stringBuilder.append("UPPER(");
                    stringBuilder.append(this.createWhereColumn(serverMetaData, compareCondition, string));
                    stringBuilder.append(")");
                } else {
                    stringBuilder.append(this.createWhereColumn(serverMetaData, compareCondition, string));
                }
                stringBuilder.append(' ');
                if (compareCondition.getValue() == null) {
                    stringBuilder.append("IS NULL");
                } else {
                    if (compareCondition instanceof Equals) {
                        stringBuilder.append("= ");
                    } else if (compareCondition instanceof LikeIgnoreCase || compareCondition instanceof LikeReverseIgnoreCase) {
                        stringBuilder.append("LIKE UPPER(");
                    } else if (compareCondition instanceof Like || compareCondition instanceof LikeReverse) {
                        stringBuilder.append("LIKE ");
                    } else if (compareCondition instanceof Greater) {
                        stringBuilder.append("> ");
                    } else if (compareCondition instanceof GreaterEquals) {
                        stringBuilder.append(">= ");
                    } else if (compareCondition instanceof Less) {
                        stringBuilder.append("< ");
                    } else if (compareCondition instanceof LessEquals) {
                        stringBuilder.append("<= ");
                    } else {
                        stringBuilder.append(' ');
                    }
                    if (compareCondition instanceof LikeReverse || compareCondition instanceof LikeReverseIgnoreCase) {
                        stringBuilder.append(this.createReplace(this.createReplace(this.createWhereColumn(serverMetaData, compareCondition, string), "*", "%"), "?", "_"));
                    } else {
                        stringBuilder.append(this.createWhereParam(serverMetaData, compareCondition));
                    }
                    if (compareCondition instanceof LikeIgnoreCase || compareCondition instanceof LikeReverseIgnoreCase) {
                        stringBuilder.append(")");
                    }
                }
            }
        } else if (iCondition instanceof OperatorCondition) {
            OperatorCondition operatorCondition = (OperatorCondition)iCondition;
            ICondition[] iConditionArray = operatorCondition.getConditions();
            for (int i = 0; i < iConditionArray.length; ++i) {
                String string = this.getSQL(serverMetaData, iConditionArray[i], bl);
                if (string == null || string.length() <= 0) continue;
                if (i > 0 && stringBuilder.length() > 0) {
                    if (operatorCondition instanceof And) {
                        stringBuilder.append(" AND ");
                    } else if (operatorCondition instanceof Or) {
                        stringBuilder.append(" OR ");
                    }
                }
                if (iConditionArray[i] instanceof OperatorCondition) {
                    stringBuilder.append("(");
                    stringBuilder.append(string);
                    stringBuilder.append(")");
                    continue;
                }
                stringBuilder.append(string);
            }
        } else if (iCondition instanceof Not) {
            ICondition iCondition2 = ((Not)iCondition).getCondition();
            String string = this.getSQL(serverMetaData, iCondition2, bl);
            stringBuilder.append("NOT ");
            if (iCondition2 instanceof OperatorCondition) {
                stringBuilder.append("(");
                stringBuilder.append(string);
                stringBuilder.append(")");
            } else {
                stringBuilder.append(string);
            }
        }
        return stringBuilder.toString();
    }

    protected String createReplace(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder("REPLACE(");
        stringBuilder.append(string);
        stringBuilder.append(",'");
        stringBuilder.append(string2);
        stringBuilder.append("','");
        stringBuilder.append(string3);
        stringBuilder.append("')");
        return stringBuilder.toString();
    }

    protected String createWhereParam(ServerMetaData serverMetaData, CompareCondition compareCondition) {
        return "?";
    }

    protected String createWhereColumn(ServerMetaData serverMetaData, CompareCondition compareCondition, String string) {
        return string;
    }

    public boolean isTypeEqual(ServerColumnMetaData serverColumnMetaData, CompareCondition compareCondition) {
        if (compareCondition instanceof Equals) {
            Object object = compareCondition.getValue();
            IDataType iDataType = serverColumnMetaData.getDataType();
            if (object instanceof String && !(iDataType instanceof StringDataType) || object instanceof Timestamp && !(iDataType instanceof TimestampDataType) || object instanceof BigDecimal && !(iDataType instanceof BigDecimalDataType) || object instanceof Boolean && !(iDataType instanceof BooleanDataType)) {
                return false;
            }
        }
        return true;
    }

    protected Object[] getParameter(ICondition iCondition) {
        Object[] objectArray = null;
        if (iCondition instanceof CompareCondition) {
            CompareCondition compareCondition = (CompareCondition)iCondition;
            Object object = compareCondition.getValue();
            objectArray = object != null ? ((compareCondition instanceof Like || compareCondition instanceof LikeIgnoreCase) && object instanceof String ? new Object[]{((String)object).replace('*', '%').replace('?', '_')} : new Object[]{object}) : new Object[]{};
        } else if (iCondition instanceof OperatorCondition) {
            OperatorCondition operatorCondition = (OperatorCondition)iCondition;
            ICondition[] iConditionArray = operatorCondition.getConditions();
            for (int i = 0; i < iConditionArray.length; ++i) {
                Object[] objectArray2 = this.getParameter(iConditionArray[i]);
                if (objectArray == null) {
                    objectArray = new Object[]{};
                }
                objectArray = ArrayUtil.addAll(objectArray, objectArray2);
            }
        } else if (iCondition instanceof Not) {
            objectArray = this.getParameter(((Not)iCondition).getCondition());
        }
        return objectArray;
    }

    protected String[] splitSchemaTable(String string) {
        int n;
        int n2;
        boolean bl = false;
        if (string.indexOf(44) >= 0) {
            bl = true;
        }
        if (string.indexOf(this.sOpenQuote) >= 0) {
            bl = true;
        }
        if ((n2 = string.indexOf(32)) > 0 && (n = string.indexOf(32, n2 + 1)) > n2) {
            bl = true;
        }
        String[] stringArray = new String[2];
        if (!bl) {
            int n3;
            if (n2 < 0) {
                n2 = string.length();
            }
            if ((n3 = string.indexOf(46)) > 0) {
                stringArray[0] = string.substring(0, n3);
                stringArray[1] = string.substring(n3 + 1, n2);
            } else {
                stringArray[1] = string.substring(0, n2);
            }
        } else {
            stringArray[1] = string;
        }
        return stringArray;
    }

    public void setDefaultSchema(String string) {
        this.sDefaultSchema = string;
    }

    public String getDefaultSchema() {
        return this.sDefaultSchema;
    }

    protected Object convertDatabaseSpecificObjectToValue(ServerColumnMetaData serverColumnMetaData, Object object) throws SQLException {
        return object;
    }

    protected Object convertValueToDatabaseSpecificObject(Object object) {
        if (object instanceof Date && !(object instanceof Timestamp)) {
            return new Timestamp(((Date)object).getTime());
        }
        return object;
    }

    protected String getIdentifier() {
        if (this.sIdentifier == null) {
            this.sIdentifier = DBAccess.createIdentifier(this.sUrl, this.sUsername);
        }
        kvlApplicationGroups.put(this.sApplicationName, this.sIdentifier, true);
        return this.sIdentifier;
    }

    public static void clearMetaData() {
        AbstractCachedStorage.clearMetaData();
        kvlApplicationGroups.clear();
        ghtFKsCache.clear();
        ghtPKCache.clear();
        ghtUKsCache.clear();
        ghtAllowedValuesCache.clear();
        ghtColumnMetaDataCache.clear();
        ghtTableInfoCache.clear();
    }

    public static void clearMetaData(String string) {
        if (string == null) {
            string = "";
        }
        AbstractCachedStorage.clearMetaData(string);
        List<String> list = kvlApplicationGroups.remove(string);
        if (list != null) {
            for (String string2 : list) {
                ghtFKsCache.remove(string2);
                ghtPKCache.remove(string2);
                ghtUKsCache.remove(string2);
                ghtAllowedValuesCache.remove(string2);
                ghtColumnMetaDataCache.remove(string2);
                ghtTableInfoCache.remove(string2);
            }
        }
    }

    public static String createIdentifier(Object ... objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return "/";
        }
        StringBuilder stringBuilder = new StringBuilder(512);
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuilder.append('/');
            Object object = objectArray[i];
            if (object == null) continue;
            if (object instanceof Object[]) {
                Object[] objectArray2 = (Object[])object;
                for (int j = 0; j < objectArray2.length; ++j) {
                    if (j > 0) {
                        stringBuilder.append(";");
                    }
                    if ((object = objectArray2[j]) == null) continue;
                    stringBuilder.append(object);
                }
                continue;
            }
            stringBuilder.append(object);
        }
        return stringBuilder.toString();
    }

    protected boolean setDatabaseSpecificType(ResultSetMetaData resultSetMetaData, int n, ServerColumnMetaData serverColumnMetaData) throws SQLException {
        return false;
    }

    public void setMetaDataCacheOption(MetaDataCacheOption metaDataCacheOption) {
        this.mdcCacheOption = metaDataCacheOption == null ? MetaDataCacheOption.Default : metaDataCacheOption;
    }

    public MetaDataCacheOption getMetaDataCacheOption() {
        return this.mdcCacheOption;
    }

    protected boolean isMetaDataCacheEnabled() {
        String string;
        ISession iSession;
        if (lastGlobalMetaDataCache && !DBStorage.isGlobalMetaDataCacheEnabled()) {
            DBAccess.clearMetaData();
        }
        lastGlobalMetaDataCache = DBStorage.isGlobalMetaDataCacheEnabled();
        MetaDataCacheOption metaDataCacheOption = this.mdcCacheOption != MetaDataCacheOption.Default ? this.mdcCacheOption : ((iSession = SessionContext.getCurrentSession()) != null ? ((string = (String)iSession.getProperty("server.client.metadatacache_option")) == null ? MetaDataCacheOption.Default : MetaDataCacheOption.resolve(string)) : MetaDataCacheOption.Default);
        return metaDataCacheOption == MetaDataCacheOption.On || DBStorage.isGlobalMetaDataCacheEnabled() && metaDataCacheOption == MetaDataCacheOption.Default;
    }

    protected void setModified(boolean bl) throws DataSourceException {
        try {
            if (bl && this.cConnection.getAutoCommit()) {
                return;
            }
            this.bModified = bl;
        }
        catch (SQLException sQLException) {
            throw new DataSourceException("Can't set DBAccess modified!", this.formatSQLException(sQLException));
        }
    }

    public boolean isModified() {
        return this.bModified;
    }

    protected static boolean isLogEnabled(ILogger.LogLevel logLevel) {
        if (logger == null) {
            return LoggerFactory.getInstance(DBAccess.class).isEnabled(logLevel);
        }
        return logger.isEnabled(logLevel);
    }

    protected static void debug(Object ... objectArray) {
        if (logger == null) {
            logger = LoggerFactory.getInstance(DBAccess.class);
        }
        logger.debug(objectArray);
    }

    protected static void info(Object ... objectArray) {
        if (logger == null) {
            logger = LoggerFactory.getInstance(DBAccess.class);
        }
        logger.info(objectArray);
    }

    protected static void error(Object ... objectArray) {
        if (logger == null) {
            logger = LoggerFactory.getInstance(DBAccess.class);
        }
        logger.error(objectArray);
    }

    public static boolean isJdbc(String string) {
        return string == null || string.toLowerCase().startsWith("jdbc:");
    }

    protected String getColumnName(ResultSetMetaData resultSetMetaData, int n) throws SQLException {
        return resultSetMetaData.getColumnName(n);
    }

    static {
        DBAccess.registerDBAccessClass("jdbc:oracle:", OracleDBAccess.class);
        DBAccess.registerDBAccessClass("jdbc:db2:", DB2DBAccess.class);
        DBAccess.registerDBAccessClass("jdbc:derby:", DerbyDBAccess.class);
        DBAccess.registerDBAccessClass("jdbc:jtds:sqlserver:", MSSQLDBAccess.class);
        DBAccess.registerDBAccessClass("jdbc:mysql:", MySQLDBAccess.class);
        DBAccess.registerDBAccessClass("jdbc:postgresql:", PostgreSQLDBAccess.class);
        DBAccess.registerDBAccessClass("jdbc:hsqldb:", HSQLDBAccess.class);
        DBAccess.registerDBAccessClass("jdbc:sap:", HanaDBAccess.class);
        tmpAutoLinkColumnNames.put("*_id*", "*0*1");
        tmpAutoLinkColumnNames.put("*_ID*", "*0*1");
    }

    private static final class Select {
        private String sSelectStatement;
        private Object[] oaParameter;
        private int iLastRow;

        Select(String string, Object[] objectArray, int n) {
            this.sSelectStatement = string;
            this.oaParameter = objectArray;
            this.iLastRow = n;
        }

        public int hashCode() {
            return this.sSelectStatement.hashCode() + this.iLastRow * 13 + Arrays.hashCode(this.oaParameter);
        }

        public boolean equals(Object object) {
            if (object instanceof Select) {
                Select select = (Select)object;
                if (this.sSelectStatement.equals(select.sSelectStatement) && this.iLastRow == select.iLastRow) {
                    return Arrays.equals(this.oaParameter, select.oaParameter);
                }
                return false;
            }
            return super.equals(object);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Select :: ");
            stringBuilder.append(this.sSelectStatement);
            stringBuilder.append(", Parameter=");
            stringBuilder.append(StringUtil.toString(this.oaParameter));
            stringBuilder.append(", LastRow=");
            stringBuilder.append(this.iLastRow);
            stringBuilder.append("\n");
            return stringBuilder.toString();
        }
    }

    private static final class BlobFileHandle
    implements IFileHandle,
    IValidatable {
        private Blob blob;
        private String columnName;

        public BlobFileHandle(String string, Blob blob) {
            this.blob = blob;
        }

        public String getFileName() {
            return this.columnName;
        }

        public InputStream getInputStream() throws IOException {
            try {
                return this.blob.getBinaryStream();
            }
            catch (SQLException sQLException) {
                throw new IOException(sQLException.getMessage());
            }
        }

        public long getLength() throws IOException {
            try {
                return this.blob.length();
            }
            catch (SQLException sQLException) {
                throw new IOException(sQLException.getMessage());
            }
        }

        public boolean isValid() {
            try {
                return this.blob.length() >= 0L;
            }
            catch (SQLException sQLException) {
                return false;
            }
        }
    }
}

