/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.persist;

import com.sibvisions.rad.persist.AbstractStorage;
import com.sibvisions.util.GroupHashtable;
import com.sibvisions.util.KeyValueList;
import java.util.Hashtable;
import java.util.List;
import javax.rad.model.MetaDataCacheOption;
import javax.rad.persist.DataSourceException;
import javax.rad.persist.ICachedStorage;
import javax.rad.persist.MetaData;
import javax.rad.server.IConfiguration;
import javax.rad.server.ISession;
import javax.rad.server.SessionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCachedStorage
extends AbstractStorage
implements ICachedStorage {
    private static GroupHashtable<String, String, MetaData> ghtMetaData = new GroupHashtable();
    private static KeyValueList<String, String> kvlApplicationGroups = new KeyValueList();
    private static boolean bGlobalMetaDataCache = false;
    private MetaDataCacheOption mdcCacheOption = MetaDataCacheOption.Default;

    public AbstractCachedStorage() {
        IConfiguration iConfiguration = SessionContext.getCurrentServerConfig();
        if (iConfiguration != null) {
            String string = iConfiguration.getProperty("/server/globalmetadatacache", "OFF");
            AbstractCachedStorage.setGlobalMetaDataCacheEnabled("ON".equals(string));
        }
    }

    @Override
    public MetaData getMetaData(String string, String string2) throws DataSourceException {
        MetaData metaData;
        if (this.isMetaDataCacheEnabled() && (metaData = this.getMetaDataFromCache(string, string2)) != null) {
            return metaData;
        }
        metaData = this.getMetaData();
        this.putMetaDataToCache(string, string2, metaData);
        return metaData;
    }

    @Override
    public Hashtable<String, MetaData> getMetaDataFromCache(String string) {
        return AbstractCachedStorage.getMetaData(string);
    }

    protected void putMetaDataToCache(String string, String string2, MetaData metaData) {
        if (string != null) {
            if (metaData != null) {
                ghtMetaData.put(string, string + "." + string2, metaData);
            } else {
                ghtMetaData.remove(string, string + "." + string2);
            }
            ISession iSession = SessionContext.getCurrentSession();
            if (iSession != null) {
                if (metaData != null) {
                    kvlApplicationGroups.put(iSession.getApplicationName(), string, true);
                } else {
                    Hashtable<String, MetaData> hashtable = ghtMetaData.get(string);
                    if (hashtable == null || hashtable.size() == 0) {
                        kvlApplicationGroups.remove(iSession.getApplicationName(), string);
                    }
                }
            }
        }
    }

    protected MetaData getMetaDataFromCache(String string, String string2) {
        MetaData metaData = null;
        if (string != null) {
            return ghtMetaData.get(string, string + "." + string2);
        }
        return metaData;
    }

    public static Hashtable<String, MetaData> getMetaData(String string) {
        Hashtable<String, MetaData> hashtable;
        if (string != null && (hashtable = ghtMetaData.get(string)) != null) {
            return (Hashtable)hashtable.clone();
        }
        return null;
    }

    public static boolean removeMetaData(String string) {
        if (string != null) {
            Hashtable<String, MetaData> hashtable;
            ISession iSession;
            boolean bl = ghtMetaData.remove(string);
            if (bl && (iSession = SessionContext.getCurrentSession()) != null && ((hashtable = ghtMetaData.get(string)) == null || hashtable.size() == 0)) {
                kvlApplicationGroups.remove(iSession.getApplicationName(), string);
            }
            return bl;
        }
        return false;
    }

    public static void clearMetaData() {
        ghtMetaData.clear();
        kvlApplicationGroups.clear();
    }

    public static void clearMetaData(String string) {
        List<String> list = kvlApplicationGroups.remove(string);
        if (list != null) {
            for (String string2 : list) {
                ghtMetaData.remove(string2);
            }
        }
    }

    public static void setGlobalMetaDataCacheEnabled(boolean bl) {
        if (bGlobalMetaDataCache && !bl) {
            AbstractCachedStorage.clearMetaData();
        }
        bGlobalMetaDataCache = bl;
    }

    public static boolean isGlobalMetaDataCacheEnabled() {
        return bGlobalMetaDataCache;
    }

    public void setMetaDataCacheOption(MetaDataCacheOption metaDataCacheOption) {
        this.mdcCacheOption = metaDataCacheOption == null ? MetaDataCacheOption.Default : metaDataCacheOption;
    }

    public MetaDataCacheOption getMetaDataCacheOption() {
        return this.mdcCacheOption;
    }

    protected boolean isMetaDataCacheEnabled() {
        String string;
        ISession iSession;
        MetaDataCacheOption metaDataCacheOption = this.mdcCacheOption != MetaDataCacheOption.Default ? this.mdcCacheOption : ((iSession = SessionContext.getCurrentSession()) != null ? ((string = (String)iSession.getProperty("server.client.metadatacache_option")) == null ? MetaDataCacheOption.Default : MetaDataCacheOption.resolve(string)) : MetaDataCacheOption.Default);
        return metaDataCacheOption == MetaDataCacheOption.On || bGlobalMetaDataCache && metaDataCacheOption == MetaDataCacheOption.Default;
    }
}

