/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.model.mem;

import com.sibvisions.util.ArrayUtil;
import java.lang.ref.WeakReference;
import javax.rad.model.IDataBook;
import javax.rad.model.IDataSource;
import javax.rad.model.ModelException;

public class MemDataSource
implements IDataSource {
    private IDataBook.WriteBackIsolationLevel iWritebackIsolationLevel = IDataBook.WriteBackIsolationLevel.DATA_ROW;
    private ArrayUtil<WeakReference<IDataBook>> auDataBooks = new ArrayUtil();
    private boolean bIsOpen = false;

    public void open() throws ModelException {
        if (!this.isOpen()) {
            this.bIsOpen = true;
        }
    }

    public boolean isOpen() {
        return this.bIsOpen;
    }

    public synchronized void close() {
        if (this.isOpen()) {
            this.bIsOpen = false;
            for (int i = this.auDataBooks.size() - 1; i >= 0; --i) {
                IDataBook iDataBook = (IDataBook)this.auDataBooks.get(i).get();
                if (iDataBook == null) {
                    this.auDataBooks.remove(i);
                    continue;
                }
                iDataBook.close();
            }
        }
    }

    public synchronized void saveAllDataBooks() throws ModelException {
        int n = this.auDataBooks.size();
        for (int i = 0; i < n; ++i) {
            IDataBook iDataBook = (IDataBook)this.auDataBooks.get(i).get();
            if (iDataBook == null) continue;
            iDataBook.saveAllRows();
        }
    }

    public synchronized void reloadAllDataBooks() throws ModelException {
        this.restoreAllDataBooks();
        int n = this.auDataBooks.size();
        for (int i = 0; i < n; ++i) {
            IDataBook iDataBook = (IDataBook)this.auDataBooks.get(i).get();
            if (iDataBook == null) continue;
            iDataBook.reload();
        }
    }

    public synchronized void restoreAllDataBooks() {
        int n = this.auDataBooks.size();
        for (int i = 0; i < n; ++i) {
            IDataBook iDataBook = (IDataBook)this.auDataBooks.get(i).get();
            if (iDataBook == null) continue;
            try {
                iDataBook.restoreAllRows();
                continue;
            }
            catch (ModelException modelException) {
                // empty catch block
            }
        }
    }

    public synchronized void addDataBook(IDataBook iDataBook) {
        for (int i = this.auDataBooks.size() - 1; i >= 0; --i) {
            if (this.auDataBooks.get(i).get() != null) continue;
            this.auDataBooks.remove(i);
        }
        this.auDataBooks.add(new WeakReference<IDataBook>(iDataBook));
    }

    public synchronized void removeDataBook(IDataBook iDataBook) {
        for (int i = this.auDataBooks.size() - 1; i >= 0; --i) {
            IDataBook iDataBook2 = (IDataBook)this.auDataBooks.get(i).get();
            if (iDataBook2 != null && iDataBook2 != iDataBook) continue;
            this.auDataBooks.remove(i);
        }
    }

    public synchronized IDataBook[] getDataBooks() {
        ArrayUtil<IDataBook> arrayUtil = new ArrayUtil<IDataBook>();
        for (int i = this.auDataBooks.size() - 1; i >= 0; --i) {
            IDataBook iDataBook = (IDataBook)this.auDataBooks.get(i).get();
            if (iDataBook == null) {
                this.auDataBooks.remove(i);
                continue;
            }
            arrayUtil.add(0, iDataBook);
        }
        return arrayUtil.toArray(new IDataBook[arrayUtil.size()]);
    }

    public void setWritebackIsolationLevel(IDataBook.WriteBackIsolationLevel writeBackIsolationLevel) {
        this.iWritebackIsolationLevel = writeBackIsolationLevel;
    }

    public IDataBook.WriteBackIsolationLevel getWritebackIsolationLevel() {
        return this.iWritebackIsolationLevel;
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.finalize();
    }

    public String toString() {
        String string = "MemDataSource :: iWritebackIsolationLevel=";
        if (this.iWritebackIsolationLevel == IDataBook.WriteBackIsolationLevel.DATA_ROW) {
            string = string + "DATA_ROW\n";
        } else if (this.iWritebackIsolationLevel == IDataBook.WriteBackIsolationLevel.DATASOURCE) {
            string = string + "DATASOURCE\n";
        }
        return string;
    }
}

