/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.model;

import com.sibvisions.rad.model.mem.MemDataBook;
import com.sibvisions.rad.model.remote.RemoteDataBook;
import com.sibvisions.util.ArrayUtil;
import javax.rad.model.ColumnDefinition;
import javax.rad.model.IDataBook;
import javax.rad.model.IDataRow;
import javax.rad.model.ModelException;
import javax.rad.model.condition.And;
import javax.rad.model.condition.BaseCondition;
import javax.rad.model.condition.CompareCondition;
import javax.rad.model.condition.Equals;
import javax.rad.model.condition.GreaterEquals;
import javax.rad.model.condition.ICondition;
import javax.rad.model.condition.LessEquals;
import javax.rad.model.condition.Like;
import javax.rad.model.condition.LikeIgnoreCase;
import javax.rad.model.condition.Not;
import javax.rad.model.condition.OperatorCondition;
import javax.rad.model.condition.Or;
import javax.rad.model.datatype.BigDecimalDataType;
import javax.rad.model.datatype.BinaryDataType;
import javax.rad.model.datatype.BooleanDataType;
import javax.rad.model.datatype.IDataType;
import javax.rad.model.datatype.StringDataType;
import javax.rad.model.datatype.TimestampDataType;
import javax.rad.persist.ColumnMetaData;
import javax.rad.ui.celleditor.ILinkedCellEditor;

public class Filter {
    protected Filter() {
    }

    public static ICondition createLikeFilter(IDataRow iDataRow, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        BaseCondition baseCondition = new Like(iDataRow, stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            baseCondition = baseCondition.and(new Like(iDataRow, stringArray[i]));
        }
        return baseCondition;
    }

    public static ICondition createLikeIgnoreCaseFilter(IDataRow iDataRow, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        BaseCondition baseCondition = new LikeIgnoreCase(iDataRow, stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            baseCondition = baseCondition.and(new LikeIgnoreCase(iDataRow, stringArray[i]));
        }
        return baseCondition;
    }

    public static ICondition createEqualsFilter(IDataRow iDataRow, String[] stringArray) {
        return Filter.createEqualsFilter(iDataRow, stringArray, true);
    }

    public static ICondition createEqualsFilter(IDataRow iDataRow, String[] stringArray, boolean bl) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        BaseCondition baseCondition = new Equals(iDataRow, stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            baseCondition = baseCondition.and(new Equals(iDataRow, stringArray[i], bl));
        }
        return baseCondition;
    }

    public static ICondition createEqualsFilter(String[] stringArray, Object[] objectArray, ColumnMetaData[] columnMetaDataArray) {
        if (stringArray.length == 0) {
            return null;
        }
        int[] nArray = new int[stringArray.length];
        int n = columnMetaDataArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = ArrayUtil.indexOf(stringArray, columnMetaDataArray[i].getName());
            if (n2 < 0) continue;
            nArray[n2] = i;
        }
        BaseCondition baseCondition = new Equals(stringArray[0], objectArray[nArray[0]]);
        for (n = 1; n < stringArray.length; ++n) {
            baseCondition = baseCondition.and(new Equals(stringArray[n], objectArray[nArray[n]]));
        }
        return baseCondition;
    }

    public static ICondition createFilter(IDataRow iDataRow) {
        return Filter.createFilter(iDataRow, null);
    }

    public static ICondition createFilter(IDataRow iDataRow, String[] stringArray) {
        boolean bl;
        boolean bl2 = bl = stringArray != null && stringArray.length > 0;
        if (!bl) {
            stringArray = iDataRow.getRowDefinition().getColumnNames();
        }
        BaseCondition baseCondition = null;
        CompareCondition compareCondition = null;
        for (int i = 0; i < stringArray.length; ++i) {
            IDataType iDataType;
            int n = iDataRow.getRowDefinition().getColumnDefinitionIndex(stringArray[i]);
            ColumnDefinition columnDefinition = iDataRow.getRowDefinition().getColumnDefinition(n);
            if (!bl && !columnDefinition.isFilterable() || (compareCondition = (iDataType = columnDefinition.getDataType()) instanceof TimestampDataType && i + 1 < stringArray.length && iDataRow.getRowDefinition().getColumnDefinition(i + 1).getDataType() instanceof TimestampDataType ? new GreaterEquals(iDataRow, stringArray[i]) : (iDataType instanceof TimestampDataType && compareCondition instanceof GreaterEquals ? new LessEquals(iDataRow, stringArray[i]) : (iDataType instanceof BigDecimalDataType || iDataType instanceof BooleanDataType || iDataType.getCellEditor() instanceof ILinkedCellEditor && ((ILinkedCellEditor)iDataType.getCellEditor()).isValidationEnabled() || iDataType instanceof TimestampDataType ? new Equals(iDataRow, stringArray[i]) : (iDataType instanceof StringDataType ? new LikeIgnoreCase(iDataRow, stringArray[i]) : null)))) == null) continue;
            baseCondition = baseCondition == null ? compareCondition : baseCondition.and(compareCondition);
        }
        return baseCondition;
    }

    public static ICondition createFullTextFilter(IDataBook iDataBook, String string, String ... stringArray) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        boolean bl = stringArray != null && stringArray.length > 0;
        String[] stringArray2 = bl ? stringArray : iDataBook.getRowDefinition().getColumnNames();
        boolean bl2 = false;
        if (iDataBook instanceof MemDataBook) {
            bl2 = iDataBook instanceof RemoteDataBook ? ((RemoteDataBook)iDataBook).isMemFilter() : true;
        }
        string = "*" + string.trim() + "*";
        Or or = new Or();
        for (int i = 0; i < stringArray2.length; ++i) {
            try {
                ColumnDefinition columnDefinition = iDataBook.getRowDefinition().getColumnDefinition(stringArray2[i]);
                if (columnDefinition.getDataType() instanceof BinaryDataType || !columnDefinition.isWritable() && !bl2 || !bl && !columnDefinition.isFilterable()) continue;
                or.add(new LikeIgnoreCase(stringArray2[i], (Object)string));
                continue;
            }
            catch (ModelException modelException) {
                // empty catch block
            }
        }
        return or;
    }

    public static ICondition createCondition(ICondition iCondition, boolean bl, String ... stringArray) {
        ICondition iCondition2;
        ICondition iCondition3;
        ICondition iCondition4 = null;
        if (iCondition instanceof CompareCondition) {
            CompareCondition compareCondition = (CompareCondition)iCondition;
            String string = compareCondition.getColumnName();
            if (bl) {
                if (ArrayUtil.contains(stringArray, string)) {
                    iCondition4 = compareCondition;
                }
            } else if (!ArrayUtil.contains(stringArray, string)) {
                iCondition4 = compareCondition;
            }
        } else if (iCondition instanceof OperatorCondition) {
            OperatorCondition operatorCondition = (OperatorCondition)iCondition;
            ICondition[] iConditionArray = operatorCondition.getConditions();
            for (int i = 0; i < iConditionArray.length; ++i) {
                ICondition iCondition5 = Filter.createCondition(iConditionArray[i], bl, stringArray);
                if (iCondition5 == null) continue;
                if (i > 0 && iCondition4 != null) {
                    if (operatorCondition instanceof And) {
                        iCondition4 = iCondition4.and(iCondition5);
                        continue;
                    }
                    if (!(operatorCondition instanceof Or)) continue;
                    iCondition4 = iCondition4.or(iCondition5);
                    continue;
                }
                iCondition4 = iCondition5;
            }
        } else if (iCondition instanceof Not && (iCondition3 = Filter.createCondition(iCondition2 = ((Not)iCondition).getCondition(), bl, stringArray)) != null) {
            iCondition4 = new Not(iCondition3);
        }
        return iCondition4;
    }
}

