/*
 * Copyright 2009 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 *
 * 11.08.2009 - [JR] - creation
 * 25.07.2013 - [JR] - #732: tabActivated, tabDeactivated defined
 */
package javax.rad.ui.event;

/**
 * Platform and technology independent tabset listener definition.
 * It is designed for use with AWT, Swing, SWT, JSP, JSF, ... .
 * 
 * @author Ren Jahn
 */
public interface ITabsetListener
{
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Method definitions
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/**
     * Invoked when a tab was closed.
     * 
     * @param pTabsetEvent the tab event.
     */
    public void tabClosed(UITabsetEvent pTabsetEvent);
    
	/**
     * Invoked when a tab was moved.
     * 
     * @param pTabsetEvent the tab event.
     */
    public void tabMoved(UITabsetEvent pTabsetEvent);

	/**
     * Invoked when a tab was activated.
     * 
     * @param pTabsetEvent the tab event.
     */
    public void tabActivated(UITabsetEvent pTabsetEvent);
    
	/**
     * Invoked when a tab was deactivated.
     * 
     * @param pTabsetEvent the tab event.
     */
    public void tabDeactivated(UITabsetEvent pTabsetEvent);
    
}	// ITabsetListener
