/*
 * Copyright 2009 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 * 
 * 04.09.2009 - [HM] - creation                 
 */
package javax.rad.application.genui;

import javax.rad.application.IContent;
import javax.rad.genui.container.UIPanel;

import com.sibvisions.util.type.StringUtil;
import com.sibvisions.util.type.StringUtil.TextType;

/**
 * The <code>Content</code> is the default {@link IContent} implementation and extends
 * an {@link UIPanel}.
 *  
 * @author Martin Handsteiner
 */
public class Content extends UIPanel 
					 implements IContent
{
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Class members
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/** the opener. */
	private Object opener;
	
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Initialization
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/**
	 * Creates a new instance of <code>Content</code>.
	 */
	public Content()
	{
	}
	
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Interface implementation
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/**
	 * {@inheritDoc}
	 */
	public <OP> void setOpener(OP pOpener)
	{
		opener = pOpener;
	}
	
	/**
	 * {@inheritDoc}
	 */
	public <OP> OP getOpener()
	{
		return (OP)opener;
	}

	/**
	 * {@inheritDoc}
	 */
	public void notifyDestroy()
	{
	}

	/**
	 * {@inheritDoc}
	 */
	public void notifyVisible()
	{
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void addNotify()
	{
		// Only set a new root name if there wasn't already one set.
		// This is to make sure that extending classes are able to set
		// their own rootname before addNotify is called.
		// Under normal circumstances, the root name should not be set
		// until addNotify is called.
		if (getRootName() == null)
		{
			setRootName(createComponentName());
		}
		
		super.addNotify();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected String createComponentName()
	{
		return StringUtil.getText(getClass().getSimpleName(), TextType.UpperCase);
	}
	
}	// Content
