/*
 * Copyright 2009 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 *
 * 20.02.2009 - [JR] - creation
 */
package javax.rad.application;

/**
 * The <code>IMessageConstants</code> defines constant values for message handling
 * of {@link IApplication} implementations.
 * 
 * @author Ren Jahn
 */
public interface IMessageConstants
{
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Constants
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/** the type for information icon. */
	public static final int MESSAGE_ICON_INFO 			= 0;
	
	/** the type for warning icon. */
	public static final int MESSAGE_ICON_WARNING 		= 1;
	
	/** the type for error icon. */
	public static final int MESSAGE_ICON_ERROR 			= 2;
	
	/** the type for question icon. */
	public static final int MESSAGE_ICON_QUESTION		= 3;

	/** the type for ok, cancel buttons. */
	public static final int MESSAGE_BUTTON_OK_CANCEL	= 4;
	
	/** the type for yes, no buttons. */ 
	public static final int MESSAGE_BUTTON_YES_NO		= 5;
	
	/** the type for ok button. */
	public static final int MESSAGE_BUTTON_OK			= 6;

}	// IMessageConstants
