/*
 * Copyright 2009 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 *
 * 01.10.2008 - [HM] - creation
 * 08.12.2008 - [JR] - used JVxButton instead of JButton
 */
package com.sibvisions.rad.ui.swing.impl.component;

import com.sibvisions.rad.ui.swing.ext.JVxButton;

/**
 * The <code>SwingButton</code> is the <code>IButton</code>
 * implementation for swing.
 * 
 * @author Martin Handsteiner
 * @see java.awt.Button
 * @see	javax.swing.JButton
 * @see javax.rad.ui.component.IButton
 */
public class SwingButton extends SwingAbstractButton<JVxButton>
{
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Initialization
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/**
	 * Creates a new instance of <code>SwingButton</code>.
	 */
	public SwingButton()
	{
		super(new JVxButton());
		
		resource.addIgnoreActionListener(this);
	}
    
}	// SwingButton
