/*
 * Copyright 2013 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 *
 * 10.07.2013 - [JR] - creation
 * 29.10.2013 - [JR] - #859: ignore missing ServerZone
 */
package com.sibvisions.rad.server;

import javax.rad.server.ISession;
import javax.rad.server.SessionContext;

/**
 * The <code>AbstractSessionContext</code> is a simple extension of {@link SessionContext}. It allows
 * indirect access to internal classes like MasterSession. 
 * 
 * @author Ren Jahn
 */
public abstract class AbstractSessionContext extends SessionContext
{
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Class members
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/** the associated session. */
	private WrappedSession wsessMaster;

	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // User-defined methods
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/**
	 * Gets the MasterSession for this context.
	 * 
	 * @return the session or <code>null</code> if no master session was found
	 */
	public ISession getMasterSession()
	{
		ISession session = getSession();
		
		if (wsessMaster != null)
		{
			return wsessMaster;
		}
		else
		{
			if (session instanceof WrappedSession)
			{
				AbstractSession sessorig = ((WrappedSession)session).session;
						
				if (sessorig instanceof MasterSession)
				{
					wsessMaster = (WrappedSession)session;
					
					return wsessMaster;
				}
				else if (sessorig instanceof SubSession)
				{
					wsessMaster = new WrappedSession(((SubSession)sessorig).getMasterSession());
					
					return wsessMaster;
				}
			}
		}
		
		return null;
	}
	
}	// AbstractSessionContext
