/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.model.datatype;

import com.sibvisions.util.Internalize;
import javax.rad.model.ModelException;
import javax.rad.model.datatype.DataType;

public class StringDataType
extends DataType {
    public static final int TYPE_IDENTIFIER = 12;

    public int getTypeIdentifier() {
        return 12;
    }

    public Class getTypeClass() {
        return String.class;
    }

    public Object convertAndCheckToTypeClass(Object object) throws ModelException {
        String string = (String)this.convertToTypeClass(object);
        if (string == null) {
            return null;
        }
        if (string.length() > this.getSize()) {
            throw new ModelException("String is too large! - length from " + string.length() + " to " + this.getSize());
        }
        return Internalize.intern(string);
    }

    public String convertToString(Object object) {
        return (String)object;
    }

    public Object convertToTypeClass(Object object) throws ModelException {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() == 0) {
                return null;
            }
            return string;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            if (byArray.length == 0) {
                return null;
            }
            return new String(byArray);
        }
        return object.toString();
    }

    public StringDataType clone() {
        return (StringDataType)super.clone();
    }
}

