/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util;

import com.sibvisions.util.security.SecurityProvider;
import com.sibvisions.util.type.CodecUtil;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class SecureHash {
    public static final String MD2 = "MD2";
    public static final String MD4 = "MD4";
    public static final String MD5 = "MD5";
    public static final String SHA = "SHA";
    public static final String SHA_256 = "SHA-256";
    public static final String SHA_384 = "SHA-384";
    public static final String SHA_512 = "SHA-512";
    private String sAlgorithm;
    private byte[] byHash = null;
    private MessageDigest md = null;

    public SecureHash(String string) {
        this.sAlgorithm = string;
    }

    public static String getHash(String string, InputStream inputStream) throws NoSuchAlgorithmException, IOException {
        return CodecUtil.encodeHex(SecureHash.getRawHash(string, inputStream));
    }

    public static byte[] getRawHash(String string, InputStream inputStream) throws NoSuchAlgorithmException, IOException {
        int n;
        MessageDigest messageDigest = MessageDigest.getInstance(string);
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) != -1) {
            messageDigest.update(byArray, 0, n);
        }
        return messageDigest.digest();
    }

    public static String getHash(String string, byte[] byArray) throws NoSuchAlgorithmException {
        return CodecUtil.encodeHex(SecureHash.getRawHash(string, byArray));
    }

    public static byte[] getRawHash(String string, byte[] byArray) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(string);
        messageDigest.update(byArray);
        return messageDigest.digest();
    }

    public void add(InputStream inputStream) throws NoSuchAlgorithmException, IOException {
        int n;
        byte[] byArray = new byte[4096];
        if (this.md == null) {
            this.md = MessageDigest.getInstance(this.sAlgorithm);
        }
        while ((n = inputStream.read(byArray)) != -1) {
            this.md.update(byArray, 0, n);
        }
    }

    public void add(byte[] byArray) throws NoSuchAlgorithmException {
        if (byArray != null) {
            if (this.md == null) {
                this.md = MessageDigest.getInstance(this.sAlgorithm);
            }
            this.md.update(byArray);
        }
    }

    public void reset() {
        this.byHash = null;
        if (this.md != null) {
            this.md.reset();
        }
    }

    public String getHash() {
        return CodecUtil.encodeHex(this.getRawHash());
    }

    public byte[] getRawHash() {
        if (this.md != null) {
            this.byHash = this.md.digest();
            this.md = null;
        }
        return this.byHash;
    }

    static {
        SecurityProvider.init();
    }
}

