/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderedHashtable<K, V>
extends Hashtable<K, V> {
    private Vector<K> vOrderedKeys;

    public OrderedHashtable() {
        this.vOrderedKeys = new Vector(11);
    }

    public OrderedHashtable(int n) {
        super(n);
        this.vOrderedKeys = new Vector(n);
    }

    public OrderedHashtable(int n, float f) {
        super(n, f);
        this.vOrderedKeys = new Vector(n);
    }

    public OrderedHashtable(Map<? extends K, ? extends V> map) {
        this(Math.max(2 * map.size(), 11), 0.75f);
        this.vOrderedKeys = new Vector(Math.max(2 * map.size(), 11));
        this.putAll(map);
    }

    @Override
    public synchronized V put(K k, V v) {
        V v2 = super.put(k, v);
        if (v2 == null) {
            this.vOrderedKeys.add(k);
        }
        return v2;
    }

    @Override
    public synchronized V remove(Object object) {
        Object v = super.remove(object);
        if (v != null) {
            this.vOrderedKeys.removeElement(object);
        }
        return v;
    }

    @Override
    public synchronized Object clone() {
        OrderedHashtable orderedHashtable = (OrderedHashtable)super.clone();
        orderedHashtable.vOrderedKeys = (Vector)this.vOrderedKeys.clone();
        return orderedHashtable;
    }

    @Override
    public synchronized void clear() {
        super.clear();
        this.vOrderedKeys.removeAllElements();
    }

    @Override
    public synchronized Enumeration<K> keys() {
        return ((Vector)this.vOrderedKeys.clone()).elements();
    }

    public synchronized K getKey(int n) {
        return this.vOrderedKeys.get(n);
    }
}

