/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.swing.ext;

import com.sibvisions.rad.ui.awt.impl.AwtFactory;
import com.sibvisions.rad.ui.swing.ext.JVxConstants;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;

public class JVxChoice
extends JTextField
implements JVxConstants,
ItemSelectable {
    private static final NullDocumentFilter NULL_DOCUMENT_FILTER = new NullDocumentFilter();
    private static final NullCaret NULL_CARET = new NullCaret();
    private Object[] allowedValues;
    private Image[] images;
    private Cursor cursor;
    private Image defaultImage = null;
    private Color innerBackground;
    private Border innerBorder;
    private boolean imageBorderVisible = false;
    private Dimension paintSize;
    private int imageWidth;
    private int imageHeight;
    private Dimension imageSize = null;
    private int horizontalAlignment = 0;
    private int verticalAlignment = 0;
    private int selectedIndex;
    private String actionCommand = null;

    public JVxChoice() {
        this(null, null);
    }

    public JVxChoice(Object[] objectArray, Image[] imageArray) {
        this.enableEvents(24L);
        this.setCursor(Cursor.getPredefinedCursor(12));
        ((AbstractDocument)this.getDocument()).setDocumentFilter(NULL_DOCUMENT_FILTER);
        this.setCaret(NULL_CARET);
        this.setAllowedValues(objectArray);
        this.setImages(imageArray);
    }

    public void setUI(TextUI textUI) {
        Color color = this.getBackground();
        Border border = this.getBorder();
        this.setBackground(this.innerBackground);
        this.setBorder(this.innerBorder);
        super.setUI(textUI);
        this.innerBorder = this.getBorder();
        this.innerBackground = this.getBackground();
        this.setBackground(color);
        this.setBorder(border);
        this.setOpaque(false);
    }

    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
        this.cursor = cursor;
    }

    public void setEditable(boolean bl) {
        Color color = this.getBackground();
        Border border = this.getBorder();
        this.setBackground(this.innerBackground);
        this.setBorder(this.innerBorder);
        super.setEditable(bl);
        this.innerBorder = this.getBorder();
        this.innerBackground = this.getBackground();
        this.setBackground(color);
        this.setBorder(border);
        if (bl) {
            super.setCursor(this.cursor);
        } else {
            super.setCursor(Cursor.getDefaultCursor());
        }
    }

    public Color getBackground() {
        if (this.paintSize == null || this.innerBackground == null) {
            return super.getBackground();
        }
        return this.innerBackground;
    }

    public int getWidth() {
        if (this.paintSize == null) {
            return super.getWidth();
        }
        return this.paintSize.width;
    }

    public int getHeight() {
        if (this.paintSize == null) {
            return super.getHeight();
        }
        return this.paintSize.height;
    }

    public Dimension getSize() {
        if (this.paintSize == null) {
            return super.getSize();
        }
        return new Dimension(this.paintSize.width, this.paintSize.height);
    }

    public Rectangle getBounds() {
        if (this.paintSize == null) {
            return super.getBounds();
        }
        return new Rectangle(this.getX(), this.getY(), this.paintSize.width, this.paintSize.height);
    }

    public void paintComponent(Graphics graphics) {
        Dimension dimension = this.getSize();
        Insets insets = this.getInnerInsets();
        Rectangle rectangle = this.getInnerBounds();
        if (this.isBackgroundSet()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
        this.paintSize = new Dimension(rectangle.width, rectangle.height);
        Graphics graphics2 = graphics.create(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (this.imageBorderVisible) {
            this.ui.update(graphics2, this);
        }
        this.paintSize = null;
        Image image = this.selectedIndex < 0 ? this.defaultImage : (this.selectedIndex < this.images.length ? this.images[this.selectedIndex] : null);
        if (image != null) {
            int n = image.getWidth(null);
            int n2 = image.getHeight(null);
            Dimension dimension2 = this.getImageSize();
            if (this.horizontalAlignment != 100 && n < dimension2.width) {
                insets.left += (dimension2.width - n) / 2;
                dimension2.width = n;
            }
            if (this.verticalAlignment != 100 && n2 < dimension2.height) {
                insets.top += (dimension2.height - n2) / 2;
                dimension2.height = n2;
            }
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2.drawImage(image, insets.left, insets.top, dimension2.width, dimension2.height, this);
        }
        graphics2.dispose();
        if (this.imageBorderVisible && this.innerBorder != null) {
            this.innerBorder.paintBorder(this, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Insets insets = this.getInsets();
        Insets insets2 = this.getInnerInsets();
        Dimension dimension = this.getImageSize();
        return new Dimension(dimension.width + insets.left + insets.right + insets2.left + insets2.right, dimension.height + insets.top + insets.bottom + insets2.top + insets2.bottom);
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int n) {
        if (n == 2 || n == 0 || n == 4 || n == 100) {
            if (n != this.horizontalAlignment) {
                this.horizontalAlignment = n;
                this.invalidate();
                this.repaint();
            }
        } else {
            throw new IllegalArgumentException("horizontalAlignment");
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (!mouseEvent.isConsumed() && mouseEvent.getID() == 501 && this.getInnerBounds().contains(mouseEvent.getX(), mouseEvent.getY())) {
            this.requestFocus();
            this.selectNextIndex();
        }
        super.processMouseEvent(mouseEvent);
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (!keyEvent.isConsumed() && keyEvent.getID() == 401 && keyEvent.getKeyCode() == 32) {
            keyEvent.consume();
            this.selectNextIndex();
        }
        super.processKeyEvent(keyEvent);
    }

    public Object[] getSelectedObjects() {
        if (this.selectedIndex < 0) {
            return new Object[0];
        }
        return new Object[]{this.allowedValues[this.selectedIndex]};
    }

    public void addItemListener(ItemListener itemListener) {
        this.listenerList.add(ItemListener.class, itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.listenerList.remove(ItemListener.class, itemListener);
    }

    public Color getInnerBackground() {
        return this.innerBackground;
    }

    public void setInnerBackground(Color color) {
        this.innerBackground = color;
        this.invalidate();
    }

    public Border getInnerBorder() {
        return this.innerBorder;
    }

    public void setInnerBorder(Border border) {
        this.innerBorder = border;
        this.invalidate();
    }

    public boolean isImageBorderVisible() {
        return this.imageBorderVisible;
    }

    public void setImageBorderVisible(boolean bl) {
        this.imageBorderVisible = bl;
        this.invalidate();
    }

    public Object[] getAllowedValues() {
        return (Object[])this.allowedValues.clone();
    }

    public void setAllowedValues(Object[] objectArray) {
        this.allowedValues = objectArray == null ? new Object[0] : (Object[])objectArray.clone();
        this.selectedIndex = -1;
    }

    public Image[] getImages() {
        return (Image[])this.images.clone();
    }

    public void setImages(Image[] imageArray) {
        this.images = imageArray == null ? new Image[0] : (Image[])imageArray.clone();
        this.calculateImageSize();
    }

    public Dimension getImageSize() {
        if (this.imageSize == null) {
            return new Dimension(this.imageWidth, this.imageHeight);
        }
        return (Dimension)this.imageSize.clone();
    }

    public void setImageSize(Dimension dimension) {
        this.imageSize = dimension;
    }

    private void calculateImageSize() {
        this.imageWidth = 14;
        this.imageHeight = 14;
        if (this.defaultImage != null) {
            this.imageWidth = Math.max(this.imageWidth, this.defaultImage.getWidth(null));
            this.imageHeight = Math.max(this.imageHeight, this.defaultImage.getHeight(null));
        }
        for (int i = 0; i < this.images.length; ++i) {
            if (this.images[i] == null) continue;
            this.imageWidth = Math.max(this.imageWidth, this.images[i].getWidth(null));
            this.imageHeight = Math.max(this.imageHeight, this.images[i].getHeight(null));
        }
    }

    public Insets getInnerInsets() {
        if (this.imageBorderVisible && this.innerBorder != null) {
            return this.innerBorder.getBorderInsets(this);
        }
        return new Insets(0, 0, 0, 0);
    }

    public Rectangle getInnerBounds() {
        Insets insets = this.getInsets();
        Dimension dimension = this.getSize();
        dimension.width -= insets.left + insets.right;
        dimension.height -= insets.top + insets.bottom;
        Insets insets2 = this.getInnerInsets();
        Dimension dimension2 = this.getImageSize();
        dimension2.width += insets2.left + insets2.right;
        dimension2.height += insets2.top + insets2.bottom;
        Rectangle rectangle = new Rectangle();
        switch (this.horizontalAlignment) {
            case 2: {
                rectangle.x = insets.left;
                rectangle.width = dimension2.width;
                break;
            }
            case 0: {
                rectangle.x = insets.left + (dimension.width - dimension2.width) / 2;
                rectangle.width = dimension2.width;
                break;
            }
            case 4: {
                rectangle.x = insets.left + dimension.width - dimension2.width;
                rectangle.width = dimension2.width;
                break;
            }
            default: {
                rectangle.x = 0;
                rectangle.width = dimension.width;
            }
        }
        switch (this.verticalAlignment) {
            case 1: {
                rectangle.y = insets.top;
                rectangle.height = dimension2.height;
                break;
            }
            case 0: {
                rectangle.y = insets.top + (dimension.height - dimension2.height) / 2;
                rectangle.height = dimension2.height;
                break;
            }
            case 3: {
                rectangle.y = insets.top + dimension.height - dimension2.height;
                rectangle.height = dimension2.height;
                break;
            }
            default: {
                rectangle.y = insets.top;
                rectangle.height = dimension.height;
            }
        }
        return rectangle;
    }

    public Image getDefaultImage() {
        return this.defaultImage;
    }

    public void setDefaultImage(Image image) {
        this.defaultImage = image;
        this.calculateImageSize();
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int n) {
        if (n == 1 || n == 0 || n == 3 || n == 100) {
            if (n != this.verticalAlignment) {
                this.verticalAlignment = n;
                this.invalidate();
                this.repaint();
            }
        } else {
            throw new IllegalArgumentException("verticalAlignment");
        }
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int n) {
        if (n < 0 || n >= this.allowedValues.length) {
            if (this.selectedIndex != -1) {
                this.fireItemStateChanged(new ItemEvent(this, 701, this.allowedValues[this.selectedIndex], 2));
                this.selectedIndex = -1;
                this.invalidate();
                this.repaint();
                this.fireItemStateChanged(new ItemEvent(this, 701, null, 1));
            }
        } else if (this.selectedIndex != n) {
            if (this.selectedIndex == -1) {
                this.fireItemStateChanged(new ItemEvent(this, 701, null, 2));
            } else {
                this.fireItemStateChanged(new ItemEvent(this, 701, this.allowedValues[this.selectedIndex], 2));
            }
            this.selectedIndex = n;
            this.invalidate();
            this.repaint();
            this.fireItemStateChanged(new ItemEvent(this, 701, this.allowedValues[this.selectedIndex], 1));
        }
        this.fireActionEvent();
    }

    public void selectNextIndex() {
        if (this.isEnabled() && this.isEditable()) {
            if (this.selectedIndex + 1 < this.allowedValues.length) {
                this.setSelectedIndex(this.selectedIndex + 1);
            } else {
                this.setSelectedIndex(0);
            }
        }
    }

    public Object getSelectedItem() {
        if (this.selectedIndex < 0) {
            return null;
        }
        return this.allowedValues[this.selectedIndex];
    }

    public void setSelectedItem(Object object) {
        for (int i = 0; i < this.allowedValues.length; ++i) {
            if (object != this.allowedValues[i] && (object == null || !object.equals(this.allowedValues[i]))) continue;
            this.setSelectedIndex(i);
            return;
        }
        this.setSelectedIndex(-1);
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])this.listenerList.getListeners(ItemListener.class);
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(ActionListener.class);
    }

    protected void fireItemStateChanged(ItemEvent itemEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ItemListener.class) continue;
            ((ItemListener)objectArray[i + 1]).itemStateChanged(itemEvent);
        }
    }

    protected void fireActionEvent() {
        ActionEvent actionEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ActionListener.class) continue;
            if (actionEvent == null) {
                actionEvent = new ActionEvent(this, 1001, this.getActionCommand(), AwtFactory.getMostRecentEventTime(), AwtFactory.getCurrentModifiers());
            }
            ((ActionListener)objectArray[i + 1]).actionPerformed(actionEvent);
        }
    }

    public static class NullDocumentFilter
    extends DocumentFilter {
        public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
        }

        public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            filterBypass.replace(n, n2, "", attributeSet);
        }
    }

    public static class NullCaret
    implements Caret {
        public void addChangeListener(ChangeListener changeListener) {
        }

        public void removeChangeListener(ChangeListener changeListener) {
        }

        public void install(JTextComponent jTextComponent) {
        }

        public void deinstall(JTextComponent jTextComponent) {
        }

        public void setBlinkRate(int n) {
        }

        public int getBlinkRate() {
            return 0;
        }

        public void setDot(int n) {
        }

        public int getDot() {
            return 0;
        }

        public void moveDot(int n) {
        }

        public void setMagicCaretPosition(Point point) {
        }

        public Point getMagicCaretPosition() {
            return null;
        }

        public int getMark() {
            return 0;
        }

        public void setSelectionVisible(boolean bl) {
        }

        public boolean isSelectionVisible() {
            return false;
        }

        public void setVisible(boolean bl) {
        }

        public boolean isVisible() {
            return false;
        }

        public void paint(Graphics graphics) {
        }
    }
}

