/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.awt.impl;

import com.sibvisions.rad.ui.awt.impl.AwtColor;
import com.sibvisions.rad.ui.awt.impl.AwtCursor;
import com.sibvisions.rad.ui.awt.impl.AwtDimension;
import com.sibvisions.rad.ui.awt.impl.AwtFont;
import com.sibvisions.rad.ui.awt.impl.AwtImage;
import com.sibvisions.rad.ui.awt.impl.AwtPoint;
import com.sibvisions.rad.ui.awt.impl.AwtRectangle;
import com.sibvisions.rad.ui.awt.impl.AwtResource;
import com.sibvisions.util.type.ImageUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.rad.ui.IAlignmentConstants;
import javax.rad.ui.IColor;
import javax.rad.ui.IComponent;
import javax.rad.ui.IContainer;
import javax.rad.ui.ICursor;
import javax.rad.ui.IDimension;
import javax.rad.ui.IFactory;
import javax.rad.ui.IFont;
import javax.rad.ui.IImage;
import javax.rad.ui.IPoint;
import javax.rad.ui.IRectangle;
import javax.rad.ui.event.ComponentHandler;
import javax.rad.ui.event.FocusHandler;
import javax.rad.ui.event.KeyHandler;
import javax.rad.ui.event.MouseHandler;
import javax.rad.ui.event.UIComponentEvent;
import javax.rad.ui.event.UIFocusEvent;
import javax.rad.ui.event.UIKeyEvent;
import javax.rad.ui.event.UIMouseEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AwtComponent<C extends Component>
extends AwtResource<C>
implements IComponent,
IAlignmentConstants,
MouseListener,
KeyListener,
ComponentListener,
FocusListener {
    protected IContainer parent = null;
    protected IFactory factory = null;
    protected IComponent eventSource = this;
    protected MouseHandler eventMousePressed = null;
    protected MouseHandler eventMouseReleased = null;
    protected MouseHandler eventMouseClicked = null;
    protected MouseHandler eventMouseEntered = null;
    protected MouseHandler eventMouseExited = null;
    protected KeyHandler eventKeyPressed = null;
    protected KeyHandler eventKeyReleased = null;
    protected KeyHandler eventKeyTyped = null;
    protected ComponentHandler eventComponentMoved = null;
    protected ComponentHandler eventComponentResized = null;
    private FocusHandler eventFocusGained = null;
    private FocusHandler eventFocusLost = null;
    private int horizontalAlignment;
    private int verticalAlignment;
    protected boolean bMouseListener = false;
    protected boolean bKeyListener = false;
    protected boolean bComponentListener = false;
    protected boolean bFocusListener = false;

    protected AwtComponent(C c) {
        super(c);
    }

    @Override
    public String getName() {
        return ((Component)this.resource).getName();
    }

    @Override
    public void setName(String string) {
        ((Component)this.resource).setName(string);
    }

    @Override
    public IFactory getFactory() {
        return this.factory;
    }

    @Override
    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    @Override
    public void setHorizontalAlignment(int n) {
        this.horizontalAlignment = n;
    }

    @Override
    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    @Override
    public void setVerticalAlignment(int n) {
        this.verticalAlignment = n;
    }

    @Override
    public IDimension getPreferredSize() {
        Dimension dimension = ((Component)this.resource).getPreferredSize();
        if (dimension == null) {
            return null;
        }
        return new AwtDimension(dimension);
    }

    @Override
    public void setPreferredSize(IDimension iDimension) {
        if (iDimension == null) {
            ((Component)this.resource).setPreferredSize(null);
        } else {
            ((Component)this.resource).setPreferredSize((Dimension)iDimension.getResource());
        }
        ((Component)this.resource).invalidate();
    }

    @Override
    public boolean isPreferredSizeSet() {
        return ((Component)this.resource).isPreferredSizeSet();
    }

    @Override
    public IDimension getMinimumSize() {
        Dimension dimension = ((Component)this.resource).getMinimumSize();
        if (dimension == null) {
            return null;
        }
        return new AwtDimension(dimension);
    }

    @Override
    public void setMinimumSize(IDimension iDimension) {
        if (iDimension == null) {
            ((Component)this.resource).setMinimumSize(null);
        } else {
            ((Component)this.resource).setMinimumSize((Dimension)iDimension.getResource());
        }
    }

    @Override
    public boolean isMinimumSizeSet() {
        return ((Component)this.resource).isMinimumSizeSet();
    }

    @Override
    public IDimension getMaximumSize() {
        Dimension dimension = ((Component)this.resource).getMaximumSize();
        if (dimension == null) {
            return null;
        }
        return new AwtDimension(dimension);
    }

    @Override
    public void setMaximumSize(IDimension iDimension) {
        if (iDimension == null) {
            ((Component)this.resource).setMaximumSize(null);
        } else {
            ((Component)this.resource).setMaximumSize((Dimension)iDimension.getResource());
        }
    }

    @Override
    public boolean isMaximumSizeSet() {
        return ((Component)this.resource).isMaximumSizeSet();
    }

    @Override
    public IColor getBackground() {
        Color color = ((Component)this.resource).getBackground();
        if (color == null) {
            return null;
        }
        return new AwtColor(color);
    }

    @Override
    public void setBackground(IColor iColor) {
        if (iColor == null) {
            ((Component)this.resource).setBackground(null);
        } else {
            ((Component)this.resource).setBackground((Color)iColor.getResource());
        }
    }

    @Override
    public boolean isBackgroundSet() {
        return ((Component)this.resource).isBackgroundSet();
    }

    @Override
    public IColor getForeground() {
        Color color = ((Component)this.resource).getForeground();
        if (color == null) {
            return null;
        }
        return new AwtColor(color);
    }

    @Override
    public void setForeground(IColor iColor) {
        if (iColor == null) {
            ((Component)this.resource).setForeground(null);
        } else {
            ((Component)this.resource).setForeground((Color)iColor.getResource());
        }
    }

    @Override
    public boolean isForegroundSet() {
        return ((Component)this.resource).isForegroundSet();
    }

    @Override
    public ICursor getCursor() {
        Cursor cursor = ((Component)this.resource).getCursor();
        if (cursor == null) {
            return null;
        }
        return new AwtCursor(cursor);
    }

    @Override
    public void setCursor(ICursor iCursor) {
        if (iCursor == null) {
            ((Component)this.resource).setCursor(null);
        } else {
            ((Component)this.resource).setCursor((Cursor)iCursor.getResource());
        }
    }

    @Override
    public boolean isCursorSet() {
        return ((Component)this.resource).isCursorSet();
    }

    @Override
    public IFont getFont() {
        Font font = ((Component)this.resource).getFont();
        if (font == null) {
            return null;
        }
        return new AwtFont(font);
    }

    @Override
    public void setFont(IFont iFont) {
        if (iFont == null) {
            ((Component)this.resource).setFont(null);
        } else {
            ((Component)this.resource).setFont((Font)iFont.getResource());
        }
    }

    @Override
    public boolean isFontSet() {
        return ((Component)this.resource).isFontSet();
    }

    @Override
    public String getToolTipText() {
        return null;
    }

    @Override
    public void setToolTipText(String string) {
    }

    @Override
    public void setFocusable(boolean bl) {
        ((Component)this.resource).setFocusable(bl);
    }

    @Override
    public boolean isFocusable() {
        return ((Component)this.resource).isFocusable();
    }

    @Override
    public void requestFocus() {
        ((Component)this.resource).requestFocus();
    }

    @Override
    public IContainer getParent() {
        return this.parent;
    }

    @Override
    public void setParent(IContainer iContainer) {
        if (iContainer == null) {
            if (this.parent != null && this.parent.indexOf(this) >= 0) {
                throw new IllegalArgumentException("Can't unset parent, because this component is still added!");
            }
        } else if (iContainer.indexOf(this) < 0) {
            throw new IllegalArgumentException("Can't set parent, because this component is not added!");
        }
        this.parent = iContainer;
    }

    @Override
    public boolean isVisible() {
        return ((Component)this.resource).isVisible();
    }

    @Override
    public void setVisible(boolean bl) {
        ((Component)this.resource).setVisible(bl);
    }

    @Override
    public boolean isEnabled() {
        return ((Component)this.resource).isEnabled();
    }

    @Override
    public void setEnabled(boolean bl) {
        ((Component)this.resource).setEnabled(bl);
    }

    @Override
    public IPoint getLocationRelativeTo(IComponent iComponent) {
        Point point = ((Component)this.resource).getLocation();
        if (iComponent != null) {
            Container container = (Container)iComponent.getResource();
            Container container2 = ((Component)this.resource).getParent();
            if (container.isShowing() && container != container2 && container2 != null) {
                Point point2 = container.getLocationOnScreen();
                Point point3 = container2.getLocationOnScreen();
                point.x += point3.x - point2.x;
                point.y += point3.y - point2.y;
            }
        }
        return new AwtPoint(point);
    }

    @Override
    public void setLocationRelativeTo(IComponent iComponent, IPoint iPoint) {
        Point point = (Point)iPoint.getResource();
        if (iComponent != null) {
            Container container = (Container)iComponent.getResource();
            Container container2 = ((Component)this.resource).getParent();
            if (container.isShowing() && container != container2 && container2 != null) {
                Point point2 = container.getLocationOnScreen();
                Point point3 = container2.getLocationOnScreen();
                point.x -= point3.x - point2.x;
                point.y -= point3.y - point2.y;
            }
        }
        ((Component)this.resource).setLocation(point);
    }

    @Override
    public IPoint getLocation() {
        return this.getLocationRelativeTo(this.parent);
    }

    @Override
    public void setLocation(IPoint iPoint) {
        this.setLocationRelativeTo(this.parent, iPoint);
    }

    @Override
    public IDimension getSize() {
        return new AwtDimension(((Component)this.resource).getSize());
    }

    @Override
    public void setSize(IDimension iDimension) {
        ((Component)this.resource).setSize((Dimension)iDimension.getResource());
        if (!((Component)this.resource).isShowing()) {
            this.validate((Component)this.resource);
        }
    }

    @Override
    public IRectangle getBounds() {
        Rectangle rectangle = ((Component)this.resource).getBounds();
        if (this.parent != null) {
            Container container = (Container)this.parent.getResource();
            Container container2 = ((Component)this.resource).getParent();
            if (container.isShowing() && container2 != null && container != container2) {
                Point point = container.getLocationOnScreen();
                Point point2 = ((Component)this.resource).getParent().getLocationOnScreen();
                rectangle.x += point2.x - point.x;
                rectangle.y += point2.y - point.y;
            }
        }
        return new AwtRectangle(rectangle);
    }

    @Override
    public void setBounds(IRectangle iRectangle) {
        Rectangle rectangle = (Rectangle)iRectangle.getResource();
        if (this.parent != null) {
            Container container = (Container)this.parent.getResource();
            Container container2 = ((Component)this.resource).getParent();
            if (container.isShowing() && container2 != null && container != container2) {
                Point point = container.getLocationOnScreen();
                Point point2 = ((Component)this.resource).getParent().getLocationOnScreen();
                rectangle.x -= point2.x - point.x;
                rectangle.y -= point2.y - point.y;
            }
        }
        ((Component)this.resource).setBounds(rectangle);
        if (!((Component)this.resource).isShowing()) {
            this.validate((Component)this.resource);
        }
    }

    @Override
    public IComponent getEventSource() {
        return this.eventSource;
    }

    @Override
    public void setEventSource(IComponent iComponent) {
        this.eventSource = iComponent;
    }

    @Override
    public MouseHandler eventMousePressed() {
        if (this.eventMousePressed == null) {
            this.eventMousePressed = new MouseHandler("mousePressed");
            this.addMouseListener();
        }
        return this.eventMousePressed;
    }

    @Override
    public MouseHandler eventMouseReleased() {
        if (this.eventMouseReleased == null) {
            this.eventMouseReleased = new MouseHandler("mouseReleased");
            this.addMouseListener();
        }
        return this.eventMouseReleased;
    }

    @Override
    public MouseHandler eventMouseClicked() {
        if (this.eventMouseClicked == null) {
            this.eventMouseClicked = new MouseHandler("mouseClicked");
            this.addMouseListener();
        }
        return this.eventMouseClicked;
    }

    @Override
    public MouseHandler eventMouseEntered() {
        if (this.eventMouseEntered == null) {
            this.eventMouseEntered = new MouseHandler("mouseEntered");
            this.addMouseListener();
        }
        return this.eventMouseEntered;
    }

    @Override
    public MouseHandler eventMouseExited() {
        if (this.eventMouseExited == null) {
            this.eventMouseExited = new MouseHandler("mouseExited");
            this.addMouseListener();
        }
        return this.eventMouseExited;
    }

    @Override
    public KeyHandler eventKeyPressed() {
        if (this.eventKeyPressed == null) {
            this.eventKeyPressed = new KeyHandler("keyPressed");
            this.addKeyListener();
        }
        return this.eventKeyPressed;
    }

    @Override
    public KeyHandler eventKeyReleased() {
        if (this.eventKeyReleased == null) {
            this.eventKeyReleased = new KeyHandler("keyReleased");
            this.addKeyListener();
        }
        return this.eventKeyReleased;
    }

    @Override
    public KeyHandler eventKeyTyped() {
        if (this.eventKeyTyped == null) {
            this.eventKeyTyped = new KeyHandler("keyTyped");
            this.addKeyListener();
        }
        return this.eventKeyTyped;
    }

    @Override
    public ComponentHandler eventComponentMoved() {
        if (this.eventComponentMoved == null) {
            this.eventComponentMoved = new ComponentHandler("componentMoved");
            this.addComponentListener();
        }
        return this.eventComponentMoved;
    }

    @Override
    public ComponentHandler eventComponentResized() {
        if (this.eventComponentResized == null) {
            this.eventComponentResized = new ComponentHandler("componentResized");
            this.addComponentListener();
        }
        return this.eventComponentResized;
    }

    @Override
    public FocusHandler eventFocusGained() {
        if (this.eventFocusGained == null) {
            this.eventFocusGained = new FocusHandler("focusGained");
            this.addFocusListener();
        }
        return this.eventFocusGained;
    }

    @Override
    public FocusHandler eventFocusLost() {
        if (this.eventFocusLost == null) {
            this.eventFocusLost = new FocusHandler("focusLost");
            this.addFocusListener();
        }
        return this.eventFocusLost;
    }

    @Override
    public IImage capture(int n, int n2) {
        return new AwtImage(null, this.createImage((Component)this.resource, n, n2));
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.eventMousePressed != null) {
            this.eventMousePressed.dispatchEvent(this.createMouseEvent(501, mouseEvent));
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.eventMouseReleased != null) {
            this.eventMouseReleased.dispatchEvent(this.createMouseEvent(502, mouseEvent));
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.eventMouseClicked != null) {
            this.eventMouseClicked.dispatchEvent(this.createMouseEvent(500, mouseEvent));
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.eventMouseEntered != null) {
            this.eventMouseEntered.dispatchEvent(this.createMouseEvent(503, mouseEvent));
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.eventMouseExited != null) {
            this.eventMouseExited.dispatchEvent(this.createMouseEvent(504, mouseEvent));
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.eventKeyPressed != null) {
            this.eventKeyPressed.dispatchEvent(new UIKeyEvent(this.eventSource, 401, keyEvent.getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar()));
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (this.eventKeyReleased != null) {
            this.eventKeyReleased.dispatchEvent(new UIKeyEvent(this.eventSource, 402, keyEvent.getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar()));
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (this.eventKeyTyped != null) {
            this.eventKeyTyped.dispatchEvent(new UIKeyEvent(this.eventSource, 400, keyEvent.getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar()));
        }
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        if (this.eventComponentMoved != null) {
            this.eventComponentMoved.dispatchEvent(new UIComponentEvent(this.eventSource, 100, System.currentTimeMillis(), 0));
        }
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        if (this.eventComponentResized != null) {
            this.eventComponentResized.dispatchEvent(new UIComponentEvent(this.eventSource, 101, System.currentTimeMillis(), 0));
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (this.eventFocusGained != null) {
            this.eventFocusGained.dispatchEvent(new UIFocusEvent(this.eventSource, 1004, System.currentTimeMillis(), 0));
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (this.eventFocusLost != null) {
            this.eventFocusLost.dispatchEvent(new UIFocusEvent(this.eventSource, 1005, System.currentTimeMillis(), 0));
        }
    }

    protected UIMouseEvent createMouseEvent(int n, MouseEvent mouseEvent) {
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        Component component = (Component)this.eventSource.getResource();
        for (Component component2 = mouseEvent.getComponent(); component2 != component; component2 = component2.getParent()) {
            n2 += component2.getX();
            n3 += component2.getY();
        }
        return new UIMouseEvent(this.eventSource, n, mouseEvent.getWhen(), mouseEvent.getModifiers(), n2, n3, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
    }

    public void setFactory(IFactory iFactory) {
        this.factory = iFactory;
    }

    protected void addMouseListener() {
        if (!this.bMouseListener) {
            this.bMouseListener = true;
            ((Component)this.resource).addMouseListener(this);
        }
    }

    protected void addKeyListener() {
        if (!this.bKeyListener) {
            this.bKeyListener = true;
            ((Component)this.resource).addKeyListener(this);
        }
    }

    protected void addComponentListener() {
        if (!this.bComponentListener) {
            this.bComponentListener = true;
            ((Component)this.resource).addComponentListener(this);
        }
    }

    protected void addFocusListener() {
        if (!this.bFocusListener) {
            this.bFocusListener = true;
            ((Component)this.resource).addFocusListener(this);
        }
    }

    public void validate(Component component) {
        component.doLayout();
        if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                this.validate(container.getComponent(i));
            }
        }
    }

    protected Image createImage(Component component, int n, int n2) {
        BufferedImage bufferedImage = new BufferedImage(component.getWidth(), component.getHeight(), 2);
        component.validate();
        component.paint(bufferedImage.getGraphics());
        return ImageUtil.getScaledImage(bufferedImage, n, n2, false);
    }
}

