/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui;

import com.sibvisions.util.Reflective;
import com.sibvisions.util.type.FileUtil;
import com.sibvisions.util.type.ResourceUtil;
import com.sibvisions.util.xml.XmlNode;
import com.sibvisions.util.xml.XmlWorker;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.rad.application.IApplication;
import javax.rad.application.ILauncher;

public final class ApplicationUtil {
    private static boolean bIsMacOS;
    private static boolean bIsWindows;
    private static boolean bIsLinux;

    private ApplicationUtil() {
    }

    public static IApplication createApplication(ILauncher iLauncher, String string) throws Throwable {
        return (IApplication)Reflective.construct(string, iLauncher);
    }

    public static IApplication createApplication(ILauncher iLauncher, ClassLoader classLoader, String string) throws Throwable {
        return (IApplication)Reflective.construct(classLoader, string, iLauncher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlNode getConfig(ILauncher iLauncher, String string) throws Exception {
        InputStream inputStream = ResourceUtil.getResourceAsStream(string);
        if (inputStream != null) {
            XmlNode xmlNode;
            block7: {
                try {
                    XmlWorker xmlWorker = new XmlWorker();
                    xmlNode = xmlWorker.read(inputStream);
                    Object var6_5 = null;
                    if (inputStream == null) break block7;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return xmlNode;
        }
        return null;
    }

    public static String replaceParameter(String string, ILauncher iLauncher) {
        if (string != null) {
            int n;
            int n2 = 0;
            while ((n = string.indexOf("[", n2)) >= 0) {
                String string2;
                String string3;
                n2 = string.indexOf(93, n);
                if (n2 <= n || (string3 = iLauncher.getParameter(string2 = string.substring(n + 1, n2))) == null) continue;
                string = string.replace("[" + string2 + "]", string3);
                n2 = n + string3.length();
            }
            return string;
        }
        return null;
    }

    public static void setRegistryKey(String string, String string2, String string3) {
        if (bIsMacOS) {
            try {
                XmlNode xmlNode;
                File file = ApplicationUtil.getRegistryFile();
                XmlWorker xmlWorker = new XmlWorker();
                if (file.exists()) {
                    xmlNode = xmlWorker.read(file);
                } else {
                    new File(FileUtil.getDirectory(file.getAbsolutePath())).mkdirs();
                    xmlNode = XmlNode.createXmlDeclaration();
                }
                String string4 = "/registry/" + string + "/" + string2;
                if (string3 == null) {
                    xmlNode.removeNode(string4);
                } else {
                    xmlNode.setNode(string4, string3);
                }
                xmlWorker.write(file, xmlNode);
            }
            catch (Exception exception) {
                throw new SecurityException(exception);
            }
        }
        Preferences preferences = Preferences.userRoot().node(string);
        try {
            if (string3 == null) {
                preferences.remove(string2);
            } else {
                preferences.put(string2, string3);
            }
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
            return;
        }
        try {
            preferences.flush();
            preferences.sync();
        }
        catch (BackingStoreException backingStoreException) {
            throw new RuntimeException("Error saving registry key: " + string + " " + string2, backingStoreException);
        }
    }

    private static File getRegistryFile() {
        if (bIsMacOS) {
            return new File(System.getProperty("user.home"), "/Library/Preferences/com.sibvisions.rad.Registry.xml");
        }
        if (bIsLinux) {
            return new File(System.getProperty("user.home"), "/Java/registry.xml");
        }
        if (bIsWindows) {
            return new File(System.getenv("APPDATA"), "/.java/preferences/registry.xml");
        }
        return null;
    }

    public static String getRegistryKey(String string, String string2) {
        if (bIsMacOS) {
            try {
                File file = ApplicationUtil.getRegistryFile();
                if (file.exists()) {
                    XmlWorker xmlWorker = new XmlWorker();
                    XmlNode xmlNode = xmlWorker.read(file);
                    return xmlNode.getNodeValue("/registry/" + string + "/" + string2);
                }
                return null;
            }
            catch (Exception exception) {
                throw new SecurityException(exception);
            }
        }
        Preferences preferences = Preferences.userRoot();
        try {
            if (string != null && preferences.nodeExists(string)) {
                return preferences.node(string).get(string2, null);
            }
            return null;
        }
        catch (BackingStoreException backingStoreException) {
            return null;
        }
    }

    public static String getRegistryApplicationName(ILauncher iLauncher) {
        String string = iLauncher.getParameter("Launcher.codebase");
        if (string == null) {
            string = iLauncher.getParameter("Application.serverbase");
        }
        if (string != null) {
            if ((string = string.replace("://", "/").replace(":", "/")).endsWith("/")) {
                return string + iLauncher.getParameter("Application.name");
            }
            return string + "/" + iLauncher.getParameter("Application.name");
        }
        return iLauncher.getParameter("Application.name");
    }

    static {
        try {
            String string = System.getProperty("os.name").toLowerCase();
            bIsMacOS = string.indexOf("mac") >= 0;
            bIsWindows = string.indexOf("windows") >= 0;
            bIsLinux = string.indexOf("linux") >= 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

