/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server.http;

import com.sibvisions.rad.server.IRequest;
import com.sibvisions.rad.server.IResponse;
import com.sibvisions.rad.server.Server;
import com.sibvisions.util.ThreadHandler;
import com.sibvisions.util.type.CodecUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import javax.rad.server.ISession;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ServletServer
extends HttpServlet {
    private Server server;

    public void init() {
        this.server = Server.getInstance();
    }

    public void destroy() {
        this.server = null;
        ThreadHandler.stop();
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        httpServletResponse.setContentType("application/octet-stream");
        try {
            HttpSession httpSession;
            long l = System.currentTimeMillis();
            ISession iSession = this.server.process(new HttpRequest(httpServletRequest), new HttpResponse(httpServletResponse));
            if (iSession != null && (httpSession = httpServletRequest.getSession(false)) != null) {
                if (iSession.isInactive(l) || !iSession.isAlive(l)) {
                    httpSession.invalidate();
                } else {
                    httpSession.setMaxInactiveInterval(iSession.getMaxInactiveInterval());
                }
            }
        }
        catch (ServletException servletException) {
            throw servletException;
        }
        catch (Exception exception) {
            throw new ServletException((Throwable)exception);
        }
    }

    private static final class HttpResponse
    implements IResponse {
        private static final String COOKIE = "server.request.cookie";
        private HttpServletResponse response;

        private HttpResponse(HttpServletResponse httpServletResponse) {
            this.response = httpServletResponse;
        }

        public OutputStream getOutputStream() throws IOException {
            return this.response.getOutputStream();
        }

        public void setProperty(String string, Object object) {
            if (string.startsWith(COOKIE) && (object == null || object instanceof String)) {
                try {
                    Cookie cookie;
                    if (object == null) {
                        cookie = new Cookie("0x" + CodecUtil.encodeHex(string.substring(COOKIE.length() + 1)), "");
                        cookie.setMaxAge(0);
                    } else {
                        cookie = new Cookie("0x" + CodecUtil.encodeHex(string.substring(COOKIE.length() + 1)), "0x" + CodecUtil.encodeHex((String)object));
                        cookie.setMaxAge(30758400);
                    }
                    cookie.setPath("/");
                    this.response.addCookie(cookie);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }

        public void close() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class HttpRequest
    implements IRequest {
        private HttpServletRequest request;
        private Hashtable<String, Object> htProp;

        private HttpRequest(HttpServletRequest httpServletRequest) {
            this.request = httpServletRequest;
            this.htProp = new Hashtable();
            String string = this.request.getAuthType();
            if (string != null) {
                this.htProp.put("authtype", string);
            }
            if ((string = this.request.getRemoteUser()) != null) {
                this.htProp.put("remoteuser", string);
            }
            this.htProp.put("remoteaddr", this.request.getRemoteAddr());
            this.htProp.put("remotehost", this.request.getRemoteHost());
            this.htProp.put("uri", this.request.getRequestURI());
            Cookie[] cookieArray = httpServletRequest.getCookies();
            if (cookieArray != null) {
                int n = cookieArray.length;
                for (int i = 0; i < n; ++i) {
                    if (cookieArray[i].getName().startsWith("0x")) {
                        try {
                            String string2 = cookieArray[i].getValue().startsWith("0x") ? CodecUtil.decodeHex(cookieArray[i].getValue().substring(2)) : cookieArray[i].getValue();
                            if (string2 == null || string2.length() <= 0) continue;
                            this.htProp.put("cookie." + CodecUtil.decodeHex(cookieArray[i].getName().substring(2)), string2);
                        }
                        catch (Exception exception) {
                            this.htProp.put("cookie." + cookieArray[i].getName(), cookieArray[i].getValue());
                        }
                        continue;
                    }
                    this.htProp.put("cookie." + cookieArray[i].getName(), cookieArray[i].getValue());
                }
            }
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.request.getInputStream();
        }

        @Override
        public Object getProperty(String string) {
            return this.htProp.get(string);
        }

        @Override
        public Hashtable<String, Object> getProperties() {
            return this.htProp;
        }

        @Override
        public void close() {
        }
    }
}

