/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server.config;

import com.sibvisions.rad.server.config.Configuration;
import com.sibvisions.rad.server.config.ServerZone;
import com.sibvisions.rad.server.config.Zone;
import com.sibvisions.util.log.LoggerFactory;
import com.sibvisions.util.xml.XmlNode;
import java.io.File;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ApplicationZone
extends Zone {
    private ServerZone zoneServer = null;

    ApplicationZone(File file) throws Exception {
        super(ApplicationZone.checkCaseSensitive(file));
    }

    public ApplicationZone(String string) throws Exception {
        this(Configuration.getApplicationZone(string).getDirectory());
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ApplicationZone applicationZone = (ApplicationZone)super.clone();
        if (this.zoneServer != null) {
            applicationZone.zoneServer = (ServerZone)this.zoneServer.clone();
        }
        return applicationZone;
    }

    @Override
    public synchronized String getProperty(String string, String string2) throws Exception {
        String string3 = super.getProperty(string, null);
        if (string3 == null) {
            ServerZone serverZone = this.getServerZone();
            if (serverZone != null) {
                string3 = serverZone.getProperty("/server" + string.substring(12), string2);
            }
            if (string3 == null) {
                return string2;
            }
        }
        return string3;
    }

    @Override
    public synchronized List<String> getProperties(String string) throws Exception {
        List<String> list = super.getProperties(string);
        ServerZone serverZone = this.getServerZone();
        List<String> list2 = serverZone != null ? serverZone.getProperties("/server" + string.substring(12)) : null;
        if (list == null) {
            return list2;
        }
        if (list2 != null) {
            for (String string2 : list2) {
                if (list.contains(string2)) continue;
                list.add(string2);
            }
        }
        return list;
    }

    @Override
    public synchronized List<XmlNode> getNodes(String string) throws Exception {
        List<XmlNode> list = super.getNodes(string);
        ServerZone serverZone = this.getServerZone();
        List<XmlNode> list2 = serverZone != null ? serverZone.getNodes("/server" + string.substring(12)) : null;
        if (list == null) {
            return list2;
        }
        if (list2 != null) {
            list2.addAll(list);
            return list2;
        }
        return list;
    }

    @Override
    public synchronized XmlNode getNode(String string) throws Exception {
        XmlNode xmlNode = super.getNode(string);
        if (xmlNode == null) {
            ServerZone serverZone = this.getServerZone();
            if (serverZone != null) {
                return serverZone.getNode("/server" + string.substring(12));
            }
            return null;
        }
        return xmlNode;
    }

    @Override
    public void setUpdateEnabled(boolean bl) {
        if (bl) {
            this.zoneServer = null;
        } else {
            ServerZone serverZone = this.getServerZone();
            if (serverZone != null) {
                try {
                    serverZone = (ServerZone)serverZone.clone();
                    serverZone.setUpdateEnabled(false);
                    this.zoneServer = serverZone;
                }
                catch (Exception exception) {
                    throw new SecurityException("Invalid server configuration!", exception);
                }
            }
        }
        super.setUpdateEnabled(bl);
    }

    public String getName() {
        File file = this.getDirectory();
        return file != null ? file.getName() : null;
    }

    public ServerZone getServerZone() {
        if (this.zoneServer == null) {
            try {
                return Configuration.getServerZone();
            }
            catch (Exception exception) {
                LoggerFactory.getInstance(ApplicationZone.class).debug(exception);
                return null;
            }
        }
        return this.zoneServer;
    }

    private static File checkCaseSensitive(File file) throws Exception {
        File file2;
        if (file != null && (file2 = file.getCanonicalFile()) != null && !file.getName().equals(file2.getName())) {
            throw new Exception("Invalid application. Directory name is case sensitive!");
        }
        return file;
    }
}

