/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server.config;

import com.sibvisions.rad.server.config.Zone;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.xml.XmlNode;
import java.io.File;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AppSettings
extends Zone {
    AppSettings(File file) throws Exception {
        super(file, "apps.xml");
    }

    @Override
    public void update() throws Exception {
        if (this.isValid()) {
            super.update();
        } else {
            this.setContent(new XmlNode("apps"));
        }
    }

    public List<String> getAppLocations() {
        try {
            List<XmlNode> list = this.getNodes("/apps/dir");
            if (list != null) {
                ArrayUtil<String> arrayUtil = new ArrayUtil<String>();
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    arrayUtil.add(this.replace(list.get(i).getNodeValue("/location")));
                }
                return arrayUtil;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String replace(String string) {
        if (string != null) {
            StringBuilder stringBuilder = new StringBuilder(string);
            for (int i = 0; i < stringBuilder.length() - 1; ++i) {
                char c = stringBuilder.charAt(i);
                if (c != '$' || stringBuilder.charAt(i + 1) != '{') continue;
                int n = stringBuilder.length();
                for (int j = i + 1; j < n; ++j) {
                    if (stringBuilder.charAt(j) != '}') continue;
                    String string2 = System.getProperty(stringBuilder.substring(i + 2, j), "");
                    stringBuilder.replace(i, j + 1, string2);
                    i = j + 1;
                    j = n;
                }
            }
            return stringBuilder.toString();
        }
        return null;
    }
}

