/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.remote.serializer;

import com.sibvisions.rad.remote.UniversalSerializer;
import com.sibvisions.rad.remote.serializer.ITypeSerializer;
import com.sibvisions.rad.remote.serializer.TypeCache;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.rad.type.bean.BeanType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectSerializer
implements ITypeSerializer<Object> {
    public static final int TYPE_OBJECT = 68;

    @Override
    public Class<Object> getTypeClass() {
        return Object.class;
    }

    @Override
    public int getMinValue() {
        return 68;
    }

    @Override
    public int getMaxValue() {
        return 68;
    }

    @Override
    public Object read(UniversalSerializer universalSerializer, DataInputStream dataInputStream, int n, TypeCache typeCache) throws Exception {
        BeanType beanType = (BeanType)universalSerializer.read(dataInputStream, typeCache);
        int n2 = beanType.getPropertyCount();
        Object object = beanType.newInstance();
        for (int i = 0; i < n2; ++i) {
            beanType.put(object, i, universalSerializer.read(dataInputStream, typeCache));
        }
        return object;
    }

    @Override
    public void write(UniversalSerializer universalSerializer, DataOutputStream dataOutputStream, Object object, TypeCache typeCache) throws Exception {
        BeanType beanType = BeanType.getBeanType(object);
        int n = beanType.getPropertyCount();
        if (n == 0) {
            throw new IOException("There is no ITypeSerializer registered for Objects of instance " + beanType.getClassName() + "!");
        }
        dataOutputStream.writeByte(68);
        universalSerializer.write(dataOutputStream, beanType, typeCache);
        for (int i = 0; i < n; ++i) {
            universalSerializer.write(dataOutputStream, beanType.get(object, i), typeCache);
        }
    }
}

