/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.remote.serializer;

import com.sibvisions.rad.remote.UniversalSerializer;
import com.sibvisions.rad.remote.serializer.AbstractSizedSerializer;
import com.sibvisions.rad.remote.serializer.ITypeSerializer;
import com.sibvisions.rad.remote.serializer.TypeCache;
import java.io.DataInputStream;
import java.io.DataOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntArraySerializer
extends AbstractSizedSerializer
implements ITypeSerializer<int[]> {
    private static final int TYPE_INT_ARRAY_MIN = 33;
    private static final int TYPE_INT_ARRAY_MAX = 35;

    @Override
    public Class<int[]> getTypeClass() {
        return int[].class;
    }

    @Override
    public int getMinValue() {
        return 33;
    }

    @Override
    public int getMaxValue() {
        return 35;
    }

    @Override
    public int[] read(UniversalSerializer universalSerializer, DataInputStream dataInputStream, int n, TypeCache typeCache) throws Exception {
        int n2 = this.readSize(dataInputStream, n, 33, 35);
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = dataInputStream.readInt();
        }
        return nArray;
    }

    @Override
    public void write(UniversalSerializer universalSerializer, DataOutputStream dataOutputStream, int[] nArray, TypeCache typeCache) throws Exception {
        this.writeSize(dataOutputStream, nArray.length, 33, 35);
        for (int i = 0; i < nArray.length; ++i) {
            dataOutputStream.writeInt(nArray[i]);
        }
    }
}

