/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.remote.http;

import com.sibvisions.rad.remote.AbstractSerializedConnection;
import com.sibvisions.rad.remote.ISerializer;
import com.sibvisions.rad.remote.http.HttpsHostnameVerifier;
import com.sibvisions.rad.remote.http.HttpsTrustManager;
import com.sibvisions.util.ChangedHashtable;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.rad.remote.ConnectionInfo;

public class HttpConnection
extends AbstractSerializedConnection {
    public static final String PREFIX_HTTP = "client.http.";
    public static final String PROP_SERVICE = "service";
    private static Provider provider = null;
    private static TrustManager[] tmSsl = null;
    private static HostnameVerifier hvSsl = null;
    private URL urlServlet = null;
    private String sServletURL = null;
    private URLConnection ucServer = null;
    private ILogger log = LoggerFactory.getInstance(this.getClass());
    private int iConTimeout = -1;

    public HttpConnection(Properties properties) throws MalformedURLException, NoSuchAlgorithmException, KeyManagementException, ClassNotFoundException {
        this(HttpConnection.createSerializer(properties.getProperty("serializer")), properties.getProperty(PROP_SERVICE));
    }

    public HttpConnection(String string) throws MalformedURLException, NoSuchAlgorithmException, KeyManagementException {
        this(null, string);
    }

    public HttpConnection(ISerializer iSerializer, String string) throws MalformedURLException, NoSuchAlgorithmException, KeyManagementException {
        super(iSerializer);
        this.sServletURL = string;
        this.urlServlet = new URL(string);
        this.log.info("Server: ", string, ", Serializer: ", iSerializer != null ? iSerializer.getClass() : null);
        this.initSsl();
    }

    private void initSsl() throws NoSuchAlgorithmException, KeyManagementException {
        if ("https".equals(this.urlServlet.getProtocol().toLowerCase())) {
            if (provider == null) {
                try {
                    try {
                        provider = (Provider)Class.forName("com.sun.net.ssl.internal.ssl.Provider").newInstance();
                    }
                    catch (Exception exception) {
                        this.log.error(exception);
                        try {
                            provider = (Provider)Class.forName("org.apache.harmony.xnet.provider.jsse.JSSEProvider").newInstance();
                        }
                        catch (Exception exception2) {
                            this.log.error(exception2);
                        }
                    }
                    if (provider != null) {
                        tmSsl = new TrustManager[]{new HttpsTrustManager()};
                        hvSsl = new HttpsHostnameVerifier();
                        Security.addProvider(provider);
                        SSLContext sSLContext = SSLContext.getInstance("SSL");
                        sSLContext.init(null, tmSsl, new SecureRandom());
                        HttpsURLConnection.setDefaultSSLSocketFactory(sSLContext.getSocketFactory());
                        HttpsURLConnection.setDefaultHostnameVerifier(hvSsl);
                    } else {
                        this.log.error("SSL Security provider not found!");
                    }
                }
                catch (SecurityException securityException) {
                    this.log.error(securityException);
                    tmSsl = null;
                    hvSsl = null;
                    provider = null;
                }
            }
            if (tmSsl != null && hvSsl != null) {
                ((HttpsTrustManager)tmSsl[0]).addUrl(this.urlServlet);
                ((HttpsHostnameVerifier)hvSsl).addUrl(this.urlServlet);
            }
        }
    }

    public OutputStream getOutputStream(ConnectionInfo connectionInfo) throws IOException {
        this.ucServer = this.urlServlet.openConnection();
        this.ucServer.setUseCaches(false);
        this.ucServer.setRequestProperty("Content-Type", "application/octet-stream");
        if (this.iConTimeout >= 0) {
            this.ucServer.setConnectTimeout(this.iConTimeout);
        }
        this.ucServer.setDoInput(true);
        this.ucServer.setDoOutput(true);
        ChangedHashtable<String, Object> changedHashtable = connectionInfo.getProperties();
        for (Map.Entry entry : changedHashtable.entrySet()) {
            Object v;
            String string = (String)entry.getKey();
            if (!string.startsWith(PREFIX_HTTP) || !((v = entry.getValue()) instanceof String)) continue;
            this.ucServer.setRequestProperty(string.substring(PREFIX_HTTP.length()), (String)v);
        }
        return this.ucServer.getOutputStream();
    }

    public InputStream getInputStream(ConnectionInfo connectionInfo) throws IOException {
        if (this.ucServer != null) {
            return this.ucServer.getInputStream();
        }
        throw new IOException("The connection is not open!");
    }

    public String getServletURL() {
        return this.sServletURL;
    }

    public void setConnectionTimeout(int n) {
        this.iConTimeout = n;
    }
}

