/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.persist.jdbc;

import com.sibvisions.rad.persist.jdbc.DBAccess;
import com.sibvisions.rad.persist.jdbc.ForeignKey;
import com.sibvisions.rad.persist.jdbc.Key;
import com.sibvisions.rad.persist.jdbc.ServerColumnMetaData;
import com.sibvisions.rad.persist.jdbc.ServerMetaData;
import com.sibvisions.util.type.StringUtil;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.rad.persist.DataSourceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HSQLDBAccess
extends DBAccess {
    public HSQLDBAccess() {
        this.setDriver("org.hsqldb.jdbcDriver");
    }

    @Override
    public void open() throws DataSourceException {
        this.setDBProperty("get_column_name", "false");
        super.open();
    }

    @Override
    protected Key getPrimaryKeyIntern(String string, String string2, String string3) throws DataSourceException {
        return super.getPrimaryKeyIntern(string, string2, this.getWritebackTable(string3));
    }

    @Override
    protected List<ForeignKey> getForeignKeysIntern(String string, String string2, String string3) throws DataSourceException {
        return super.getForeignKeysIntern(string, string2, this.getWritebackTable(string3));
    }

    @Override
    protected List<Key> getUniqueKeysIntern(String string, String string2, String string3) throws DataSourceException {
        return super.getUniqueKeysIntern(string, string2, this.getWritebackTable(string3));
    }

    @Override
    protected Object[] insertDatabaseSpecific(String string, String string2, ServerMetaData serverMetaData, Object[] objectArray, String string3) throws DataSourceException {
        objectArray = this.insertAnsiSQL(string, string2, serverMetaData, objectArray, string3);
        return this.hsqlInsertPostProcessing(serverMetaData, objectArray);
    }

    @Override
    public Map<String, Object> getDefaultValues(String string, String string2, String string3) throws DataSourceException {
        return super.getDefaultValues(string, string2, string3.toUpperCase());
    }

    @Override
    protected Object translateDefaultValue(String string, int n, String string2) throws Exception {
        return super.translateDefaultValue(string, n, StringUtil.removeQuotes(string2, "'"));
    }

    public String getWritebackTable(String string) {
        if (string != null) {
            if (HSQLDBAccess.removeQuotes(string).equals(string)) {
                return string.toUpperCase();
            }
            return string;
        }
        return null;
    }

    private Object[] hsqlInsertPostProcessing(ServerMetaData serverMetaData, Object[] objectArray) throws DataSourceException {
        int[] nArray = serverMetaData.getPrimaryKeyColumnIndices();
        if (serverMetaData.getPrimaryKeyType() == ServerMetaData.PrimaryKeyType.PrimaryKeyColumns && nArray != null) {
            ServerColumnMetaData[] serverColumnMetaDataArray = serverMetaData.getServerColumnMetaData();
            int n = -1;
            for (int i = 0; n < 0 && i < nArray.length; ++i) {
                if (serverColumnMetaDataArray[nArray[i]].getDataType().getTypeIdentifier() != 3 || objectArray[nArray[i]] != null) continue;
                n = nArray[i];
            }
            if (n >= 0) {
                CallableStatement callableStatement = null;
                ResultSet resultSet = null;
                try {
                    callableStatement = this.getConnection().prepareCall("CALL IDENTITY()");
                    resultSet = callableStatement.executeQuery();
                    if (resultSet.next() && serverMetaData.getPrimaryKeyColumnIndices().length > 0) {
                        objectArray[n] = resultSet.getObject(1);
                    }
                    Object[] objectArray2 = objectArray;
                    return objectArray2;
                }
                catch (SQLException sQLException) {
                    throw new DataSourceException("The generated keys couldn't read!", this.formatSQLException(sQLException));
                }
                finally {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (callableStatement != null) {
                        try {
                            callableStatement.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
        return objectArray;
    }
}

