/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.model;

import javax.rad.model.IDataRow;
import javax.rad.model.SortDefinition;

public class DataBookSorter {
    private final SortDefinition sort;

    public DataBookSorter(SortDefinition sortDefinition) {
        this.sort = sortDefinition;
    }

    public int[] sort(IDataRow[] iDataRowArray) {
        int[] nArray = this.createArrayWithAscendingIndexes(iDataRowArray.length);
        this.quickSort(nArray, iDataRowArray, 0, nArray.length - 1);
        this.insertionSort(nArray, iDataRowArray, 0, nArray.length - 1);
        return nArray;
    }

    private int[] createArrayWithAscendingIndexes(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        return nArray;
    }

    private void swap(int[] nArray, int n, int n2) {
        int n3 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = n3;
    }

    private void quickSort(int[] nArray, IDataRow[] iDataRowArray, int n, int n2) {
        if (n2 - n > 4) {
            int n3 = (n2 + n) / 2;
            if (iDataRowArray[nArray[n]].compareTo(iDataRowArray[nArray[n3]], this.sort) > 0) {
                this.swap(nArray, n, n3);
            }
            if (iDataRowArray[nArray[n]].compareTo(iDataRowArray[nArray[n2]], this.sort) > 0) {
                this.swap(nArray, n, n2);
            }
            if (iDataRowArray[nArray[n3]].compareTo(iDataRowArray[nArray[n2]], this.sort) > 0) {
                this.swap(nArray, n3, n2);
            }
            int n4 = n2 - 1;
            this.swap(nArray, n3, n4);
            n3 = n;
            IDataRow iDataRow = iDataRowArray[nArray[n4]];
            while (true) {
                if (iDataRowArray[nArray[++n3]].compareTo(iDataRow, this.sort) < 0) {
                    continue;
                }
                while (iDataRowArray[nArray[--n4]].compareTo(iDataRow, this.sort) > 0) {
                }
                if (n4 < n3) break;
                this.swap(nArray, n3, n4);
            }
            this.swap(nArray, n3, n2 - 1);
            this.quickSort(nArray, iDataRowArray, n, n4);
            this.quickSort(nArray, iDataRowArray, n3 + 1, n2);
        }
    }

    private void insertionSort(int[] nArray, IDataRow[] iDataRowArray, int n, int n2) {
        for (int i = n + 1; i <= n2; ++i) {
            int n3 = nArray[i];
            IDataRow iDataRow = iDataRowArray[n3];
            for (int j = i; j > n && iDataRowArray[nArray[j - 1]].compareTo(iDataRow, this.sort) > 0; --j) {
                nArray[j] = nArray[j - 1];
            }
            nArray[j] = n3;
        }
    }
}

