/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.application;

import com.sibvisions.rad.application.Application;
import java.awt.Color;
import javax.rad.application.IConnectable;
import javax.rad.genui.UIColor;
import javax.rad.genui.UIDimension;
import javax.rad.genui.UIFont;
import javax.rad.genui.UIInsets;
import javax.rad.genui.UIRectangle;
import javax.rad.genui.component.UIButton;
import javax.rad.genui.component.UIIcon;
import javax.rad.genui.component.UILabel;
import javax.rad.genui.component.UIPasswordField;
import javax.rad.genui.component.UITextField;
import javax.rad.genui.container.UIDesktopPanel;
import javax.rad.genui.container.UIInternalFrame;
import javax.rad.genui.container.UIPanel;
import javax.rad.genui.layout.UIBorderLayout;
import javax.rad.genui.layout.UIFormLayout;
import javax.rad.ui.IComponent;
import javax.rad.ui.IImage;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class Login
extends UIInternalFrame {
    public static final int MODE_LOGIN = 0;
    public static final int MODE_CHANGE_PASSWORD = 1;
    private static final String WELCOME = "Welcome";
    private static final String CHANGE_PASSWORD = "Change password";
    private IConnectable conMain;
    private UIPanel panManual = new UIPanel();
    private UIPanel panIcon = new UIPanel();
    private UIPanel panTitle = new UIPanel();
    private UIPanel panButtons = new UIPanel();
    private UITextField tfUserName = new UITextField();
    private UIPasswordField tfPassword = new UIPasswordField();
    private UIPasswordField tfPasswordNew = new UIPasswordField();
    private UIPasswordField tfPasswordConfirm = new UIPasswordField();
    private UIButton butOK = new UIButton();
    private UIButton butCancel = new UIButton();
    private UILabel lblInfoTitle = new UILabel();
    private UILabel lblInfoText = new UILabel();
    private UILabel lblUserName = new UILabel();
    private UILabel lblPassword = new UILabel();
    private UILabel lblPasswordNew = new UILabel();
    private UILabel lblPasswordConfirm = new UILabel();
    private UIIcon icoInfo;
    private String sError = null;
    private int iMode;

    public Login(UIDesktopPanel uIDesktopPanel, IConnectable iConnectable) {
        super(uIDesktopPanel);
        this.conMain = iConnectable;
        this.init();
    }

    protected void init() {
        this.setLayout(new UIBorderLayout());
        this.panManual.setLayout(new UIBorderLayout());
        this.panIcon.setLayout(null);
        this.panIcon.setVisible(false);
        this.icoInfo = new UIIcon();
        this.panIcon.add(this.icoInfo);
        this.panManual.add((IComponent)this.panIcon, "West");
        this.panTitle.setLayout(new UIFormLayout());
        UIPanel uIPanel = new UIPanel();
        uIPanel.setLayout(new UIBorderLayout());
        if (this.panTitle.getResource() instanceof JPanel) {
            ((JPanel)this.panTitle.getResource()).setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY));
        }
        this.lblInfoTitle.setFont(new UIFont("dialog", 1, 15));
        this.panTitle.add(this.lblInfoTitle);
        this.panTitle.add((IComponent)this.lblInfoText, "\n");
        this.panTitle.setBackground(UIColor.white);
        uIPanel.add((IComponent)this.panTitle, "North");
        UIPanel uIPanel2 = new UIPanel();
        uIPanel2.setLayout(new UIFormLayout());
        this.lblUserName.setText("Username");
        this.lblPassword.setText("Password");
        this.lblPasswordNew.setText("Password (new)");
        this.lblPasswordConfirm.setText("Password (confirm)");
        uIPanel2.add(this.lblUserName);
        uIPanel2.add(this.tfUserName);
        uIPanel2.add((IComponent)this.lblPassword, "\n");
        uIPanel2.add(this.tfPassword);
        uIPanel2.add((IComponent)this.lblPasswordNew, "\n");
        uIPanel2.add(this.tfPasswordNew);
        uIPanel2.add((IComponent)this.lblPasswordConfirm, "\n");
        uIPanel2.add(this.tfPasswordConfirm);
        uIPanel.add((IComponent)uIPanel2, "Center");
        this.panManual.add((IComponent)uIPanel, "Center");
        UIFormLayout uIFormLayout = new UIFormLayout();
        uIFormLayout.setMargins(new UIInsets(5, 5, 5, 5));
        uIFormLayout.setHorizontalAlignment(2);
        this.panButtons.setLayout(uIFormLayout);
        this.panButtons.setBackground(UIColor.white);
        this.butOK.setDefaultButton(true);
        this.butOK.setPreferredSize(new UIDimension(100, 25));
        this.butCancel.setText("Cancel");
        this.butCancel.setPreferredSize(new UIDimension(100, 25));
        this.panButtons.add((IComponent)this.butCancel, uIFormLayout.getConstraints(uIFormLayout.getTopMarginAnchor(), uIFormLayout.getLeftMarginAnchor(), null, null));
        this.panButtons.add((IComponent)this.butOK, uIFormLayout.getConstraints(uIFormLayout.getTopMarginAnchor(), null, null, uIFormLayout.getRightMarginAnchor()));
        uIPanel.add((IComponent)this.panButtons, "South");
        if (this.panTitle.getResource() instanceof JPanel) {
            ((JPanel)this.panButtons.getResource()).setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.LIGHT_GRAY));
        }
        this.setResizable(false);
        this.setClosable(false);
        this.setMaximizable(false);
        this.setIconifiable(false);
        this.setIconImage(null);
        this.setTitle("Login");
        this.setMode(0);
    }

    public void setUserName(String string) {
        this.tfUserName.setText(string);
    }

    public String getUserName() {
        return this.tfUserName.getText();
    }

    public void setPassword(String string) {
        this.tfPassword.setText(string);
    }

    public String getPassword() {
        return this.tfPassword.getText();
    }

    public String getNewPassword() {
        if (this.iMode == 1) {
            if (this.tfPasswordNew.getText().length() == 0) {
                return null;
            }
            if (!this.tfPasswordNew.getText().equals(this.tfPasswordConfirm.getText())) {
                throw new SecurityException("The passwords are different!");
            }
            return this.tfPasswordNew.getText();
        }
        return null;
    }

    public void setInfoImage(IImage iImage) {
        this.icoInfo.setImage(iImage);
        if (iImage != null) {
            this.icoInfo.setBounds(new UIRectangle(0, 0, iImage.getWidth(), iImage.getHeight()));
            this.panIcon.setPreferredSize(new UIDimension(iImage.getWidth(), 0));
            this.panIcon.setVisible(true);
        } else {
            this.panIcon.removeAll();
            this.panIcon.setVisible(false);
        }
    }

    public IImage getInfoImage() {
        return this.icoInfo.getImage();
    }

    public void setError(String string) {
        if (string != null && string.length() > 0) {
            this.sError = string;
            this.lblInfoTitle.setForeground(UIColor.red);
            this.lblInfoTitle.setText(string);
        } else {
            this.sError = null;
            this.lblInfoTitle.setForeground(UIColor.black);
            if (this.iMode == 1) {
                this.lblInfoTitle.setText(CHANGE_PASSWORD);
            } else {
                this.lblInfoTitle.setText(WELCOME);
            }
        }
    }

    public String getError() {
        return this.sError;
    }

    public void setMode(int n) {
        boolean bl;
        this.setError(null);
        this.removeAll();
        this.add(this.panManual);
        boolean bl2 = bl = n == 1;
        if (bl) {
            this.lblInfoTitle.setText(CHANGE_PASSWORD);
            if (this.conMain.isConnected()) {
                this.lblInfoText.setText("Please enter and confirm the new password.");
                this.tfUserName.setEnabled(false);
                this.butCancel.eventAction().removeListener(this.conMain);
                this.butCancel.eventAction().addListener(this.conMain, "doHideLogin");
                this.butOK.eventAction().removeListener(this.conMain);
                this.butOK.eventAction().addListener(this.conMain, "doChangePassword");
                this.butOK.setText("Change");
                this.tfPassword.requestFocus();
            } else {
                this.lblInfoText.setText("Please enter your username and passwords.");
                this.butCancel.eventAction().removeListener(this.conMain);
                this.butCancel.eventAction().addListener(this.conMain, "doHideChangePassword");
                this.butOK.eventAction().removeListener(this.conMain);
                this.butOK.eventAction().addListener(this.conMain, "doLogin");
                this.butOK.setText("Logon");
                this.tfUserName.requestFocus();
            }
        } else {
            this.lblInfoTitle.setText(WELCOME);
            this.lblInfoText.setText("Please enter your username and password.");
            this.tfUserName.setEnabled(true);
            this.butOK.eventAction().removeListener(this.conMain);
            this.butOK.eventAction().addListener(this.conMain, "doLogin");
            this.butOK.setText("Logon");
            this.tfUserName.requestFocus();
        }
        this.lblPasswordNew.setVisible(bl);
        this.tfPasswordNew.setVisible(bl);
        this.lblPasswordConfirm.setVisible(bl);
        this.tfPasswordConfirm.setVisible(bl);
        this.butCancel.setVisible(bl);
        this.tfPasswordNew.setText("");
        this.tfPasswordConfirm.setText("");
        if (((Application)this.conMain).getLauncher().isWebEnvironment()) {
            if (n == 1) {
                this.setSize(400, 280);
            } else {
                this.setSize(400, 220);
            }
        }
        this.iMode = n;
    }

    public int getMode() {
        return this.iMode;
    }
}

