/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.application;

import com.sibvisions.rad.application.About;
import com.sibvisions.rad.application.ApplicationUtil;
import com.sibvisions.rad.application.Error;
import com.sibvisions.rad.application.Login;
import com.sibvisions.rad.application.Message;
import javax.rad.application.IContent;
import javax.rad.application.genui.RemoteApplication;
import javax.rad.application.genui.UILauncher;
import javax.rad.genui.UIColor;
import javax.rad.genui.UIContainer;
import javax.rad.genui.UIDimension;
import javax.rad.genui.UIFont;
import javax.rad.genui.UIImage;
import javax.rad.genui.celleditor.UIChoiceCellEditor;
import javax.rad.genui.component.UIButton;
import javax.rad.genui.component.UIIcon;
import javax.rad.genui.container.AbstractFrame;
import javax.rad.genui.container.AbstractWindow;
import javax.rad.genui.container.UIDesktopPanel;
import javax.rad.genui.container.UIToolBar;
import javax.rad.genui.layout.UIBorderLayout;
import javax.rad.genui.menu.UIMenu;
import javax.rad.genui.menu.UIMenuBar;
import javax.rad.genui.menu.UIMenuItem;
import javax.rad.remote.AbstractConnection;
import javax.rad.remote.ChangePasswordException;
import javax.rad.remote.CommunicationException;
import javax.rad.remote.IConnection;
import javax.rad.remote.MasterConnection;
import javax.rad.remote.SessionExpiredException;
import javax.rad.remote.event.CallErrorEvent;
import javax.rad.remote.event.CallEvent;
import javax.rad.remote.event.ConnectionEvent;
import javax.rad.remote.event.IConnectionListener;
import javax.rad.remote.event.PropertyEvent;
import javax.rad.ui.IComponent;
import javax.rad.ui.IContainer;
import javax.rad.ui.IRectangle;
import javax.rad.ui.event.Key;
import javax.rad.ui.event.UIActionEvent;
import javax.rad.ui.event.UIWindowEvent;
import javax.rad.util.ExceptionHandler;
import javax.rad.util.event.IExceptionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Application
extends RemoteApplication
implements IExceptionListener,
IConnectionListener {
    public static final String PARAM_MENU_EXIT_VISIBLE = "Application.Menu.exit.visible";
    private IConnection iconApplication;
    private UIDesktopPanel dpanDesktop;
    private UIMenuBar menu;
    private UIToolBar toolbar;
    private Login login;
    private Error error;
    private UIMenuItem miFileLogin;
    private UIMenuItem miFileLogout;
    private UIMenuItem miFileChangePwd;
    private UIMenuItem miFileExit;
    private UIMenuItem miHelp;
    private UIMenuItem miHelpAbout;
    private UIButton butLogin;
    private UIButton butLogout;
    private UIButton butExit;

    public Application(UILauncher uILauncher) {
        super(uILauncher);
        ExceptionHandler.addExceptionListener(this);
        this.preConfigure();
        String string = this.getApplicationName();
        uILauncher.setParameter("Application.name", string);
        if (string != null && string.length() > 0) {
            string = string.toLowerCase();
            string = string.substring(0, 1).toUpperCase() + string.substring(1);
        }
        this.setName(string);
        this.setPreferredSize(new UIDimension(1024, 768));
        UIChoiceCellEditor.addDefaultChoiceCellEditor(ApplicationUtil.YESNO_EDITOR);
        this.configureFrame(uILauncher);
        this.menu = this.createMenu();
        this.configureMenu(this.menu);
        this.toolbar = this.createToolBar();
        this.configureToolBar(this.toolbar);
        this.dpanDesktop = this.createDesktopPane();
        this.configureDesktopPane(this.dpanDesktop);
        this.login = this.createLogin();
        this.configureLogin(this.login);
        this.configureApplicationPane(this.getApplicationPane());
    }

    protected void preConfigure() {
    }

    protected abstract String getApplicationName();

    protected abstract IConnection createConnection() throws Exception;

    @Override
    public UIContainer getContentPane() {
        return this.dpanDesktop;
    }

    @Override
    public void notifyVisible() {
        this.afterLogout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyDestroy() {
        try {
            AbstractConnection abstractConnection = this.getConnection();
            if (abstractConnection != null) {
                try {
                    abstractConnection.close();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    this.setConnection(null);
                    throw throwable;
                }
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            super.notifyDestroy();
            throw throwable;
        }
        super.notifyDestroy();
    }

    @Override
    public <OP> Message showMessage(OP OP, int n, int n2, String string, String string2, String string3) throws Throwable {
        Message message = new Message(this.getDesktopPane(), n, n2, string, string2, string3);
        this.configureFrame(message);
        message.pack();
        message.setOpener(OP);
        message.centerRelativeTo(this);
        message.setVisible(true);
        return message;
    }

    @Override
    public void handleException(Throwable throwable) {
        this.error(throwable);
        try {
            if (this.error == null || this.error.isClosed()) {
                this.error = this.createError();
                this.error.eventWindowClosed().addListener(this, "doErrorClosed");
                this.configureFrame(this.error);
                Application.invokeLater(this, "showErrorDialog");
            }
            this.error.addError(throwable);
        }
        catch (Throwable throwable2) {
            this.getLauncher().handleException(throwable2);
            this.getLauncher().handleException(throwable);
        }
    }

    @Override
    public void callError(CallErrorEvent callErrorEvent) {
        Throwable throwable = callErrorEvent.getCause();
        if (throwable instanceof CommunicationException) {
            this.logout();
            if (throwable instanceof SessionExpiredException) {
                this.login.setError("Session expired!");
            }
        }
    }

    @Override
    public void connectionOpened(ConnectionEvent connectionEvent) {
    }

    @Override
    public void connectionReOpened(ConnectionEvent connectionEvent) {
    }

    @Override
    public void connectionClosed(ConnectionEvent connectionEvent) {
    }

    @Override
    public void actionCalled(CallEvent callEvent) {
    }

    @Override
    public void objectCalled(CallEvent callEvent) {
    }

    @Override
    public void propertyChanged(PropertyEvent propertyEvent) {
    }

    @Override
    protected void afterLogout() {
        this.setTitle(this.getName());
        this.setLoginVisible(true);
        this.getLauncher().cancelPendingThreads();
        super.afterLogout();
    }

    @Override
    protected void afterLogin() {
        this.setTitle(this.getName() + " [" + this.getConnection().getUserName() + "]");
        this.setLoginVisible(false);
        this.login.setPassword(null);
        super.afterLogin();
    }

    protected void configureApplicationPane(IContainer iContainer) {
        iContainer.setLayout(new UIBorderLayout());
        iContainer.add(this.getDesktopPane());
    }

    protected UIDesktopPanel createDesktopPane() {
        return new UIDesktopPanel();
    }

    protected void configureDesktopPane(UIDesktopPanel uIDesktopPanel) {
        UIIcon uIIcon = new UIIcon();
        uIIcon.setImage(UIImage.getImage("/com/sibvisions/rad/application/images/background.png"));
        uIIcon.setHorizontalAlignment(2);
        uIIcon.setVerticalAlignment(2);
        uIDesktopPanel.add(uIIcon);
        uIDesktopPanel.setBackground(new UIColor(253, 253, 253));
    }

    public UIDesktopPanel getDesktopPane() {
        return this.dpanDesktop;
    }

    protected UIMenuBar createMenu() {
        UIMenuBar uIMenuBar = new UIMenuBar();
        this.getLauncher().setMenuBar(uIMenuBar);
        return uIMenuBar;
    }

    protected void configureMenu(UIMenuBar uIMenuBar) {
        boolean bl = this.isExitVisible();
        UIMenu uIMenu = new UIMenu();
        uIMenu.setText("File");
        this.miFileLogin = this.createMenuItem("doShowLogin", null, "Login", UIImage.getImage("LOGIN_SMALL"));
        this.miFileLogout = this.createMenuItem("doLogout", null, "Logout", UIImage.getImage("LOGOUT_SMALL"));
        this.miFileChangePwd = this.createMenuItem("doShowChangePassword", null, "Change password", UIImage.getImage("CHANGE_PASSWORD_SMALL"));
        if (bl) {
            this.miFileExit = this.createMenuItem("doExit", null, "Exit", UIImage.getImage("EXIT_SMALL"));
        }
        uIMenu.add(this.miFileLogin);
        uIMenu.add(this.miFileLogout);
        uIMenu.add(this.miFileChangePwd);
        if (bl) {
            uIMenu.addSeparator();
            uIMenu.add(this.miFileExit);
        }
        UIMenu uIMenu2 = new UIMenu();
        uIMenu2.setText("Help");
        this.miHelp = this.createMenuItem("doHelp", null, "Help contents", UIImage.getImage("HELP_SMALL"));
        this.miHelp.setAccelerator(Key.getKeyOnReleased(112));
        this.miHelpAbout = this.createMenuItem("doAbout", null, "About", UIImage.getImage("ABOUT_SMALL"));
        uIMenu2.add(this.miHelp);
        uIMenu2.addSeparator();
        uIMenu2.add(this.miHelpAbout);
        uIMenuBar.removeAll();
        uIMenuBar.add((IComponent)uIMenu, -1);
        uIMenuBar.add((IComponent)uIMenu2, -1);
        this.miFileLogin.setVisible(false);
        this.miFileLogout.setVisible(false);
    }

    protected UIToolBar createToolBar() {
        UIToolBar uIToolBar = new UIToolBar();
        return uIToolBar;
    }

    protected void configureToolBar(UIToolBar uIToolBar) {
        boolean bl = this.isExitVisible();
        this.butLogin = this.createToolBarButton("doShowLogin", null, "Login", UIImage.getImage("LOGIN_LARGE"));
        this.butLogout = this.createToolBarButton("doLogout", null, "Logout", UIImage.getImage("LOGOUT_LARGE"));
        if (bl) {
            this.butExit = this.createToolBarButton("doExit", null, "Exit", UIImage.getImage("EXIT_LARGE"));
        }
        uIToolBar.removeAll();
        if (bl) {
            uIToolBar.add(this.butExit);
        }
        uIToolBar.add(this.butLogin);
        uIToolBar.add(this.butLogout);
        this.getLauncher().removeAllToolBars();
        this.getLauncher().addToolBar(uIToolBar);
        this.butLogin.setVisible(false);
        this.butLogout.setVisible(false);
    }

    protected Login createLogin() {
        return new Login(this.getDesktopPane(), this);
    }

    protected About createAbout() {
        return new About(this.getDesktopPane());
    }

    protected void configureLogin(Login login) {
        this.configureFrame(login);
        login.setInfoImage(UIImage.getImage("/com/sibvisions/rad/application/images/login.png"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void logout() {
        block5: {
            this.configureMenu(this.menu);
            this.configureToolBar(this.toolbar);
            AbstractConnection abstractConnection = this.getConnection();
            if (abstractConnection != null) {
                try {
                    try {
                        abstractConnection.removeConnectionListener(this);
                        abstractConnection.close();
                    }
                    catch (Throwable throwable) {
                        this.debug(throwable);
                        Object var4_3 = null;
                        this.setConnection(null);
                        this.iconApplication = null;
                        break block5;
                    }
                    Object var4_2 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    this.setConnection(null);
                    this.iconApplication = null;
                    throw throwable;
                }
                this.setConnection(null);
                this.iconApplication = null;
            }
        }
        this.afterLogout();
    }

    protected void setTitle(String string) {
        this.getLauncher().setTitle(string);
    }

    private void setChangePasswordVisible(boolean bl) {
        if (bl) {
            this.login.setMode(1);
            this.setLoginFrameVisible(true, false);
        } else if (this.login.isVisible()) {
            this.login.setMode(0);
            this.setLoginFrameVisible(true, false);
        }
    }

    private void setLoginVisible(boolean bl) {
        this.miFileLogin.setVisible(bl);
        this.miFileLogout.setVisible(!bl);
        this.butLogin.setVisible(bl);
        this.butLogout.setVisible(!bl);
        this.login.setMode(0);
        this.setLoginFrameVisible(bl, false);
    }

    private void setLoginFrameVisible(boolean bl, boolean bl2) {
        if (bl && this.login.getParent() == null) {
            IRectangle iRectangle = this.login.getBounds();
            this.getContentPane().add(this.login);
            this.login.setBounds(iRectangle);
        }
        if (bl) {
            this.login.pack();
            int n = this.login.getMode();
            this.login.setModal(n == 1);
            if (bl2 || !this.login.isVisible()) {
                this.login.centerRelativeTo(this.dpanDesktop);
            }
        }
        this.login.setVisible(bl);
        if (!bl) {
            this.getContentPane().remove(this.login);
        }
    }

    public void showErrorDialog() {
        this.configureFrame(this.error);
        this.error.pack();
        this.error.centerRelativeTo(this.dpanDesktop);
        this.error.setVisible(true);
    }

    protected void configureFrame(AbstractFrame abstractFrame) {
        abstractFrame.setIconImage(UIImage.getImage("/com/sibvisions/rad/application/images/frame.png"));
    }

    public UIMenuItem createMenuItem(String string, String string2, String string3, UIImage uIImage) {
        UIMenuItem uIMenuItem = new UIMenuItem();
        uIMenuItem.setText(string3);
        uIMenuItem.eventAction().addListener(this, string);
        uIMenuItem.setActionCommand(string2);
        uIMenuItem.setImage(uIImage);
        return uIMenuItem;
    }

    public UIButton createToolBarButton(String string, String string2, String string3, UIImage uIImage) {
        UIButton uIButton = new UIButton();
        uIButton.setText(string3);
        uIButton.setImage(uIImage);
        uIButton.eventAction().addListener(this, string);
        uIButton.setActionCommand(string2);
        uIButton.setMinimumSize(new UIDimension(47, 47));
        uIButton.setHorizontalTextPosition(1);
        uIButton.setVerticalTextPosition(2);
        uIButton.setVerticalAlignment(1);
        uIButton.setHorizontalAlignment(1);
        uIButton.setFont(new UIFont("Arial", 1, 11));
        uIButton.setImageTextGap(2);
        uIButton.setFocusable(false);
        uIButton.setBorderOnMouseEntered(true);
        return uIButton;
    }

    protected void configureAbout(About about) {
    }

    public UIMenuBar getMenuBar() {
        return this.menu;
    }

    public UIToolBar getToolBar() {
        return this.toolbar;
    }

    public Login getLogin() {
        return this.login;
    }

    protected Error createError() throws Throwable {
        Error error = new Error(this.getDesktopPane());
        error.setOpener(this);
        return error;
    }

    public Error getError() {
        return this.error;
    }

    public void doErrorClosed(UIWindowEvent uIWindowEvent) {
        this.error = null;
    }

    public void doLogin(UIActionEvent uIActionEvent) throws Throwable {
        try {
            this.login.setError(null);
            this.iconApplication = this.createConnection();
            MasterConnection masterConnection = new MasterConnection(this.iconApplication);
            masterConnection.addConnectionListener(this);
            masterConnection.setApplicationName(this.getApplicationName());
            masterConnection.setUserName(this.login.getUserName());
            masterConnection.setPassword(this.login.getPassword());
            masterConnection.setNewPassword(this.login.getPassword(), this.login.getNewPassword());
            masterConnection.open();
            this.setConnection(masterConnection);
            this.afterLogin();
        }
        catch (Throwable throwable) {
            this.setConnection(null);
            this.iconApplication = null;
            if (throwable instanceof ChangePasswordException) {
                IContent iContent = this.showMessage(this, 0, 6, throwable.getMessage(), "doShowChangePassword", (String)null);
                ((AbstractWindow)((Object)iContent)).centerRelativeTo(this.login);
            }
            throw throwable;
        }
    }

    public void doChangePassword(UIActionEvent uIActionEvent) throws Throwable {
        ((MasterConnection)this.getConnection()).setNewPassword(this.login.getPassword(), this.login.getNewPassword());
        IContent iContent = this.showMessage(this, 0, 6, "Password changed successful!", "doHideLogin", "doHideLogin");
        ((AbstractWindow)((Object)iContent)).centerRelativeTo(this.login);
    }

    public void doShowLogin(UIActionEvent uIActionEvent) {
        this.setLoginVisible(true);
    }

    public void doHideLogin(UIActionEvent uIActionEvent) {
        this.setLoginVisible(false);
    }

    public void doShowChangePassword(UIActionEvent uIActionEvent) {
        this.setChangePasswordVisible(true);
    }

    public void doHideChangePassword(UIActionEvent uIActionEvent) {
        this.setChangePasswordVisible(false);
    }

    public void doExit(UIActionEvent uIActionEvent) {
        try {
            this.logout();
        }
        catch (Throwable throwable) {
            this.debug(throwable);
        }
        this.getLauncher().dispose();
    }

    public void doLogout(UIActionEvent uIActionEvent) {
        this.logout();
    }

    public void doAbout(UIActionEvent uIActionEvent) throws Throwable {
        About about = this.createAbout();
        this.configureFrame(about);
        this.configureAbout(about);
        about.pack();
        about.centerRelativeTo(this.getContentPane());
        about.setVisible(true);
    }

    public void doHelp(UIActionEvent uIActionEvent) throws Throwable {
    }

    protected boolean isExitVisible() {
        String string = this.getLauncher().getParameter(PARAM_MENU_EXIT_VISIBLE);
        return string == null || Boolean.parseBoolean(string);
    }
}

