/*
 * Copyright 2009 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 *
 * 01.10.2008 - [RH] - creation
 */
package javax.rad.model.event;

import javax.rad.model.ModelException;

/**
 * The <code>IDataBookListener</code> informs about changes in the <code>IDataBook</code>.
 * 
 * @see javax.rad.model.IDataBook
 * 
 * @author Roland Hrmann
 */
public interface IDataBookListener
{
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Method definitions
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/**
	 * Notifies that the IDataBook is changed. 
	 * 
	 * @param pDataBookEvent gives information about the changed IDataBook, the type of change and the original IDataRow.
	 * @throws ModelException if a ModelException occurs.
	 */
	public void dataBookChanged(DataBookEvent pDataBookEvent) throws ModelException;	
	
} 	// IDataBookListener
