/*
 * Copyright 2009 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 *
 * 17.11.2008 - [HM] - creation
 * 10.12.2008 - [JR] - moved accelerator methods to UIButton
 * 19.10.2009 - [JR] - extends AbstractUIActionComponent instead of AbstractUIButton
 */
package javax.rad.genui.menu;

import javax.rad.genui.component.AbstractUIActionComponent;
import javax.rad.ui.menu.IMenuItem;

/**
 * Platform and technology independent MenuItem.
 * It is designed for use with AWT, Swing, SWT, JSP, JSF, ... .
 * 
 * @author Martin Handsteiner
 * 
 * @param <C> instance of IMenuItem
 */
public abstract class AbstractUIMenuItem<C extends IMenuItem> extends AbstractUIActionComponent<C> 
                                                              implements IMenuItem
{
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Initialization
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	  
    /**
     * Creates a new instance of <code>UIMenuItem</code>.
     *
     * @param pMenuItem the IMenuItem.
     * @see IMenuItem
     */
	protected AbstractUIMenuItem(C pMenuItem)
	{
		super(pMenuItem);
	}
	
}	// UIMenuItem
