/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.genui.control;

import javax.rad.genui.UIComponent;
import javax.rad.model.IDataBook;
import javax.rad.model.ModelException;
import javax.rad.model.ui.IControllable;
import javax.rad.model.ui.IController;
import javax.rad.ui.IComponent;
import javax.rad.ui.IContainer;
import javax.rad.ui.container.IInternalFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractControllable<C extends IComponent>
extends UIComponent<C>
implements IControllable {
    private IController controller = null;
    private boolean askControllableController = true;
    private IInternalFrame internalFrame = null;

    protected AbstractControllable(C c) {
        super(c);
    }

    @Override
    public IController getController() {
        return this.controller;
    }

    @Override
    public void setController(IController iController) {
        this.controller = iController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCommandEnabled(String string) {
        if (this.askControllableController && this.controller instanceof IControllable && this.controller.getActiveControllable() == this) {
            try {
                this.askControllableController = false;
                boolean bl = ((IControllable)((Object)this.controller)).isCommandEnabled(string);
                return bl;
            }
            finally {
                this.askControllableController = true;
            }
        }
        if (string == "COMMAND_FIRST") {
            return this.isFirstEnabled();
        }
        if (string == "COMMAND_LAST") {
            return this.isLastEnabled();
        }
        if (string == "COMMAND_NEXT") {
            return this.isNextEnabled();
        }
        if (string == "COMMAND_PREVIOUS") {
            return this.isPreviousEnabled();
        }
        if (string == "COMMAND_EDIT") {
            return this.isEditEnabled();
        }
        if (string == "COMMAND_INSERT") {
            return this.isInsertEnabled();
        }
        if (string == "COMMAND_INSERT_SUB") {
            return this.isInsertSubEnabled();
        }
        if (string == "COMMAND_RESTORE") {
            return this.isRestoreEnabled();
        }
        if (string == "COMMAND_DELETE") {
            return this.isDeleteEnabled();
        }
        if (string == "COMMAND_DUPLICATE") {
            return this.isDuplicateEnabled();
        }
        if (string == "COMMAND_EXPORT") {
            return this.isExportEnabled();
        }
        if (string == "COMMAND_SEARCH") {
            return this.isSearchEnabled();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doCommand(String string) throws Throwable {
        if (this.askControllableController && this.controller instanceof IControllable) {
            try {
                this.askControllableController = false;
                ((IControllable)((Object)this.controller)).doCommand(string);
            }
            finally {
                this.askControllableController = true;
            }
        } else if (string == "COMMAND_FIRST") {
            this.doFirst();
        } else if (string == "COMMAND_LAST") {
            this.doLast();
        } else if (string == "COMMAND_NEXT") {
            this.doNext();
        } else if (string == "COMMAND_PREVIOUS") {
            this.doPrevious();
        } else if (string == "COMMAND_EDIT") {
            this.doEdit();
        } else if (string == "COMMAND_INSERT") {
            this.doInsert();
        } else if (string == "COMMAND_INSERT_SUB") {
            this.doInsertSub();
        } else if (string == "COMMAND_RESTORE") {
            this.doRestore();
        } else if (string == "COMMAND_DELETE") {
            this.doDelete();
        } else if (string == "COMMAND_DUPLICATE") {
            this.doDuplicate();
        } else if (string == "COMMAND_EXPORT") {
            this.doExport();
        } else if (string == "COMMAND_SEARCH") {
            this.doSearch();
        }
    }

    @Override
    public void addNotify() {
        IContainer iContainer;
        super.addNotify();
        for (iContainer = this.getParent(); iContainer != null && !(iContainer instanceof IController); iContainer = iContainer.getParent()) {
            if (!(iContainer instanceof IInternalFrame)) continue;
            this.internalFrame = (IInternalFrame)iContainer;
        }
        this.setController((IController)((Object)iContainer));
        ((IComponent)this.uiResource).eventFocusGained().addListener(this, "doNotifyController");
        if (this.internalFrame != null) {
            this.internalFrame.eventWindowActivated().addListener(this, "doNotifyController");
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.internalFrame != null) {
            this.internalFrame.eventWindowActivated().removeListener(this);
            this.internalFrame = null;
        }
        ((IComponent)this.uiResource).eventFocusGained().removeListener(this, "doNotifyController");
        if (this.getController() != null && this.getController().getActiveControllable() == this) {
            this.getController().setActiveControllable(null);
        }
        this.setController(null);
    }

    public void doNotifyController() {
        if (!(this.controller == null || this.internalFrame != null && this.internalFrame.isModal())) {
            this.controller.setActiveControllable(this);
        }
    }

    public boolean isFirstEnabled() {
        IDataBook iDataBook = this.getActiveDataBook();
        try {
            return iDataBook != null && iDataBook.getDataRow(1) != null && iDataBook.getSelectedRow() > 0;
        }
        catch (ModelException modelException) {
            return false;
        }
    }

    public void doFirst() throws ModelException {
        IDataBook iDataBook = this.getActiveDataBook();
        if (iDataBook != null) {
            this.requestFocus();
            iDataBook.setSelectedRow(0);
        }
    }

    public boolean isLastEnabled() {
        IDataBook iDataBook = this.getActiveDataBook();
        try {
            return iDataBook != null && iDataBook.getDataRow(1) != null && (!iDataBook.isAllFetched() || iDataBook.getSelectedRow() < iDataBook.getRowCount() - 1);
        }
        catch (ModelException modelException) {
            return false;
        }
    }

    public void doLast() throws ModelException {
        IDataBook iDataBook = this.getActiveDataBook();
        if (iDataBook != null) {
            this.requestFocus();
            iDataBook.fetchAll();
            iDataBook.setSelectedRow(iDataBook.getRowCount() - 1);
        }
    }

    public boolean isPreviousEnabled() {
        IDataBook iDataBook = this.getActiveDataBook();
        try {
            return iDataBook != null && iDataBook.getDataRow(1) != null && iDataBook.getSelectedRow() > 0;
        }
        catch (ModelException modelException) {
            return false;
        }
    }

    public void doPrevious() throws ModelException {
        IDataBook iDataBook = this.getActiveDataBook();
        if (iDataBook != null) {
            this.requestFocus();
            iDataBook.setSelectedRow(iDataBook.getSelectedRow() - 1);
        }
    }

    public boolean isNextEnabled() {
        IDataBook iDataBook = this.getActiveDataBook();
        try {
            return iDataBook != null && iDataBook.getDataRow(iDataBook.getSelectedRow() + 1) != null;
        }
        catch (ModelException modelException) {
            return false;
        }
    }

    public void doNext() throws ModelException {
        IDataBook iDataBook = this.getActiveDataBook();
        if (iDataBook != null) {
            this.requestFocus();
            iDataBook.fetchAll();
            iDataBook.setSelectedRow(iDataBook.getSelectedRow() + 1);
        }
    }

    public boolean isInsertEnabled() {
        IDataBook iDataBook = this.getActiveDataBook();
        try {
            return iDataBook != null && iDataBook.isInsertAllowed();
        }
        catch (ModelException modelException) {
            return false;
        }
    }

    public void doInsert() throws ModelException {
        IDataBook iDataBook = this.getActiveDataBook();
        if (iDataBook != null) {
            this.requestFocus();
            iDataBook.insert(false);
        }
    }

    public boolean isInsertSubEnabled() {
        return false;
    }

    public void doInsertSub() throws ModelException {
    }

    public boolean isDeleteEnabled() {
        IDataBook iDataBook = this.getActiveDataBook();
        try {
            return iDataBook != null && iDataBook.isDeleteAllowed() && !iDataBook.isDeleting();
        }
        catch (ModelException modelException) {
            return false;
        }
    }

    public void doDelete() throws ModelException {
        IDataBook iDataBook = this.getActiveDataBook();
        if (iDataBook != null) {
            this.requestFocus();
            iDataBook.delete();
        }
    }

    public boolean isRestoreEnabled() {
        IDataBook iDataBook = this.getActiveDataBook();
        try {
            return iDataBook != null && (iDataBook.isInserting() || iDataBook.isDeleting() || iDataBook.isUpdating());
        }
        catch (ModelException modelException) {
            return false;
        }
    }

    public void doRestore() throws ModelException {
        IDataBook iDataBook = this.getActiveDataBook();
        if (iDataBook != null) {
            this.requestFocus();
            iDataBook.restoreSelectedRow();
        }
    }

    public boolean isDuplicateEnabled() {
        IDataBook iDataBook = this.getActiveDataBook();
        try {
            return iDataBook != null && iDataBook.isInsertAllowed() && iDataBook.getSelectedRow() >= 0;
        }
        catch (ModelException modelException) {
            return false;
        }
    }

    public void doDuplicate() throws ModelException {
    }

    public boolean isExportEnabled() {
        IDataBook iDataBook = this.getActiveDataBook();
        return iDataBook != null;
    }

    public void doExport() throws Throwable {
    }

    public boolean isEditEnabled() {
        IDataBook iDataBook = this.getActiveDataBook();
        try {
            return iDataBook != null && iDataBook.getSelectedRow() >= 0 && !iDataBook.isReadonly();
        }
        catch (ModelException modelException) {
            return false;
        }
    }

    public void doEdit() throws ModelException {
    }

    public boolean isSearchEnabled() {
        IDataBook iDataBook = this.getActiveDataBook();
        return iDataBook != null;
    }

    public void doSearch() throws ModelException {
    }
}

