/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.genui;

import java.util.ArrayList;
import java.util.List;
import javax.rad.genui.UIComponent;
import javax.rad.genui.UILayout;
import javax.rad.genui.UIResource;
import javax.rad.genui.container.UITabsetPanel;
import javax.rad.ui.IComponent;
import javax.rad.ui.IContainer;
import javax.rad.ui.IImage;
import javax.rad.ui.ILayout;
import javax.rad.ui.container.IToolBar;
import javax.rad.ui.menu.IMenuBar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UIContainer<C extends IContainer>
extends UIComponent<C>
implements IContainer {
    private ILayout uiLayout = null;
    protected List<IComponent> components = new ArrayList<IComponent>(4);
    private boolean bAddNotify = false;

    protected UIContainer(C c) {
        super(c);
    }

    @Override
    public ILayout getLayout() {
        return this.uiLayout;
    }

    @Override
    public void setLayout(ILayout iLayout) {
        if (iLayout instanceof UILayout) {
            ((IContainer)this.uiResource).setLayout((ILayout)((UILayout)iLayout).uiResource);
        } else {
            ((IContainer)this.uiResource).setLayout(iLayout);
        }
        this.uiLayout = iLayout;
    }

    @Override
    public void add(IComponent iComponent) {
        this.add(iComponent, null, -1);
    }

    @Override
    public void add(IComponent iComponent, Object object) {
        this.add(iComponent, object, -1);
    }

    @Override
    public void add(IComponent iComponent, int n) {
        this.add(iComponent, null, n);
    }

    @Override
    public void add(IComponent iComponent, Object object, int n) {
        this.checkAdd(iComponent, object, n);
        if (iComponent.getParent() != null) {
            iComponent.getParent().remove(iComponent);
        }
        IComponent iComponent2 = iComponent instanceof UIComponent ? ((UIComponent)iComponent).getComponentUIResource() : iComponent;
        Object object2 = object instanceof UIResource ? ((UIResource)object).getUIResource() : object;
        if (iComponent instanceof UIComponent && this.isNotified() && !((UIComponent)iComponent).isBeforeNotified()) {
            ((UIComponent)iComponent).beforeAddNotify(this);
        }
        if (n < 0) {
            this.components.add(iComponent);
        } else {
            this.components.add(n, iComponent);
        }
        IContainer iContainer = null;
        if (iComponent instanceof UIComponent) {
            iContainer = iComponent.getParent();
            iComponent.setParent(this);
        }
        try {
            ((IContainer)this.uiResource).add(iComponent2, object2, n);
        }
        catch (RuntimeException runtimeException) {
            this.components.remove(iComponent);
            if (iComponent instanceof UIComponent) {
                iComponent.setParent(iContainer);
            }
            throw runtimeException;
        }
        catch (Error error) {
            this.components.remove(iComponent);
            if (iComponent instanceof UIComponent) {
                iComponent.setParent(iContainer);
            }
            throw error;
        }
        if (iComponent instanceof UIComponent && this.isNotified() && !((UIComponent)iComponent).isNotified()) {
            ((UIComponent)iComponent).addNotify();
        }
    }

    @Override
    public void remove(int n) {
        IComponent iComponent;
        IComponent iComponent2 = this.components.get(n);
        if (iComponent2 instanceof UIComponent) {
            ((IContainer)this.uiResource).remove(((UIComponent)iComponent2).getComponentUIResource());
            if (((UIComponent)iComponent2).isNotified()) {
                ((UIComponent)iComponent2).removeNotify();
            }
        } else {
            ((IContainer)this.uiResource).remove(iComponent2);
        }
        if ((iComponent = this.components.remove(n)) instanceof UIComponent) {
            iComponent.setParent(null);
        }
    }

    @Override
    public void remove(IComponent iComponent) {
        if (iComponent.getParent() == this) {
            this.remove(this.components.indexOf(iComponent));
        }
    }

    @Override
    public void removeAll() {
        while (this.components.size() > 0) {
            this.remove(this.components.size() - 1);
        }
    }

    @Override
    public int getComponentCount() {
        return this.components.size();
    }

    @Override
    public IComponent getComponent(int n) {
        return this.components.get(n);
    }

    @Override
    public int indexOf(IComponent iComponent) {
        return this.components.indexOf(iComponent);
    }

    @Override
    public void updateTranslation() {
        super.updateTranslation();
        if (this.bAddNotify) {
            return;
        }
        int n = this.components.size();
        for (int i = 0; i < n; ++i) {
            IComponent iComponent = this.components.get(i);
            if (!(iComponent instanceof UIComponent)) continue;
            ((UIComponent)iComponent).updateTranslation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeAddNotify(IComponent iComponent) {
        if (this.bAddNotify) {
            return;
        }
        this.bAddNotify = true;
        try {
            super.beforeAddNotify(iComponent);
        }
        finally {
            this.bAddNotify = false;
        }
        int n = this.components.size();
        for (int i = 0; i < n; ++i) {
            IComponent iComponent2 = this.components.get(i);
            if (!(iComponent2 instanceof UIComponent) || ((UIComponent)iComponent2).isBeforeNotified()) continue;
            ((UIComponent)iComponent2).beforeAddNotify(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotify() {
        if (this.bAddNotify) {
            return;
        }
        this.bAddNotify = true;
        try {
            super.addNotify();
        }
        finally {
            this.bAddNotify = false;
        }
        int n = this.components.size();
        for (int i = 0; i < n; ++i) {
            IComponent iComponent = this.components.get(i);
            if (!(iComponent instanceof UIComponent) || ((UIComponent)iComponent).isNotified()) continue;
            ((UIComponent)iComponent).addNotify();
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        int n = this.components.size();
        for (int i = 0; i < n; ++i) {
            IComponent iComponent = this.components.get(i);
            if (!(iComponent instanceof UIComponent) || !((UIComponent)iComponent).isNotified()) continue;
            ((UIComponent)iComponent).removeNotify();
        }
    }

    protected void checkAdd(IComponent iComponent, Object object, int n) {
        if (!(this instanceof IToolBar) && iComponent instanceof IToolBar) {
            throw new IllegalArgumentException("It's not supported to 'add' an IToolBar. Use 'addToolBar'!");
        }
        if (iComponent instanceof IMenuBar) {
            throw new IllegalArgumentException("It's not supported to 'add' an IMenuBar. Use 'setMenuBar'!");
        }
    }

    public void setZOrder(IComponent iComponent, int n) {
        int n2 = this.indexOf(iComponent);
        if (n2 >= 0) {
            String string = null;
            IImage iImage = null;
            if (this.getLayout() != null) {
                string = (String)this.getLayout().getConstraints(iComponent);
            } else if (this instanceof UITabsetPanel) {
                string = ((UITabsetPanel)this).getTextAt(n2);
                iImage = ((UITabsetPanel)this).getIconAt(n2);
            }
            if (iComponent instanceof UIComponent) {
                ((IContainer)this.uiResource).remove(((UIComponent)iComponent).getComponentUIResource());
            } else {
                ((IContainer)this.uiResource).remove(iComponent);
            }
            this.components.remove(n2);
            if (n > this.components.size()) {
                n = this.components.size();
            }
            this.components.add(n, iComponent);
            if (iComponent instanceof UIComponent) {
                iComponent = ((UIComponent)iComponent).getComponentUIResource();
            }
            if (string instanceof UIResource) {
                string = ((UIResource)((Object)string)).getUIResource();
            }
            ((IContainer)this.uiResource).add(iComponent, string, n);
            if (iImage != null) {
                ((UITabsetPanel)this).setIconAt(n2, iImage);
            }
        }
    }
}

