/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util.type;

import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.type.IResourceArchive;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourceUtil {
    private static ClassLoader clDefault = null;
    private static List<IResourceArchive> liResourceArchive = null;

    private ResourceUtil() {
    }

    public static void addResourceArchive(IResourceArchive iResourceArchive) {
        ResourceUtil.addResourceArchive(-1, iResourceArchive);
    }

    public static void addResourceArchive(int n, IResourceArchive iResourceArchive) {
        if (iResourceArchive != null) {
            if (liResourceArchive == null) {
                liResourceArchive = new ArrayUtil<IResourceArchive>();
            }
            if (n == -1) {
                liResourceArchive.add(liResourceArchive.size(), iResourceArchive);
            } else {
                liResourceArchive.add(n, iResourceArchive);
            }
        }
    }

    public static void removeResourceArchive(IResourceArchive iResourceArchive) {
        if (iResourceArchive != null && liResourceArchive != null) {
            liResourceArchive.remove(iResourceArchive);
            if (liResourceArchive.size() == 0) {
                liResourceArchive = null;
            }
        }
    }

    public static void removeAllResourceArchives() {
        if (liResourceArchive != null) {
            liResourceArchive.clear();
            liResourceArchive = null;
        }
    }

    public static List<IResourceArchive> getResourceArchives() {
        return liResourceArchive;
    }

    public static InputStream getResourceAsStream(String string) {
        return ResourceUtil.getResourceAsStream(clDefault, string);
    }

    public static URL getResource(String string) {
        return ResourceUtil.getResource(clDefault, string);
    }

    public static InputStream getResourceAsStream(ClassLoader classLoader, String string) {
        Object object;
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        try {
            File file;
            object = new File(string);
            if (((File)object).exists()) {
                try {
                    return new FileInputStream((File)object);
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            String string2 = ResourceUtil.getLocationForClass(classLoader, ResourceUtil.getFqClassName(ResourceUtil.class));
            if (string2 != null && string2.toLowerCase().endsWith(".jar") && (file = new File(new File(string2).getParentFile(), ((File)object).getName())).exists()) {
                try {
                    return new FileInputStream(file);
                }
                catch (IOException iOException) {
                    return null;
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (liResourceArchive != null) {
            object = null;
            int n = liResourceArchive.size();
            for (int i = 0; i < n && object == null; ++i) {
                object = liResourceArchive.get(i).getInputStream(string);
            }
            if (object != null) {
                return object;
            }
        }
        return ResourceUtil.getPrivilegedResourceAsStream(classLoader, string);
    }

    public static URL getResource(ClassLoader classLoader, String string) {
        Serializable serializable;
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        try {
            File file;
            serializable = new File(string);
            if (((File)serializable).exists()) {
                try {
                    return ((File)serializable).toURI().toURL();
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            String string2 = ResourceUtil.getLocationForClass(ResourceUtil.getFqClassName(ResourceUtil.class));
            if (string2 != null && string2.toLowerCase().endsWith(".jar") && (file = new File(new File(string2).getParentFile(), ((File)serializable).getName())).exists()) {
                try {
                    return file.toURI().toURL();
                }
                catch (IOException iOException) {
                    return null;
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (liResourceArchive != null) {
            serializable = null;
            int n = liResourceArchive.size();
            for (int i = 0; i < n && serializable == null; ++i) {
                serializable = liResourceArchive.get(i).getURL(string);
            }
            if (serializable != null) {
                return serializable;
            }
        }
        return ResourceUtil.getPrivilegedResource(classLoader, string);
    }

    private static InputStream getPrivilegedResourceAsStream(ClassLoader classLoader, String string) {
        final URL uRL = ResourceUtil.getPrivilegedResource(classLoader, string);
        if (uRL != null) {
            try {
                return uRL.openStream();
            }
            catch (SecurityException securityException) {
                return (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            return uRL.openStream();
                        }
                        catch (IOException iOException) {
                            return null;
                        }
                    }
                });
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return null;
    }

    private static URL getPrivilegedResource(ClassLoader classLoader, String string) {
        String string2;
        String string3;
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        if (string.charAt(0) != '/') {
            string3 = "/" + string;
            string2 = string;
        } else {
            string3 = string;
            string2 = string.substring(1);
        }
        URL uRL = classLoader == null ? ResourceUtil.class.getResource(string3) : classLoader.getResource(string2);
        if (uRL == null) {
            uRL = (URL)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ClassLoader classLoader = null;
                    try {
                        classLoader = Thread.currentThread().getContextClassLoader();
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                    if (classLoader != null) {
                        return classLoader.getResource(string2);
                    }
                    return ClassLoader.getSystemResource(string2);
                }
            });
        }
        if (uRL == null && clDefault != null) {
            uRL = clDefault.getResource(string2);
        }
        return uRL;
    }

    public static String getPathForClass(String string) {
        String string2 = ResourceUtil.getLocationForClass(string);
        if (string2 != null) {
            File file = new File(string2);
            if (!file.isDirectory()) {
                return file.getParentFile().getAbsolutePath();
            }
            return file.getAbsolutePath();
        }
        return null;
    }

    public static String getLocationForClass(String string) {
        return ResourceUtil.getLocationForClass(clDefault, string);
    }

    public static String getLocationForClass(ClassLoader classLoader, String string) {
        int n;
        URL uRL = ResourceUtil.getPrivilegedResource(classLoader, string);
        if (uRL == null) {
            return null;
        }
        String string2 = uRL.getFile();
        if (string2.toUpperCase().startsWith("FILE:")) {
            string2 = string2.substring(5);
        }
        if ((string2 = (n = (string2 = string2.replace("%20", " ")).indexOf("!")) >= 0 ? string2.substring(0, n) : string2.substring(0, string2.indexOf(string))) != null && !string2.toLowerCase().startsWith("http")) {
            return new File(string2).getAbsolutePath();
        }
        return string2;
    }

    public static File getFileForClass(String string) {
        return ResourceUtil.getFileForClass(clDefault, string);
    }

    public static File getFileForClass(ClassLoader classLoader, String string) {
        int n;
        URL uRL = ResourceUtil.getPrivilegedResource(classLoader, string);
        if (uRL == null) {
            return null;
        }
        String string2 = uRL.getFile();
        if (string2.toUpperCase().startsWith("FILE:")) {
            string2 = string2.substring(5);
        }
        if ((n = (string2 = string2.replace("%20", " ")).indexOf("!")) >= 0) {
            string2 = string2.substring(0, string2.indexOf("!"));
        }
        if (string2 != null && !string2.toLowerCase().startsWith("http")) {
            return new File(string2);
        }
        return null;
    }

    public static String getFqClassName(Object object) {
        String string;
        if (object instanceof Class) {
            string = ResourceUtil.getName((Class)object);
        } else if (object != null) {
            String string2;
            string = object instanceof String ? ((string2 = (String)object).indexOf(".") >= 0 || string2.indexOf("/") >= 0 ? (String)object : ResourceUtil.getName(object.getClass())) : ResourceUtil.getName(object.getClass());
        } else {
            return null;
        }
        string = string.replace('.', '/');
        string = "/" + string + ".class";
        return string;
    }

    public static String getName(Class<?> clazz) {
        if (clazz != null) {
            String string = clazz.getName();
            int n = string.indexOf("$");
            if (n > 0) {
                return string.substring(0, n);
            }
            return string;
        }
        return null;
    }

    public static String getAccessibleProperty(String string, String string2) {
        try {
            String string3 = System.getProperty(string);
            if (string3 == null) {
                return string2;
            }
            return string3;
        }
        catch (SecurityException securityException) {
            return string2;
        }
    }

    public static boolean getAccessibleBoolean(String string, boolean bl) {
        try {
            String string2 = System.getProperty(string);
            if (string2 == null) {
                return bl;
            }
            return Boolean.valueOf(string2);
        }
        catch (SecurityException securityException) {
            return bl;
        }
    }

    public static String getPackage(Class<?> clazz) {
        if (clazz.getPackage() != null) {
            return clazz.getPackage().getName();
        }
        String string = clazz.getName();
        return string.substring(0, string.length() - clazz.getSimpleName().length() - 1);
    }

    public static void setDefaultClassLoader(ClassLoader classLoader) {
        clDefault = classLoader;
    }

    public static ClassLoader getResourceClassLoader(Object object) {
        if (clDefault == null) {
            if (object != null) {
                return object.getClass().getClassLoader();
            }
            return ResourceUtil.class.getClassLoader();
        }
        return clDefault;
    }

    public static Class<?>[] getInterfaces(Class<?> clazz, boolean bl, Class<?> ... classArray) {
        ArrayUtil arrayUtil = new ArrayUtil();
        ResourceUtil.getInterfaces(arrayUtil, clazz, bl, classArray);
        return arrayUtil.toArray(new Class[arrayUtil.size()]);
    }

    public static void getInterfaces(List<Class<?>> list, Class<?> clazz, boolean bl, Class<?> ... classArray) {
        for (Class<?> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            Class<?>[] classArray2;
            for (Class<?> clazz3 : classArray2 = clazz2.getInterfaces()) {
                boolean bl2 = classArray == null || classArray.length == 0;
                for (int i = 0; !bl2 && i < classArray.length; ++i) {
                    if (!classArray[i].isAssignableFrom(clazz3)) continue;
                    bl2 = true;
                }
                if (!bl2 || list.contains(clazz3)) continue;
                list.add(clazz3);
                if (!bl) continue;
                ResourceUtil.getInterfaces(list, clazz3, bl, new Class[0]);
            }
        }
    }
}

