/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util.type;

import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.FileSearch;
import com.sibvisions.util.type.DateUtil;
import com.sibvisions.util.type.StringUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Calendar;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileUtil {
    private FileUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(InputStream inputStream, File file) throws IOException {
        long l;
        block6: {
            BufferedOutputStream bufferedOutputStream = null;
            try {
                int n;
                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                long l2 = 0L;
                byte[] byArray = new byte[4096];
                while ((n = inputStream.read(byArray)) >= 0) {
                    bufferedOutputStream.write(byArray, 0, n);
                    l2 += (long)n;
                }
                bufferedOutputStream.flush();
                l = l2;
                Object var10_7 = null;
                if (bufferedOutputStream == null) break block6;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var10_8 = null;
                    if (bufferedOutputStream == null) break block7;
                    try {
                        bufferedOutputStream.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            try {
                bufferedOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return l;
    }

    public static long copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        return FileUtil.copy(inputStream, false, outputStream, false);
    }

    public static long copy(InputStream inputStream, boolean bl, OutputStream outputStream, boolean bl2) throws IOException {
        int n;
        long l = 0L;
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        outputStream.flush();
        if (bl) {
            inputStream.close();
        }
        if (bl2) {
            outputStream.close();
        }
        return l;
    }

    public static void copy(File file, File file2, String ... stringArray) throws IOException {
        FileUtil.copy(file, file2, CopyMode.Overwrite, stringArray);
    }

    public static void copy(File file, File file2, CopyMode copyMode, String ... stringArray) throws IOException {
        if (file.isFile()) {
            FileUtil.copyFile(file, file2, copyMode);
        } else if (file.isDirectory()) {
            FileUtil.copyDirectory(file, file2, copyMode, stringArray);
        } else {
            throw new IOException("File or directory is required: '" + file.getAbsolutePath() + "'!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File file, File file2, CopyMode copyMode) throws IOException {
        IOException iOException3;
        AbstractInterruptibleChannel abstractInterruptibleChannel;
        Object object;
        Object object2;
        block29: {
            Object object3;
            if (file2.exists()) {
                if (copyMode == CopyMode.Keep) {
                    return;
                }
                if (copyMode == CopyMode.Backup) {
                    object2 = DateUtil.format(Calendar.getInstance().getTime(), "dd_MM_yyyy_HH_mm_ss");
                    object = FileUtil.getExtension(file2.getName());
                    object3 = new File(file2.getParent(), FileUtil.removeExtension(file2.getName()) + "_" + (String)object2 + (object != null ? "." + (String)object : ""));
                    if (!file2.renameTo((File)object3)) {
                        throw new IOException("Can't rename file '" + file2.getAbsolutePath() + "' to '" + ((File)object3).getAbsolutePath() + "'!");
                    }
                }
            }
            object2 = null;
            object = null;
            object3 = null;
            abstractInterruptibleChannel = null;
            try {
                if (!file2.exists()) {
                    File file3 = file2.getParentFile();
                    if (file3 != null) {
                        file3.mkdirs();
                    }
                } else if (file2.isDirectory()) {
                    file2 = new File(file2, file.getName());
                }
                object2 = new FileInputStream(file);
                object = new FileOutputStream(file2);
                object3 = ((FileInputStream)object2).getChannel();
                abstractInterruptibleChannel = ((FileOutputStream)object).getChannel();
                long l = ((FileChannel)object3).size();
                ((FileChannel)object3).transferTo(0L, l, (WritableByteChannel)((Object)abstractInterruptibleChannel));
                Object var10_9 = null;
                if (object3 == null) break block29;
            }
            catch (Throwable throwable) {
                IOException iOException22;
                Object var10_10 = null;
                if (object3 != null) {
                    try {
                        ((AbstractInterruptibleChannel)object3).close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                if (object2 != null) {
                    try {
                        ((FileInputStream)object2).close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                if (abstractInterruptibleChannel != null) {
                    try {
                        abstractInterruptibleChannel.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                if (object != null) {
                    try {
                        ((FileOutputStream)object).close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                ((AbstractInterruptibleChannel)object3).close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (object2 != null) {
            try {
                ((FileInputStream)object2).close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (abstractInterruptibleChannel != null) {
            try {
                abstractInterruptibleChannel.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (object != null) {
            try {
                ((FileOutputStream)object).close();
            }
            catch (IOException iOException3) {}
        }
    }

    private static void copyDirectory(File file, File file2, CopyMode copyMode, String ... stringArray) throws IOException {
        File file3;
        FileSearch fileSearch = new FileSearch();
        fileSearch.search(file, true, stringArray);
        int n = file.getAbsolutePath().length();
        for (Map.Entry<String, List<String>> object : fileSearch.getFilesPerDirectory().entrySet()) {
            File file4 = new File(object.getKey());
            file3 = new File(file2, object.getKey().substring(n));
            if (!file3.exists() && !file3.mkdirs()) {
                throw new IOException("Can't create directory '" + file3.getAbsolutePath() + "'!");
            }
            for (String string : object.getValue()) {
                FileUtil.copyFile(new File(file4, string), new File(file3, string), copyMode);
            }
        }
        if (file.exists() && fileSearch.getFoundFiles().isEmpty() && fileSearch.getFoundDirectories().isEmpty()) {
            file2.mkdirs();
        }
        for (String string : fileSearch.getFoundDirectories()) {
            file3 = new File(file2, string.substring(n));
            if (file3.exists()) continue;
            file3.mkdirs();
        }
    }

    public static void move(File file, File file2) throws IOException {
        FileUtil.move(file, file2, CopyMode.Overwrite);
    }

    public static void move(File file, File file2, CopyMode copyMode) throws IOException {
        if (file.equals(file2)) {
            return;
        }
        if (file.isFile()) {
            FileUtil.moveFile(file, file2, copyMode);
        } else if (file.isDirectory()) {
            FileUtil.moveDirectory(file, file2, copyMode);
        } else {
            throw new IOException("File or directory is required: '" + file.getAbsolutePath() + "'!");
        }
    }

    private static void moveFile(File file, File file2, CopyMode copyMode) throws IOException {
        if (file2.isDirectory()) {
            file2 = new File(file2, file.getName());
        }
        if (file2.exists()) {
            if (file2.isDirectory()) {
                throw new IOException("Can't move '" + file.getAbsolutePath() + "' to directory '" + file2.getAbsolutePath() + "'!");
            }
            if (copyMode == null || copyMode == CopyMode.Overwrite) {
                if (!file2.delete()) {
                    throw new IOException("Can't overwrite '" + file2.getAbsolutePath() + "'!");
                }
            } else {
                if (copyMode == CopyMode.Keep) {
                    return;
                }
                String string = DateUtil.format(Calendar.getInstance().getTime(), "dd_MM_yyyy_HH_mm_ss");
                String string2 = FileUtil.getExtension(file2.getName());
                File file3 = new File(file2.getParent(), FileUtil.removeExtension(file2.getName()) + "_" + string + (string2 != null ? "." + string2 : ""));
                if (!file2.renameTo(file3)) {
                    throw new IOException("Can't rename file '" + file2.getAbsolutePath() + "' to '" + file3.getAbsolutePath() + "'!");
                }
            }
        } else {
            File file4 = file2.getParentFile();
            if (file4 != null) {
                file4.mkdirs();
            }
        }
        if (!file.renameTo(file2)) {
            throw new IOException("Can't move '" + file.getAbsolutePath() + "' to '" + file2.getAbsolutePath() + "'!");
        }
    }

    private static void moveDirectory(File file, File file2, CopyMode copyMode) throws IOException {
        if (file2.exists()) {
            if (file2.isFile()) {
                throw new IOException("Can't move '" + file.getAbsolutePath() + "' to file '" + file2.getAbsolutePath() + "'!");
            }
            if (copyMode == null || copyMode == CopyMode.Overwrite || copyMode == CopyMode.Keep) {
                FileUtil.copyDirectory(file, file2, copyMode, new String[0]);
                FileUtil.delete(file, new String[0]);
                return;
            }
            String string = DateUtil.format(Calendar.getInstance().getTime(), "dd_MM_yyyy_HH_mm_ss");
            File file3 = new File(file2.getAbsolutePath() + "_" + string);
            if (!file2.renameTo(file3)) {
                throw new IOException("Can't rename file '" + file2.getAbsolutePath() + "' to '" + file3.getAbsolutePath() + "'!");
            }
        } else {
            file2.getParentFile().mkdirs();
        }
        if (!file.renameTo(file2)) {
            if (!file2.mkdirs()) {
                throw new IOException("Can't move '" + file.getAbsolutePath() + "' to '" + file2.getAbsolutePath() + "' because create target directory failed!");
            }
            FileUtil.copyDirectory(file, file2, CopyMode.Overwrite, new String[0]);
            if (file.exists() && !file.delete()) {
                file.deleteOnExit();
            }
        }
    }

    public static byte[] getContent(InputStream inputStream) {
        return FileUtil.getContent(inputStream, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static byte[] getContent(InputStream inputStream, boolean bl) {
        if (inputStream != null) {
            byte[] byArray;
            BufferedInputStream bufferedInputStream;
            block11: {
                int n;
                bufferedInputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray2 = new byte[8192];
                while ((n = bufferedInputStream.read(byArray2)) >= 0) {
                    byteArrayOutputStream.write(byArray2, 0, n);
                }
                byteArrayOutputStream.close();
                byArray = byteArrayOutputStream.toByteArray();
                Object var9_8 = null;
                if (!bl) break block11;
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return byArray;
            catch (IOException iOException) {
                byte[] byArray3;
                block12: {
                    try {
                        byArray3 = null;
                        Object var9_9 = null;
                        if (!bl) break block12;
                    }
                    catch (Throwable throwable) {
                        Object var9_10 = null;
                        if (bl) {
                            try {
                                bufferedInputStream.close();
                            }
                            catch (IOException iOException2) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    try {
                        bufferedInputStream.close();
                    }
                    catch (IOException iOException3) {
                        // empty catch block
                    }
                }
                return byArray3;
            }
        }
        return null;
    }

    public static byte[] getContent(File file) throws IOException {
        if (file == null) {
            throw new IOException("File not found: null");
        }
        return FileUtil.getContent(file.getAbsolutePath());
    }

    public static byte[] getContent(String string) throws IOException {
        if (string == null) {
            throw new IOException("File not found: null");
        }
        return FileUtil.getContent(new FileInputStream(string), true);
    }

    public static byte[] getContent(InputStreamReader inputStreamReader) {
        return FileUtil.getContent(inputStreamReader, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static byte[] getContent(InputStreamReader inputStreamReader, boolean bl) {
        if (inputStreamReader != null) {
            byte[] byArray;
            block13: {
                int n;
                OutputStreamWriter outputStreamWriter;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, inputStreamReader.getEncoding());
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                    return null;
                }
                char[] cArray = new char[8192];
                while ((n = inputStreamReader.read(cArray)) >= 0) {
                    outputStreamWriter.write(cArray, 0, n);
                }
                outputStreamWriter.flush();
                outputStreamWriter.close();
                byteArrayOutputStream.close();
                byArray = byteArrayOutputStream.toByteArray();
                Object var9_9 = null;
                if (!bl) break block13;
                try {
                    inputStreamReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return byArray;
            catch (IOException iOException) {
                byte[] byArray2;
                block14: {
                    try {
                        byArray2 = null;
                        Object var9_10 = null;
                        if (!bl) break block14;
                    }
                    catch (Throwable throwable) {
                        Object var9_11 = null;
                        if (bl) {
                            try {
                                inputStreamReader.close();
                            }
                            catch (IOException iOException2) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    try {
                        inputStreamReader.close();
                    }
                    catch (IOException iOException3) {
                        // empty catch block
                    }
                }
                return byArray2;
            }
        }
        return null;
    }

    public static String removeExtension(String string) {
        int n;
        if (string != null && (n = string.lastIndexOf(46)) > 0) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String getExtension(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return null;
    }

    public static File getNotExistingFile(File file) {
        return FileUtil.getNotExistingFile(file, "[", "]");
    }

    public static File getNotExistingFile(File file, String string, String string2) {
        String string3 = FileUtil.getExtension(file.getName());
        String string4 = FileUtil.removeExtension(file.getName());
        int n = 1;
        while (file.exists()) {
            file = new File(file.getParent(), string4 + string + n + string2 + "." + string3);
            ++n;
        }
        return file;
    }

    public static String getName(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(47);
        if (n < 0) {
            n = string.lastIndexOf(92);
        }
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    public static String getDirectory(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(47);
        if (n < 0) {
            n = string.lastIndexOf(92);
        }
        if (n > 0) {
            return string.substring(0, n);
        }
        return null;
    }

    public static String formatAsDirectory(String string) {
        if (string == null) {
            return null;
        }
        char c = string.charAt(string.length() - 1);
        if (c == '\\' || c == '/') {
            return string;
        }
        return string + "/";
    }

    public static boolean deleteSub(File file, String ... stringArray) {
        FileSearch fileSearch = new FileSearch();
        fileSearch.search(file, true, stringArray);
        for (String string : fileSearch.getFoundFiles()) {
            if (new File(string).delete()) continue;
            return false;
        }
        List<String> list = fileSearch.getFoundDirectories();
        for (int i = list.size() - 1; i >= 0; --i) {
            if (new File((String)list.get(i)).delete()) continue;
            return false;
        }
        return true;
    }

    public static boolean delete(File file, String ... stringArray) {
        if (FileUtil.deleteSub(file, stringArray)) {
            return stringArray != null && stringArray.length != 0 || !file.exists() || file.delete();
        }
        return false;
    }

    public static boolean deleteEmpty(File file, String ... stringArray) {
        FileSearch fileSearch = new FileSearch();
        fileSearch.search(file, true, stringArray);
        List<String> list = fileSearch.getFoundDirectories();
        for (int i = list.size() - 1; i >= 0; --i) {
            File file2 = new File(list.get(i));
            String[] stringArray2 = file2.list();
            if (stringArray2 == null || stringArray2.length != 0 || file2.delete()) continue;
            return false;
        }
        return true;
    }

    public static boolean deleteIfEmpty(File ... fileArray) {
        for (File file : fileArray) {
            String[] stringArray = file.list();
            if (stringArray == null || stringArray.length != 0 || file.delete()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void zip(OutputStream outputStream, int n, String[] stringArray, String ... stringArray2) throws IOException {
        Object object;
        int n2;
        if (stringArray == null) return;
        if (stringArray.length == 0) {
            return;
        }
        ArrayUtil<String> arrayUtil = new ArrayUtil<String>();
        Object object2 = stringArray;
        int n3 = ((String[])object2).length;
        for (n2 = 0; n2 < n3; ++n2) {
            object = object2[n2];
            if (((String)(object = ((String)object).replace("\\", "/"))).endsWith("/")) {
                object = ((String)object).substring(0, ((String)object).length() - 1);
            }
            arrayUtil.add((String)object);
        }
        Collections.sort(arrayUtil);
        for (n3 = arrayUtil.size() - 1; n3 >= 0; --n3) {
            object2 = (String)arrayUtil.get(n3);
            for (n2 = n3 - 1; n2 >= 0; --n2) {
                if (!((String)object2).startsWith((String)arrayUtil.get(n2))) continue;
                arrayUtil.remove(n3);
                n2 = -1;
            }
        }
        FileInputStream fileInputStream = null;
        ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
        object = new BufferedOutputStream(zipOutputStream);
        CRC32 cRC32 = null;
        FileSearch fileSearch = new FileSearch();
        byte[] byArray = new byte[4096];
        zipOutputStream.setMethod(n);
        if (n == 8) {
            zipOutputStream.setLevel(9);
        }
        try {
            for (String string : arrayUtil) {
                if (fileSearch.getFoundDirectories().contains(string)) continue;
                fileSearch.search(string, true, stringArray2);
            }
            List<String> list = fileSearch.getFoundDirectories();
            for (Map.Entry<String, List<String>> entry : fileSearch.getFilesPerDirectory().entrySet()) {
                if (list.contains(entry.getKey())) continue;
                list.add(entry.getKey());
            }
            Collections.sort(list);
            ArrayUtil<String> arrayUtil2 = new ArrayUtil<String>();
            StringBuilder stringBuilder = new StringBuilder();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ZipEntry zipEntry;
                String string = (String)iterator.next();
                String string2 = string.replace("\\", "/");
                int n4 = -1;
                int n5 = arrayUtil.size();
                for (int i = 0; i < n5 && n4 == -1; ++i) {
                    if (!string2.startsWith((String)arrayUtil.get(i))) continue;
                    n4 = ((String)arrayUtil.get(i)).length() + 1;
                }
                List<String> list2 = fileSearch.getFilesPerDirectory().get(string);
                if (list2 == null) continue;
                stringBuilder.setLength(0);
                if (n4 < string2.length()) {
                    for (String string3 : StringUtil.separateList(string2.substring(n4), "/", false)) {
                        stringBuilder.append(string3);
                        stringBuilder.append("/");
                        string2 = stringBuilder.toString();
                        if (arrayUtil2.indexOf(string2) >= 0) continue;
                        zipEntry = new ZipEntry(string2);
                        if (n == 0) {
                            zipEntry.setSize(0L);
                            zipEntry.setCrc(0L);
                        }
                        zipOutputStream.putNextEntry(zipEntry);
                        arrayUtil2.add(string2);
                    }
                }
                for (String string4 : list2) {
                    block34: {
                        Exception exception3;
                        Object var29_37;
                        int n6;
                        File file;
                        block33: {
                            file = new File(string, string4);
                            if (n == 0) {
                                Exception exception22;
                                Object var26_35;
                                cRC32 = new CRC32();
                                try {
                                    fileInputStream = new FileInputStream(file);
                                    while ((n6 = fileInputStream.read(byArray)) >= 0) {
                                        cRC32.update(byArray, 0, n6);
                                    }
                                    var26_35 = null;
                                    if (fileInputStream == null) break block33;
                                }
                                catch (Throwable throwable) {
                                    var26_35 = null;
                                    if (fileInputStream == null) throw throwable;
                                    try {
                                        fileInputStream.close();
                                        throw throwable;
                                    }
                                    catch (Exception exception22) {
                                        // empty catch block
                                    }
                                    throw throwable;
                                }
                                try {}
                                catch (Exception exception22) {}
                                fileInputStream.close();
                            }
                        }
                        zipEntry = new ZipEntry(file.getAbsolutePath().substring(n4).replace('\\', '/'));
                        if (n == 0) {
                            zipEntry.setSize(file.length());
                            zipEntry.setTime(file.lastModified());
                            zipEntry.setCrc(cRC32.getValue());
                        }
                        zipOutputStream.putNextEntry(zipEntry);
                        try {
                            fileInputStream = new FileInputStream(file);
                            while ((n6 = fileInputStream.read(byArray)) >= 0) {
                                ((BufferedOutputStream)object).write(byArray, 0, n6);
                            }
                            var29_37 = null;
                            if (fileInputStream == null) break block34;
                        }
                        catch (Throwable throwable) {
                            var29_37 = null;
                            if (fileInputStream == null) throw throwable;
                            try {
                                fileInputStream.close();
                                throw throwable;
                            }
                            catch (Exception exception3) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                        try {}
                        catch (Exception exception3) {}
                        fileInputStream.close();
                    }
                    ((BufferedOutputStream)object).flush();
                    zipOutputStream.closeEntry();
                }
            }
            Object var32_41 = null;
        }
        catch (Throwable throwable) {
            Object var32_42 = null;
            try {
                ((FilterOutputStream)object).close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {
            return;
        }
        ((FilterOutputStream)object).close();
    }

    public static void unzip(String string, String string2) throws IOException {
        FileUtil.unzip(new File(string), string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File file, String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            FileUtil.unzip((InputStream)fileInputStream, string);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            fileInputStream.close();
        }
        catch (Exception exception) {}
    }

    public static void unzip(InputStream inputStream, String string) throws IOException {
        FileUtil.unzip(inputStream, new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void unzip(InputStream inputStream, File file) throws IOException {
        byte[] byArray = new byte[4096];
        File file2 = file;
        if (!file2.exists() && !file2.mkdirs()) throw new IOException("Can not create target directory: " + file.getAbsolutePath());
        BufferedOutputStream bufferedOutputStream = null;
        ZipInputStream zipInputStream = null;
        try {
            ZipEntry zipEntry;
            zipInputStream = new ZipInputStream(inputStream);
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                Exception exception2;
                Object var11_10;
                String string = zipEntry.getName();
                file2 = new File(file, string);
                if (zipEntry.isDirectory()) {
                    file2.mkdirs();
                    continue;
                }
                String string2 = FileUtil.getDirectory(file2.getAbsolutePath());
                if (string2 != null) {
                    new File(string2).mkdirs();
                }
                try {
                    int n;
                    bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
                    while ((n = zipInputStream.read(byArray)) != -1) {
                        bufferedOutputStream.write(byArray, 0, n);
                    }
                    var11_10 = null;
                    if (bufferedOutputStream == null) continue;
                }
                catch (Throwable throwable) {
                    var11_10 = null;
                    if (bufferedOutputStream == null) throw throwable;
                    try {
                        bufferedOutputStream.close();
                        bufferedOutputStream = null;
                        throw throwable;
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    bufferedOutputStream.close();
                    bufferedOutputStream = null;
                }
                catch (Exception exception2) {}
            }
            Object var14_13 = null;
            if (zipInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            if (zipInputStream == null) throw throwable;
            try {
                zipInputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            zipInputStream.close();
            return;
        }
        catch (Exception exception) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> listZipEntries(InputStream inputStream) throws IOException {
        ArrayUtil<String> arrayUtil;
        block6: {
            ZipInputStream zipInputStream = null;
            try {
                ZipEntry zipEntry;
                zipInputStream = new ZipInputStream(inputStream);
                ArrayUtil<String> arrayUtil2 = new ArrayUtil<String>();
                while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    arrayUtil2.add(zipEntry.getName());
                }
                arrayUtil = arrayUtil2;
                Object var6_5 = null;
                if (zipInputStream == null) break block6;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var6_6 = null;
                    if (zipInputStream == null) break block7;
                    try {
                        zipInputStream.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            try {
                zipInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return arrayUtil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void save(File file, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            FileUtil.save(file, byteArrayInputStream);
            Object var4_3 = null;
            if (byteArrayInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (byteArrayInputStream == null) throw throwable;
            try {
                byteArrayInputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            byteArrayInputStream.close();
            return;
        }
        catch (Exception exception) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void save(File file, InputStream inputStream) throws IOException {
        FilterOutputStream filterOutputStream = null;
        try {
            int n;
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray)) >= 0) {
                ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
            }
            ((BufferedOutputStream)filterOutputStream).flush();
            filterOutputStream.close();
            return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (filterOutputStream == null) throw throwable;
            try {
                filterOutputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public static void replace(File file, File file2, Hashtable<String, String> hashtable, String string) throws IOException {
        FileUtil.replace(file, file2, hashtable, string, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void replace(File var0, File var1_1, Hashtable<String, String> var2_2, String var3_3, String var4_4) throws IOException {
        block29: {
            var5_5 = null;
            var6_6 = null;
            var7_7 = null;
            try {
                block28: {
                    var5_5 = new FileInputStream(var0);
                    if (var0 == var1_1 || var0.equals(var1_1)) {
                        var8_8 = true;
                        if (var0.length() <= 1024000L) {
                            var6_6 = new ByteArrayOutputStream();
                        } else {
                            var7_7 = File.createTempFile(FileUtil.class.getName(), "jvx");
                            var6_6 = new FileOutputStream(var7_7);
                        }
                    } else {
                        var8_8 = false;
                        var6_6 = new FileOutputStream(var1_1);
                    }
                    FileUtil.replace(var5_5, var6_6, var2_2, var3_3, var4_4);
                    var5_5.close();
                    var5_5 = null;
                    if (var8_8) {
                        if (var7_7 != null && var0.delete() && var7_7.renameTo(var0)) {
                            var8_8 = false;
                        }
                        if (var8_8) {
                            if (var6_6 instanceof ByteArrayOutputStream) {
                                var9_9 = null;
                                try {
                                    var9_9 = new BufferedOutputStream(new FileOutputStream(var1_1));
                                    var9_9.write(((ByteArrayOutputStream)var6_6).toByteArray());
                                    var11_10 = null;
                                    ** if (var9_9 == null) goto lbl-1000
                                }
                                catch (Throwable var10_14) {
                                    var11_11 = null;
                                    if (var9_9 != null) {
                                        try {
                                            var9_9.close();
                                        }
                                        catch (Exception var12_13) {
                                            // empty catch block
                                        }
                                    }
                                    throw var10_14;
                                }
lbl-1000:
                                // 1 sources

                                {
                                    try {
                                        var9_9.close();
                                    }
                                    catch (Exception var12_12) {}
                                }
lbl-1000:
                                // 2 sources

                                {
                                    break block28;
                                }
                            }
                            FileUtil.copy(var7_7, var1_1, new String[0]);
                        }
                    }
                }
                var14_15 = null;
                if (var5_5 == null) break block29;
            }
            catch (Throwable var13_19) {
                var14_16 = null;
                if (var5_5 != null) {
                    try {
                        var5_5.close();
                    }
                    catch (Exception var15_18) {
                        // empty catch block
                    }
                }
                if (var6_6 != null) {
                    try {
                        var6_6.close();
                    }
                    catch (Exception var15_18) {
                        // empty catch block
                    }
                }
                if (var7_7 != null && !var7_7.delete()) {
                    var7_7.deleteOnExit();
                }
                throw var13_19;
            }
            try {
                var5_5.close();
            }
            catch (Exception var15_17) {
                // empty catch block
            }
        }
        if (var6_6 != null) {
            try {
                var6_6.close();
            }
            catch (Exception var15_17) {
                // empty catch block
            }
        }
        if (var7_7 != null && !var7_7.delete()) {
            var7_7.deleteOnExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replace(InputStream inputStream, OutputStream outputStream, Hashtable<String, String> hashtable, String string, String string2) throws IOException {
        Exception exception3;
        BufferedWriter bufferedWriter;
        block13: {
            BufferedReader bufferedReader = null;
            bufferedWriter = null;
            try {
                InputStreamReader inputStreamReader = string != null ? new InputStreamReader(inputStream, string) : new InputStreamReader(inputStream);
                bufferedReader = new BufferedReader(inputStreamReader);
                OutputStreamWriter outputStreamWriter = string2 != null ? new OutputStreamWriter(outputStream, string2) : new OutputStreamWriter(outputStream);
                bufferedWriter = new BufferedWriter(outputStreamWriter);
                String string3 = System.getProperty("line.separator");
                String string4 = bufferedReader.readLine();
                while (string4 != null) {
                    for (Map.Entry<String, String> entry : hashtable.entrySet()) {
                        string4 = StringUtil.replace(string4, entry.getKey(), entry.getValue());
                    }
                    bufferedWriter.write(string4);
                    string4 = bufferedReader.readLine();
                    if (string4 == null) continue;
                    bufferedWriter.write(string3);
                }
                bufferedWriter.write(string3);
                Object var14_13 = null;
                if (bufferedReader == null) break block13;
            }
            catch (Throwable throwable) {
                Exception exception22;
                Object var14_14 = null;
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception exception22) {
                        // empty catch block
                    }
                }
                if (bufferedWriter != null) {
                    try {
                        bufferedWriter.close();
                    }
                    catch (Exception exception22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                bufferedReader.close();
            }
            catch (Exception exception3) {
                // empty catch block
            }
        }
        if (bufferedWriter != null) {
            try {
                bufferedWriter.close();
            }
            catch (Exception exception3) {}
        }
    }

    public static boolean like(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        return FileUtil.like(string, 0, string.length(), string2, 0, string2.length());
    }

    private static boolean like(String string, int n, int n2, String string2, int n3, int n4) {
        int n5 = n;
        for (int i = n3; i < n4; ++i) {
            char c = string2.charAt(i);
            if (c == '*') {
                if (i + 1 < n4 && string2.charAt(i + 1) == '*') {
                    if (i + 1 == n4 - 1) {
                        return true;
                    }
                    int n6 = i + 2;
                    while (n5 < n2) {
                        if (FileUtil.like(string, n5, n2, string2, n6, n4)) {
                            return true;
                        }
                        ++n5;
                    }
                    return false;
                }
                int n7 = i + 1;
                int n8 = string.indexOf(47, n5);
                if (n8 < 0) {
                    n8 = string.indexOf(92, n5);
                }
                if (n8 < 0) {
                    if (i == n4 - 1) {
                        return true;
                    }
                    n8 = n2;
                } else {
                    ++n8;
                }
                int n9 = string2.indexOf(47, n7);
                if (n9 < 0) {
                    n9 = string2.indexOf(92, n7);
                }
                n9 = n9 < 0 ? n4 : ++n9;
                while (n5 < n8) {
                    if (FileUtil.like(string, n5, n8, string2, n7, n9) && FileUtil.like(string, n8, n2, string2, n9, n4)) {
                        return true;
                    }
                    ++n5;
                }
                return false;
            }
            if (n5 == n2) {
                return false;
            }
            if (c != '?' && c != string.charAt(n5)) {
                return false;
            }
            ++n5;
        }
        return n5 == n2;
    }

    public static void close(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CopyMode {
        Backup,
        Overwrite,
        Keep;

    }
}

