/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util.type;

import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.ICloseable;
import com.sibvisions.util.log.LoggerFactory;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CommonUtil {
    private CommonUtil() {
    }

    public static String dump(Throwable throwable, boolean bl) {
        if (throwable == null) {
            return "";
        }
        StringWriter stringWriter = new StringWriter(512);
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (bl) {
            throwable.printStackTrace(printWriter);
        } else {
            printWriter.println(throwable);
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            int n = stackTraceElementArray.length;
            for (int i = 0; i < n; ++i) {
                printWriter.println("\tat " + stackTraceElementArray[i]);
            }
        }
        printWriter.close();
        return stringWriter.toString();
    }

    public static Throwable getFirstCause(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        Throwable throwable2 = throwable;
        while (throwable2.getCause() != null) {
            throwable2 = throwable2.getCause();
        }
        return throwable2;
    }

    public static List<Throwable> getCauseList(Throwable throwable) {
        Throwable throwable2;
        ArrayUtil<Throwable> arrayUtil = new ArrayUtil<Throwable>();
        if (throwable == null) {
            return arrayUtil;
        }
        for (throwable2 = throwable; throwable2 != null && throwable2.getCause() != null; throwable2 = throwable2.getCause()) {
            arrayUtil.add(throwable2);
        }
        if (throwable2 != null) {
            arrayUtil.add(throwable2);
        }
        return arrayUtil;
    }

    public static boolean containsException(Throwable throwable, Class<?> clazz) {
        return CommonUtil.getException(throwable, clazz) != null;
    }

    public static Throwable getException(Throwable throwable, Class<?> clazz) {
        if (throwable == null) {
            return null;
        }
        Throwable throwable2 = throwable;
        if (clazz.isAssignableFrom(throwable2.getClass())) {
            return throwable2;
        }
        while (throwable2.getCause() != null) {
            if (!clazz.isAssignableFrom((throwable2 = throwable2.getCause()).getClass())) continue;
            return throwable2;
        }
        return null;
    }

    public static <T> T nvl(T t, T t2) {
        if (t == null) {
            return t2;
        }
        return t;
    }

    public static boolean equals(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    public static int getFreePort(int n, int n2) {
        return CommonUtil.getFreePort(n, n2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static int getFreePort(int n, int n2, boolean bl) {
        ServerSocket serverSocket = null;
        for (int i = n; i <= n2; ++i) {
            Exception exception42;
            Object var9_8;
            int n3;
            block15: {
                block16: {
                    serverSocket = new ServerSocket();
                    if (!bl) break block16;
                    try {
                        serverSocket.bind(new InetSocketAddress("127.0.0.1", i));
                        Object var6_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_11 = null;
                        try {
                            serverSocket.close();
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        serverSocket.close();
                    }
                    catch (Exception exception3) {}
                    serverSocket = new ServerSocket();
                }
                serverSocket.bind(new InetSocketAddress("0.0.0.0", i));
                n3 = i;
                var9_8 = null;
                if (serverSocket == null) break block15;
                try {
                    serverSocket.close();
                }
                catch (Exception exception42) {
                    // empty catch block
                }
            }
            return n3;
            catch (IOException iOException) {
                try {
                    var9_8 = null;
                    if (serverSocket == null) continue;
                }
                catch (Throwable throwable) {
                    var9_8 = null;
                    if (serverSocket != null) {
                        try {
                            serverSocket.close();
                        }
                        catch (Exception exception42) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                try {
                    serverSocket.close();
                }
                catch (Exception exception42) {}
                continue;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isReachable(String string, int n) {
        boolean bl;
        Socket socket = null;
        try {
            try {
                socket = new Socket();
                socket.setReuseAddress(true);
                socket.setSoTimeout(3000);
                InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
                socket.connect(inetSocketAddress, 3000);
                bl = true;
                Object var6_7 = null;
                if (socket == null) return bl;
            }
            catch (Exception exception) {
                boolean bl2 = false;
                Object var6_8 = null;
                if (socket == null) return bl2;
                try {
                    socket.close();
                    return bl2;
                }
                catch (Exception exception3) {
                    // empty catch block
                }
                return bl2;
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (socket == null) throw throwable;
            try {}
            catch (Exception exception2) {
                throw throwable;
            }
            socket.close();
            throw throwable;
        }
        try {}
        catch (Exception exception) {
            // empty catch block
            return bl;
        }
        socket.close();
        return bl;
    }

    public static <T> T close(T ... TArray) {
        if (TArray != null) {
            for (int i = 0; i < TArray.length; ++i) {
                T t = TArray[i];
                try {
                    if (t instanceof ICloseable) {
                        ((ICloseable)t).close();
                        continue;
                    }
                    if (t instanceof Connection) {
                        ((Connection)t).close();
                        continue;
                    }
                    if (t instanceof Statement) {
                        ((Statement)t).close();
                        continue;
                    }
                    if (t instanceof ResultSet) {
                        ((ResultSet)t).close();
                        continue;
                    }
                    if (t instanceof Closeable) {
                        ((Closeable)t).close();
                        continue;
                    }
                    Method method = t.getClass().getMethod("close", new Class[0]);
                    method.invoke(t, new Object[0]);
                    continue;
                }
                catch (Throwable throwable) {
                    LoggerFactory.getInstance(CommonUtil.class).debug(throwable);
                }
            }
        }
        return null;
    }
}

