/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util;

import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.type.StringUtil;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyValueList<K, V> {
    private Hashtable<K, List<V>> htValues = new Hashtable();

    public String toString() {
        return StringUtil.toString(this.htValues);
    }

    public boolean equals(Object object) {
        return this.htValues.equals(object);
    }

    public int hashCode() {
        return this.htValues.hashCode();
    }

    public synchronized void put(K k, V v) {
        this.put(k, v, false);
    }

    public synchronized void putAll(K k, Collection<V> collection) {
        for (V v : collection) {
            this.put(k, v, false);
        }
    }

    public synchronized void put(K k, V v, boolean bl) {
        List<V> list = this.htValues.get(k);
        if (list == null) {
            list = new ArrayUtil<V>();
            this.htValues.put(k, list);
            list.add(v);
        } else if (!bl || list.indexOf(v) < 0) {
            list.add(v);
        }
    }

    public synchronized List<V> get(K k) {
        return this.htValues.get(k);
    }

    public synchronized void remove(K k, V v) {
        List<V> list = this.htValues.get(k);
        if (list != null) {
            list.remove(v);
            if (list.size() == 0) {
                this.htValues.remove(k);
            }
        }
    }

    public synchronized void clear() {
        this.htValues.clear();
    }

    public synchronized List<V> remove(K k) {
        return this.htValues.remove(k);
    }

    public synchronized boolean containsKey(K k) {
        return this.htValues.containsKey(k);
    }

    public synchronized boolean containsValue(V v) {
        for (List<V> list : this.htValues.values()) {
            for (Object e : list) {
                if (!e.equals(v)) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized boolean contains(K k, V v) {
        List<V> list = this.htValues.get(k);
        if (list == null) {
            return false;
        }
        return list.contains(v);
    }

    public synchronized int size() {
        return this.htValues.size();
    }

    public synchronized boolean isEmpty() {
        return this.htValues.isEmpty();
    }

    public synchronized Enumeration<List<V>> elements() {
        return this.htValues.elements();
    }

    public synchronized Collection<List<V>> values() {
        return this.htValues.values();
    }

    public Set<K> keySet() {
        return this.htValues.keySet();
    }

    public Set<Map.Entry<K, List<V>>> entrySet() {
        return this.htValues.entrySet();
    }
}

