/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util;

import java.lang.ref.WeakReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Internalize {
    private static final int MIN_SIZE = 63719;
    private static final int MAX_SIZE = 200000;
    private static boolean outOfMemoryDetectedOrMaxSizeReached = false;
    private static long lastRehashCheck = -1L;
    private static int size = 0;
    private static WeakReference<?>[] cache = new WeakReference[63719];

    private Internalize() {
    }

    public static final synchronized <T> T intern(T t) {
        return Internalize.internNoSync(t);
    }

    public static final <T> T internNoSync(T t) {
        if (t == null) {
            return t;
        }
        int n = (t.hashCode() & Integer.MAX_VALUE) % cache.length;
        int n2 = -1;
        WeakReference<?> weakReference = cache[n];
        T t2 = null;
        while (weakReference != null) {
            Object t3 = weakReference.get();
            t2 = t3;
            if (t.equals(t3)) break;
            if (t2 == null) {
                if (n2 < 0) {
                    n2 = n;
                }
                Internalize.cache[n] = null;
                --size;
            }
            if (++n == cache.length) {
                n = 0;
            }
            weakReference = cache[n];
        }
        if (weakReference == null) {
            if (outOfMemoryDetectedOrMaxSizeReached) {
                if (System.currentTimeMillis() > lastRehashCheck + 2000L) {
                    Internalize.rehashAndClearUnused();
                }
            } else {
                if (n2 >= 0) {
                    Internalize.cache[n2] = new WeakReference<T>(t, null);
                } else {
                    Internalize.cache[n] = new WeakReference<T>(t, null);
                }
                if (++size > cache.length / 2) {
                    Internalize.rehashAndClearUnused();
                }
            }
            return t;
        }
        if (n2 >= 0) {
            Internalize.cache[n] = null;
            Internalize.cache[n2] = weakReference;
        }
        return t2;
    }

    private static final void rehashAndClearUnused() {
        WeakReference<?> weakReference;
        int n;
        for (n = 0; n < cache.length; ++n) {
            weakReference = cache[n];
            if (weakReference == null || weakReference.get() != null) continue;
            Internalize.cache[n] = null;
            --size;
        }
        n = cache.length;
        if (size > n / 2) {
            n *= 3;
        } else {
            outOfMemoryDetectedOrMaxSizeReached = false;
            while (n > 63719 && size < n / 8) {
                n /= 3;
            }
        }
        if (n > 200000 || outOfMemoryDetectedOrMaxSizeReached) {
            outOfMemoryDetectedOrMaxSizeReached = true;
            lastRehashCheck = System.currentTimeMillis();
        } else if (n != cache.length) {
            try {
                WeakReference[] weakReferenceArray = new WeakReference[n];
                for (int i = 0; i < cache.length; ++i) {
                    weakReference = cache[i];
                    if (weakReference == null) continue;
                    Object t = weakReference.get();
                    if (t == null) {
                        --size;
                        continue;
                    }
                    int n2 = (t.hashCode() & Integer.MAX_VALUE) % weakReferenceArray.length;
                    while (weakReferenceArray[n2] != null) {
                        if (++n2 != weakReferenceArray.length) continue;
                        n2 = 0;
                    }
                    weakReferenceArray[n2] = weakReference;
                }
                cache = weakReferenceArray;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                outOfMemoryDetectedOrMaxSizeReached = true;
                lastRehashCheck = System.currentTimeMillis();
            }
        }
    }
}

