/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.swing.impl;

import com.sibvisions.rad.ui.awt.impl.AwtResource;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.rad.ui.IImage;
import javax.swing.ImageIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwingImage
extends AwtResource<ImageIcon>
implements IImage {
    private String imageName;

    public SwingImage(ImageIcon imageIcon) {
        this(null, imageIcon);
    }

    public SwingImage(String string, ImageIcon imageIcon) {
        super(imageIcon);
        this.imageName = string;
    }

    @Override
    public String getImageName() {
        return this.imageName;
    }

    @Override
    public int getWidth() {
        return ((ImageIcon)this.resource).getIconWidth();
    }

    @Override
    public int getHeight() {
        return ((ImageIcon)this.resource).getIconHeight();
    }

    @Override
    public void saveAs(OutputStream outputStream, IImage.ImageType imageType) throws IOException {
        String string;
        if (imageType == null) {
            string = "png";
        } else {
            switch (imageType) {
                case JPG: {
                    string = "jpg";
                    break;
                }
                case GIF: {
                    string = "gif";
                    break;
                }
                case BMP: {
                    string = "bmp";
                    break;
                }
                default: {
                    string = "png";
                }
            }
        }
        if (((ImageIcon)this.resource).getImage() instanceof RenderedImage) {
            ImageIO.write((RenderedImage)((Object)((ImageIcon)this.resource).getImage()), string, outputStream);
        } else {
            BufferedImage bufferedImage = new BufferedImage(((ImageIcon)this.resource).getIconWidth(), ((ImageIcon)this.resource).getIconHeight(), 2);
            bufferedImage.getGraphics().drawImage(((ImageIcon)this.resource).getImage(), 0, 0, null);
            ImageIO.write((RenderedImage)bufferedImage, string, outputStream);
        }
    }
}

