/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.swing.impl;

import com.sibvisions.rad.remote.http.HttpConnection;
import com.sibvisions.rad.ui.ApplicationUtil;
import com.sibvisions.rad.ui.Webstart;
import com.sibvisions.rad.ui.awt.impl.AwtFactory;
import com.sibvisions.rad.ui.swing.ext.JVxDesktopPane;
import com.sibvisions.rad.ui.swing.impl.FileChooser;
import com.sibvisions.rad.ui.swing.impl.SwingFactory;
import com.sibvisions.rad.ui.swing.impl.SwingImage;
import com.sibvisions.rad.ui.swing.impl.container.SwingFrame;
import com.sibvisions.util.FileViewer;
import com.sibvisions.util.log.LoggerFactory;
import com.sibvisions.util.type.FileUtil;
import com.sibvisions.util.xml.XmlNode;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import javax.rad.application.IApplication;
import javax.rad.application.IConnectable;
import javax.rad.application.IFileHandleReceiver;
import javax.rad.application.ILauncher;
import javax.rad.application.genui.UILauncher;
import javax.rad.genui.UIFactoryManager;
import javax.rad.io.FileHandle;
import javax.rad.io.IFileHandle;
import javax.rad.io.RemoteFileHandle;
import javax.rad.remote.AbstractConnection;
import javax.rad.remote.IConnection;
import javax.rad.ui.IComponent;
import javax.rad.ui.IContainer;
import javax.rad.ui.IImage;
import javax.rad.ui.IRectangle;
import javax.rad.ui.UIException;
import javax.rad.ui.event.UIWindowEvent;
import javax.rad.ui.menu.IMenuBar;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

public class SwingApplication
extends SwingFrame
implements ILauncher {
    public static final String PROPERTY_APPLICATION = "application";
    private static final String CONFIG_ROOT_NODE = "application";
    private UILauncher uilauncher;
    private JRootPane rootPane;
    private JVxDesktopPane desktopModal;
    private IApplication application = null;
    private XmlNode xmnAppConfig = null;
    private Hashtable<String, Object> htCachedObjects = null;
    private FileChooser fileChooser = null;
    private boolean bSystemExitOnDispose = true;

    public static void main(String[] stringArray) {
        String[] stringArray2;
        String string;
        if (stringArray.length == 0) {
            throw new UIException("No class name parameter found!");
        }
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].startsWith("\"") || !stringArray[i].endsWith("\"")) continue;
            stringArray[i] = stringArray[i].substring(1, stringArray[i].length() - 1);
        }
        String string2 = stringArray[0];
        if (stringArray.length >= 2) {
            string = stringArray[1];
            stringArray2 = new String[stringArray.length - 2];
            System.arraycopy(stringArray, 2, stringArray2, 0, stringArray2.length);
        } else {
            string = "application.xml";
            stringArray2 = null;
        }
        try {
            System.setProperty("sun.awt.noerasebackground", "true");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            System.setProperty("sun.java2d.d3d", "false");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            Toolkit.getDefaultToolkit().setDynamicLayout(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        String string3 = string2;
        String string4 = string;
        String[] stringArray3 = stringArray2;
        new SwingApplication(string3, string4, stringArray3);
    }

    public SwingApplication() {
    }

    public SwingApplication(String string, String string2, String[] stringArray) {
        this.startup(string, string2, stringArray);
    }

    public void startup(final String string, final String string2, final String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SwingApplication.this.startupInternal(string, string2, stringArray);
            }
        });
    }

    private void startupInternal(String string, String string2, String[] stringArray) {
        Class clazz;
        this.loadConfiguration(string2);
        this.updateConfiguration(stringArray);
        String string3 = this.getParameter("Application.serverbase");
        if (string3 != null) {
            RemoteFileHandle.setDownloadURLSpec(string3 + "/services/Download?KEY=");
        }
        LoggerFactory.init(this.getParameter("Launcher.logfactory"));
        try {
            clazz = Class.forName(this.getParameter("Launcher.uifactory"));
        }
        catch (Exception exception) {
            clazz = SwingFactory.class;
        }
        this.setFactory(UIFactoryManager.getFactoryInstance(clazz));
        SwingFactory.setLookAndFeel(this, this.getParameter("Application.LookAndFeel"));
        this.rootPane = new JRootPane();
        this.rootPane.setOpaque(false);
        this.rootPane.setContentPane(((JFrame)this.resource).getContentPane());
        this.desktopModal = new JVxDesktopPane();
        this.desktopModal.add(this.rootPane);
        ((JFrame)this.resource).setContentPane(this.desktopModal);
        this.uilauncher = new UILauncher(this);
        if (this.htCachedObjects != null) {
            for (Map.Entry<String, Object> entry : this.htCachedObjects.entrySet()) {
                this.uilauncher.putObject(entry.getKey(), entry.getValue());
            }
            this.htCachedObjects = null;
        }
        try {
            this.application = ApplicationUtil.createApplication(this.uilauncher, string);
            this.uilauncher.setTitle(this.application.getName());
            this.uilauncher.add((IComponent)this.application, "Center");
            ((JFrame)this.resource).getRootPane().putClientProperty("application", this.application);
            this.uilauncher.pack();
        }
        catch (Throwable throwable) {
            this.desktopModal.setPreferredSize(new Dimension(800, 600));
            this.uilauncher.pack();
            this.uilauncher.handleException(throwable);
        }
        this.eventWindowClosing().setDefaultListener(this, "dispose");
        int n = this.getState();
        if (n == 6 || n == 2 || n == 4) {
            this.setState(n);
        }
        if (!ApplicationUtil.configureFrameBounds((Frame)this.resource)) {
            ((JFrame)this.resource).setLocationRelativeTo(null);
        }
        this.uilauncher.setVisible(true);
        if (this.application != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SwingApplication.this.application.notifyVisible();
                }
            });
        }
    }

    public void dispose() {
        if (this.application != null) {
            try {
                this.application.notifyDestroy();
            }
            catch (Exception exception) {
                LoggerFactory.getInstance(this.getClass()).info("Forced application destroy failed", exception);
            }
        }
        super.dispose();
        if (this.eventWindowClosed != null) {
            this.eventWindowClosed.dispatchEvent(new UIWindowEvent(this.eventSource, 202, AwtFactory.getMostRecentEventTime(), AwtFactory.getCurrentModifiers()));
        }
        if (this.bSystemExitOnDispose) {
            System.exit(0);
        }
    }

    public void setMenuBar(IMenuBar iMenuBar) {
        if (this.menuBar != null) {
            this.menuBar.setParent(null);
        }
        IContainer iContainer = null;
        if (iMenuBar != null) {
            iContainer = iMenuBar.getParent();
            iMenuBar.setParent(this);
        }
        try {
            if (iMenuBar != null) {
                this.rootPane.setJMenuBar((JMenuBar)iMenuBar.getResource());
            } else {
                this.rootPane.setJMenuBar(null);
            }
        }
        catch (RuntimeException runtimeException) {
            if (iMenuBar != null) {
                iMenuBar.setParent(iContainer);
            }
            throw runtimeException;
        }
        catch (Error error) {
            if (iMenuBar != null) {
                iMenuBar.setParent(iContainer);
            }
            throw error;
        }
        this.menuBar = iMenuBar;
    }

    protected void setLayoutIntern(LayoutManager layoutManager) {
        this.rootPane.getContentPane().setLayout(layoutManager);
    }

    protected void addIntern(Component component, Object object, int n) {
        this.rootPane.getContentPane().add(component, object, n);
    }

    protected void removeIntern(Component component) {
        this.rootPane.getContentPane().remove(component);
    }

    public IImage capture(int n, int n2) {
        return new SwingImage(null, new ImageIcon(this.createImage(((JFrame)this.resource).getRootPane(), n, n2)));
    }

    public String getParameter(String string) {
        XmlNode xmlNode = this.xmnAppConfig.getNode(string);
        if (xmlNode != null) {
            String string2 = ApplicationUtil.replaceParameter(xmlNode.getValue(), this);
            if (string2 != null) {
                string2 = string2.replace("\\n", "\n");
                string2 = string2.replace("<br>", "\n");
            }
            return string2;
        }
        return null;
    }

    public void setParameter(String string, String string2) {
        this.xmnAppConfig.setNode(string, string2);
    }

    public void showDocument(String string, IRectangle iRectangle, String string2) throws Throwable {
        try {
            FileViewer.open(string);
        }
        catch (Exception exception) {
            if (Webstart.isJnlp()) {
                Webstart.showDocument(string);
            }
            throw exception;
        }
    }

    public void showFileHandle(IFileHandle iFileHandle, IRectangle iRectangle, String string) throws Throwable {
        this.checkDownloadURLSpec(iFileHandle);
        try {
            File file = null;
            if (iFileHandle instanceof FileHandle) {
                file = ((FileHandle)iFileHandle).getFile();
            }
            if (file == null) {
                file = FileUtil.getNotExistingFile(new File(System.getProperty("java.io.tmpdir"), iFileHandle.getFileName()));
                file.deleteOnExit();
                FileUtil.copy(iFileHandle.getInputStream(), true, new FileOutputStream(file), true);
            }
            FileViewer.open(file);
        }
        catch (Throwable throwable) {
            if (Webstart.isJnlp()) {
                Webstart.showSaveDialog(iFileHandle);
            }
            throw throwable;
        }
    }

    public void showFileHandle(IFileHandle iFileHandle) throws Throwable {
        this.showFileHandle(iFileHandle, null, "_blank");
    }

    public void saveFileHandle(IFileHandle iFileHandle, String string) throws Throwable {
        this.checkDownloadURLSpec(iFileHandle);
        try {
            if (this.fileChooser == null) {
                this.fileChooser = new FileChooser();
            }
            this.fileChooser.saveAs(this.uilauncher, (Frame)this.resource, iFileHandle, string);
        }
        catch (SecurityException securityException) {
            if (Webstart.isJnlp()) {
                Webstart.showSaveDialog(iFileHandle);
            }
            throw securityException;
        }
    }

    public void getFileHandle(IFileHandleReceiver iFileHandleReceiver, String string) throws Throwable {
        try {
            if (this.fileChooser == null) {
                this.fileChooser = new FileChooser();
            }
            this.fileChooser.open(this.uilauncher, (Frame)this.resource, iFileHandleReceiver, string);
        }
        catch (SecurityException securityException) {
            if (Webstart.isJnlp()) {
                IFileHandle[] iFileHandleArray = Webstart.showOpenDialog(true);
                if (iFileHandleArray != null) {
                    for (int i = 0; i < iFileHandleArray.length; ++i) {
                        iFileHandleReceiver.receiveFileHandle(iFileHandleArray[i]);
                    }
                }
            }
            throw securityException;
        }
    }

    public void cancelPendingThreads() {
    }

    public void setRegistryKey(String string, String string2) {
        block2: {
            try {
                ApplicationUtil.setRegistryKey(ApplicationUtil.getRegistryApplicationName(this), string, string2);
            }
            catch (SecurityException securityException) {
                if (!Webstart.isJnlp()) break block2;
                Webstart.setProperty(string, string2);
            }
        }
    }

    public String getRegistryKey(String string) {
        try {
            return ApplicationUtil.getRegistryKey(ApplicationUtil.getRegistryApplicationName(this), string);
        }
        catch (SecurityException securityException) {
            if (Webstart.isJnlp()) {
                return Webstart.getProperty(string);
            }
            return null;
        }
    }

    public String getEnvironmentName() {
        return "DESKTOP";
    }

    public void handleException(Throwable throwable) {
        SwingFactory.showError(throwable, this.desktopModal);
    }

    private void loadConfiguration(String string) {
        if (string != null && string.trim().length() > 0) {
            try {
                this.xmnAppConfig = ApplicationUtil.getConfig(this, string);
                if (this.xmnAppConfig != null) {
                    this.xmnAppConfig = this.xmnAppConfig.getNode("application");
                }
            }
            catch (Exception exception) {
                LoggerFactory.getInstance(this.getClass()).error("Configuration load error!", exception);
            }
        }
        if (this.xmnAppConfig == null) {
            this.xmnAppConfig = new XmlNode("application");
            LoggerFactory.getInstance(this.getClass()).error("Configuration was not found -> empty configuration was created!");
        }
    }

    private void updateConfiguration(String[] stringArray) {
        Object object;
        if (stringArray != null) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                object = new StringTokenizer(stringArray[i], "=");
                if (((StringTokenizer)object).countTokens() != 2) continue;
                this.xmnAppConfig.setNode(((StringTokenizer)object).nextToken(), ((StringTokenizer)object).nextToken());
            }
        }
        if (Webstart.isJnlp()) {
            try {
                object = Webstart.getCodeBase();
                if (object != null) {
                    this.xmnAppConfig.setNode("Launcher.codebase", object);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public IApplication getApplication() {
        return this.application;
    }

    private void checkDownloadURLSpec(IFileHandle iFileHandle) {
        int n;
        IConnection iConnection;
        AbstractConnection abstractConnection;
        String string;
        if (iFileHandle instanceof RemoteFileHandle && this.application instanceof IConnectable && (string = RemoteFileHandle.getDownloadURLSpec()) == null && (abstractConnection = ((IConnectable)((Object)this.application)).getConnection()) != null && (iConnection = abstractConnection.getConnection()) instanceof HttpConnection && (n = (string = ((HttpConnection)iConnection).getServletURL()).indexOf("/services/Server")) >= 0) {
            RemoteFileHandle.setDownloadURLSpec(string.substring(0, n) + "/services/Download?KEY=");
        }
    }

    public void putObject(String string, Object object) {
        if (this.uilauncher != null) {
            this.uilauncher.putObject(string, object);
        } else if (object != null) {
            if (this.htCachedObjects == null) {
                this.htCachedObjects = new Hashtable();
            }
            this.htCachedObjects.put(string, object);
        } else if (this.htCachedObjects != null) {
            this.htCachedObjects.remove(string);
            if (this.htCachedObjects.isEmpty()) {
                this.htCachedObjects = null;
            }
        }
    }

    public Object getObject(String string) {
        if (this.uilauncher != null) {
            return this.uilauncher.getObject(string);
        }
        if (this.htCachedObjects != null) {
            return this.htCachedObjects.get(string);
        }
        return null;
    }

    public void setSystemExitOnDispose(boolean bl) {
        this.bSystemExitOnDispose = bl;
    }

    public boolean isSystemExitOnDispose() {
        return this.bSystemExitOnDispose;
    }
}

