/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.swing.ext.celleditor;

import com.sibvisions.rad.ui.swing.ext.ICellFormatterEditorListener;
import com.sibvisions.rad.ui.swing.ext.JVxEditor;
import com.sibvisions.rad.ui.swing.ext.JVxScrollPane;
import com.sibvisions.rad.ui.swing.ext.JVxUtil;
import com.sibvisions.rad.ui.swing.ext.celleditor.JVxInplaceCellEditor;
import com.sibvisions.rad.ui.swing.ext.format.CellFormat;
import com.sibvisions.rad.ui.swing.impl.SwingFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.rad.model.ColumnDefinition;
import javax.rad.model.IDataBook;
import javax.rad.model.IDataPage;
import javax.rad.model.IDataRow;
import javax.rad.model.ModelException;
import javax.rad.model.datatype.IDataType;
import javax.rad.model.datatype.StringDataType;
import javax.rad.model.ui.ICellEditor;
import javax.rad.model.ui.ICellEditorHandler;
import javax.rad.model.ui.ICellEditorListener;
import javax.rad.model.ui.ICellRenderer;
import javax.rad.ui.celleditor.ITextCellEditor;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JVxTextCellEditor
extends JVxInplaceCellEditor
implements ITextCellEditor,
ICellRenderer<JComponent> {
    private String contentType;
    private DefaultTableCellRenderer cellRenderer = null;
    private StringBuilder echoChars = new StringBuilder();

    public JVxTextCellEditor() {
        this(null);
    }

    public JVxTextCellEditor(String string) {
        this.setContentType(string);
    }

    @Override
    public ICellEditorHandler<JComponent> createCellEditorHandler(ICellEditorListener iCellEditorListener, IDataRow iDataRow, String string) {
        return new CellEditorHandler(this, (ICellFormatterEditorListener)iCellEditorListener, iDataRow, string);
    }

    @Override
    public boolean isDirectCellEditor() {
        return false;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public void setContentType(String string) {
        this.contentType = string == null ? "text/plain;singleline" : string.intern();
    }

    @Override
    public JComponent getCellRendererComponent(JComponent jComponent, IDataPage iDataPage, int n, IDataRow iDataRow, String string, boolean bl, boolean bl2) {
        if (this.cellRenderer == null) {
            this.cellRenderer = new DefaultTableCellRenderer();
            this.echoChars.append(new JPasswordField().getEchoChar());
        }
        this.cellRenderer.setHorizontalAlignment(SwingFactory.getHorizontalSwingAlignment(this.getHorizontalAlignment()));
        this.cellRenderer.setVerticalAlignment(SwingFactory.getVerticalSwingAlignment(this.getVerticalAlignment()));
        try {
            String string2 = iDataRow.getRowDefinition().getColumnDefinition(string).getDataType().convertToString(iDataRow.getValue(string));
            if (string2 != null && this.contentType == "text/plain;password") {
                int n2 = string2.length();
                while (this.echoChars.length() < n2) {
                    this.echoChars.append(this.echoChars.charAt(0));
                }
                string2 = this.echoChars.substring(0, n2);
            }
            this.cellRenderer.setText(string2);
        }
        catch (Exception exception) {
            this.cellRenderer.setText(null);
        }
        return this.cellRenderer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CellEditorHandler
    implements ICellEditorHandler<JComponent>,
    DocumentListener,
    FocusListener,
    KeyListener,
    Runnable {
        private JVxTextCellEditor cellEditor;
        private ICellFormatterEditorListener cellEditorListener;
        private IDataRow dataRow;
        private Border oldBorder;
        private String columnName;
        private int maxLength;
        private JComponent cellEditorComponent;
        private JTextComponent textComponent;
        private boolean enterKeyIsUnused;
        private boolean ignoreEvent;
        private boolean firstEditingStarted = true;

        public CellEditorHandler(JVxTextCellEditor jVxTextCellEditor, ICellFormatterEditorListener iCellFormatterEditorListener, IDataRow iDataRow, String string) {
            this.cellEditor = jVxTextCellEditor;
            this.cellEditorListener = iCellFormatterEditorListener;
            this.dataRow = iDataRow;
            this.columnName = string;
            String string2 = this.cellEditor.getContentType();
            if (string2 == "text/plain;singleline") {
                this.textComponent = new JTextField(10);
                ((JTextField)this.textComponent).setHorizontalAlignment(SwingFactory.getHorizontalSwingAlignment(this.cellEditor.getHorizontalAlignment()));
                this.cellEditorComponent = this.textComponent;
                this.enterKeyIsUnused = true;
            } else if (string2 == "text/plain;password") {
                this.textComponent = new JPasswordField(10);
                ((JPasswordField)this.textComponent).setHorizontalAlignment(SwingFactory.getHorizontalSwingAlignment(this.cellEditor.getHorizontalAlignment()));
                this.cellEditorComponent = this.textComponent;
                this.enterKeyIsUnused = true;
            } else if (string2 == "text/plain;multiline" || string2 == "text/plain;wrappedmultiline") {
                this.textComponent = new JTextArea(4, 12);
                this.textComponent.setFont(new JTextField().getFont());
                ((JTextArea)this.textComponent).setWrapStyleWord(true);
                ((JTextArea)this.textComponent).setLineWrap(string2 == "text/plain;wrappedmultiline");
                this.enterKeyIsUnused = false;
                this.cellEditorComponent = new JVxScrollPane(this.textComponent);
            } else {
                this.textComponent = new JEditorPane();
                ((JEditorPane)this.textComponent).setContentType(string2);
                this.enterKeyIsUnused = false;
                this.cellEditorComponent = new JVxScrollPane(this.textComponent);
            }
            JVxUtil.installActions(this.textComponent);
            try {
                this.maxLength = ((StringDataType)this.dataRow.getRowDefinition().getColumnDefinition(this.columnName).getDataType()).getSize();
            }
            catch (Exception exception) {
                this.maxLength = Integer.MAX_VALUE;
            }
            this.textComponent.getDocument().addDocumentListener(this);
            ((AbstractDocument)this.textComponent.getDocument()).setDocumentFilter(new TextDocumentFilter());
            this.textComponent.setFocusTraversalKeysEnabled(false);
            this.textComponent.addFocusListener(this);
            this.textComponent.addKeyListener(this);
        }

        @Override
        public void uninstallEditor() {
            this.textComponent.getDocument().removeDocumentListener(this);
            this.textComponent.removeFocusListener(this);
            this.textComponent.removeKeyListener(this);
        }

        @Override
        public void updateEditor() {
        }

        @Override
        public ICellEditor getCellEditor() {
            return this.cellEditor;
        }

        @Override
        public ICellEditorListener getCellEditorListener() {
            return this.cellEditorListener;
        }

        @Override
        public IDataRow getDataRow() {
            return this.dataRow;
        }

        @Override
        public String getColumnName() {
            return this.columnName;
        }

        @Override
        public JComponent getCellEditorComponent() {
            return this.cellEditorComponent;
        }

        @Override
        public void saveEditing() throws ModelException {
            IDataType iDataType = this.dataRow.getRowDefinition().getColumnDefinition(this.columnName).getDataType();
            Object object = this.dataRow.getValue(this.columnName);
            Object object2 = iDataType.convertToTypeClass(this.textComponent.getText());
            if (!this.cellEditorListener.isSavingImmediate() || iDataType.compareTo(object, object2) != 0) {
                this.dataRow.setValue(this.columnName, object2);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void cancelEditing() throws ModelException {
            if (this.ignoreEvent) return;
            this.ignoreEvent = true;
            try {
                try {
                    Font font;
                    Color color;
                    Object object;
                    boolean bl;
                    ColumnDefinition columnDefinition = this.dataRow.getRowDefinition().getColumnDefinition(this.columnName);
                    String string = columnDefinition.getDataType().convertToString(this.dataRow.getValue(this.columnName));
                    this.textComponent.setText(string);
                    CellFormat cellFormat = null;
                    Container container = this.textComponent.getParent();
                    if (container instanceof JViewport) {
                        container = container.getParent().getParent();
                    }
                    boolean bl2 = bl = container == null || container.isEnabled();
                    if (this.dataRow instanceof IDataBook) {
                        object = (IDataBook)this.dataRow;
                        this.textComponent.setEditable(bl && object.isUpdateAllowed() && !columnDefinition.isReadOnly() && object.getSelectedRow() >= 0);
                        if (this.cellEditorListener.getCellFormatter() != null) {
                            try {
                                cellFormat = this.cellEditorListener.getCellFormatter().getCellFormat((IDataBook)object, object.getDataPage(), (IDataRow)object, this.columnName, object.getSelectedRow(), -1);
                            }
                            catch (ModelException modelException) {}
                        }
                    } else {
                        this.textComponent.setEditable(bl && !columnDefinition.isReadOnly());
                    }
                    if (cellFormat == null) {
                        object = null;
                        color = null;
                        font = null;
                    } else {
                        object = cellFormat.getBackground();
                        color = cellFormat.getForeground();
                        font = cellFormat.getFont();
                    }
                    if (font == null) {
                        font = ((Component)((Object)this.cellEditorListener)).getFont();
                    }
                    if (color == null && ((Component)((Object)this.cellEditorListener)).isForegroundSet()) {
                        color = ((Component)((Object)this.cellEditorListener)).getForeground();
                    }
                    if (object == null && ((Component)((Object)this.cellEditorListener)).isBackgroundSet()) {
                        object = ((Component)((Object)this.cellEditorListener)).getBackground();
                    }
                    this.textComponent.setFont(font);
                    if (this.textComponent.isEditable()) {
                        if (object == null) {
                            object = columnDefinition.isNullable() ? JVxUtil.getSystemColor("IControl.background") : JVxUtil.getSystemColor("IControl.mandatoryBackground");
                        }
                        if (this.textComponent.hasFocus() && (this.cellEditor.getContentType() == "text/plain;singleline" || this.cellEditor.getContentType() == "text/plain;password")) {
                            this.textComponent.selectAll();
                        } else {
                            this.textComponent.select(0, 0);
                        }
                    } else {
                        object = JVxUtil.getSystemColor("IControl.readOnlyBackground");
                        this.textComponent.select(0, 0);
                    }
                    this.textComponent.setBackground((Color)object);
                    this.textComponent.setForeground(color);
                }
                catch (Exception exception) {
                    this.textComponent.setText(null);
                    this.textComponent.setEditable(false);
                    this.textComponent.setBackground(JVxUtil.getSystemColor("IControl.readOnlyBackground"));
                    throw new ModelException("Editor cannot be restored!", exception);
                }
                Object var10_11 = null;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                Container container = this.cellEditorComponent.getParent();
                if (container instanceof JVxEditor) {
                    if (!((JVxEditor)container).isBorderVisible()) {
                        this.oldBorder = this.cellEditorComponent.getBorder();
                        this.cellEditorComponent.setBorder(new EmptyBorder(0, 0, 0, 0));
                    } else if (this.oldBorder != null) {
                        this.cellEditorComponent.setBorder(this.oldBorder);
                    }
                }
                this.firstEditingStarted = true;
                this.ignoreEvent = false;
                throw throwable;
            }
            Container container = this.cellEditorComponent.getParent();
            if (container instanceof JVxEditor) {
                if (!((JVxEditor)container).isBorderVisible()) {
                    this.oldBorder = this.cellEditorComponent.getBorder();
                    this.cellEditorComponent.setBorder(new EmptyBorder(0, 0, 0, 0));
                } else if (this.oldBorder != null) {
                    this.cellEditorComponent.setBorder(this.oldBorder);
                }
            }
            this.firstEditingStarted = true;
            this.ignoreEvent = false;
        }

        @Override
        public void run() {
            try {
                this.saveEditing();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ignoreEvent = false;
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            if (!(EventQueue.getCurrentEvent() instanceof FocusEvent)) {
                this.fireEditingStarted();
                if (!this.ignoreEvent && this.cellEditorListener.isSavingImmediate()) {
                    this.ignoreEvent = true;
                    SwingUtilities.invokeLater(this);
                }
            }
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            if (!(EventQueue.getCurrentEvent() instanceof FocusEvent)) {
                this.fireEditingStarted();
                if (!this.ignoreEvent && this.cellEditorListener.isSavingImmediate()) {
                    this.ignoreEvent = true;
                    SwingUtilities.invokeLater(this);
                }
            }
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (this.textComponent.isEditable() && (this.cellEditor.getContentType() == "text/plain;singleline" || this.cellEditor.getContentType() == "text/plain;password")) {
                this.textComponent.selectAll();
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                this.fireEditingComplete("FOCUS_LOST");
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (!keyEvent.isConsumed()) {
                switch (keyEvent.getKeyCode()) {
                    case 27: {
                        this.fireEditingComplete("ESCAPE_KEY");
                        break;
                    }
                    case 10: {
                        if (keyEvent.getModifiers() == 0 && !this.enterKeyIsUnused) break;
                        keyEvent.consume();
                        if (keyEvent.isShiftDown()) {
                            this.fireEditingComplete("SHIFT_ENTER_KEY");
                            break;
                        }
                        this.fireEditingComplete("ENTER_KEY");
                        break;
                    }
                    case 9: {
                        if (keyEvent.getModifiers() == 0 && !this.enterKeyIsUnused) break;
                        keyEvent.consume();
                        if (keyEvent.isShiftDown()) {
                            this.fireEditingComplete("SHIFT_TAB_KEY");
                            break;
                        }
                        this.fireEditingComplete("TAB_KEY");
                        break;
                    }
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        protected void fireEditingStarted() {
            if (this.firstEditingStarted && !this.ignoreEvent && this.cellEditorListener != null) {
                this.firstEditingStarted = false;
                this.cellEditorListener.editingStarted();
            }
        }

        protected void fireEditingComplete(String string) {
            if (!this.ignoreEvent && this.cellEditorListener != null) {
                this.cellEditorListener.editingComplete(string);
            }
        }

        private void replaceAllowed(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            Document document = filterBypass.getDocument();
            int n3 = document.getLength() - n2 + (string != null ? string.length() : 0);
            if (n3 <= this.maxLength) {
                filterBypass.replace(n, n2, string, attributeSet);
            } else {
                UIManager.getLookAndFeel().provideErrorFeedback(this.textComponent);
            }
        }

        private class TextDocumentFilter
        extends DocumentFilter {
            private TextDocumentFilter() {
            }

            public void remove(DocumentFilter.FilterBypass filterBypass, int n, int n2) throws BadLocationException {
                CellEditorHandler.this.replaceAllowed(filterBypass, n, n2, null, null);
            }

            public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
                CellEditorHandler.this.replaceAllowed(filterBypass, n, 0, string, attributeSet);
            }

            public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
                CellEditorHandler.this.replaceAllowed(filterBypass, n, n2, string, attributeSet);
            }
        }
    }
}

