/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server.security;

import com.sibvisions.rad.persist.jdbc.DBCredentials;
import com.sibvisions.rad.server.config.ApplicationZone;
import com.sibvisions.util.type.CommonUtil;
import com.sibvisions.util.xml.XmlNode;
import javax.rad.server.IConfiguration;

public final class DataSourceHandler {
    private DataSourceHandler() {
    }

    public static DBCredentials createDBCredentials(ApplicationZone applicationZone, String string) {
        if (applicationZone != null && string != null) {
            return DataSourceHandler.createDBCredentials(applicationZone.getConfig(), string);
        }
        return null;
    }

    public static DBCredentials createDBCredentials(IConfiguration iConfiguration, String string) {
        int n;
        XmlNode xmlNode;
        if (iConfiguration != null && string != null && (xmlNode = iConfiguration.getNode("/application/datasource")) != null && (n = xmlNode.indexOf("/db/name", string)) >= 0) {
            return DataSourceHandler.createDBCredentials(xmlNode.getNode("/db(" + n + ")"));
        }
        return null;
    }

    public static DBCredentials createDBCredentials(XmlNode xmlNode) {
        XmlNode xmlNode2;
        if (xmlNode != null && (xmlNode2 = xmlNode.getNode("/url")) != null) {
            return new DBCredentials(DataSourceHandler.getValue(xmlNode.getNode("/driver")), DataSourceHandler.getValue(xmlNode2), DataSourceHandler.getValue(xmlNode.getNode("/username")), DataSourceHandler.getValue(xmlNode.getNode("/password")));
        }
        return null;
    }

    private static String getValue(XmlNode xmlNode) {
        if (xmlNode != null) {
            return CommonUtil.nvl(xmlNode.getValue(), "");
        }
        return null;
    }
}

