/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server.security;

import com.sibvisions.rad.persist.jdbc.DBAccess;
import com.sibvisions.rad.persist.jdbc.DBCredentials;
import com.sibvisions.rad.server.config.Configuration;
import com.sibvisions.rad.server.config.Zone;
import com.sibvisions.rad.server.security.AbstractSecurityManager;
import com.sibvisions.rad.server.security.DBSecurityManager;
import com.sibvisions.rad.server.security.DataSourceHandler;
import com.sibvisions.rad.server.security.IAccessController;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.log.LoggerFactory;
import com.sibvisions.util.type.CommonUtil;
import com.sibvisions.util.xml.XmlNode;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import javax.rad.server.IConfiguration;
import javax.rad.server.ISession;

public abstract class AbstractDBSecurityManager
extends AbstractSecurityManager {
    private DBCredentials credentials = null;
    private Connection con = null;
    private long lConfigModified = -1L;
    private List<Statement> liStatements = null;

    protected abstract void updateConfiguration(IConfiguration var1) throws Exception;

    protected abstract void initStatements(Connection var1) throws Exception;

    protected abstract String getAliveQuery();

    public synchronized void release() {
        try {
            this.closeConnection();
        }
        catch (Exception exception) {
            this.error(exception);
        }
    }

    protected void finalize() throws Throwable {
        CommonUtil.close(this.con);
        super.finalize();
    }

    protected Connection openConnection(ISession iSession) throws Exception {
        String string = iSession.getApplicationName();
        DBCredentials dBCredentials = this.getCredentials(iSession);
        if (dBCredentials == null) {
            throw new IllegalArgumentException("Database credentials were not found!");
        }
        if (dBCredentials.getDriver() == null) {
            DBAccess dBAccess = DBAccess.getDBAccess(dBCredentials.getUrl());
            if (dBAccess != null) {
                dBCredentials = new DBCredentials(dBAccess.getDriver(), dBCredentials.getUrl(), dBCredentials.getUserName(), dBCredentials.getPassword());
                if (dBCredentials.getDriver() == null) {
                    throw new IllegalArgumentException("Parameter 'driver' is missing for application '" + string + "'");
                }
            } else {
                throw new IllegalArgumentException("Parameter 'url' is missing for application '" + string + "'");
            }
        }
        if (dBCredentials.getUrl() == null) {
            throw new IllegalArgumentException("Parameter 'url' is missing for application '" + string + "'");
        }
        if (dBCredentials.getUserName() == null) {
            throw new IllegalArgumentException("Parameter 'username' is missing for application '" + string + "'");
        }
        if (dBCredentials.getPassword() == null) {
            throw new IllegalArgumentException("Parameter 'password' is missing for application '" + string + "'");
        }
        boolean bl = false;
        IConfiguration iConfiguration = iSession.getConfig();
        long l = iConfiguration instanceof Zone ? ((Zone)((Object)iConfiguration)).getFile().lastModified() : Configuration.getApplicationZone(string).getFile().lastModified();
        if (this.con == null || !this.credentials.equals(dBCredentials) || this.lConfigModified != l) {
            bl = true;
        } else {
            boolean bl2 = bl = !this.isConnectionAlive();
        }
        if (bl) {
            this.closeConnection();
            try {
                Class.forName(dBCredentials.getDriver());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ClassNotFoundException("JDBC driver '" + dBCredentials.getDriver() + "' for application '" + string + "' was not found!", classNotFoundException);
            }
            try {
                DBAccess dBAccess = DBAccess.getDBAccess(dBCredentials);
                dBAccess.open();
                this.con = dBAccess.getConnection();
                this.con.setAutoCommit(false);
                this.updateConfiguration(iConfiguration);
                this.initStatements(this.con);
            }
            catch (SQLException sQLException) {
                this.closeConnection();
                throw new Exception("Can not open database connection with '" + dBCredentials.getUrl() + "' for application '" + string + "'", sQLException);
            }
            this.credentials = dBCredentials;
            this.lConfigModified = l;
        }
        return this.con;
    }

    protected void closeConnection() throws Exception {
        if (this.con != null) {
            if (this.liStatements != null) {
                for (Statement statement : this.liStatements) {
                    CommonUtil.close(statement);
                }
            }
            this.con = CommonUtil.close(this.con);
        }
    }

    protected DBCredentials getCredentials(ISession iSession) {
        return AbstractDBSecurityManager.getCredentials(iSession.getConfig());
    }

    public static DBCredentials getCredentials(IConfiguration iConfiguration) {
        try {
            XmlNode xmlNode = iConfiguration.getNode("/application/securitymanager/database");
            if (xmlNode == null) {
                return DataSourceHandler.createDBCredentials(iConfiguration, "default");
            }
            XmlNode xmlNode2 = xmlNode.getNode("/datasource");
            if (xmlNode2 == null) {
                return DataSourceHandler.createDBCredentials(xmlNode);
            }
            return DataSourceHandler.createDBCredentials(iConfiguration, xmlNode2.getValue());
        }
        catch (Exception exception) {
            LoggerFactory.getInstance(AbstractDBSecurityManager.class).error(exception);
            return null;
        }
    }

    public Connection getConnection() throws Exception {
        if (this.con != null && !this.isConnectionAlive()) {
            try {
                DBAccess dBAccess = DBAccess.getDBAccess(this.credentials);
                this.con = dBAccess.getConnection();
                this.con.setAutoCommit(false);
                this.initStatements(this.con);
            }
            catch (SQLException sQLException) {
                this.closeConnection();
                throw new Exception("Can not open database connection with '" + this.credentials.getUrl() + "'", sQLException);
            }
        }
        return this.con;
    }

    public Connection getConnection(ISession iSession) throws Exception {
        return this.openConnection(iSession);
    }

    protected IAccessController createAccessController(ISession iSession) {
        String string = iSession.getConfig().getProperty("/application/securitymanager/accesscontroller");
        if (string != null && string.trim().length() > 0) {
            try {
                Class<?> clazz = Class.forName(string);
                return (IAccessController)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SecurityException("Access controller '" + string + "' was not found!");
            }
            catch (InstantiationException instantiationException) {
                throw new SecurityException("Can't instantiate access controller '" + string + "'!");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SecurityException("Access controller '" + string + "' not accessible!");
            }
        }
        return new DBSecurityManager.DBAccessController();
    }

    protected void commit() throws SQLException {
        this.con.commit();
    }

    protected void rollback() {
        try {
            this.con.rollback();
        }
        catch (Throwable throwable) {
            this.error(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isConnectionAlive() {
        boolean bl;
        String string = this.getAliveQuery();
        if (string == null) {
            return true;
        }
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.con.createStatement();
            resultSet = statement.executeQuery(string);
            resultSet.next();
            bl = true;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            boolean bl2;
            try {
                bl2 = false;
                Object var7_7 = null;
            }
            catch (Throwable throwable2) {
                Object var7_8 = null;
                statement = (Statement)CommonUtil.close(resultSet, statement);
                throw throwable2;
            }
            statement = (Statement)CommonUtil.close(resultSet, statement);
            return bl2;
        }
        statement = (Statement)CommonUtil.close(resultSet, statement);
        return bl;
    }

    protected void register(Statement statement) {
        if (this.liStatements == null) {
            this.liStatements = new ArrayUtil<Statement>();
        }
        if (!this.liStatements.contains(statement)) {
            this.liStatements.add(statement);
        }
    }

    protected boolean unregister(Statement statement) {
        if (this.liStatements == null) {
            return false;
        }
        return this.liStatements.remove(statement);
    }

    protected PreparedStatement prepareStatement(Connection connection, String string) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        this.register(preparedStatement);
        return preparedStatement;
    }

    protected CallableStatement prepareCall(Connection connection, String string) throws SQLException {
        CallableStatement callableStatement = connection.prepareCall(string);
        this.register(callableStatement);
        return callableStatement;
    }
}

