/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server.config;

import com.sibvisions.rad.server.config.AppSettings;
import com.sibvisions.rad.server.config.ApplicationZone;
import com.sibvisions.rad.server.config.ServerZone;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.SecureHash;
import com.sibvisions.util.log.LoggerFactory;
import com.sibvisions.util.type.FileUtil;
import com.sibvisions.util.type.ResourceUtil;
import com.sibvisions.util.xml.XmlNode;
import com.sibvisions.util.xml.XmlWorker;
import java.io.File;
import java.net.URL;
import java.util.Hashtable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Configuration {
    private static final String NAME_RAD = "rad";
    private static final String NAME_APPS = "apps";
    private static final String NAME_SERVER = "server";
    private static String sOldBaseDir = null;
    private static File fiBaseDir = null;
    private static File fiConfigDir = null;
    private static File fiAppsDir = null;
    private static File fiServerDir = null;
    private static Hashtable<String, ApplicationZone> htAppZones = null;
    private static ServerZone zoServer = null;
    private static AppSettings asApps = null;

    private Configuration() {
    }

    private static void initDirectories() {
        String string;
        String string2;
        String string3 = ResourceUtil.getAccessibleProperty("Configuration.basedir", "");
        if (!(sOldBaseDir != null && string3.equals(sOldBaseDir) || (string2 = ResourceUtil.getLocationForClass(string = ResourceUtil.getFqClassName(Configuration.class))) == null)) {
            Object object;
            File file;
            boolean bl = true;
            if (string3.trim().length() == 0 || !new File(string3).exists()) {
                file = new File(string2);
                if (!file.isDirectory()) {
                    file = new File(file.getParentFile().getParentFile(), "classes");
                }
                if (!(fiBaseDir = file.getParentFile()).exists()) {
                    object = ResourceUtil.getResource(ResourceUtil.getFqClassName(Configuration.class));
                    String string4 = ((URL)object).toExternalForm();
                    string4 = string4.substring(0, string4.indexOf(string));
                    try {
                        int n = string4.lastIndexOf(47);
                        n = string4.lastIndexOf(47, n - 1);
                        string4 = string4.substring(0, n) + "/rad.zip";
                        URL uRL = new URL(string4);
                        String string5 = SecureHash.getHash("MD5", uRL.openStream());
                        File file2 = new File(System.getProperty("java.io.tmpdir"), "rad_" + string5);
                        if (!file2.exists()) {
                            FileUtil.unzip(uRL.openStream(), file2);
                        }
                        fiBaseDir = file2;
                        bl = false;
                    }
                    catch (Exception exception) {
                        LoggerFactory.getInstance(Configuration.class).error("Base directory is not available!", exception);
                    }
                }
            } else {
                fiBaseDir = new File(string3);
            }
            if (bl) {
                file = fiBaseDir;
                while (file != null) {
                    object = file.getName();
                    if (((String)object).equalsIgnoreCase(NAME_APPS) || ((String)object).equalsIgnoreCase(NAME_SERVER)) {
                        if ((file = file.getParentFile()) == null || !file.getName().equals(NAME_RAD)) continue;
                        fiBaseDir = file.getParentFile();
                        file = null;
                        continue;
                    }
                    file = file.getParentFile();
                }
            }
            fiConfigDir = new File(fiBaseDir, NAME_RAD);
            fiAppsDir = new File(fiConfigDir, NAME_APPS);
            fiServerDir = new File(fiConfigDir, NAME_SERVER);
            sOldBaseDir = string3;
        }
    }

    public static File getConfigurationDir() {
        Configuration.initDirectories();
        return fiConfigDir;
    }

    public static File getApplicationsDir() {
        Configuration.initDirectories();
        return fiAppsDir;
    }

    public static File getServerDir() {
        Configuration.initDirectories();
        return fiServerDir;
    }

    public static ApplicationZone getApplicationZone(String string) throws Exception {
        ApplicationZone applicationZone = null;
        if (string == null || string.trim().length() == 0) {
            applicationZone = new ApplicationZone((File)null);
        } else {
            if (htAppZones != null && (applicationZone = htAppZones.get(string)) != null) {
                applicationZone.setUpdateEnabled(true);
            }
            if (applicationZone != null && !applicationZone.isValid()) {
                htAppZones.remove(string);
                applicationZone = null;
            }
            if (applicationZone == null) {
                Object object;
                Object object2;
                Object object3;
                File file = new File(Configuration.getApplicationsDir(), string);
                if (!ApplicationZone.isValid(file)) {
                    object3 = Configuration.getAppSettings();
                    object2 = ((AppSettings)object3).getAppLocations();
                    if (object2 != null) {
                        int n = object2.size();
                        for (int i = 0; i < n && applicationZone == null; ++i) {
                            object = new File(object2.get(i), string);
                            if (!ApplicationZone.isValid((File)object)) continue;
                            applicationZone = new ApplicationZone((File)object);
                        }
                    }
                } else {
                    applicationZone = new ApplicationZone(file);
                }
                if (applicationZone == null) {
                    object = new XmlWorker();
                    for (object3 = Configuration.getApplicationsDir(); object3 != null && applicationZone == null; object3 = ((File)object3).getParentFile()) {
                        object2 = new File((File)object3, "config.xml");
                        if (!((File)object2).exists() || !((File)object2).canRead()) continue;
                        if (string.equals(((File)object3).getName())) {
                            applicationZone = new ApplicationZone((File)object3);
                            continue;
                        }
                        try {
                            XmlNode xmlNode = ((XmlWorker)object).read((File)object2);
                            if (xmlNode != null && xmlNode.getSubNodes() != null && xmlNode.getNode("/application") == null) continue;
                            applicationZone = new ApplicationZone((File)object3);
                            continue;
                        }
                        catch (Exception exception) {
                            LoggerFactory.getInstance(Configuration.class).debug("Invalid config.xml '", object2, "'", exception);
                        }
                    }
                }
                if (applicationZone == null) {
                    applicationZone = new ApplicationZone(file);
                }
                if (htAppZones == null) {
                    htAppZones = new Hashtable();
                }
                htAppZones.put(string, applicationZone);
            }
        }
        return applicationZone;
    }

    public static ServerZone getServerZone() throws Exception {
        if (zoServer == null) {
            zoServer = new ServerZone(Configuration.getServerDir());
        } else {
            if (!zoServer.isValid()) {
                return null;
            }
            zoServer.setUpdateEnabled(true);
        }
        return zoServer;
    }

    public static List<String> listApplicationNames(ApplicationListOption applicationListOption) {
        ArrayUtil<String> arrayUtil = new ArrayUtil<String>();
        for (File file : Configuration.listApplicationDirectories(applicationListOption)) {
            arrayUtil.add(file.getName());
        }
        return arrayUtil;
    }

    public static boolean isApplication(String string) {
        if (string != null) {
            if (!ApplicationZone.isValid(new File(Configuration.getApplicationsDir(), string))) {
                AppSettings appSettings = Configuration.getAppSettings();
                List<String> list = appSettings.getAppLocations();
                if (list != null) {
                    int n = list.size();
                    for (int i = 0; i < n; ++i) {
                        File file = new File(list.get(i), string);
                        if (!ApplicationZone.isValid(file)) continue;
                        return true;
                    }
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public static AppSettings getAppSettings() {
        if (asApps == null) {
            Configuration.initDirectories();
            try {
                asApps = new AppSettings(fiConfigDir);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return asApps;
    }

    public static List<File> listApplicationDirectories(ApplicationListOption applicationListOption) {
        ArrayUtil<File> arrayUtil = new ArrayUtil<File>();
        File[] fileArray = Configuration.getApplicationsDir().listFiles();
        AppSettings appSettings = Configuration.getAppSettings();
        List<String> list = appSettings.getAppLocations();
        if (list != null) {
            for (String object : list) {
                File[] fileArray2;
                File file = new File(object);
                if (!file.exists() || (fileArray2 = new File(object).listFiles()) == null || fileArray2.length <= 0) continue;
                fileArray = ArrayUtil.addAll(fileArray, fileArray2);
            }
        }
        if (fileArray != null) {
            if (applicationListOption == null) {
                applicationListOption = ApplicationListOption.Visible;
            }
            block5: for (File file : fileArray) {
                if (!file.isDirectory()) continue;
                switch (applicationListOption) {
                    case Hidden: {
                        if (!file.isHidden() && file.getName().charAt(0) != '.') continue block5;
                        arrayUtil.add(file);
                        continue block5;
                    }
                    case Visible: {
                        if (file.isHidden() || file.getName().charAt(0) == '.') continue block5;
                        arrayUtil.add(file);
                        continue block5;
                    }
                    default: {
                        arrayUtil.add(file);
                    }
                }
            }
        }
        return arrayUtil;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ApplicationListOption {
        All,
        Visible,
        Hidden;

    }
}

