/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.remote;

import com.sibvisions.rad.remote.ISerializer;
import com.sibvisions.rad.remote.UniversalSerializer;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.KeyValueList;
import com.sibvisions.util.Reflective;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.LoggerFactory;
import com.sibvisions.util.type.CommonUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.rad.remote.ConnectionInfo;
import javax.rad.remote.IConnection;
import javax.rad.remote.event.CallBackEvent;
import javax.rad.remote.event.ICallBackListener;
import javax.rad.remote.event.IConnectionPropertyChangedListener;
import javax.rad.remote.event.PropertyEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSerializedConnection
implements IConnection {
    public static final String PROP_SERIALIZER = "serializer";
    private Reflective refUIThread = new Reflective();
    private Hashtable<Object, CallBackInfo> htCallBack = null;
    private KeyValueList<Object, Object> kvlConCallBack = null;
    private Object oSync = new Object();
    private ISerializer serializer = null;
    private ArrayUtil<IConnectionPropertyChangedListener> auPropertyChangedListeners;
    private long lSequence = 0L;
    private boolean bCalling = false;

    public AbstractSerializedConnection(Properties properties) throws ClassNotFoundException {
        this(AbstractSerializedConnection.createSerializer(properties.getProperty(PROP_SERIALIZER)));
    }

    public AbstractSerializedConnection(ISerializer iSerializer) {
        this.serializer = iSerializer == null ? new UniversalSerializer() : iSerializer;
    }

    @Override
    public void open(ConnectionInfo connectionInfo) throws Throwable {
        Object object = this.callIntern(connectionInfo, new String[]{"Session!"}, new String[]{"createSession"}, null, null)[0];
        connectionInfo.setConnectionId(object);
    }

    @Override
    public void openSub(ConnectionInfo connectionInfo, ConnectionInfo connectionInfo2) throws Throwable {
        Object object = this.callIntern(connectionInfo2, new String[]{"Session!"}, new String[]{"createSubSession"}, new Object[][]{{connectionInfo.getConnectionId()}}, null)[0];
        connectionInfo2.setConnectionId(object);
    }

    @Override
    public boolean isOpen(ConnectionInfo connectionInfo) {
        return connectionInfo != null && connectionInfo.getConnectionId() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(ConnectionInfo connectionInfo) throws Throwable {
        block5: {
            block6: {
                int n;
                List<Object> list;
                if (!this.isOpen(connectionInfo)) break block6;
                try {
                    this.call(connectionInfo, new String[]{"Session!"}, new String[]{"destroySession"}, null, null);
                    Object var3_2 = null;
                    Object object = connectionInfo.getConnectionId();
                    connectionInfo.setConnectionId(null);
                    if (this.kvlConCallBack == null || (list = this.kvlConCallBack.remove(object)) == null) break block5;
                    n = list.size();
                }
                catch (Throwable throwable) {
                    List<Object> list2;
                    Object var3_3 = null;
                    Object object = connectionInfo.getConnectionId();
                    connectionInfo.setConnectionId(null);
                    if (this.kvlConCallBack != null && (list2 = this.kvlConCallBack.remove(object)) != null) {
                        int n2 = list2.size();
                        for (int i = 0; i < n2; ++i) {
                            this.htCallBack.remove(list2.get(i));
                        }
                    }
                    throw throwable;
                }
                for (int i = 0; i < n; ++i) {
                    this.htCallBack.remove(list.get(i));
                }
                break block5;
            }
            throw new IllegalStateException("Connection not open");
        }
    }

    @Override
    public void reopen(ConnectionInfo connectionInfo) throws Throwable {
        try {
            this.close(connectionInfo);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.open(connectionInfo);
    }

    @Override
    public Object[] call(ConnectionInfo connectionInfo, String[] stringArray, String[] stringArray2, Object[][] objectArray, ICallBackListener[] iCallBackListenerArray) throws Throwable {
        if (connectionInfo == null) {
            throw new IllegalArgumentException("Invalid connection information: null");
        }
        if (connectionInfo.getConnectionId() == null) {
            throw new IllegalStateException("The connection is not open!");
        }
        return this.callIntern(connectionInfo, stringArray, stringArray2, objectArray, iCallBackListenerArray);
    }

    @Override
    public ConnectionInfo[] setAndCheckAlive(ConnectionInfo connectionInfo, ConnectionInfo[] connectionInfoArray) throws Throwable {
        Object[] objectArray;
        Hashtable<Object, ConnectionInfo> hashtable;
        int n;
        if (connectionInfoArray != null) {
            n = connectionInfoArray.length;
            hashtable = new Hashtable<Object, ConnectionInfo>(n);
            objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = connectionInfoArray[i].getConnectionId();
                hashtable.put(objectArray[i], connectionInfoArray[i]);
            }
        } else {
            hashtable = null;
            objectArray = null;
        }
        if ((objectArray = (Object[])this.callIntern(connectionInfo, new String[]{"Session!"}, new String[]{"setAndCheckAlive"}, new Object[][]{objectArray}, null)[0]) == null) {
            return null;
        }
        n = objectArray.length;
        ConnectionInfo[] connectionInfoArray2 = new ConnectionInfo[n];
        for (int i = 0; i < n; ++i) {
            connectionInfoArray2[i] = (ConnectionInfo)hashtable.get(objectArray[i]);
        }
        return connectionInfoArray2;
    }

    @Override
    public void setProperty(ConnectionInfo connectionInfo, String string, Object object) throws Throwable {
        if (string != null) {
            if (string.startsWith("client.")) {
                if (this.isOpen(connectionInfo)) {
                    throw new SecurityException("Client properties are not accessible after the connection was opened!");
                }
                Object object2 = connectionInfo.getProperties().put(string, object);
                this.firePropertyChanged(string, object2, object);
            } else {
                Object object3 = connectionInfo.getProperties().put(string, object);
                this.firePropertyChanged(string, object3, object);
                if (!CommonUtil.equals(object3, object) && string != null && string.startsWith("server.session.") && this.isOpen(connectionInfo)) {
                    this.callIntern(connectionInfo, new String[0], new String[0], null, null);
                }
            }
        } else {
            throw new IllegalArgumentException("Property name is undefined!");
        }
    }

    @Override
    public Object getProperty(ConnectionInfo connectionInfo, String string) throws Throwable {
        if (connectionInfo != null) {
            return connectionInfo.getProperties().get(string);
        }
        return null;
    }

    @Override
    public Hashtable<String, Object> getProperties(ConnectionInfo connectionInfo) throws Throwable {
        if (connectionInfo != null) {
            return (Hashtable)connectionInfo.getProperties().clone();
        }
        return null;
    }

    @Override
    public void addPropertyChangedListener(IConnectionPropertyChangedListener iConnectionPropertyChangedListener) {
        if (this.auPropertyChangedListeners == null) {
            this.auPropertyChangedListeners = new ArrayUtil();
        }
        this.auPropertyChangedListeners.add(iConnectionPropertyChangedListener);
    }

    @Override
    public void removePropertyChangedListener(IConnectionPropertyChangedListener iConnectionPropertyChangedListener) {
        if (this.auPropertyChangedListeners != null) {
            this.auPropertyChangedListeners.remove(iConnectionPropertyChangedListener);
        }
    }

    @Override
    public void setNewPassword(ConnectionInfo connectionInfo, String string, String string2) throws Throwable {
        this.callIntern(connectionInfo, new String[]{"Session!"}, new String[]{"setNewPassword"}, new Object[][]{{string, string2}}, null);
    }

    public abstract OutputStream getOutputStream(ConnectionInfo var1) throws Throwable;

    public abstract InputStream getInputStream(ConnectionInfo var1) throws Throwable;

    protected void finalize() throws Throwable {
        this.htCallBack = null;
        this.kvlConCallBack = null;
        super.finalize();
    }

    protected static ISerializer createSerializer(String string) throws ClassNotFoundException {
        if (string != null) {
            ISerializer iSerializer = null;
            try {
                iSerializer = (ISerializer)Class.forName(string).newInstance();
                return iSerializer;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw classNotFoundException;
            }
            catch (Exception exception) {
                throw new ClassNotFoundException(string);
            }
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private Object[] callIntern(ConnectionInfo var1_1, String[] var2_2, String[] var3_3, Object[][] var4_4, ICallBackListener[] var5_5) throws Throwable {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean isCalling() {
        return this.bCalling;
    }

    private synchronized Object createCallBackId() {
        return Long.toHexString(++this.lSequence) + "SC";
    }

    private void doCallBack(byte by, Object object, Object object2) {
        CallBackInfo callBackInfo = this.htCallBack.remove(object);
        if (callBackInfo != null) {
            this.kvlConCallBack.remove(callBackInfo.getConnectionId(), object);
            if (this.htCallBack.size() == 0) {
                this.htCallBack = null;
                this.kvlConCallBack = null;
            }
            if (callBackInfo.getCallBackListener() != null) {
                this.refUIThread.invokeLater(new CallBackWorker(callBackInfo, by, object2));
            }
        } else {
            throw new IllegalArgumentException("CallBack ID not found: '" + object + "'");
        }
    }

    private void firePropertyChanged(String string, Object object, Object object2) {
        if (this.auPropertyChangedListeners != null && !CommonUtil.equals(object, object2)) {
            PropertyEvent propertyEvent = new PropertyEvent(string, object, object2);
            for (IConnectionPropertyChangedListener iConnectionPropertyChangedListener : this.auPropertyChangedListeners) {
                iConnectionPropertyChangedListener.propertyChanged(propertyEvent);
            }
        }
    }

    private static final class CallBackWorker
    implements Runnable {
        private CallBackInfo cbiInfo;
        private byte byType;
        private Object oResult;
        private ILogger log;
        private long lCreated = System.currentTimeMillis();

        private CallBackWorker(CallBackInfo callBackInfo, byte by, Object object) {
            this.cbiInfo = callBackInfo;
            this.byType = by;
            this.oResult = object;
        }

        public void run() {
            ICallBackListener iCallBackListener = this.cbiInfo.getCallBackListener();
            if (iCallBackListener != null) {
                try {
                    Object object = null;
                    Throwable throwable = null;
                    switch (this.byType) {
                        case 2: {
                            throwable = (Throwable)this.oResult;
                            break;
                        }
                        default: {
                            object = this.oResult;
                        }
                    }
                    iCallBackListener.callBack(new CallBackEvent(this.cbiInfo.getObjectName(), this.cbiInfo.getMethodName(), object, throwable, this.cbiInfo.getCreateTime(), this.lCreated));
                }
                catch (Throwable throwable) {
                    this.error(throwable);
                }
            }
        }

        private void error(Object ... objectArray) {
            if (this.log == null) {
                this.log = LoggerFactory.getInstance(this.getClass());
            }
            this.log.error(objectArray);
        }
    }

    private static final class CallBackInfo {
        private Object oConnectionId;
        private ICallBackListener cblListener;
        private String sObjectName;
        private String sMethodName;
        private long lCreated = System.currentTimeMillis();

        private CallBackInfo(Object object, String string, String string2, ICallBackListener iCallBackListener) {
            this.oConnectionId = object;
            this.sObjectName = string;
            this.sMethodName = string2;
            this.cblListener = iCallBackListener;
        }

        private Object getConnectionId() {
            return this.oConnectionId;
        }

        private String getObjectName() {
            return this.sObjectName;
        }

        private String getMethodName() {
            return this.sMethodName;
        }

        private ICallBackListener getCallBackListener() {
            return this.cblListener;
        }

        private long getCreateTime() {
            return this.lCreated;
        }
    }
}

