/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.persist;

import com.sibvisions.rad.model.DataBookCSVExporter;
import com.sibvisions.rad.model.Filter;
import com.sibvisions.rad.model.mem.MemDataBook;
import com.sibvisions.rad.persist.AbstractCachedStorage;
import com.sibvisions.util.ArrayUtil;
import java.io.OutputStream;
import java.util.List;
import javax.rad.model.ColumnDefinition;
import javax.rad.model.ColumnView;
import javax.rad.model.IDataRow;
import javax.rad.model.IRowDefinition;
import javax.rad.model.ModelException;
import javax.rad.model.RowDefinition;
import javax.rad.model.SortDefinition;
import javax.rad.model.condition.ICondition;
import javax.rad.model.datatype.IDataType;
import javax.rad.model.event.DataBookEvent;
import javax.rad.persist.ColumnMetaData;
import javax.rad.persist.DataSourceException;
import javax.rad.persist.MetaData;
import javax.rad.type.bean.BeanType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMemStorage
extends AbstractCachedStorage {
    private MetaData metadata = null;
    private MemDataBook book = new MemDataBook();
    private String[] saAllColumns = null;
    private String[] saQueryColumns = null;
    private IDataRow rowSearch;
    private ICondition condSearch;
    private SortDefinition sortDefault = null;
    private boolean bIgnoreEvents = false;

    public AbstractMemStorage() {
        this.book.eventBeforeInserted().addListener(this, "doInsert");
        this.book.eventBeforeDeleted().addListener(this, "doDelete");
        this.book.eventBeforeUpdated().addListener(this, "doUpdate");
        try {
            this.book.setName("storage");
        }
        catch (ModelException modelException) {
            // empty catch block
        }
    }

    @Override
    public void writeCSV(OutputStream outputStream, String[] stringArray, String[] stringArray2, ICondition iCondition, SortDefinition sortDefinition, String string) throws Exception {
        DataBookCSVExporter.writeCSV(this.book, outputStream, stringArray, stringArray2, iCondition, sortDefinition, string);
    }

    @Override
    public final MetaData getMetaData() throws DataSourceException {
        if (!this.isOpen()) {
            throw new DataSourceException("AbstractMemStorage isn't open!");
        }
        return this.metadata;
    }

    @Override
    protected final List<Object[]> executeFetch(ICondition iCondition, SortDefinition sortDefinition, int n, int n2) throws DataSourceException {
        return this.executeFetch(this.saQueryColumns, iCondition, sortDefinition, n, n2);
    }

    @Override
    protected final List<Object[]> executeFetchAsBean(ICondition iCondition, SortDefinition sortDefinition, int n, int n2) throws DataSourceException {
        return this.executeFetch(this.saAllColumns, iCondition, sortDefinition, n, n2);
    }

    @Override
    protected final Object[] executeRefetchRow(Object[] objectArray) throws DataSourceException {
        if (objectArray.length > this.saQueryColumns.length) {
            return this.executeRefetchRow(this.saAllColumns, objectArray);
        }
        return this.executeRefetchRow(this.saQueryColumns, objectArray);
    }

    @Override
    protected final Object[] executeRefetchRowAsBean(Object[] objectArray) throws DataSourceException {
        return this.executeRefetchRow(this.saAllColumns, objectArray);
    }

    @Override
    protected final Object[] executeInsert(Object[] objectArray) throws DataSourceException {
        if (objectArray.length > this.saQueryColumns.length) {
            return this.executeInsert(this.saAllColumns, objectArray);
        }
        return this.executeInsert(this.saQueryColumns, objectArray);
    }

    @Override
    protected final Object[] executeInsertAsBean(Object[] objectArray) throws DataSourceException {
        return this.executeInsert(this.saAllColumns, objectArray);
    }

    @Override
    protected final Object[] executeUpdate(Object[] objectArray, Object[] objectArray2) throws DataSourceException {
        if (objectArray2.length > this.saQueryColumns.length) {
            return this.executeUpdate(this.saAllColumns, objectArray, objectArray2);
        }
        return this.executeUpdate(this.saQueryColumns, objectArray, objectArray2);
    }

    @Override
    protected final Object[] executeUpdateAsBean(Object[] objectArray, Object[] objectArray2) throws DataSourceException {
        return this.executeUpdate(this.saAllColumns, objectArray, objectArray2);
    }

    @Override
    protected final void executeDelete(Object[] objectArray) throws DataSourceException {
        if (objectArray.length > this.saQueryColumns.length) {
            this.executeDelete(this.saAllColumns, objectArray);
        } else {
            this.executeDelete(this.saQueryColumns, objectArray);
        }
    }

    @Override
    protected void executeDeleteAsBean(Object[] objectArray) throws DataSourceException {
        this.executeDelete(this.saAllColumns, objectArray);
    }

    @Override
    public int getEstimatedRowCount(ICondition iCondition) throws DataSourceException {
        try {
            return this.book.getEstimatedRowCount();
        }
        catch (ModelException modelException) {
            throw new DataSourceException("Can not calculate estimated row count!", modelException);
        }
    }

    public abstract RowDefinition getRowDefinition() throws ModelException;

    public abstract void loadData(MemDataBook var1, ICondition var2) throws ModelException;

    public abstract void insert(DataBookEvent var1) throws ModelException;

    public abstract void update(DataBookEvent var1) throws ModelException;

    public abstract void delete(DataBookEvent var1) throws ModelException;

    public void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.finalize();
    }

    @Override
    protected BeanType createBeanType(String[] stringArray) {
        return super.createBeanType(this.saAllColumns);
    }

    public void open() throws DataSourceException {
        if (!this.isOpen()) {
            try {
                RowDefinition rowDefinition = this.getRowDefinition();
                this.book.setRowDefinition(this.getRowDefinition());
                this.book.open();
                try {
                    String[] stringArray;
                    MetaData metaData = new MetaData();
                    ColumnView columnView = rowDefinition.getColumnView(null);
                    for (String string : stringArray = columnView.getColumnNames()) {
                        metaData.addColumnMetaData(ColumnMetaData.createColumnMetaData(rowDefinition.getColumnDefinition(string)));
                    }
                    metaData.setPrimaryKeyColumnNames(rowDefinition.getPrimaryKeyColumnNames());
                    this.metadata = metaData;
                    this.saQueryColumns = stringArray;
                    String[] stringArray2 = rowDefinition.getColumnNames();
                    ArrayUtil<String> arrayUtil = new ArrayUtil<String>(this.saQueryColumns);
                    for (int i = 0; i < stringArray2.length; ++i) {
                        if (arrayUtil.indexOf(stringArray2[i]) >= 0) continue;
                        arrayUtil.add(stringArray2[i]);
                    }
                    this.saAllColumns = arrayUtil.toArray(new String[arrayUtil.size()]);
                    String[] stringArray3 = rowDefinition.getPrimaryKeyColumnNames();
                    if (stringArray3 == null || stringArray3.length == 0) {
                        stringArray3 = stringArray;
                    }
                    this.rowSearch = this.book.createEmptyRow(this.saAllColumns);
                    this.condSearch = Filter.createEqualsFilter(this.rowSearch, stringArray3, false);
                }
                catch (ModelException modelException) {
                    throw new DataSourceException("Can not build meta data!", modelException);
                }
            }
            catch (ModelException modelException) {
                throw new DataSourceException("Can not open MemDataBook!", modelException);
            }
        }
    }

    @Override
    public void close() {
        if (this.isOpen()) {
            this.book.close();
            this.metadata = null;
            this.saAllColumns = null;
            this.saQueryColumns = null;
            this.rowSearch = null;
            this.condSearch = null;
            this.bIgnoreEvents = false;
        }
    }

    public boolean isOpen() {
        return this.book.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Object[]> executeFetch(String[] stringArray, ICondition iCondition, SortDefinition sortDefinition, int n, int n2) throws DataSourceException {
        try {
            this.bIgnoreEvents = true;
            try {
                this.loadData(this.book, iCondition);
                this.book.saveAllRows();
                Object var7_6 = null;
                this.bIgnoreEvents = false;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.bIgnoreEvents = false;
                throw throwable;
            }
            if (sortDefinition == null) {
                this.book.setSort(this.sortDefault);
            } else {
                this.book.setSort(sortDefinition);
            }
            ArrayUtil<Object[]> arrayUtil = new ArrayUtil<Object[]>();
            int n3 = this.book.getRowCount();
            for (int i = n <= 0 ? 0 : n; i < n3; ++i) {
                arrayUtil.add(this.book.getDataRow(i).getValues(stringArray));
            }
            arrayUtil.add(null);
            return arrayUtil;
        }
        catch (ModelException modelException) {
            throw new DataSourceException("Error fetching data!", modelException);
        }
    }

    protected final Object[] executeRefetchRow(String[] stringArray, Object[] objectArray) throws DataSourceException {
        try {
            ICondition iCondition = Filter.createEqualsFilter(this.metadata.getPrimaryKeyColumnNames(), objectArray, this.metadata.getColumnMetaData());
            this.executeFetch(iCondition, null, 0, 2);
            this.searchRow(stringArray, objectArray);
            return this.book.getValues(stringArray);
        }
        catch (ModelException modelException) {
            try {
                this.book.restoreSelectedRow();
            }
            catch (ModelException modelException2) {
                this.error(modelException);
                throw new DataSourceException("Refetch failed!", modelException2);
            }
            throw new DataSourceException("Refetch failed!", modelException);
        }
    }

    private Object[] executeInsert(String[] stringArray, Object[] objectArray) throws DataSourceException {
        try {
            this.book.insert(false);
            this.book.setValues(stringArray, objectArray);
            this.book.saveSelectedRow();
            this.validateWithMetaData(stringArray, this.book.getValues(stringArray));
            return this.book.getValues(stringArray);
        }
        catch (ModelException modelException) {
            try {
                this.book.restoreSelectedRow();
            }
            catch (ModelException modelException2) {
                this.error(modelException);
                throw new DataSourceException("Insert failed!", modelException2);
            }
            throw new DataSourceException("Insert failed!", modelException);
        }
    }

    private Object[] executeUpdate(String[] stringArray, Object[] objectArray, Object[] objectArray2) throws DataSourceException {
        try {
            this.searchRow(stringArray, objectArray);
            IRowDefinition iRowDefinition = this.book.getRowDefinition();
            ArrayUtil<String> arrayUtil = new ArrayUtil<String>();
            ArrayUtil<Object> arrayUtil2 = new ArrayUtil<Object>();
            for (int i = 0; i < objectArray2.length; ++i) {
                IDataType iDataType = iRowDefinition.getColumnDefinition(i).getDataType();
                if (iDataType.compareTo(objectArray2[i], objectArray[i]) == 0) continue;
                arrayUtil.add(stringArray[i]);
                arrayUtil2.add(objectArray2[i]);
            }
            this.book.setValues(arrayUtil.toArray(new String[arrayUtil.size()]), arrayUtil2.toArray(new Object[arrayUtil2.size()]));
            this.book.saveSelectedRow();
            this.validateWithMetaData(stringArray, this.book.getValues(stringArray));
            return this.book.getValues(stringArray);
        }
        catch (ModelException modelException) {
            try {
                this.book.restoreSelectedRow();
            }
            catch (ModelException modelException2) {
                this.error(modelException);
                throw new DataSourceException("Update failed!", modelException2);
            }
            throw new DataSourceException("Update failed!", modelException);
        }
    }

    private void executeDelete(String[] stringArray, Object[] objectArray) throws DataSourceException {
        try {
            this.validateWithMetaData(stringArray, objectArray);
            this.searchRow(stringArray, objectArray);
            this.book.delete();
            this.book.saveSelectedRow();
        }
        catch (ModelException modelException) {
            throw new DataSourceException("Delete failed!", modelException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchRow(String[] stringArray, Object[] objectArray) throws ModelException {
        this.rowSearch.setValues(stringArray, objectArray);
        int n = this.book.searchNext(this.condSearch);
        if (n < 0) {
            this.bIgnoreEvents = true;
            try {
                this.loadData(this.book, this.condSearch);
                this.book.saveAllRows();
                Object var5_4 = null;
                this.bIgnoreEvents = false;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.bIgnoreEvents = false;
                throw throwable;
            }
            n = this.book.searchNext(this.condSearch);
        }
        if (n < 0) {
            throw new DataSourceException("Row was not found!");
        }
        this.book.setSelectedRow(n);
    }

    public void doInsert(DataBookEvent dataBookEvent) throws ModelException {
        if (!this.bIgnoreEvents) {
            this.insert(dataBookEvent);
        }
    }

    public void doUpdate(DataBookEvent dataBookEvent) throws ModelException {
        if (!this.bIgnoreEvents) {
            this.update(dataBookEvent);
        }
    }

    public void doDelete(DataBookEvent dataBookEvent) throws ModelException {
        if (!this.bIgnoreEvents) {
            this.delete(dataBookEvent);
        }
    }

    protected void validateWithMetaData(String[] stringArray, Object[] objectArray) throws ModelException {
        IRowDefinition iRowDefinition = this.book.getRowDefinition();
        for (int i = 0; i < stringArray.length; ++i) {
            ColumnDefinition columnDefinition = iRowDefinition.getColumnDefinition(stringArray[i]);
            if (columnDefinition.isNullable() || objectArray[i] != null) continue;
            throw new ModelException("Column '" + stringArray[i] + "' can not be null!");
        }
    }

    public MemDataBook getDataBook() {
        return this.book;
    }

    public void setDefaultSort(SortDefinition sortDefinition) {
        this.sortDefault = sortDefinition;
    }

    public SortDefinition getDefaultSort() {
        return this.sortDefault;
    }

    public int getRowCount() throws ModelException {
        return this.book.getRowCount();
    }
}

