/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.genui.celleditor;

import com.sibvisions.rad.model.mem.MemDataBook;
import javax.rad.genui.UIFactoryManager;
import javax.rad.genui.celleditor.UIComboCellEditor;
import javax.rad.model.ColumnDefinition;
import javax.rad.model.ColumnView;
import javax.rad.model.IDataBook;
import javax.rad.model.IDataRow;
import javax.rad.model.ModelException;
import javax.rad.model.reference.ReferenceDefinition;
import javax.rad.model.ui.ICellEditorHandler;
import javax.rad.model.ui.ICellEditorListener;
import javax.rad.ui.celleditor.ILinkedCellEditor;
import javax.rad.util.ExceptionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIEnumCellEditor
extends UIComboCellEditor<ILinkedCellEditor> {
    private static final String DISPLAY_COLUMN_NAME = "DISPLAY";
    private static final String VALUE_COLUMN_NAME = "VALUE";
    private Object[] allowedValues = null;
    private String columnName = null;
    private Object[] displayValues = null;
    private ReferenceDefinition linkReference = new ReferenceDefinition();
    private IDataBook referencedDataBook = new MemDataBook();

    public UIEnumCellEditor() {
        super(UIFactoryManager.getFactory().createLinkedCellEditor());
        Object object;
        try {
            this.referencedDataBook.setName("REFERENCE");
            object = this.referencedDataBook.getRowDefinition();
            object.addColumnDefinition(new ColumnDefinition(VALUE_COLUMN_NAME));
            object.addColumnDefinition(new ColumnDefinition(DISPLAY_COLUMN_NAME));
            this.referencedDataBook.open();
        }
        catch (ModelException modelException) {
            ExceptionHandler.raise(modelException);
        }
        this.linkReference.setReferencedColumnNames(new String[]{VALUE_COLUMN_NAME});
        this.linkReference.setReferencedDataBook(this.referencedDataBook);
        object = (ILinkedCellEditor)this.getUIResource();
        object.setLinkReference(this.linkReference);
        object.setColumnView(new ColumnView(DISPLAY_COLUMN_NAME));
        object.setDisplayReferencedColumnName(DISPLAY_COLUMN_NAME);
        object.setTableHeaderVisible(false);
    }

    public UIEnumCellEditor(Object[] objectArray, Object[] objectArray2) {
        this();
        this.setAllowedValues(objectArray);
        this.setDisplayValues(objectArray2);
    }

    @Override
    public ICellEditorHandler createCellEditorHandler(ICellEditorListener iCellEditorListener, IDataRow iDataRow, String string) {
        this.setColumnName(string);
        return super.createCellEditorHandler(iCellEditorListener, iDataRow, string);
    }

    public Object[] getAllowedValues() {
        return this.allowedValues;
    }

    public void setAllowedValues(Object[] objectArray) {
        this.allowedValues = objectArray;
        this.updateReferencedDataBook(VALUE_COLUMN_NAME, this.allowedValues);
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String string) {
        this.columnName = string;
        this.linkReference.setColumnNames(new String[]{this.columnName});
    }

    public Object[] getDisplayValues() {
        return this.displayValues;
    }

    public void setDisplayValues(Object[] objectArray) {
        this.displayValues = objectArray;
        this.updateReferencedDataBook(DISPLAY_COLUMN_NAME, this.displayValues);
    }

    private void updateReferencedDataBook(String string, Object[] objectArray) {
        try {
            for (int i = 0; i < objectArray.length; ++i) {
                if (i >= this.referencedDataBook.getRowCount()) {
                    this.referencedDataBook.insert(false);
                } else {
                    this.referencedDataBook.setSelectedRow(i);
                }
                this.referencedDataBook.setValue(string, objectArray[i]);
            }
            this.referencedDataBook.saveAllRows();
        }
        catch (ModelException modelException) {
            ExceptionHandler.raise(modelException);
        }
    }
}

