/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.application;

import com.sibvisions.rad.application.Application;
import com.sibvisions.rad.application.event.DialogHandler;
import com.sibvisions.util.ArrayUtil;
import java.util.List;
import javax.rad.application.genui.Content;
import javax.rad.genui.UIColor;
import javax.rad.genui.UIImage;
import javax.rad.genui.component.UIButton;
import javax.rad.genui.component.UIIcon;
import javax.rad.genui.container.UIInternalFrame;
import javax.rad.genui.container.UIPanel;
import javax.rad.genui.layout.UIBorderLayout;
import javax.rad.genui.layout.UIFlowLayout;
import javax.rad.genui.layout.UIFormLayout;
import javax.rad.ui.IComponent;
import javax.rad.ui.IContainer;
import javax.rad.ui.component.IButton;

public class Dialog
extends Content {
    private UIBorderLayout blThis = new UIBorderLayout(0, 0);
    private UIFormLayout folButtons = new UIFormLayout();
    private UIFlowLayout floButtonsLeft = new UIFlowLayout();
    private UIFlowLayout floButtonsCenter = new UIFlowLayout();
    private UIFlowLayout floButtonsRight = new UIFlowLayout();
    private UIPanel panButtons = new UIPanel(this.folButtons);
    private UIPanel panButtonsLeft = new UIPanel(this.floButtonsLeft);
    private UIPanel panButtonsCenter = new UIPanel(this.floButtonsCenter);
    private UIPanel panButtonsRight = new UIPanel(this.floButtonsRight);
    private UIButton butOK = new UIButton("OK");
    private UIButton butCancel = new UIButton("Cancel");
    private ButtonMode buttonMode;
    private List<IButton> liButtonsLeft;
    private List<IButton> liButtonsCenter;
    private List<IButton> liButtonsRight;
    private DialogHandler eventOk;
    private DialogHandler eventCancel;

    public Dialog(IComponent iComponent) {
        this.butOK.setImage(UIImage.getImage("OK_SMALL"));
        this.butOK.eventAction().addListener(this, "doOk");
        this.butOK.setDefaultButton(true);
        this.butOK.setBackground(null);
        this.butCancel.eventAction().addListener(this, "doCancel");
        this.butCancel.setFocusable(false);
        this.butCancel.setBackground(null);
        this.folButtons.setMargins(12, 8, 8, 8);
        this.floButtonsLeft.setMargins(0, 0, 0, 0);
        this.floButtonsCenter.setMargins(0, 0, 0, 0);
        this.floButtonsRight.setMargins(0, 0, 0, 0);
        this.blThis.setMargins(0, 0, 0, 0);
        this.setLayout(this.blThis);
        this.panButtonsLeft.setBackground(null);
        this.panButtonsCenter.setBackground(null);
        this.panButtonsRight.setBackground(null);
        this.panButtons.setBackground(UIColor.white);
        this.panButtons.add((IComponent)this.panButtonsLeft, this.folButtons.getLeftAlignedConstraints(0, 0));
        this.panButtons.add((IComponent)this.panButtonsCenter, this.folButtons.getHCenterConstraints(0, 0, -1, 0));
        this.panButtons.add((IComponent)this.panButtonsRight, this.folButtons.getRightAlignedConstraints(-1, 0));
        UIIcon uIIcon = new UIIcon();
        uIIcon.setBackground(UIColor.gray);
        this.panButtons.add((IComponent)uIIcon, this.folButtons.getConstraints(this.folButtons.getTopAnchor(), this.folButtons.getLeftAnchor(), this.folButtons.createAnchor(this.folButtons.getTopAnchor(), 1), this.folButtons.getRightAnchor()));
        this.add(iComponent, "Center");
        this.add((IComponent)this.panButtons, "South");
        this.setButtonMode(ButtonMode.Ok);
        this.setPreferredSize(300, 150);
    }

    public void notifyVisible() {
        super.notifyVisible();
        this.configureButtons();
    }

    public void setButtonMode(ButtonMode buttonMode) {
        this.buttonMode = buttonMode;
    }

    public ButtonMode getButtonMode() {
        return this.buttonMode;
    }

    public void doCancel() {
        if (this.eventCancel != null) {
            this.eventCancel.dispatchEvent(this);
        }
    }

    public void doOk() {
        if (this.eventOk != null) {
            this.eventOk.dispatchEvent(this);
        }
    }

    protected void configureButtons() {
        this.panButtonsLeft.removeAll();
        this.panButtonsCenter.removeAll();
        this.panButtonsRight.removeAll();
        switch (this.buttonMode) {
            case Ok: {
                this.panButtonsCenter.add(this.butOK);
                this.panButtons.setVisible(true);
                break;
            }
            case OkCancel: {
                this.panButtonsLeft.add(this.butCancel);
                this.panButtonsRight.add(this.butOK);
                this.panButtons.setVisible(true);
                break;
            }
            case Cancel: {
                this.panButtonsCenter.add(this.butCancel);
                this.panButtons.setVisible(true);
                break;
            }
            default: {
                int n;
                int n2;
                int n3 = 0;
                if (this.liButtonsLeft != null) {
                    n2 = 0;
                    n = this.liButtonsLeft.size();
                    while (n2 < n) {
                        this.panButtonsLeft.add(this.liButtonsLeft.get(n2));
                        ++n2;
                        ++n3;
                    }
                }
                if (this.liButtonsCenter != null) {
                    n2 = 0;
                    n = this.liButtonsCenter.size();
                    while (n2 < n) {
                        this.panButtonsCenter.add(this.liButtonsCenter.get(n2));
                        ++n2;
                        ++n3;
                    }
                }
                if (this.liButtonsRight != null) {
                    n2 = 0;
                    n = this.liButtonsRight.size();
                    while (n2 < n) {
                        this.panButtonsRight.add(this.liButtonsRight.get(n2));
                        ++n2;
                        ++n3;
                    }
                }
                this.panButtons.setVisible(n3 > 0);
            }
        }
    }

    public void addLeftButton(IButton iButton) {
        this.removeButton(iButton);
        if (this.liButtonsLeft == null) {
            this.liButtonsLeft = new ArrayUtil<IButton>();
        }
        this.liButtonsLeft.add(iButton);
        iButton.setBackground(null);
    }

    public void addCenterButton(IButton iButton) {
        this.removeButton(iButton);
        if (this.liButtonsCenter == null) {
            this.liButtonsCenter = new ArrayUtil<IButton>();
        }
        this.liButtonsCenter.add(iButton);
        iButton.setBackground(null);
    }

    public void addRightButton(IButton iButton) {
        this.removeButton(iButton);
        if (this.liButtonsRight == null) {
            this.liButtonsRight = new ArrayUtil<IButton>();
        }
        this.liButtonsRight.add(iButton);
        iButton.setBackground(null);
    }

    public void removeButton(IButton iButton) {
        IContainer iContainer;
        if (this.liButtonsLeft != null) {
            this.liButtonsLeft.remove(iButton);
            if (this.liButtonsLeft.isEmpty()) {
                this.liButtonsLeft = null;
            }
        }
        if (this.liButtonsCenter != null) {
            this.liButtonsCenter.remove(iButton);
            if (this.liButtonsCenter.isEmpty()) {
                this.liButtonsCenter = null;
            }
        }
        if (this.liButtonsRight != null) {
            this.liButtonsRight.remove(iButton);
            if (this.liButtonsRight.isEmpty()) {
                this.liButtonsRight = null;
            }
        }
        if ((iContainer = iButton.getParent()) != null) {
            iContainer.remove(iButton);
        }
    }

    public DialogHandler eventOk() {
        if (this.eventOk == null) {
            this.eventOk = new DialogHandler("dialogOk");
        }
        return this.eventOk;
    }

    public DialogHandler eventCancel() {
        if (this.eventCancel == null) {
            this.eventCancel = new DialogHandler("dialogCancel");
        }
        return this.eventCancel;
    }

    public static UIInternalFrame openInternalFrame(Application application, String string, boolean bl, IComponent iComponent) {
        if (iComponent instanceof Content) {
            ((Content)iComponent).setOpener(application);
        }
        UIInternalFrame uIInternalFrame = new UIInternalFrame(application.getDesktopPane());
        uIInternalFrame.setResizable(true);
        uIInternalFrame.setTitle(string != null ? string : iComponent.getName());
        uIInternalFrame.add(iComponent);
        uIInternalFrame.eventWindowClosing().addListener(uIInternalFrame, "dispose");
        uIInternalFrame.setIconImage(null);
        uIInternalFrame.setMaximizable(false);
        uIInternalFrame.setIconifiable(false);
        uIInternalFrame.setModal(bl);
        if (iComponent instanceof Content) {
            uIInternalFrame.eventWindowClosing().addListener(iComponent, "notifyDestroy", 0);
            if (iComponent instanceof Dialog) {
                uIInternalFrame.eventWindowClosing().addListener(iComponent, "doCancel", 0);
                ((Dialog)iComponent).eventOk().addListener(iComponent, "notifyDestroy");
                ((Dialog)iComponent).eventOk().addListener(uIInternalFrame, "dispose");
                ((Dialog)iComponent).eventCancel().addListener(iComponent, "notifyDestroy");
                ((Dialog)iComponent).eventCancel().addListener(uIInternalFrame, "dispose");
            }
        }
        application.configureFrame(uIInternalFrame);
        if (iComponent.isPreferredSizeSet()) {
            uIInternalFrame.setPreferredSize(iComponent.getPreferredSize());
        }
        uIInternalFrame.pack();
        uIInternalFrame.centerRelativeTo(application.getDesktopPane());
        if (iComponent instanceof Content) {
            ((Content)iComponent).notifyVisible();
        }
        uIInternalFrame.setVisible(true);
        return uIInternalFrame;
    }

    public IButton getOkButton() {
        return this.butOK;
    }

    public IButton getCancelButton() {
        return this.butCancel;
    }

    protected UIPanel getButtonPanel() {
        return this.panButtons;
    }

    protected UIPanel getLeftButtonPanel() {
        return this.panButtonsLeft;
    }

    protected UIPanel getCenterButtonPanel() {
        return this.panButtonsCenter;
    }

    protected UIPanel getRightButtonPanel() {
        return this.panButtonsRight;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ButtonMode {
        Ok,
        OkCancel,
        Cancel,
        Custom;

    }
}

