/*
 * Copyright 2009 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 *
 * 01.10.2008 - [JR] - creation
 * 12.08.2008 - [JR] - rewritten constructor: Throwable as parameter
 */
package javax.rad.remote.event;


/**
 * The <code>CallErrorEvent</code> encapsulates the connection error
 * and all relevant information.
 * 
 * @author Ren Jahn
 */
public class CallErrorEvent
{
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Class members
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/** the source of this event. */
	private Object oSource;
	
	/** the error cause. */
	private Throwable thCause;
	
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Initialization
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
	/**
	 * Creates a new instance of <code>CallErrorEvent</code>.
	 * 
	 * @param pSource the Source of this Event
	 * @param pCause the error cause
	 */
	public CallErrorEvent(Object pSource, Throwable pCause)
	{
		this.oSource = pSource;
		thCause      = pCause;		
	}
	
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// User-defined methods
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/**
	 * Gets the source of the event.
	 * 
	 * @return the source of the event
	 */
	public Object getSource()
	{
		return oSource;
	}
	
	/**
	 * Gets the cause which inited the event.
	 * 
	 * @return the cause
	 */
	public Throwable getCause()
	{
		return thCause;
	}
	
}	// CallErrorEvent
