/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util;

import java.io.File;
import java.io.IOException;

public final class FileViewer {
    private FileViewer() {
    }

    public static void open(File file) throws IOException {
        FileViewer.open(file.getAbsolutePath());
    }

    public static void open(String string) throws IOException {
        String string2 = System.getProperty("os.name").toLowerCase();
        int n = -1;
        if (string2.startsWith("windows")) {
            n = FileViewer.checkResult(Runtime.getRuntime().exec(new String[]{"rundll32", "url.dll,FileProtocolHandler", "\"" + string + "\""}));
        } else if (string2.indexOf("linux") >= 0) {
            String string3 = System.getenv("GDMSESSION");
            if (string3 == null) {
                string3 = System.getenv("DESKTOP_SESSION");
            }
            if (string3 == null) {
                throw new IOException("WindowManager detection failed!");
            }
            if ((string3 = string3.toLowerCase()).indexOf("gnome") >= 0) {
                n = FileViewer.checkResult(Runtime.getRuntime().exec(new String[]{"gnome-open", string}));
            } else if (string3.indexOf("kde") >= 0) {
                n = FileViewer.checkResult(Runtime.getRuntime().exec(new String[]{"kde-open", string}));
            }
            if (n != 0) {
                n = FileViewer.checkResult(Runtime.getRuntime().exec(new String[]{"xdg-open", string}));
            }
        } else if (string2.indexOf("mac") >= 0 && (n = FileViewer.checkResult(Runtime.getRuntime().exec(new String[]{"open", string}))) != 0) {
            n = FileViewer.checkResult(Runtime.getRuntime().exec(new String[]{"open", "\"" + string + "\""}));
        }
        if (n != 0) {
            throw new IOException("The document [" + string + "] can not be opened!");
        }
    }

    private static int checkResult(Process process) {
        try {
            return process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            return -1;
        }
    }
}

