/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.swing.ext;

import com.sibvisions.rad.ui.swing.ext.ICellFormatterEditorListener;
import com.sibvisions.rad.ui.swing.ext.JVxUtil;
import com.sibvisions.rad.ui.swing.ext.format.ICellFormatter;
import com.sibvisions.rad.ui.swing.ext.layout.JVxBorderLayout;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.LoggerFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.rad.model.IDataBook;
import javax.rad.model.IDataRow;
import javax.rad.model.ModelException;
import javax.rad.model.datatype.IDataType;
import javax.rad.model.ui.ICellEditor;
import javax.rad.model.ui.ICellEditorHandler;
import javax.rad.model.ui.IEditorControl;
import javax.rad.util.ExceptionHandler;
import javax.rad.util.TranslationMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JVxEditor
extends JPanel
implements IEditorControl,
ICellFormatterEditorListener,
FocusListener,
Runnable {
    private static ILogger logger = null;
    private IDataRow dataRow = null;
    private String columnName = null;
    private ICellEditor cellEditor = null;
    private ICellFormatter cellFormatter = null;
    private ICellEditorHandler<JComponent> cellEditorHandler = null;
    private Component focusableComponent = null;
    private TranslationMap translation = null;
    private JTextField dummyEditor = new JTextField(10);
    private boolean savingImmediate = false;
    private boolean firstNotifyRepaintCall = true;
    private boolean isCancelling = false;
    private boolean borderVisible = true;
    private boolean isNotified = false;
    private boolean editingStarted = false;
    boolean temporaryIsShowingState = false;

    public JVxEditor() {
        super(new JVxBorderLayout());
        this.dummyEditor.setEditable(false);
        this.dummyEditor.setEnabled(false);
        this.add((Component)this.dummyEditor, "Center");
        super.setBackground(null);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.cancelEditing();
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.cancelEditing();
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.cancelEditing();
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.cancelEditing();
    }

    @Override
    public boolean isShowing() {
        return this.temporaryIsShowingState || super.isShowing();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.isNotified = true;
        if (this.cellEditorHandler != null) {
            this.focusableComponent = this.getFocusableComponent(this.cellEditorHandler.getCellEditorComponent());
            this.focusableComponent.addFocusListener(this);
        }
        if (EventQueue.isDispatchThread()) {
            this.run();
        } else {
            this.notifyRepaint();
        }
    }

    @Override
    public void removeNotify() {
        this.isNotified = false;
        super.removeNotify();
    }

    @Override
    public void requestFocus() {
        if (this.focusableComponent == null) {
            super.requestFocus();
        } else {
            this.focusableComponent.requestFocus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (!this.isCancelling) {
                this.isCancelling = true;
                if (this.isNotified) {
                    this.cancelEditing();
                }
            }
            Object var2_1 = null;
            this.isCancelling = false;
            this.firstNotifyRepaintCall = true;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.isCancelling = false;
            this.firstNotifyRepaintCall = true;
            throw throwable;
        }
    }

    @Override
    public void notifyRepaint() {
        if (this.firstNotifyRepaintCall && !this.editingStarted) {
            this.firstNotifyRepaintCall = false;
            JVxUtil.invokeLater(this);
        }
    }

    @Override
    public void cancelEditing() {
        this.editingStarted = false;
        if (this.cellEditorHandler != null) {
            try {
                this.cellEditorHandler.cancelEditing();
            }
            catch (ModelException modelException) {
                if (logger == null) {
                    logger = LoggerFactory.getInstance(this.getClass());
                }
                logger.debug(modelException);
                this.uninstallEditor();
                this.installEditor();
            }
        }
    }

    @Override
    public void saveEditing() throws ModelException {
        if (this.editingStarted) {
            this.editingStarted = false;
            this.cellEditorHandler.saveEditing();
        }
    }

    @Override
    public ICellFormatter getCellFormatter() {
        return this.cellFormatter;
    }

    public void setCellFormatter(ICellFormatter iCellFormatter) {
        this.cellFormatter = iCellFormatter;
    }

    @Override
    public void setTranslation(TranslationMap translationMap) {
        if (this.translation != translationMap) {
            this.translation = translationMap;
            if (this.cellEditorHandler != null) {
                this.cellEditorHandler.updateEditor();
            }
            this.notifyRepaint();
        }
    }

    @Override
    public TranslationMap getTranslation() {
        return this.translation;
    }

    @Override
    public void editingStarted() {
        try {
            this.editingStarted = true;
            if (this.dataRow instanceof IDataBook) {
                IDataRow iDataRow = this.dataRow.createDataRow(null);
                ((IDataBook)this.dataRow).update();
                if (!iDataRow.equals(this.dataRow, new String[]{this.columnName})) {
                    this.editingStarted = false;
                    this.notifyRepaint();
                }
            }
        }
        catch (ModelException modelException) {
            this.editingStarted = false;
            this.notifyRepaint();
            ExceptionHandler.raise(modelException);
        }
    }

    @Override
    public void editingComplete(String string) {
        if (string == "ESCAPE_KEY") {
            this.cancelEditing();
        } else {
            try {
                this.saveEditing();
            }
            catch (ModelException modelException) {
                this.cancelEditing();
                ExceptionHandler.raise(modelException);
            }
            if (string == "ENTER_KEY") {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
            } else if (string == "SHIFT_ENTER_KEY") {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
            } else if (string == "TAB_KEY") {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
            } else if (string == "SHIFT_TAB_KEY") {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
            }
        }
    }

    @Override
    public boolean isSavingImmediate() {
        return this.savingImmediate;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.processFocusEvent(focusEvent);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.processFocusEvent(focusEvent);
    }

    @Override
    public IDataRow getDataRow() {
        return this.dataRow;
    }

    @Override
    public void setDataRow(IDataRow iDataRow) throws ModelException {
        this.uninstallEditor();
        this.dataRow = iDataRow;
        this.installEditor();
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public void setColumnName(String string) throws ModelException {
        this.uninstallEditor();
        this.columnName = string;
        this.installEditor();
    }

    public void setSavingImmediate(boolean bl) {
        this.savingImmediate = bl;
    }

    private void uninstallEditor() {
        if (this.cellEditorHandler != null) {
            if (this.focusableComponent != null) {
                this.focusableComponent.removeFocusListener(this);
            }
            this.cellEditorHandler.uninstallEditor();
            this.dataRow.removeControl(this);
            this.remove(this.cellEditorHandler.getCellEditorComponent());
            this.cellEditorHandler = null;
        } else {
            this.remove(this.dummyEditor);
        }
    }

    public void setBorderVisible(boolean bl) {
        this.uninstallEditor();
        this.borderVisible = bl;
        this.installEditor();
    }

    public boolean isBorderVisible() {
        return this.borderVisible;
    }

    private void installEditor() {
        this.dummyEditor.setBackground(null);
        this.dummyEditor.setEditable(true);
        this.dummyEditor.setEnabled(true);
        this.dummyEditor.setEditable(false);
        this.dummyEditor.setEnabled(false);
        this.focusableComponent = null;
        if (this.dataRow != null && this.columnName != null) {
            try {
                IDataType iDataType = this.dataRow.getRowDefinition().getColumnDefinition(this.columnName).getDataType();
                ICellEditor iCellEditor = this.cellEditor == null ? iDataType.getCellEditor() : this.cellEditor;
                if (iCellEditor == null) {
                    iCellEditor = JVxUtil.getDefaultCellEditor(iDataType.getTypeClass());
                }
                this.cellEditorHandler = iCellEditor.createCellEditorHandler(this, this.dataRow, this.columnName);
                Component component = this.cellEditorHandler.getCellEditorComponent();
                this.add(component, "Center");
                this.dataRow.addControl(this);
                if (this.isNotified) {
                    this.focusableComponent = this.getFocusableComponent(component);
                    this.focusableComponent.addFocusListener(this);
                    this.run();
                }
            }
            catch (ModelException modelException) {
                this.dummyEditor.setBackground(JVxUtil.getSystemColor("IControl.invalidEditorBackground"));
            }
        }
        if (this.cellEditorHandler == null) {
            this.add((Component)this.dummyEditor, "Center");
        }
    }

    protected Component getFocusableComponent(Component component) {
        this.temporaryIsShowingState = true;
        Component component2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalPolicy().getFirstComponent(this);
        this.temporaryIsShowingState = false;
        if (component2 == null) {
            return component;
        }
        return component2;
    }

    @Override
    public ICellEditor getCellEditor() {
        return this.cellEditor;
    }

    @Override
    public void setCellEditor(ICellEditor iCellEditor) throws ModelException {
        this.uninstallEditor();
        this.cellEditor = iCellEditor;
        this.installEditor();
    }

    public ICellEditorHandler<JComponent> getCellEditorHandler() {
        return this.cellEditorHandler;
    }
}

