/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.swing.ext;

import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.WeakHashMap;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JVxButton
extends JButton {
    private static final String BUTTON_ACCELERATOR = "buttonAccelerator";
    private static final String BORDER_ON_MOUSE_ENTERED = "borderOnMouseEntered";
    private static final AcceleratorAction ACCELERATOR_ACTION_PRESSED = new AcceleratorAction("pressed");
    private static final AcceleratorAction ACCELERATOR_ACTION_RELEASED = new AcceleratorAction("released");
    private boolean bDefault = false;
    private static WeakHashMap<AbstractButton, Long> borderRemovedTime = new WeakHashMap();

    public JVxButton() {
        super(null, null);
    }

    public JVxButton(Icon icon) {
        super(null, icon);
    }

    public JVxButton(String string) {
        super(string, null);
    }

    public JVxButton(Action action) {
        super(null, null);
        this.setAction(action);
    }

    public JVxButton(String string, Icon icon) {
        super(null, null);
    }

    public boolean isShowing() {
        if (super.isShowing()) {
            Long l;
            if (!this.isContentAreaFilled() && (l = borderRemovedTime.get(this)) != null) {
                long l2 = System.currentTimeMillis() - l;
                if (l2 < 210L) {
                    return l2 < 70L;
                }
                borderRemovedTime.remove(this);
            }
            return true;
        }
        return false;
    }

    public boolean isDefaultButton() {
        return this.bDefault || super.isDefaultButton();
    }

    public void addNotify() {
        JButton jButton;
        JRootPane jRootPane;
        super.addNotify();
        if (this.bDefault && (jRootPane = SwingUtilities.getRootPane(this)) != null && (jButton = jRootPane.getDefaultButton()) != this) {
            if (jButton instanceof JVxButton) {
                ((JVxButton)jButton).setDefaultButton(false);
            }
            jRootPane.setDefaultButton(this);
        }
    }

    public void setDefaultButton(boolean bl) {
        this.bDefault = bl;
    }

    public KeyStroke getAccelerator() {
        return JVxButton.getAccelerator(this);
    }

    public void setAccelerator(KeyStroke keyStroke) {
        JVxButton.setAccelerator(this, keyStroke);
    }

    public boolean isBorderOnMouseEntered() {
        return JVxButton.isBorderOnMouseEntered(this);
    }

    public void setBorderOnMouseEntered(boolean bl) {
        JVxButton.setBorderOnMouseEntered(this, bl);
    }

    private static KeyStroke getKeyStroke(KeyStroke keyStroke, boolean bl) {
        int n = keyStroke.getKeyCode();
        if (n == 0) {
            n = Character.toUpperCase(keyStroke.getKeyChar());
        }
        return KeyStroke.getKeyStroke(keyStroke.getKeyCode(), keyStroke.getModifiers(), bl);
    }

    public static KeyStroke getAccelerator(AbstractButton abstractButton) {
        return (KeyStroke)abstractButton.getClientProperty(BUTTON_ACCELERATOR);
    }

    public static void setAccelerator(AbstractButton abstractButton, KeyStroke keyStroke) {
        KeyStroke keyStroke2 = JVxButton.getAccelerator(abstractButton);
        if (keyStroke2 != null) {
            abstractButton.getActionMap().remove("pressed");
            abstractButton.getInputMap(2).remove(JVxButton.getKeyStroke(keyStroke2, false));
            abstractButton.getActionMap().remove("released");
            abstractButton.getInputMap(2).remove(JVxButton.getKeyStroke(keyStroke2, true));
        }
        abstractButton.putClientProperty(BUTTON_ACCELERATOR, keyStroke);
        if (keyStroke != null) {
            abstractButton.getActionMap().put("pressed", ACCELERATOR_ACTION_PRESSED);
            abstractButton.getInputMap(2).put(JVxButton.getKeyStroke(keyStroke, false), "pressed");
            abstractButton.getActionMap().put("released", ACCELERATOR_ACTION_RELEASED);
            abstractButton.getInputMap(2).put(JVxButton.getKeyStroke(keyStroke, true), "released");
        }
    }

    public static boolean isBorderOnMouseEntered(AbstractButton abstractButton) {
        return abstractButton.getClientProperty(BORDER_ON_MOUSE_ENTERED) != null;
    }

    public static void setBorderOnMouseEntered(AbstractButton abstractButton, boolean bl) {
        BorderOnMouseEnteredListener borderOnMouseEnteredListener = (BorderOnMouseEnteredListener)abstractButton.getClientProperty(BORDER_ON_MOUSE_ENTERED);
        if (bl) {
            if (borderOnMouseEnteredListener == null) {
                borderOnMouseEnteredListener = new BorderOnMouseEnteredListener(abstractButton);
                abstractButton.putClientProperty(BORDER_ON_MOUSE_ENTERED, borderOnMouseEnteredListener);
                abstractButton.addMouseListener(borderOnMouseEnteredListener);
                abstractButton.addPropertyChangeListener("ancestor", borderOnMouseEnteredListener);
                abstractButton.getModel().addChangeListener(borderOnMouseEnteredListener);
                abstractButton.putClientProperty("jvx.opaque", abstractButton.isOpaque());
                abstractButton.setOpaque(false);
                borderOnMouseEnteredListener.setBorderVisible(abstractButton.getModel().isPressed() || abstractButton.getModel().isSelected());
            }
        } else if (borderOnMouseEnteredListener != null) {
            abstractButton.putClientProperty(BORDER_ON_MOUSE_ENTERED, null);
            abstractButton.removeMouseListener(borderOnMouseEnteredListener);
            abstractButton.getModel().removeChangeListener(borderOnMouseEnteredListener);
            Boolean bl2 = (Boolean)abstractButton.getClientProperty("jvx.opaque");
            if (bl2 != null) {
                abstractButton.putClientProperty("jvx.opaque", null);
                abstractButton.setOpaque(bl2);
            }
            borderOnMouseEnteredListener.setBorderVisible(true);
        }
    }

    private static class AcceleratorAction
    extends AbstractAction {
        private static final String PRESSED = "pressed";
        private static final String RELEASED = "released";

        AcceleratorAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            Object object = this.getValue("Name");
            if (object == PRESSED) {
                ButtonModel buttonModel = abstractButton.getModel();
                buttonModel.setArmed(true);
                buttonModel.setPressed(true);
                if (!abstractButton.hasFocus()) {
                    abstractButton.requestFocus();
                }
            } else if (object == RELEASED) {
                ButtonModel buttonModel = abstractButton.getModel();
                buttonModel.setPressed(false);
                buttonModel.setArmed(false);
            }
        }
    }

    private static class BorderOnMouseEnteredListener
    implements ChangeListener,
    PropertyChangeListener,
    MouseListener {
        private AbstractButton abstractButton;
        private boolean entered = false;

        BorderOnMouseEnteredListener(AbstractButton abstractButton) {
            this.abstractButton = abstractButton;
            this.setBorderVisible(false);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (!this.entered) {
                this.setBorderVisible(this.abstractButton.getModel().isPressed() || this.abstractButton.getModel().isSelected());
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (this.abstractButton.isEnabled() && (mouseEvent.getModifiers() & 0x1C) == 0) {
                this.entered = true;
                this.setBorderVisible(true);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (this.entered) {
                this.entered = false;
                this.setBorderVisible(this.abstractButton.getModel().isPressed() || this.abstractButton.getModel().isSelected());
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        protected void setBorderVisible(boolean bl) {
            if (this.abstractButton.isBorderPainted() != bl) {
                boolean bl2 = this.abstractButton.isOpaque();
                if (!bl && this.abstractButton.isShowing()) {
                    this.abstractButton.getUI().paint(this.abstractButton.getGraphics(), this.abstractButton);
                    borderRemovedTime.put(this.abstractButton, System.currentTimeMillis());
                }
                this.abstractButton.setBorderPainted(bl);
                this.abstractButton.setContentAreaFilled(bl);
                if (bl2 != this.abstractButton.isOpaque()) {
                    this.abstractButton.setOpaque(bl2);
                }
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (this.entered && propertyChangeEvent.getNewValue() == null) {
                this.entered = false;
                this.setBorderVisible(this.abstractButton.getModel().isPressed() || this.abstractButton.getModel().isSelected());
            }
        }
    }
}

