/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server.security;

import com.sibvisions.rad.server.AbstractSession;
import com.sibvisions.rad.server.config.DBObjects;
import com.sibvisions.rad.server.security.AbstractDBSecurityManager;
import com.sibvisions.rad.server.security.IAccessController;
import com.sibvisions.util.ArrayUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.UUID;
import javax.rad.remote.ChangePasswordException;
import javax.rad.server.IConfiguration;
import javax.rad.server.ISession;

public class DBSecurityManager
extends AbstractDBSecurityManager {
    protected static final String TABLE_USERS = "USERS";
    protected static final String TABLE_AUTOLOGIN = "AUTOLOGIN";
    protected static final String VIEW_ACCESSRULES = "V_ACCESSRULES";
    private PreparedStatement psAutoLogin;
    private PreparedStatement psInsertAutoLogin;
    private PreparedStatement psDeleteAutoLoginKey;
    private PreparedStatement psDeleteAutoLoginUser;
    private PreparedStatement psUserId;
    private PreparedStatement psUserName;
    private PreparedStatement psAccessRule;
    private PreparedStatement psChangePwd;
    private PreparedStatement psChangePwdUnset;
    private String sUsersTable;
    private String sUsersId;
    private String sUsersName;
    private String sUsersChgPwd;
    private String sUsersPwd;
    private String sAutoLoginTable;
    private String sAutoLoginId;
    private String sAutoLoginKey;
    private String sAccessTable;
    private String sAccessUser;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public synchronized void validateAuthentication(ISession var1_1) throws Exception {
        block45: {
            var2_2 = var1_1.getApplicationName();
            var3_3 = var1_1.getUserName();
            var4_4 = var1_1.getConfig();
            var5_5 = null;
            var6_6 = false;
            this.openConnection(var1_1);
            try {
                block44: {
                    block43: {
                        var7_7 = (String)var1_1.getProperty("client.login.key");
                        if (this.psAutoLogin != null && var7_7 != null) {
                            var8_9 = null;
                            try {
                                block42: {
                                    this.psAutoLogin.clearParameters();
                                    this.psAutoLogin.setString(1, var7_7);
                                    var8_9 = this.psAutoLogin.executeQuery();
                                    if (!var8_9.next()) break block42;
                                    this.psUserId.clearParameters();
                                    this.psUserId.setBigDecimal(1, var8_9.getBigDecimal(1));
                                    var5_5 = this.psUserId.executeQuery();
                                    var6_6 = true;
                                }
                                var11_10 = null;
                                ** if (var8_9 == null) goto lbl-1000
                            }
                            catch (Throwable var10_21) {
                                var11_12 = null;
                                if (var8_9 != null) {
                                    try {
                                        var8_9.close();
                                    }
                                    catch (SQLException var12_15) {
                                        // empty catch block
                                    }
                                }
                                throw var10_21;
                            }
lbl-1000:
                            // 1 sources

                            {
                                try {
                                    var8_9.close();
                                }
                                catch (SQLException var12_13) {}
                            }
lbl-1000:
                            // 2 sources

                            {
                                break block43;
                                catch (Exception var9_16) {
                                    this.debug(new Object[]{var9_16});
                                    var11_11 = null;
                                    if (var8_9 != null) {
                                        try {
                                            var8_9.close();
                                        }
                                        catch (SQLException var12_14) {}
                                    }
                                }
                            }
                        }
                    }
                    if (var5_5 == null) {
                        this.psUserName.clearParameters();
                        this.psUserName.setString(1, var3_3);
                        var5_5 = this.psUserName.executeQuery();
                    }
                    this.validateUser(var1_1, var5_5);
                    if (!var6_6) {
                        try {
                            var8_9 = var5_5.getString(DBObjects.getColumnName(var4_4, "USERS", "PASSWORD"));
                        }
                        catch (SQLException var9_17) {
                            var8_9 = null;
                        }
                        if (!this.isPasswordValid(var1_1, (String)var8_9)) {
                            throw new SecurityException("Invalid password for '" + var3_3 + "' and application '" + var2_2 + "'");
                        }
                    }
                    try {
                        var8_9 = var5_5.getString(DBObjects.getColumnName(var4_4, "USERS", "CHANGE_PASSWORD"));
                    }
                    catch (SQLException var9_19) {
                        var8_9 = null;
                    }
                    if (this.isChangePassword(var1_1, (String)var8_9)) {
                        throw new ChangePasswordException("Please change your password");
                    }
                    var9_20 = Boolean.valueOf((String)var1_1.getProperty("client.login.auto"));
                    if (var7_7 == null && var9_20 && this.psAutoLogin != null && this.psDeleteAutoLoginUser != null && this.psInsertAutoLogin != null) {
                        var7_7 = UUID.randomUUID().toString();
                        try {
                            var10_22 = var5_5.getBigDecimal(DBObjects.getColumnName(var4_4, "USERS", "ID"));
                            this.psDeleteAutoLoginUser.clearParameters();
                            this.psDeleteAutoLoginUser.setBigDecimal(1, var10_22);
                            if (this.psDeleteAutoLoginUser.execute()) {
                                this.psDeleteAutoLoginUser.getResultSet().close();
                            }
                            this.psInsertAutoLogin.clearParameters();
                            this.psInsertAutoLogin.setBigDecimal(1, var10_22);
                            this.psInsertAutoLogin.setString(2, var7_7);
                            if (this.psInsertAutoLogin.execute()) {
                                this.psInsertAutoLogin.getResultSet().close();
                            }
                            this.commit();
                            var1_1.setProperty("client.login.key", var7_7);
                        }
                        catch (Exception var10_23) {
                            this.rollback();
                            this.error(new Object[]{var10_23});
                        }
                    }
                    if (var6_6) {
                        if (!(var1_1 instanceof AbstractSession)) break block44;
                        try {
                            ((AbstractSession)var1_1).setUserName(var5_5.getString(DBObjects.getColumnName(var4_4, "USERS", "USERNAME")));
                            break block44;
                        }
                        catch (SQLException var10_24) {
                            throw new SecurityException("USERNAME column for application '" + var2_2 + "' was not found!");
                        }
                    }
                    if (var9_20) break block44;
                    var1_1.setProperty("client.login.key", null);
                }
                var14_25 = null;
                ** if (var5_5 == null) goto lbl-1000
            }
            catch (Throwable var13_37) {
                var14_26 = null;
                if (var5_5 != null) {
                    try {
                        var5_5.close();
                    }
                    catch (Throwable var16_36) {
                        var17_32 = null;
                        var5_5 = null;
                        throw var16_36;
                    }
                }
                throw var13_37;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var5_5.close();
                }
                catch (Throwable var16_35) {
                    var17_29 = null;
                    var5_5 = null;
                    throw var16_35;
                }
            }
lbl-1000:
            // 1 sources

            {
                break block45;
                catch (SQLException var7_8) {
                    this.error(new Object[]{var7_8});
                    throw new SecurityException("Authentication for user '" + var3_3 + "' and application '" + var2_2 + "' is not possible");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void changePassword(ISession iSession) throws Exception {
        boolean bl;
        String string;
        String string2 = (String)iSession.getProperty("client.oldpassword");
        String string3 = (String)iSession.getProperty("client.newpassword");
        this.validatePassword(iSession, string2, string3);
        String string4 = iSession.getApplicationName();
        String string5 = iSession.getUserName();
        IConfiguration iConfiguration = iSession.getConfig();
        this.openConnection(iSession);
        ResultSet resultSet = null;
        this.psUserName.clearParameters();
        this.psUserName.setString(1, string5);
        resultSet = this.psUserName.executeQuery();
        this.validateUser(iSession, resultSet);
        try {
            string = resultSet.getString(DBObjects.getColumnName(iConfiguration, TABLE_USERS, "PASSWORD"));
        }
        catch (SQLException sQLException) {
            string = null;
        }
        if ((iSession.getProperty("client.login.key") == null || iSession.getPassword() != null) && !this.comparePassword(iConfiguration, iSession.getPassword(), string2) || !this.comparePassword(iConfiguration, string2, string)) throw new SecurityException("Invalid password for '" + string5 + "' and application '" + string4 + "'");
        try {
            resultSet.getString(DBObjects.getColumnName(iConfiguration, TABLE_USERS, "CHANGE_PASSWORD"));
            bl = true;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        PreparedStatement preparedStatement = bl ? this.psChangePwdUnset : this.psChangePwd;
        preparedStatement.clearParameters();
        preparedStatement.setString(1, DBSecurityManager.getEncryptedPassword(iConfiguration, string3));
        preparedStatement.setString(2, string5);
        if (preparedStatement.execute()) {
            preparedStatement.getResultSet().close();
        }
        this.commit();
        if (preparedStatement.getUpdateCount() != 1) {
            throw new SecurityException("User '" + string5 + "' was not found for application '" + string4 + "'");
        }
        Object var12_14 = null;
        if (resultSet == null) return;
        try {
            resultSet.close();
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            resultSet = null;
            throw throwable;
        }
        {
            catch (SQLException sQLException) {
                this.rollback();
                this.debug(sQLException);
                throw new SecurityException("Error while changing password of '" + string5 + "' for application '" + string4 + "'");
            }
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            if (resultSet == null) throw throwable;
            try {
                resultSet.close();
            }
            catch (Throwable throwable2) {
                Object var15_21 = null;
                resultSet = null;
                throw throwable2;
            }
        }
    }

    public synchronized void logout(ISession iSession) {
        if (Boolean.valueOf((String)iSession.getProperty("userlogout")).booleanValue()) {
            try {
                String string = (String)iSession.getProperty("client.login.key");
                if (string != null) {
                    this.openConnection(iSession);
                    this.psDeleteAutoLoginKey.clearParameters();
                    this.psDeleteAutoLoginKey.setString(1, string);
                    if (this.psDeleteAutoLoginKey.execute()) {
                        this.psDeleteAutoLoginKey.getResultSet().close();
                    }
                    this.commit();
                    iSession.setProperty("client.login.key", null);
                }
            }
            catch (Exception exception) {
                this.rollback();
                this.error(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized IAccessController getAccessController(ISession iSession) throws Exception {
        Object object;
        IConfiguration iConfiguration = iSession.getConfig();
        ResultSet resultSet = null;
        this.openConnection(iSession);
        if (this.psAccessRule == null) {
            return null;
        }
        this.psAccessRule.clearParameters();
        this.psAccessRule.setObject(1, iSession.getUserName());
        resultSet = this.psAccessRule.executeQuery();
        String string = (String)iSession.getProperty("client.Launcher.environment");
        String string2 = DBObjects.getYesValue(iConfiguration);
        IAccessController iAccessController = this.createAccessController(iSession);
        String string3 = DBObjects.getColumnName(iConfiguration, VIEW_ACCESSRULES, "LIFECYCLENAME");
        String string4 = null;
        String string5 = null;
        String string6 = null;
        boolean bl = false;
        if (string != null) {
            string4 = DBObjects.getColumnName(iConfiguration, VIEW_ACCESSRULES, "ENV_DESKTOP");
            string5 = DBObjects.getColumnName(iConfiguration, VIEW_ACCESSRULES, "ENV_WEB");
            string6 = DBObjects.getColumnName(iConfiguration, VIEW_ACCESSRULES, "ENV_MOBILE");
            object = resultSet.getMetaData();
            int n = object.getColumnCount();
            for (int i = 1; i <= n && !bl; ++i) {
                String string7 = object.getColumnName(i);
                if (!string7.equals(string4) && !string7.equals(string5) && !string7.equals(string6)) continue;
                bl = true;
            }
        }
        while (resultSet.next()) {
            boolean bl2 = true;
            if (bl) {
                if (string.equals("DESKTOP")) {
                    if (!string2.equals(resultSet.getString(string4))) {
                        bl2 = false;
                    }
                } else if (string.equals("WEB")) {
                    if (!string2.equals(resultSet.getString(string5))) {
                        bl2 = false;
                    }
                } else if (string.equals("MOBILE") && !string2.equals(resultSet.getString(string6))) {
                    bl2 = false;
                }
            }
            if (!bl2) continue;
            iAccessController.addAccess(resultSet.getString(string3));
        }
        object = iAccessController;
        Object var18_19 = null;
        if (resultSet == null) return object;
        try {
            resultSet.close();
        }
        catch (Throwable throwable) {
            Object var21_24 = null;
            resultSet = null;
            throw throwable;
        }
        catch (SQLException sQLException) {
            try {
                this.debug(sQLException);
                IAccessController iAccessController2 = null;
                Object var18_20 = null;
                if (resultSet == null) return iAccessController2;
            }
            catch (Throwable throwable) {
                Object var18_21 = null;
                if (resultSet == null) throw throwable;
                try {
                    resultSet.close();
                }
                catch (Throwable throwable2) {
                    Object var21_30 = null;
                    resultSet = null;
                    throw throwable2;
                }
            }
            try {
                resultSet.close();
            }
            catch (Throwable throwable) {
                Object var21_27 = null;
                resultSet = null;
                throw throwable;
            }
        }
    }

    protected void updateConfiguration(IConfiguration iConfiguration) throws Exception {
        this.sUsersTable = DBObjects.getTableName(iConfiguration, TABLE_USERS);
        this.sUsersId = DBObjects.getColumnName(iConfiguration, TABLE_USERS, "ID");
        this.sUsersName = DBObjects.getColumnName(iConfiguration, TABLE_USERS, "USERNAME");
        this.sUsersChgPwd = DBObjects.getColumnName(iConfiguration, TABLE_USERS, "CHANGE_PASSWORD");
        this.sUsersPwd = DBObjects.getColumnName(iConfiguration, TABLE_USERS, "PASSWORD");
        this.sAutoLoginTable = DBObjects.getTableName(iConfiguration, TABLE_AUTOLOGIN);
        this.sAutoLoginId = DBObjects.getColumnName(iConfiguration, TABLE_AUTOLOGIN, "USER_ID");
        this.sAutoLoginKey = DBObjects.getColumnName(iConfiguration, TABLE_AUTOLOGIN, "LOGINKEY");
        this.sAccessTable = DBObjects.getTableName(iConfiguration, VIEW_ACCESSRULES);
        this.sAccessUser = DBObjects.getColumnName(iConfiguration, VIEW_ACCESSRULES, "USERNAME");
    }

    protected void initStatements(Connection connection) throws Exception {
        this.psUserId = this.close(this.psUserId);
        this.psUserId = this.prepareStatement(connection, "select * from " + this.sUsersTable + " u where u." + this.sUsersId + " = ?");
        this.psUserName = this.close(this.psUserName);
        this.psUserName = this.prepareStatement(connection, "select * from " + this.sUsersTable + " u where u." + this.sUsersName + " = ?");
        this.psChangePwd = this.close(this.psChangePwd);
        this.psChangePwd = this.prepareStatement(connection, "update " + this.sUsersTable + " u set u." + this.sUsersPwd + " = ? " + " where u." + this.sUsersName + " = ?");
        this.psChangePwdUnset = this.close(this.psChangePwdUnset);
        this.psChangePwdUnset = this.prepareStatement(connection, "update " + this.sUsersTable + " u set u." + this.sUsersPwd + " = ?, " + "u." + this.sUsersChgPwd + " = 'N' " + " where u." + this.sUsersName + " = ?");
        try {
            this.psAutoLogin = this.close(this.psAutoLogin);
            this.psAutoLogin = this.prepareStatement(connection, "select al." + this.sAutoLoginId + " from " + this.sAutoLoginTable + " as al where al." + this.sAutoLoginKey + " = ?");
            this.psInsertAutoLogin = this.close(this.psInsertAutoLogin);
            this.psInsertAutoLogin = this.prepareStatement(connection, "insert into " + this.sAutoLoginTable + "(" + this.sAutoLoginId + ", " + this.sAutoLoginKey + ") values (?, ?)");
            this.psDeleteAutoLoginKey = this.close(this.psDeleteAutoLoginKey);
            this.psDeleteAutoLoginKey = this.prepareStatement(connection, "delete from " + this.sAutoLoginTable + " where " + this.sAutoLoginKey + " = ?");
            this.psDeleteAutoLoginUser = this.close(this.psDeleteAutoLoginUser);
            this.psDeleteAutoLoginUser = this.prepareStatement(connection, "delete from " + this.sAutoLoginTable + " where " + this.sAutoLoginId + " = ?");
        }
        catch (SQLException sQLException) {
            this.psAutoLogin = this.close(this.psAutoLogin);
            this.psInsertAutoLogin = this.close(this.psInsertAutoLogin);
            this.psDeleteAutoLoginKey = this.close(this.psDeleteAutoLoginKey);
            this.psDeleteAutoLoginUser = this.close(this.psDeleteAutoLoginUser);
        }
        try {
            this.psAccessRule = this.close(this.psAccessRule);
            this.psAccessRule = this.prepareStatement(connection, "select * from " + this.sAccessTable + " where " + this.sAccessUser + " = ?");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected String getAliveQuery() {
        return "select ID from " + this.sUsersTable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateUser(ISession iSession, ResultSet resultSet) throws Exception {
        Timestamp timestamp;
        Timestamp timestamp2;
        String string;
        String string2 = iSession.getApplicationName();
        String string3 = iSession.getUserName();
        if (!resultSet.next()) throw new SecurityException("User '" + string3 + "' was not found for application '" + string2 + "'");
        IConfiguration iConfiguration = iSession.getConfig();
        try {
            string = resultSet.getString(DBObjects.getColumnName(iConfiguration, TABLE_USERS, "ACTIVE"));
        }
        catch (SQLException sQLException) {
            string = null;
        }
        if (!this.isActive(iSession, string)) throw new SecurityException("User '" + string3 + "' is inactive for application '" + string2 + "'");
        try {
            timestamp2 = resultSet.getTimestamp(DBObjects.getColumnName(iConfiguration, TABLE_USERS, "VALID_FROM"));
        }
        catch (SQLException sQLException) {
            timestamp2 = null;
        }
        try {
            timestamp = resultSet.getTimestamp(DBObjects.getColumnName(iConfiguration, TABLE_USERS, "VALID_TO"));
        }
        catch (SQLException sQLException) {
            timestamp = null;
        }
        if (this.isValid(iSession, timestamp2, timestamp)) return;
        throw new SecurityException("User '" + string3 + "' is expired for application '" + string2 + "'");
    }

    protected boolean isActive(ISession iSession, String string) throws Exception {
        if (string == null) {
            return true;
        }
        return DBObjects.getYesValue(iSession.getConfig()).equals(string);
    }

    protected boolean isValid(ISession iSession, Timestamp timestamp, Timestamp timestamp2) {
        long l = System.currentTimeMillis();
        return !(timestamp != null && timestamp.getTime() > l || timestamp2 != null && timestamp2.getTime() <= l);
    }

    protected boolean isPasswordValid(ISession iSession, String string) throws Exception {
        return this.comparePassword(iSession.getConfig(), iSession.getPassword(), string);
    }

    protected boolean isChangePassword(ISession iSession, String string) throws Exception {
        if (string == null) {
            return false;
        }
        return DBObjects.getYesValue(iSession.getConfig()).equals(string);
    }

    public static final class DBAccessController
    implements IAccessController {
        private ArrayUtil<String> auAllowedLCO = null;

        public boolean isAllowed(String string) {
            if (string != null && this.auAllowedLCO != null) {
                return this.auAllowedLCO.contains(string);
            }
            return false;
        }

        public void addAccess(String string) {
            if (string == null) {
                return;
            }
            if (this.auAllowedLCO == null) {
                this.auAllowedLCO = new ArrayUtil();
            }
            if (!this.auAllowedLCO.contains(string)) {
                this.auAllowedLCO.add(string);
            }
        }

        public void removeAccess(String string) {
            if (string == null || this.auAllowedLCO == null) {
                return;
            }
            this.auAllowedLCO.remove(string);
        }

        public String[] getAllowedLifeCycleNames() {
            if (this.auAllowedLCO == null) {
                return new String[0];
            }
            return this.auAllowedLCO.toArray(new String[this.auAllowedLCO.size()]);
        }
    }
}

